/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public final class MethodBytecodeUtil {
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");

    private MethodBytecodeUtil() {
    }

    public static void visit(Method method, MethodVisitor methodVisitor, boolean withLineNumbers) {
        assert (method.virtualMachine().canGetBytecodes());
        MethodBytecodeUtil.visit(method, method.bytecodes(), methodVisitor, withLineNumbers);
    }

    public static void visit(Method method, long maxOffset, MethodVisitor methodVisitor, boolean withLineNumbers) {
        if (maxOffset > 0L) {
            byte[] originalBytecodes;
            assert (method.virtualMachine().canGetBytecodes());
            byte[] bytecodes = originalBytecodes = method.bytecodes();
            if (maxOffset < (long)originalBytecodes.length) {
                bytecodes = new byte[originalBytecodes.length];
                System.arraycopy(originalBytecodes, 0, bytecodes, 0, (int)maxOffset);
            }
            MethodBytecodeUtil.visit(method, bytecodes, methodVisitor, withLineNumbers);
        }
    }

    private static void visit(final Method method, byte[] bytecodes, final MethodVisitor methodVisitor, boolean withLineNumbers) {
        ReferenceType type = method.declaringType();
        assert (type.virtualMachine().canGetConstantPool());
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)bytes);){
            MethodBytecodeUtil.writeClassHeader(dos, type.constantPoolCount(), type.constantPool());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassReader reader = new ClassReader(bytes.getInternalBuffer(), 0, bytes.size());
        ClassWriter writer = new ClassWriter(reader, 0);
        String superName = null;
        String[] interfaces = null;
        if (type instanceof ClassType) {
            ClassType superClass = ((ClassType)type).superclass();
            superName = superClass != null ? superClass.name() : null;
            interfaces = (String[])((ClassType)type).interfaces().stream().map(ReferenceType::name).toArray(String[]::new);
        } else if (type instanceof InterfaceType) {
            interfaces = (String[])((InterfaceType)type).superinterfaces().stream().map(ReferenceType::name).toArray(String[]::new);
        }
        writer.visit(52, 1, type.name(), type.signature(), superName, interfaces);
        Attribute bootstrapMethods = MethodBytecodeUtil.createBootstrapMethods(reader, writer);
        if (bootstrapMethods != null) {
            writer.visitAttribute(bootstrapMethods);
        }
        MethodVisitor mv = writer.visitMethod(1, method.name(), method.signature(), method.signature(), null);
        mv.visitAttribute(MethodBytecodeUtil.createCode(writer, method, bytecodes, withLineNumbers));
        final InstructionOffsetReader insnOffsReader = methodVisitor instanceof InstructionOffsetReader ? (InstructionOffsetReader)methodVisitor : null;
        new ClassReader(writer.toByteArray()){

            protected void readBytecodeInstructionOffset(int bytecodeOffset) {
                if (insnOffsReader != null) {
                    insnOffsReader.readBytecodeInstructionOffset(bytecodeOffset);
                }
            }
        }.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                assert (name.equals(method.name()));
                return methodVisitor;
            }
        }, 0);
    }

    private static void writeClassHeader(DataOutputStream dos, int constantPoolCount, byte[] constantPool) throws IOException {
        dos.writeInt(-889275714);
        dos.writeInt(52);
        dos.writeShort(constantPoolCount + 1);
        dos.write(constantPool);
        byte[] utfStr = "BootstrapMethods".getBytes(StandardCharsets.UTF_8);
        dos.writeByte(1);
        dos.writeShort(utfStr.length);
        dos.write(utfStr);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(1);
        dos.writeShort(constantPoolCount);
        dos.writeInt(0);
    }

    @Nullable
    private static Attribute createBootstrapMethods(ClassReader classReader, ClassWriter classWriter) {
        HashSet<Short> bootstrapMethods = new HashSet<Short>();
        block4: for (int i = 1; i < classReader.getItemCount(); ++i) {
            int index = classReader.getItem(i);
            int tag = classReader.readByte(index - 1);
            switch (tag) {
                case 5: 
                case 6: {
                    ++i;
                    continue block4;
                }
                case 17: 
                case 18: {
                    bootstrapMethods.add(classReader.readShort(index));
                }
            }
        }
        if (!bootstrapMethods.isEmpty()) {
            int dummyRef = classWriter.newHandle(6, "DummyOwner", "DummyMethod", "", false);
            return MethodBytecodeUtil.createAttribute("BootstrapMethods", (ThrowableConsumer<? super DataOutputStream, ? extends IOException>)((ThrowableConsumer)dos -> {
                dos.writeShort(bootstrapMethods.size());
                for (int i = 0; i < bootstrapMethods.size(); ++i) {
                    dos.writeShort(dummyRef);
                    dos.writeShort(0);
                }
            }));
        }
        return null;
    }

    private static Attribute createCode(ClassWriter cw, Method method, byte[] bytecodes, boolean withLineNumbers) {
        return MethodBytecodeUtil.createAttribute("Code", (ThrowableConsumer<? super DataOutputStream, ? extends IOException>)((ThrowableConsumer)dos -> {
            List<Location> locations;
            dos.writeShort(0);
            dos.writeShort(0);
            dos.writeInt(bytecodes.length);
            dos.write(bytecodes);
            dos.writeShort(0);
            List<Location> list = locations = withLineNumbers ? DebuggerUtilsEx.allLineLocations(method) : null;
            if (!ContainerUtil.isEmpty(locations)) {
                dos.writeShort(1);
                dos.writeShort(cw.newUTF8("LineNumberTable"));
                dos.writeInt(2 * locations.size() + 2);
                dos.writeShort(locations.size());
                for (Location l : locations) {
                    dos.writeShort((short)l.codeIndex());
                    dos.writeShort(l.lineNumber());
                }
            } else {
                dos.writeShort(0);
            }
        }));
    }

    private static Attribute createAttribute(String name, ThrowableConsumer<? super DataOutputStream, ? extends IOException> generator) {
        int end;
        int start;
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)bytes);){
            MethodBytecodeUtil.writeClassHeader(dos, 0, ArrayUtil.EMPTY_BYTE_ARRAY);
            start = dos.size();
            generator.consume((Object)dos);
            end = dos.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final ClassReader reader = new ClassReader(bytes.getInternalBuffer(), 0, bytes.size());
        return new Attribute(name){

            public Attribute read() {
                return this.read(reader, start, end - start, null, 0, null);
            }
        }.read();
    }

    public static Type getVarInstructionType(int opcode) {
        return switch (opcode) {
            case 22, 55 -> Type.LONG_TYPE;
            case 24, 57 -> Type.DOUBLE_TYPE;
            case 23, 56 -> Type.FLOAT_TYPE;
            case 21, 54 -> Type.INT_TYPE;
            default -> OBJECT_TYPE;
        };
    }

    @Nullable
    public static Method getLambdaMethod(ReferenceType clsType, @NotNull ClassesByNameProvider classesByName) {
        List applicableMethods;
        if (classesByName == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(0);
        }
        if (DebuggerUtilsEx.isLambdaClassName(clsType.name()) && (applicableMethods = ContainerUtil.filter(clsType.methods(), m -> m.isPublic() && !m.isBridge())).size() == 1) {
            return MethodBytecodeUtil.getFirstCalledMethod((Method)applicableMethods.get(0), classesByName);
        }
        return null;
    }

    @Nullable
    public static Method getBridgeTargetMethod(Method method, @NotNull ClassesByNameProvider classesByName) {
        if (classesByName == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(1);
        }
        return method.isBridge() ? MethodBytecodeUtil.getFirstCalledMethod(method, classesByName) : null;
    }

    private static Method getFirstCalledMethod(final Method method, final @NotNull ClassesByNameProvider classesByName) {
        if (classesByName == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(2);
        }
        final Ref methodInSameClass = Ref.create();
        final Ref methodRef = Ref.create();
        MethodBytecodeUtil.visit(method, new MethodVisitor(589824){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                ReferenceType cls;
                if ("java/lang/AbstractMethodError".equals(owner)) {
                    return;
                }
                ReferenceType declaringType = method.declaringType();
                owner = Type.getObjectType((String)owner).getClassName();
                String declaringTypeName = declaringType.name();
                ReferenceType referenceType = cls = declaringTypeName.equals(owner) ? declaringType : (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner));
                if (cls == null) {
                    return;
                }
                Method targetMethod = DebuggerUtils.findMethod((ReferenceType)cls, (String)name, (String)desc);
                methodRef.setIfNull((Object)targetMethod);
                if (owner.equals(DebuggerUtilsEx.getLambdaBaseClassName(declaringTypeName))) {
                    methodInSameClass.setIfNull((Object)targetMethod);
                }
            }
        }, false);
        if (methodInSameClass.get() != null) {
            return (Method)methodInSameClass.get();
        }
        return (Method)methodRef.get();
    }

    public static List<Location> removeSameLineLocations(@NotNull List<Location> locations) {
        if (locations == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(3);
        }
        if (locations.size() < 2) {
            return locations;
        }
        MultiMap byMethod = new MultiMap();
        for (Location location : locations) {
            byMethod.putValue((Object)location.method(), (Object)location);
        }
        ArrayList<Location> res = new ArrayList<Location>();
        for (Map.Entry entry : byMethod.entrySet()) {
            res.addAll(MethodBytecodeUtil.removeMethodSameLineLocations((Method)entry.getKey(), (List)entry.getValue()));
        }
        return res;
    }

    private static Collection<Location> removeMethodSameLineLocations(@NotNull Method method, @NotNull List<Location> locations) {
        int locationsSize;
        if (method == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(4);
        }
        if (locations == null) {
            MethodBytecodeUtil.$$$reportNull$$$0(5);
        }
        if ((locationsSize = locations.size()) < 2) {
            return locations;
        }
        VirtualMachine vm = method.declaringType().virtualMachine();
        if (!vm.canGetConstantPool() || !vm.canGetBytecodes()) {
            return locations;
        }
        final int lineNumber = locations.get(0).lineNumber();
        final ArrayList mask = new ArrayList(locationsSize);
        MethodBytecodeUtil.visit(method, new MethodVisitor(589824){
            boolean myNewBlock;
            {
                super(arg0);
                this.myNewBlock = true;
            }

            public void visitLineNumber(int line, Label start) {
                if (lineNumber == line) {
                    mask.add(this.myNewBlock);
                    this.myNewBlock = false;
                }
            }

            public void visitInsn(int opcode) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    this.myNewBlock = true;
                }
            }

            public void visitJumpInsn(int opcode, Label label) {
                this.myNewBlock = true;
            }
        }, true);
        if (mask.size() == locationsSize) {
            locations.sort(Comparator.comparing(Location::codeIndex));
            ArrayList<Location> res = new ArrayList<Location>(locationsSize);
            int pos = 0;
            for (Location location : locations) {
                if (!((Boolean)mask.get(pos++)).booleanValue()) continue;
                res.add(location);
            }
            return res;
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/jdi/MethodBytecodeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLambdaMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBridgeTargetMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstCalledMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSameLineLocations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeMethodSameLineLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface InstructionOffsetReader {
        public void readBytecodeInstructionOffset(int var1);
    }
}

