/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.ui;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MemoryAgentDialog
extends DialogWrapper {
    protected final boolean myRebuildOnSessionEvents;
    protected final XDebuggerTree myTree;
    protected final BorderLayoutPanel myPanel;
    protected final JProgressBar myProgressBar;
    protected final JBLabel myInfoLabel;
    protected final JBPanel myTopPanel;

    MemoryAgentDialog(@NotNull Project project, @NotNull String name, @NotNull XValue value, @Nullable XDebugSession session, @NotNull XDebuggerTree tree, boolean rebuildOnSessionEvents) {
        if (project == null) {
            MemoryAgentDialog.$$$reportNull$$$0(0);
        }
        if (name == null) {
            MemoryAgentDialog.$$$reportNull$$$0(1);
        }
        if (value == null) {
            MemoryAgentDialog.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            MemoryAgentDialog.$$$reportNull$$$0(3);
        }
        super(project, false);
        this.myRebuildOnSessionEvents = rebuildOnSessionEvents;
        this.setModal(false);
        this.myTopPanel = new JBPanel();
        this.myTopPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myInfoLabel = new JBLabel();
        this.myTopPanel.add((Component)this.myInfoLabel);
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setVisible(false);
        this.myTopPanel.add((Component)this.myProgressBar);
        this.myTree = tree;
        this.myPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree)).addToTop((Component)this.myTopPanel);
        XValueNodeImpl root = new XValueNodeImpl(this.myTree, null, name, value);
        this.myTree.setRoot((XDebuggerTreeNode)root, true);
        this.myTree.setSelectionRow(0);
        this.myTree.expandNodesOnLoad(node -> node == root);
        if (session != null) {
            session.addSessionListener(new XDebugSessionListener(){

                public void sessionPaused() {
                    if (MemoryAgentDialog.this.myRebuildOnSessionEvents) {
                        MemoryAgentDialog.this.myTree.invokeLater(() -> MemoryAgentDialog.this.myTree.rebuild());
                    }
                }

                public void sessionResumed() {
                    MemoryAgentDialog.this.close(0);
                }
            }, this.myDisposable);
        }
        this.init();
    }

    public ProgressIndicator createProgressIndicator() {
        return new MemoryAgentActionProgressIndicator();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/agent/ui/MemoryAgentDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MemoryAgentActionProgressIndicator
    extends ProgressIndicatorBase {
        protected MemoryAgentActionProgressIndicator() {
        }

        public void setText(String text) {
            super.setText(text);
            MemoryAgentDialog.this.myInfoLabel.setText(text);
        }

        public void setFraction(double fraction) {
            super.setFraction(fraction);
            MemoryAgentDialog.this.myProgressBar.setMinimum(0);
            MemoryAgentDialog.this.myProgressBar.setMaximum(100);
            MemoryAgentDialog.this.myProgressBar.setValue((int)(fraction * 100.0));
        }

        public void start() {
            super.start();
            MemoryAgentDialog.this.myProgressBar.setVisible(true);
        }

        public void stop() {
            super.stop();
            MemoryAgentDialog.this.myProgressBar.setVisible(false);
            MemoryAgentDialog.this.myInfoLabel.setVisible(false);
        }
    }
}

