/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 \u00112\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011B\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "myBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "text", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "getMyBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "AddCallerNotFilter", "AddCallerFilter", "AddInstanceFilter", "AddClassFilter", "AddClassNotFilter", "Companion", "intellij.java.debugger.impl"})
public abstract class BreakpointIntentionAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XBreakpoint<?> myBreakpoint;
    @JvmField
    @NotNull
    public static final Key<String> CALLER_KEY;
    @JvmField
    @NotNull
    public static final Key<String> THIS_TYPE_KEY;
    @JvmField
    @NotNull
    public static final Key<Long> THIS_ID_KEY;

    public BreakpointIntentionAction(@NotNull XBreakpoint<?> myBreakpoint, @NlsActions.ActionText @NotNull String text) {
        Intrinsics.checkNotNullParameter(myBreakpoint, (String)"myBreakpoint");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text);
        this.myBreakpoint = myBreakpoint;
    }

    @NotNull
    protected final XBreakpoint<?> getMyBreakpoint() {
        return this.myBreakpoint;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @JvmStatic
    @NotNull
    public static final List<AnAction> getIntentions(@NotNull XBreakpoint<?> breakpoint, @Nullable XDebugSession currentSession) {
        return Companion.getIntentions(breakpoint, currentSession);
    }

    static {
        Key key = Key.create((String)"CALLER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CALLER_KEY = key;
        Key key2 = Key.create((String)"THIS_TYPE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        THIS_TYPE_KEY = key2;
        Key key3 = Key.create((String)"THIS_ID_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        THIS_ID_KEY = key3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddCallerFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myCaller", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.debugger.impl"})
    public static final class AddCallerFilter
    extends BreakpointIntentionAction {
        @NotNull
        private final String myCaller;

        public AddCallerFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myCaller) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter((Object)myCaller, (String)"myCaller");
            Object[] objectArray = new Object[1];
            String string = StringUtil.substringBefore((String)myCaller, (String)"(");
            if (string == null) {
                string = myCaller;
            }
            objectArray[0] = StringUtil.getShortName((String)string);
            String string2 = JavaDebuggerBundle.message((String)"action.stop.only.if.called.from.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            super(breakpoint, string2);
            this.myCaller = myCaller;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            $this$update_u24lambda_u240 = (JavaBreakpointProperties)v0;
            $i$a$-with-BreakpointIntentionAction$AddCallerFilter$update$1 = false;
            v1 = e.getPresentation();
            if (!$this$update_u24lambda_u240.isCALLER_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $this$update_u24lambda_u240.getCallerFilters();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCallerFilters(...)");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myCaller))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            JavaBreakpointProperties $this$actionPerformed_u24lambda_u240 = (JavaBreakpointProperties)xBreakpointProperties;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setCALLER_FILTERS_ENABLED(true);
            ClassFilter callerFilter = new ClassFilter(this.myCaller);
            ClassFilter[] classFilterArray = $this$actionPerformed_u24lambda_u240.getCallerFilters();
            Intrinsics.checkNotNullExpressionValue((Object)classFilterArray, (String)"getCallerFilters(...)");
            $this$actionPerformed_u24lambda_u240.setCallerFilters((ClassFilter[])Companion.appendIfNeeded(classFilterArray, callerFilter));
            $this$actionPerformed_u24lambda_u240.setCallerExclusionFilters((ClassFilter[])ArrayUtil.remove((Object[])$this$actionPerformed_u24lambda_u240.getCallerExclusionFilters(), (Object)callerFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            Intrinsics.checkNotNull(xBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddCallerNotFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myCaller", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.debugger.impl"})
    public static final class AddCallerNotFilter
    extends BreakpointIntentionAction {
        @NotNull
        private final String myCaller;

        public AddCallerNotFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myCaller) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter((Object)myCaller, (String)"myCaller");
            Object[] objectArray = new Object[1];
            String string = StringUtil.substringBefore((String)myCaller, (String)"(");
            if (string == null) {
                string = myCaller;
            }
            objectArray[0] = StringUtil.getShortName((String)string);
            String string2 = JavaDebuggerBundle.message((String)"action.do.not.stop.if.called.from.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            super(breakpoint, string2);
            this.myCaller = myCaller;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            $this$update_u24lambda_u240 = (JavaBreakpointProperties)v0;
            $i$a$-with-BreakpointIntentionAction$AddCallerNotFilter$update$1 = false;
            v1 = e.getPresentation();
            if (!$this$update_u24lambda_u240.isCALLER_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $this$update_u24lambda_u240.getCallerExclusionFilters();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCallerExclusionFilters(...)");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myCaller))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            JavaBreakpointProperties $this$actionPerformed_u24lambda_u240 = (JavaBreakpointProperties)xBreakpointProperties;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setCALLER_FILTERS_ENABLED(true);
            ClassFilter callerFilter = new ClassFilter(this.myCaller);
            $this$actionPerformed_u24lambda_u240.setCallerFilters((ClassFilter[])ArrayUtil.remove((Object[])$this$actionPerformed_u24lambda_u240.getCallerFilters(), (Object)callerFilter));
            ClassFilter[] classFilterArray = $this$actionPerformed_u24lambda_u240.getCallerExclusionFilters();
            Intrinsics.checkNotNullExpressionValue((Object)classFilterArray, (String)"getCallerExclusionFilters(...)");
            $this$actionPerformed_u24lambda_u240.setCallerExclusionFilters((ClassFilter[])Companion.appendIfNeeded(classFilterArray, callerFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            Intrinsics.checkNotNull(xBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddClassFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myClass", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.debugger.impl"})
    public static final class AddClassFilter
    extends BreakpointIntentionAction {
        @NotNull
        private final String myClass;

        public AddClassFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myClass) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter((Object)myClass, (String)"myClass");
            Object[] objectArray = new Object[]{StringUtil.getShortName((String)myClass)};
            String string = JavaDebuggerBundle.message((String)"action.stop.only.in.class.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(breakpoint, string);
            this.myClass = myClass;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            $this$update_u24lambda_u240 = (JavaBreakpointProperties)v0;
            $i$a$-with-BreakpointIntentionAction$AddClassFilter$update$1 = false;
            v1 = e.getPresentation();
            if (!$this$update_u24lambda_u240.isCLASS_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $this$update_u24lambda_u240.getClassFilters();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getClassFilters(...)");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myClass))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            JavaBreakpointProperties $this$actionPerformed_u24lambda_u240 = (JavaBreakpointProperties)xBreakpointProperties;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setCLASS_FILTERS_ENABLED(true);
            ClassFilter classFilter = new ClassFilter(this.myClass);
            ClassFilter[] classFilterArray = $this$actionPerformed_u24lambda_u240.getClassFilters();
            Intrinsics.checkNotNullExpressionValue((Object)classFilterArray, (String)"getClassFilters(...)");
            $this$actionPerformed_u24lambda_u240.setClassFilters((ClassFilter[])Companion.appendIfNeeded(classFilterArray, classFilter));
            $this$actionPerformed_u24lambda_u240.setClassExclusionFilters((ClassFilter[])ArrayUtil.remove((Object[])$this$actionPerformed_u24lambda_u240.getClassExclusionFilters(), (Object)classFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            Intrinsics.checkNotNull(xBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddClassNotFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myClass", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.debugger.impl"})
    public static final class AddClassNotFilter
    extends BreakpointIntentionAction {
        @NotNull
        private final String myClass;

        public AddClassNotFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myClass) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter((Object)myClass, (String)"myClass");
            Object[] objectArray = new Object[]{StringUtil.getShortName((String)myClass)};
            String string = JavaDebuggerBundle.message((String)"action.do.not.stop.in.class.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(breakpoint, string);
            this.myClass = myClass;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            $this$update_u24lambda_u240 = (JavaBreakpointProperties)v0;
            $i$a$-with-BreakpointIntentionAction$AddClassNotFilter$update$1 = false;
            v1 = e.getPresentation();
            if (!$this$update_u24lambda_u240.isCLASS_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $this$update_u24lambda_u240.getClassExclusionFilters();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getClassExclusionFilters(...)");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myClass))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            JavaBreakpointProperties $this$actionPerformed_u24lambda_u240 = (JavaBreakpointProperties)xBreakpointProperties;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setCLASS_FILTERS_ENABLED(true);
            ClassFilter classFilter = new ClassFilter(this.myClass);
            ClassFilter[] classFilterArray = $this$actionPerformed_u24lambda_u240.getClassExclusionFilters();
            Intrinsics.checkNotNullExpressionValue((Object)classFilterArray, (String)"getClassExclusionFilters(...)");
            $this$actionPerformed_u24lambda_u240.setClassExclusionFilters((ClassFilter[])Companion.appendIfNeeded(classFilterArray, classFilter));
            $this$actionPerformed_u24lambda_u240.setClassFilters((ClassFilter[])ArrayUtil.remove((Object[])$this$actionPerformed_u24lambda_u240.getClassFilters(), (Object)classFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            Intrinsics.checkNotNull(xBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddInstanceFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myInstance", "", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;J)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.debugger.impl"})
    public static final class AddInstanceFilter
    extends BreakpointIntentionAction {
        private final long myInstance;

        public AddInstanceFilter(@NotNull XBreakpoint<?> breakpoint, long myInstance) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            String string = JavaDebuggerBundle.message((String)"action.stop.only.in.current.object.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            super(breakpoint, string);
            this.myInstance = myInstance;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            $this$update_u24lambda_u240 = (JavaBreakpointProperties)v0;
            $i$a$-with-BreakpointIntentionAction$AddInstanceFilter$update$1 = false;
            v1 = e.getPresentation();
            if (!$this$update_u24lambda_u240.isINSTANCE_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $this$update_u24lambda_u240.getInstanceFilters();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstanceFilters(...)");
            if (!ArraysKt.contains((Object[])v2, (Object)InstanceFilter.create(this.myInstance))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            Intrinsics.checkNotNull((Object)xBreakpointProperties, (String)"null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            JavaBreakpointProperties $this$actionPerformed_u24lambda_u240 = (JavaBreakpointProperties)xBreakpointProperties;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setINSTANCE_FILTERS_ENABLED(true);
            InstanceFilter[] instanceFilterArray = $this$actionPerformed_u24lambda_u240.getInstanceFilters();
            Intrinsics.checkNotNullExpressionValue((Object)instanceFilterArray, (String)"getInstanceFilters(...)");
            $this$actionPerformed_u24lambda_u240.setInstanceFilters((InstanceFilter[])Companion.appendIfNeeded(instanceFilterArray, InstanceFilter.create(this.myInstance)));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            Intrinsics.checkNotNull(xBreakpoint, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J/\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00142\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018R#\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$Companion;", "", "<init>", "()V", "CALLER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "THIS_TYPE_KEY", "THIS_ID_KEY", "", "getIntentions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "appendIfNeeded", "", "T", "array", "element", "([Ljava/lang/Object;Ljava/lang/Object;)[Ljava/lang/Object;", "intellij.java.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<AnAction> getIntentions(@NotNull XBreakpoint<?> breakpoint, @Nullable XDebugSession currentSession) {
            XDebugProcess process;
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            XDebugSession xDebugSession = currentSession;
            Object object = process = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            if (process instanceof JavaDebugProcess) {
                ArrayList<BreakpointIntentionAction> res = new ArrayList<BreakpointIntentionAction>();
                XStackFrame currentStackFrame = currentSession.getCurrentStackFrame();
                if (currentStackFrame instanceof JavaStackFrame) {
                    StackFrameDescriptorImpl stackFrameDescriptorImpl = ((JavaStackFrame)currentStackFrame).getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl, (String)"getDescriptor(...)");
                    StackFrameDescriptorImpl frameDescriptor = stackFrameDescriptorImpl;
                    String string = frameDescriptor.getUserData(THIS_TYPE_KEY);
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        res.add(new AddClassFilter(breakpoint, it));
                        res.add(new AddClassNotFilter(breakpoint, it));
                    }
                    Long l = frameDescriptor.getUserData(THIS_ID_KEY);
                    if (l != null) {
                        long it = ((Number)l).longValue();
                        boolean bl = false;
                        res.add(new AddInstanceFilter(breakpoint, it));
                    }
                    String string2 = frameDescriptor.getUserData(CALLER_KEY);
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        res.add(new AddCallerFilter(breakpoint, it));
                        res.add(new AddCallerNotFilter(breakpoint, it));
                    }
                }
                return res;
            }
            return CollectionsKt.emptyList();
        }

        private final <T> T[] appendIfNeeded(T[] array, T element) {
            Object[] objectArray;
            if (ArraysKt.contains((Object[])array, element)) {
                objectArray = array;
            } else {
                Object[] objectArray2 = ArrayUtil.append((Object[])array, element);
                Intrinsics.checkNotNull((Object)objectArray2);
                objectArray = objectArray2;
            }
            return objectArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

