/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.CallTracingPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.facet.FacetManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance(JavaLineBreakpointType.class);

    public JavaLineBreakpointType() {
        super("java-line", JavaDebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, title);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    protected String getGeneralDescription(XLineBreakpointType.XLineBreakpointVariant variant) {
        String string = JavaLineBreakpointProperties.getGeneralDescription((JavaLineBreakpointProperties)variant.createProperties());
        if (string == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    public String getGeneralDescription(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        return JavaLineBreakpointProperties.getGeneralDescription((JavaLineBreakpointProperties)breakpoint.getProperties());
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(3);
        }
        return new JavaLineBreakpointProperties();
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        return new LineBreakpoint<JavaLineBreakpointProperties>(project, (XBreakpoint)breakpoint);
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        boolean startMethodIsOuterLambda;
        PsiFile file;
        if (project == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (position == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(5);
        }
        if ((file = DebuggerUtilsEx.getPsiFile(position, project)) == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(6);
            }
            return list;
        }
        SourcePosition pos = SourcePosition.createFromLine((PsiFile)file, (int)position.getLine());
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        PsiElement condRet = JavaLineBreakpointType.canStopOnConditionalReturn(file) ? JavaLineBreakpointType.findSingleConditionalReturn(project, document, position.getLine()) : null;
        PsiElement startMethod = DebuggerUtilsEx.getContainingMethod(pos);
        PsiElement outerMethod = startMethod != null && startMethod.getTextOffset() >= pos.getOffset() ? DebuggerUtilsEx.getContainingMethod(startMethod.getParent()) : startMethod;
        boolean bl = startMethodIsOuterLambda = startMethod == outerMethod && lambdas.contains(startMethod);
        if ((lambdas.isEmpty() || startMethodIsOuterLambda && lambdas.size() == 1) && condRet == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(8);
            }
            return list;
        }
        SmartList res = new SmartList();
        boolean mainMethodAdded = false;
        int lambdaCount = 0;
        if (!(startMethod instanceof PsiLambdaExpression)) {
            res.add(new LineJavaBreakpointVariant(this, position, startMethod, -1));
            mainMethodAdded = true;
        }
        int ordinal = 0;
        for (PsiLambdaExpression lambda : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda, document, position.getLine());
            XSourcePositionImpl elementPosition = XSourcePositionImpl.createByElement((PsiElement)firstElem);
            if (elementPosition == null) continue;
            PsiElement body = lambda.getBody();
            LOG.assertTrue(body != null, (Object)"if we got an element, there must be a body");
            if (startMethodIsOuterLambda && lambda == startMethod) {
                res.addFirst(new LineJavaBreakpointVariant(this, (XSourcePosition)elementPosition, body, ordinal));
                mainMethodAdded = true;
            } else if (lambda != outerMethod) {
                ++lambdaCount;
                res.add(new LambdaJavaBreakpointVariant(this, (XSourcePosition)elementPosition, body, ordinal));
            }
            ++ordinal;
        }
        if (lambdaCount >= 2 || mainMethodAdded && lambdaCount == 1) {
            res.add(new JavaBreakpointVariant(this, position, lambdaCount));
        }
        if (condRet != null) {
            PsiElement method = DebuggerUtilsEx.getContainingMethod(condRet);
            int ordinal2 = lambdas.indexOf(method);
            res.add(new ConditionalReturnJavaBreakpointVariant(this, position, condRet, ordinal2));
        }
        SmartList smartList = res;
        if (smartList == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement findSingleConditionalReturn(@Nullable SourcePosition pos) {
        if (pos == null) {
            return null;
        }
        return JavaLineBreakpointType.findSingleConditionalReturn(pos.getFile(), pos.getLine());
    }

    @Nullable
    public static PsiElement findSingleConditionalReturn(@NotNull PsiFile file, int line) {
        if (file == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(10);
        }
        if (file.getFileType().isBinary()) {
            return null;
        }
        Project project = file.getProject();
        return (PsiElement)ReadAction.compute(() -> {
            Document document = file.getViewProvider().getDocument();
            return document != null ? JavaLineBreakpointType.findSingleConditionalReturn(project, document, line) : null;
        });
    }

    @Nullable
    protected static PsiElement findSingleConditionalReturn(@NotNull Project project, @NotNull Document document, int line) {
        if (project == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(11);
        }
        if (document == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(12);
        }
        if (!DocumentUtil.isValidLine((int)line, (Document)document)) {
            return null;
        }
        class RetFinder
        implements Processor<PsiElement> {
            boolean somethingBeforeReturn = false;
            @Nullable
            PsiElement singleReturn = null;

            RetFinder() {
            }

            public boolean process(PsiElement element) {
                if (JavaLineBreakpointType.isReturnKeyword(element)) {
                    if (this.singleReturn != null) {
                        this.singleReturn = null;
                        return false;
                    }
                    if (!this.somethingBeforeReturn) {
                        assert (this.singleReturn == null);
                        return false;
                    }
                    this.singleReturn = element;
                }
                if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                    this.somethingBeforeReturn = true;
                }
                return true;
            }
        }
        RetFinder finder = new RetFinder();
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)finder);
        return finder.singleReturn;
    }

    public static boolean isReturnKeyword(@NotNull PsiElement element) {
        if (element == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(13);
        }
        return element instanceof LeafElement && element.getText().equals("return");
    }

    public static boolean canStopOnConditionalReturn(@NotNull PsiFile file) {
        if (file == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(14);
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-331623, EA-903915");){
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            boolean bl = module == null || !ContainerUtil.exists((Object[])FacetManager.getInstance((Module)module).getAllFacets(), f -> f.getName().equals("Android"));
            return bl;
        }
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        Object properties;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(15);
        }
        if (position == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(16);
        }
        if ((properties = breakpoint.getProperties()) instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)properties)).isAllPositions()) {
                return true;
            }
            Language language = position.getFile().getLanguage();
            LOG.assertTrue(language.isKindOf((Language)JavaLanguage.INSTANCE), (Object)language.getID());
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        SourcePosition position;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(17);
        }
        if ((position = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties) {
            JavaLineBreakpointProperties javaProperties = (JavaLineBreakpointProperties)((Object)properties);
            if (!(breakpoint instanceof RunToCursorBreakpoint) && javaProperties.isInLambda()) {
                Integer ordinal = javaProperties.getLambdaOrdinal();
                assert (ordinal != null);
                List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(position, true);
                if (ordinal < lambdas.size()) {
                    return (PsiElement)lambdas.get(ordinal);
                }
            }
        }
        return DebuggerUtilsEx.getContainingMethod(position);
    }

    protected static Stream<Location> collectInlineConditionalReturnLocations(@NotNull Method method, int lineNumber) {
        if (method == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(18);
        }
        assert (lineNumber > 0);
        class Visitor
        extends MethodVisitor
        implements MethodBytecodeUtil.InstructionOffsetReader {
            final SmartList<Integer> returnOffsets;
            private int bytecodeOffset;
            private boolean lineMatched;
            private boolean lastAddedReturnIsLastInstruction;
            final /* synthetic */ int val$lineNumber;

            protected Visitor(int n) {
                this.val$lineNumber = n;
                super(589824);
                this.returnOffsets = new SmartList();
                this.bytecodeOffset = -1;
            }

            @Override
            public void readBytecodeInstructionOffset(int offset) {
                this.bytecodeOffset = offset;
            }

            public void visitLineNumber(int line, Label start) {
                this.lineMatched = line == this.val$lineNumber;
            }

            public void visitInsn(int opcode) {
                this.lastAddedReturnIsLastInstruction = false;
                if (this.lineMatched && 172 <= opcode && opcode <= 177) {
                    assert (this.bytecodeOffset >= 0);
                    this.returnOffsets.add((Object)this.bytecodeOffset);
                    this.lastAddedReturnIsLastInstruction = true;
                }
            }
        }
        Visitor visitor = new Visitor(lineNumber);
        MethodBytecodeUtil.visit(method, visitor, true);
        if (visitor.lastAddedReturnIsLastInstruction && visitor.returnOffsets.size() >= 2) {
            visitor.returnOffsets.removeLast();
        }
        return visitor.returnOffsets.stream().map(offs -> method.locationOfCodeIndex(offs.intValue()));
    }

    public boolean variantAndBreakpointMatch(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint, @NotNull XLineBreakpointType.XLineBreakpointVariant variant) {
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(19);
        }
        if (variant == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(20);
        }
        JavaLineBreakpointProperties props = (JavaLineBreakpointProperties)breakpoint.getProperties();
        if (variant instanceof ExactJavaBreakpointVariant) {
            ExactJavaBreakpointVariant exactJavaVariant = (ExactJavaBreakpointVariant)variant;
            return Objects.equals(props.getEncodedInlinePosition(), exactJavaVariant.myEncodedInlinePosition) || props.isAllPositions() && JavaLineBreakpointProperties.isLinePosition(exactJavaVariant.myEncodedInlinePosition);
        }
        return props.isLinePosition();
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        Breakpoint<?> javaBreakpoint;
        PsiElement highlightedElement = null;
        Integer lambdaOrdinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (lambdaOrdinal != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)javaBreakpoint;
            assert (breakpoint.getProperties() != null);
            if (((JavaLineBreakpointProperties)breakpoint.getProperties()).isConditionalReturn()) {
                highlightedElement = JavaLineBreakpointType.findSingleConditionalReturn(lineBreakpoint.getSourcePosition());
            } else {
                highlightedElement = this.getContainingMethod(lineBreakpoint);
                if (highlightedElement instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambda = (PsiLambdaExpression)highlightedElement;
                    highlightedElement = lambda.getBody();
                }
            }
        }
        if (highlightedElement != null) {
            PsiFile file = highlightedElement.getContainingFile();
            int line = breakpoint.getLine();
            return DebuggerUtilsEx.getHighlightingRangeInsideLine(highlightedElement.getTextRange(), file, line);
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaLineBreakpointProperties properties;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(21);
        }
        if ((properties = (JavaLineBreakpointProperties)breakpoint.getProperties()) == null) {
            return null;
        }
        boolean condRet = properties.isConditionalReturn();
        boolean isLambda = properties.isInLambda();
        if (!condRet && !isLambda) {
            return null;
        }
        return (XSourcePosition)ReadAction.compute(() -> {
            SourcePosition linePosition = JavaLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint);
            if (linePosition != null) {
                PsiElement theReturn;
                PsiElement psiElement = theReturn = condRet ? JavaLineBreakpointType.findSingleConditionalReturn(linePosition) : null;
                if (theReturn != null) {
                    return XSourcePositionImpl.createByElement((PsiElement)theReturn);
                }
                if (isLambda) {
                    Integer lambdaOrdinal = properties.getLambdaOrdinal();
                    assert (lambdaOrdinal != null);
                    return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(linePosition, lambdaOrdinal));
                }
            }
            return null;
        });
    }

    @Nullable
    private static Integer getLambdaOrdinal(XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint.getProperties();
        return properties != null ? properties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(XLineBreakpointImpl breakpoint) {
        PsiFile psiFile;
        VirtualFile file = breakpoint.getFile();
        if (file != null && (psiFile = PsiManager.getInstance((Project)breakpoint.getProject()).findFile(file)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)breakpoint.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(22);
        }
        if (project == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(23);
        }
        return JavaLineBreakpointType.canPutAtElement(file, line, project, (element, document) -> {
            if (DumbService.isDumb((Project)project)) {
                return true;
            }
            if (element instanceof PsiField) {
                PsiField psiField = (PsiField)element;
                PsiExpression initializer = psiField.getInitializer();
                if (initializer != null && !PsiTypes.nullType().equals(initializer.getType())) {
                    Object value = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer);
                    return value == null;
                }
                return false;
            }
            if (element instanceof PsiMethod) {
                int offset;
                PsiStatement[] statements;
                PsiMethod psiMethod = (PsiMethod)element;
                PsiCodeBlock body = psiMethod.getBody();
                if (body != null && (statements = body.getStatements()).length > 0 && DocumentUtil.isValidOffset((int)(offset = statements[0].getTextOffset()), (Document)document) && document.getLineNumber(offset) == line) {
                    return true;
                }
                return false;
            }
            return true;
        });
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaLineBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(24);
        }
        if (Registry.is((String)"debugger.call.tracing")) {
            return new CallTracingPropertiesPanel(project);
        }
        return null;
    }

    private static boolean isWhiteSpaceOrComment(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(25);
        }
        return psiElement instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiComment.class, (boolean)false) != null;
    }

    public static TextRange getTextRangeWithoutTrailingComments(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(26);
        }
        @NotNull PsiElement lastChild = psiElement;
        for (PsiElement prevChild = psiElement.getLastChild(); prevChild != null && JavaLineBreakpointType.isWhiteSpaceOrComment(prevChild); prevChild = prevChild.getPrevSibling()) {
            lastChild = prevChild;
        }
        return new TextRange(psiElement.getTextRange().getStartOffset(), lastChild.getTextRange().getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 11: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSingleConditionalReturn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReturnKeyword";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canStopOnConditionalReturn";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectInlineConditionalReturnLocations";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "variantAndBreakpointMatch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceOrComment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeWithoutTrailingComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LineJavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, @Nullable XSourcePosition position, PsiElement method, int lambdaOrdinal) {
            if (position == null) {
                LineJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(this$0, position, method, (Integer)JavaLineBreakpointProperties.encodeInlinePosition(lambdaOrdinal, false));
        }

        @Override
        @NotNull
        public String getText() {
            String string = JavaDebuggerBundle.message((String)"breakpoint.variant.text.line", (Object[])new Object[0]);
            if (string == null) {
                LineJavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        public int getPriority(@NotNull Project project) {
            if (project == null) {
                LineJavaBreakpointVariant.$$$reportNull$$$0(2);
            }
            int basePriority = super.getPriority(project);
            PsiFile file = DebuggerUtilsEx.getPsiFile(this.mySourcePosition, project);
            if (file == null) {
                return basePriority;
            }
            SourcePosition pos = SourcePosition.createFromLine((PsiFile)file, (int)this.mySourcePosition.getLine());
            PsiElement firstLineElement = pos.getElementAt();
            if (firstLineElement == null) {
                return basePriority;
            }
            if (this.isLowPriority(firstLineElement)) {
                return basePriority - 50;
            }
            return basePriority;
        }

        protected boolean isLowPriority(PsiElement firstLineElement) {
            PsiJavaToken dot;
            return firstLineElement instanceof PsiJavaToken && (dot = (PsiJavaToken)firstLineElement).getTokenType() == JavaTokenType.DOT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPriority";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LambdaJavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, @NotNull XSourcePosition position, PsiElement element, int lambdaOrdinal) {
            if (position == null) {
                LambdaJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            if (element == null) {
                LambdaJavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            super(this$0, position, element, (Integer)JavaLineBreakpointProperties.encodeInlinePosition(lambdaOrdinal, false));
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        private final int lambdaCount;
        protected final Integer myEncodedInlinePosition;

        public JavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, XSourcePosition position, int lambdaCount, Integer myEncodedInlinePosition) {
            if (position == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((XLineBreakpointType)this$0, position);
            this.lambdaCount = lambdaCount;
            this.myEncodedInlinePosition = myEncodedInlinePosition;
        }

        public JavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, XSourcePosition position, Integer encodedInlinePosition) {
            if (position == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            this(this$0, position, -1, encodedInlinePosition);
        }

        public JavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, XSourcePosition position, int lambdaCount) {
            if (position == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(2);
            }
            this(this$0, position, lambdaCount, null);
        }

        public JavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, XSourcePosition position) {
            if (position == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(3);
            }
            this(this$0, position, -1);
        }

        @NotNull
        public String getText() {
            String string = this.lambdaCount >= 0 ? JavaDebuggerBundle.message((String)"breakpoint.variant.text.line.and.lambda", (Object[])new Object[]{this.lambdaCount}) : JavaDebuggerBundle.message((String)"breakpoint.variant.text.line.and.lambda.uknown.count", (Object[])new Object[0]);
            if (string == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setEncodedInlinePosition(this.myEncodedInlinePosition);
            return properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public class ConditionalReturnJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public ConditionalReturnJavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, XSourcePosition position, PsiElement element, int lambdaOrdinal) {
            if (position == null) {
                ConditionalReturnJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(this$0, position, element, (Integer)JavaLineBreakpointProperties.encodeInlinePosition(lambdaOrdinal, true));
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ConditionalReturnJavaBreakpointVariant", "<init>"));
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;

        public ExactJavaBreakpointVariant(@NotNull JavaLineBreakpointType this$0, @Nullable XSourcePosition position, PsiElement element, Integer encodedInlinePosition) {
            if (position == null) {
                ExactJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(this$0, position, encodedInlinePosition);
            this.myElement = element;
        }

        public Icon getIcon() {
            return this.myElement != null ? this.myElement.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)((String)ReadAction.compute(() -> this.myElement.getText())), (int)100, (int)0) : JavaDebuggerBundle.message((String)"breakpoint.variant.text.line", (Object[])new Object[0]);
            if (string == null) {
                ExactJavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        public TextRange getHighlightRange() {
            if (this.myElement == null || JavaLineBreakpointProperties.isLinePosition(this.myEncodedInlinePosition)) {
                return null;
            }
            TextRange textRange = JavaLineBreakpointType.getTextRangeWithoutTrailingComments(this.myElement);
            return DebuggerUtilsEx.getHighlightingRangeInsideLine(textRange, this.myElement.getContainingFile(), this.mySourcePosition.getLine());
        }

        public boolean isMultiVariant() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

