/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerTree
extends DnDAwareTree
implements UiDataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(DebuggerTree.class);
    protected static final Key<Rectangle> VISIBLE_RECT = Key.create((String)"VISIBLE_RECT");
    public static final DataKey<DebuggerTree> DATA_KEY = DataKey.create((String)"DebuggerTree");
    protected final NodeManagerImpl myNodeManager;
    private DebuggerContextImpl myDebuggerContext = DebuggerContextImpl.EMPTY_CONTEXT;
    private DebuggerTreeNodeImpl myEditedNode;
    private final Project myProject;

    public DebuggerTree(Project project) {
        super((TreeModel)null);
        this.myProject = project;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)((Object)new DebuggerTreeRenderer()));
        this.updateUI();
        TreeUtil.installActions((JTree)((Object)this));
        this.setScrollsOnExpand(false);
        this.myNodeManager = this.createNodeManager(project);
        TreeBuilder model = new TreeBuilder((Object)this){

            @Override
            public void buildChildren(TreeBuilderNode node) {
                DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
                if (debuggerTreeNode.getDescriptor() instanceof DefaultNodeDescriptor) {
                    return;
                }
                DebuggerTree.this.buildNode(debuggerTreeNode);
            }

            @Override
            public boolean isExpandable(TreeBuilderNode builderNode) {
                return DebuggerTree.this.isExpandable((DebuggerTreeNodeImpl)builderNode);
            }
        };
        model.setRoot(this.getNodeFactory().getDefaultNode());
        this.setModel(model);
        TreeSpeedSearch search = TreeSpeedSearch.installOn((JTree)((Object)this));
        search.setComparator(new SpeedSearchComparator(false));
    }

    protected NodeManagerImpl createNodeManager(Project project) {
        return new NodeManagerImpl(project, this);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        this.myNodeManager.dispose();
        this.myDebuggerContext = DebuggerContextImpl.EMPTY_CONTEXT;
    }

    protected boolean isExpandable(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        return descriptor.isExpandable();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DebuggerTree.$$$reportNull$$$0(0);
        }
        sink.set(DATA_KEY, (Object)this);
    }

    private void buildNode(DebuggerTreeNodeImpl node) {
        DebuggerCommandImpl command2;
        if (node == null || node.getDescriptor() == null) {
            return;
        }
        DebuggerManagerThreadImpl managerThread = this.getDebuggerContext().getManagerThread();
        if (managerThread != null && (command2 = this.getBuildNodeCommand(node)) != null) {
            node.add(this.myNodeManager.createMessageNode(MessageDescriptor.EVALUATING));
            managerThread.schedule(command2);
        }
    }

    protected DebuggerCommandImpl getBuildNodeCommand(DebuggerTreeNodeImpl node) {
        if (node.getDescriptor() instanceof ThreadDescriptorImpl) {
            return new BuildThreadCommand(node);
        }
        if (node.getDescriptor() instanceof ThreadGroupDescriptorImpl) {
            return new BuildThreadGroupCommand(node);
        }
        LOG.assertTrue(false);
        return null;
    }

    public void saveState(DebuggerTreeNodeImpl node) {
        if (node.getDescriptor() != null) {
            TreePath path = new TreePath(node.getPath());
            node.getDescriptor().myIsExpanded = this.isExpanded(path);
            node.getDescriptor().myIsSelected = this.getSelectionModel().isPathSelected(path);
            Rectangle rowBounds = this.getRowBounds(this.getRowForPath(path));
            if (rowBounds != null && this.getVisibleRect().contains(rowBounds)) {
                node.getDescriptor().putUserData(VISIBLE_RECT, this.getVisibleRect());
                node.getDescriptor().myIsVisible = true;
            } else {
                node.getDescriptor().putUserData(VISIBLE_RECT, null);
                node.getDescriptor().myIsVisible = false;
            }
        }
        Enumeration e = node.rawChildren();
        while (e.hasMoreElements()) {
            DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
            this.saveState(child);
        }
    }

    public void restoreState(DebuggerTreeNodeImpl node) {
        this.restoreStateImpl(node);
        this.scrollToVisible(node);
    }

    protected final void scrollToVisible(DebuggerTreeNodeImpl scopeNode) {
        TreePath rootPath = new TreePath(scopeNode.getPath());
        int rowCount = this.getRowCount();
        for (int idx = rowCount - 1; idx >= 0; --idx) {
            DebuggerTreeNodeImpl pathNode;
            NodeDescriptorImpl descriptor;
            TreePath treePath = this.getPathForRow(idx);
            if (treePath == null || !rootPath.isDescendant(treePath) || (descriptor = (pathNode = (DebuggerTreeNodeImpl)treePath.getLastPathComponent()).getDescriptor()) == null || !descriptor.myIsVisible) continue;
            Rectangle visibleRect = descriptor.getUserData(VISIBLE_RECT);
            if (visibleRect != null) {
                this.scrollRectToVisible(visibleRect);
                break;
            }
            this.scrollPathToVisible(treePath);
            break;
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
        aRect.width += aRect.x;
        aRect.x = 0;
        super.scrollRectToVisible(aRect);
    }

    private void restoreStateImpl(DebuggerTreeNodeImpl node) {
        this.restoreNodeState(node);
        if (node.getDescriptor().myIsExpanded) {
            Enumeration e = node.rawChildren();
            while (e.hasMoreElements()) {
                DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
                this.restoreStateImpl(child);
            }
        }
    }

    public void restoreState() {
        this.clearSelection();
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (root != null) {
            this.restoreState(root);
        }
    }

    protected void restoreNodeState(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (descriptor != null) {
            if (node.getParent() == null) {
                descriptor.myIsExpanded = true;
            }
            TreePath path = new TreePath(node.getPath());
            if (descriptor.myIsExpanded) {
                this.expandPath(path);
            }
            if (descriptor.myIsSelected) {
                this.addSelectionPath(path);
            }
        }
    }

    public NodeManagerImpl getNodeFactory() {
        return this.myNodeManager;
    }

    public TreeBuilder getMutableModel() {
        return (TreeBuilder)this.getModel();
    }

    public void removeAllChildren() {
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        root.removeAllChildren();
        this.treeChanged();
    }

    public void showMessage(MessageDescriptor messageDesc) {
        DebuggerTreeNodeImpl root = this.getNodeFactory().getDefaultNode();
        this.getMutableModel().setRoot(root);
        DebuggerTreeNodeImpl message = root.add(messageDesc);
        this.treeChanged();
        this.expandPath(new TreePath(message.getPath()));
    }

    public void showMessage(@NlsContexts.Label String messageText) {
        this.showMessage(new MessageDescriptor(messageText));
    }

    public final void treeChanged() {
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (node != null) {
            this.getMutableModel().nodeStructureChanged(node);
            this.restoreState();
        }
    }

    protected abstract void build(DebuggerContextImpl var1);

    public void rebuild(DebuggerContextImpl context) {
        ThreadingAssertions.assertEventDispatchThread();
        DebuggerManagerThreadImpl managerThread = context.getManagerThread();
        if (managerThread == null) {
            return;
        }
        this.myDebuggerContext = context;
        this.saveState();
        managerThread.schedule(PrioritizedTask.Priority.NORMAL, () -> this.getNodeFactory().setHistoryByContext(context));
        this.build(context);
    }

    public void saveState() {
        this.saveState((DebuggerTreeNodeImpl)this.getModel().getRoot());
    }

    public void onEditorShown(DebuggerTreeNodeImpl node) {
        this.myEditedNode = node;
    }

    public void onEditorHidden(DebuggerTreeNodeImpl node) {
        if (this.myEditedNode != null) {
            assert (this.myEditedNode == node);
            this.myEditedNode = null;
        }
    }

    public DebuggerContextImpl getDebuggerContext() {
        return this.myDebuggerContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/debugger/ui/impl/watch/DebuggerTree", "uiDataSnapshot"));
    }

    private class BuildThreadCommand
    extends BuildNodeCommand {
        BuildThreadCommand(DebuggerTreeNodeImpl threadNode) {
            super(threadNode, ((ThreadDescriptorImpl)threadNode.getDescriptor()).getThreadReference());
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            int status;
            ThreadDescriptorImpl threadDescriptor;
            ThreadReferenceProxyImpl threadProxy;
            if (suspendContext == null) {
                BuildThreadCommand.$$$reportNull$$$0(0);
            }
            if (!(threadProxy = (threadDescriptor = (ThreadDescriptorImpl)this.myNode.getDescriptor()).getThreadReference()).isCollected() && this.getDebuggerContext().getDebugProcess().getSuspendManager().isSuspended(threadProxy) && (status = threadProxy.status()) != -1 && status != 5 && status != 0) {
                try {
                    for (StackFrameProxyImpl stackFrame : threadProxy.frames()) {
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getStackFrameDescriptor(threadDescriptor, stackFrame), this.getDebuggerContext().createEvaluationContext()));
                    }
                }
                catch (EvaluateException e) {
                    this.myChildren.clear();
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(e.getMessage()));
                    LOG.debug((Throwable)e);
                }
            }
            this.updateUI(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/impl/watch/DebuggerTree$BuildThreadCommand", "threadAction"));
        }
    }

    private class BuildThreadGroupCommand
    extends DebuggerCommandImpl {
        private final DebuggerTreeNodeImpl myNode;
        protected final List<DebuggerTreeNodeImpl> myChildren = new LinkedList<DebuggerTreeNodeImpl>();

        BuildThreadGroupCommand(DebuggerTreeNodeImpl node) {
            this.myNode = node;
        }

        @Override
        protected void action() {
            ThreadGroupDescriptorImpl groupDescriptor = (ThreadGroupDescriptorImpl)this.myNode.getDescriptor();
            ThreadGroupReferenceProxyImpl threadGroup = groupDescriptor.getThreadGroupReference();
            ArrayList<ThreadReferenceProxyImpl> threads = new ArrayList<ThreadReferenceProxyImpl>(threadGroup.threads());
            threads.sort(ThreadReferenceProxyImpl.ourComparator);
            DebuggerContextImpl debuggerContext = DebuggerTree.this.getDebuggerContext();
            SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
            EvaluationContextImpl evaluationContext = suspendContext != null && !suspendContext.isResumed() ? debuggerContext.createEvaluationContext() : null;
            boolean showCurrent = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD;
            for (ThreadGroupReferenceProxyImpl group : threadGroup.threadGroups()) {
                if (group == null) continue;
                DebuggerTreeNodeImpl threadNode = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadGroupDescriptor(groupDescriptor, group), evaluationContext);
                if (showCurrent && ((ThreadGroupDescriptorImpl)threadNode.getDescriptor()).isCurrent()) {
                    this.myChildren.add(0, threadNode);
                    continue;
                }
                this.myChildren.add(threadNode);
            }
            ArrayList<DebuggerTreeNodeImpl> threadNodes = new ArrayList<DebuggerTreeNodeImpl>();
            for (ThreadReferenceProxyImpl thread : threads) {
                if (thread == null) continue;
                DebuggerTreeNodeImpl threadNode = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadDescriptor(groupDescriptor, thread), evaluationContext);
                if (showCurrent && ((ThreadDescriptorImpl)threadNode.getDescriptor()).isCurrent()) {
                    threadNodes.add(0, threadNode);
                    continue;
                }
                threadNodes.add(threadNode);
            }
            this.myChildren.addAll(threadNodes);
            this.updateUI(true);
        }

        protected void updateUI(boolean scrollToVisible) {
            DebuggerInvocationUtil.invokeLaterAnyModality(DebuggerTree.this.getProject(), () -> {
                this.myNode.removeAllChildren();
                for (DebuggerTreeNodeImpl debuggerTreeNode : this.myChildren) {
                    this.myNode.add(debuggerTreeNode);
                }
                this.myNode.childrenChanged(scrollToVisible);
            });
        }
    }

    public abstract class BuildNodeCommand
    extends DebuggerContextCommandImpl {
        protected final DebuggerTreeNodeImpl myNode;
        protected final List<DebuggerTreeNodeImpl> myChildren;

        protected BuildNodeCommand(DebuggerTreeNodeImpl node, ThreadReferenceProxyImpl thread) {
            super(DebuggerTree.this.getDebuggerContext(), thread);
            this.myChildren = new LinkedList<DebuggerTreeNodeImpl>();
            this.myNode = node;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.NORMAL;
        }

        protected void updateUI(boolean scrollToVisible) {
            DebuggerInvocationUtil.invokeLaterAnyModality(DebuggerTree.this.getProject(), () -> {
                this.myNode.removeAllChildren();
                for (DebuggerTreeNodeImpl debuggerTreeNode : this.myChildren) {
                    this.myNode.add(debuggerTreeNode);
                }
                this.myNode.childrenChanged(scrollToVisible);
            });
        }
    }
}

