/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ThreadGroupDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.sun.jdi.ObjectCollectedException;

public class ThreadGroupDescriptorImpl
extends NodeDescriptorImpl
implements ThreadGroupDescriptor {
    private final ThreadGroupReferenceProxyImpl myThreadGroup;
    private boolean myIsCurrent;
    private String myName = null;
    private boolean myIsExpandable = true;

    public ThreadGroupDescriptorImpl(ThreadGroupReferenceProxyImpl threadGroup) {
        this.myThreadGroup = threadGroup;
    }

    @Override
    public ThreadGroupReferenceProxyImpl getThreadGroupReference() {
        return this.myThreadGroup;
    }

    public boolean isCurrent() {
        return this.myIsCurrent;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadGroupReferenceProxyImpl group = this.getThreadGroupReference();
        try {
            this.myName = group.name();
            return JavaDebuggerBundle.message((String)"label.thread.group.node", (Object[])new Object[]{this.myName, group.uniqueID()});
        }
        catch (ObjectCollectedException e) {
            return this.myName != null ? JavaDebuggerBundle.message((String)"label.thread.group.node.group.collected", (Object[])new Object[]{this.myName}) : "";
        }
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    @Override
    public void setContext(EvaluationContextImpl context) {
        ThreadReferenceProxyImpl threadProxy = context != null ? context.getSuspendContext().getThread() : null;
        this.myIsCurrent = threadProxy != null && this.isDescendantGroup(threadProxy.threadGroupProxy());
        this.myIsExpandable = this.calcExpandable();
    }

    private boolean isDescendantGroup(ThreadGroupReferenceProxyImpl group) {
        if (group == null) {
            return false;
        }
        if (this.getThreadGroupReference() == group) {
            return true;
        }
        return this.isDescendantGroup(group.parent());
    }

    private boolean calcExpandable() {
        ThreadGroupReferenceProxyImpl group = this.getThreadGroupReference();
        return !group.threads().isEmpty() || !group.threadGroups().isEmpty();
    }
}

