/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ArrayRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance(ArrayRenderer.class);
    @NonNls
    public static final String UNIQUE_ID = "ArrayRenderer";
    public int START_INDEX = 0;
    public int END_INDEX = Integer.MAX_VALUE;
    public int ENTRIES_LIMIT = 100;
    private boolean myForced = false;

    public ArrayRenderer() {
        super("unnamed", true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Array";
    }

    @Override
    public void setName(String text) {
        LOG.assertTrue(false);
    }

    @Override
    public ArrayRenderer clone() {
        return (ArrayRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        if (!Registry.is((String)"debugger.renderers.arrays") || OnDemandRenderer.isOnDemandForced((DebugProcessImpl)evaluationContext.getDebugProcess())) {
            return ClassRenderer.calcLabel(descriptor, evaluationContext);
        }
        Value value = descriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof ArrayReference) {
            ArrayReference arrValue = (ArrayReference)value;
            String componentTypeName = ((ArrayType)arrValue.type()).componentTypeName();
            boolean isString = "java.lang.String".equals(componentTypeName);
            if (TypeConversionUtil.isPrimitive((String)componentTypeName) || UnBoxingEvaluator.isTypeUnboxable(componentTypeName) || isString) {
                CompletionStage asyncLabel = DebuggerUtilsAsync.length(arrValue).thenCompose(length -> {
                    if (length > 0) {
                        int shownLength = Math.min(length, Registry.intValue((String)(isString ? "debugger.renderers.arrays.max.strings" : "debugger.renderers.arrays.max.primitives")));
                        return DebuggerUtilsAsync.getValues(arrValue, 0, shownLength).thenCompose(values -> {
                            CompletableFuture[] futures = (CompletableFuture[])ContainerUtil.map2Array((Collection)values, (Object[])new CompletableFuture[0], v -> {
                                if (v != null) {
                                    try {
                                        v = (Value)UnBoxingEvaluator.unbox(v, evaluationContext);
                                    }
                                    catch (EvaluateException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                return ArrayRenderer.getElementAsString(v);
                            });
                            return CompletableFuture.allOf(futures).thenApply(__ -> {
                                List elements = ContainerUtil.map((Object[])futures, CompletableFuture::join);
                                if (descriptor instanceof ValueDescriptorImpl) {
                                    int compactLength = Math.min(shownLength, isString ? 5 : 10);
                                    String compact = ArrayRenderer.createLabel(elements.subList(0, compactLength), length - values.size() + (shownLength - compactLength));
                                    ((ValueDescriptorImpl)descriptor).setCompactValueLabel(compact);
                                }
                                return ArrayRenderer.createLabel(elements, length - values.size());
                            });
                        });
                    }
                    return CompletableFuture.completedFuture("[]");
                });
                if (((CompletableFuture)asyncLabel).isDone()) {
                    return (String)((CompletableFuture)asyncLabel).join();
                }
                ((CompletableFuture)asyncLabel).thenAccept(res -> {
                    descriptor.setValueLabel((String)res);
                    listener2.labelChanged();
                });
            }
            return "";
        }
        return JavaDebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    private static String createLabel(List<String> elements, int remaining) {
        StreamEx strings = StreamEx.of(elements);
        if (remaining > 0) {
            strings = strings.append((Object)JavaDebuggerBundle.message((String)"message.node.array.elements.more", (Object[])new Object[]{remaining}));
        }
        return strings.joining((CharSequence)", ", (CharSequence)"[", (CharSequence)"]");
    }

    private static CompletableFuture<String> getElementAsString(Value value) {
        if (value instanceof StringReference) {
            return DebuggerUtilsAsync.getStringValue((StringReference)value).thenApply(e -> "\"" + StringUtil.first((String)e, (int)15, (boolean)true) + "\"");
        }
        return CompletableFuture.completedFuture(value != null ? value.toString() : "null");
    }

    public void setForced(boolean forced) {
        this.myForced = forced;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayReference array = (ArrayReference)value;
        DebuggerUtilsAsync.length(array).thenAccept(arrayLength -> {
            if (arrayLength > 0) {
                if (!this.myForced) {
                    builder.initChildrenArrayRenderer(this, (int)arrayLength);
                }
                if (this.ENTRIES_LIMIT <= 0) {
                    this.ENTRIES_LIMIT = 1;
                }
                AtomicInteger added = new AtomicInteger();
                AtomicBoolean hiddenNulls = new AtomicBoolean();
                this.addChunk(array, this.START_INDEX, Math.min(arrayLength - 1, this.END_INDEX), (int)arrayLength, builder, evaluationContext, added, hiddenNulls);
            }
        });
    }

    private CompletableFuture<Void> addChunk(ArrayReference array, int start, int end, int length, ChildrenBuilder builder, EvaluationContext evaluationContext, AtomicInteger added, AtomicBoolean hiddenNulls) {
        int chunkLength = Math.min(100, end - start + 1);
        return DebuggerUtilsAsync.getValues(array, start, chunkLength).thenCompose(values -> {
            int idx;
            for (idx = start; idx < start + values.size(); ++idx) {
                Value val = (Value)values.get(idx - start);
                if (ViewsGeneralSettings.getInstance().HIDE_NULL_ARRAY_ELEMENTS && val == null) {
                    hiddenNulls.set(true);
                    continue;
                }
                ArrayElementDescriptorImpl descriptor = (ArrayElementDescriptorImpl)builder.getDescriptorManager().getArrayItemDescriptor(builder.getParentDescriptor(), array, idx);
                descriptor.setValue(val);
                DebuggerTreeNodeImpl arrayItemNode = ((NodeManagerImpl)builder.getNodeManager()).createNode(descriptor, evaluationContext);
                builder.addChildren(Collections.singletonList(arrayItemNode), false);
                if (added.incrementAndGet() >= this.ENTRIES_LIMIT) break;
            }
            if (idx < end && added.get() < this.ENTRIES_LIMIT) {
                return this.addChunk(array, idx, end, length, builder, evaluationContext, added, hiddenNulls);
            }
            this.finish(builder, length, added.get(), hiddenNulls.get(), end, idx);
            return CompletableFuture.completedFuture(null);
        });
    }

    private void finish(ChildrenBuilder builder, int arrayLength, int added, boolean hiddenNulls, int end, int idx) {
        builder.addChildren(Collections.emptyList(), true);
        if (added == 0) {
            if (this.START_INDEX == 0 && arrayLength - 1 <= this.END_INDEX) {
                builder.setMessage(JavaDebuggerBundle.message((String)"message.node.all.elements.null", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
            } else {
                builder.setMessage(JavaDebuggerBundle.message((String)"message.node.all.array.elements.null", (Object[])new Object[]{this.START_INDEX, this.END_INDEX}), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
            }
        } else {
            if (hiddenNulls) {
                builder.setMessage(JavaDebuggerBundle.message((String)"message.node.elements.null.hidden", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
            }
            if (!this.myForced && idx < end) {
                builder.tooManyChildren(end - idx);
            }
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl, (Object)node.getDescriptor().getClass().getName());
        ArrayElementDescriptorImpl descriptor = (ArrayElementDescriptorImpl)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)node.getProject());
        try {
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)node.getProject()).getLanguageLevel();
            return elementFactory.createExpressionFromText("this[" + descriptor.getIndex() + "]", (PsiElement)elementFactory.getArrayClass(languageLevel));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        if (!(value instanceof ArrayReference)) {
            return CompletableFuture.completedFuture(false);
        }
        return DebuggerUtilsAsync.length((ArrayReference)value).thenApply(l -> l > 0);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ArrayType;
    }

    public static class Filtered
    extends ArrayRenderer {
        private final XExpression myExpression;
        public static final XDebuggerTreeNodeHyperlink FILTER_HYPERLINK = new XDebuggerTreeNodeHyperlink(JavaDebuggerBundle.message((String)"array.filter.node.clear.link", (Object[])new Object[0])){

            public void onClick(MouseEvent e) {
                TreeNode parent;
                XDebuggerTree tree = (XDebuggerTree)e.getSource();
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path != null && (parent = ((TreeNode)path.getLastPathComponent()).getParent()) instanceof XValueNodeImpl) {
                    XValueNodeImpl valueNode = (XValueNodeImpl)parent;
                    ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), valueNode, DebuggerManagerEx.getInstanceEx(tree.getProject()).getContext());
                }
                e.consume();
            }
        };

        public Filtered(XExpression expression) {
            this.myExpression = expression;
        }

        public XExpression getExpression() {
            return this.myExpression;
        }

        @Override
        public void buildChildren(Value value, ChildrenBuilder builder, final EvaluationContext evaluationContext) {
            ArrayReference array;
            int arrayLength;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            NodeManagerImpl nodeManager = (NodeManagerImpl)builder.getNodeManager();
            NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
            builder.setMessage(JavaDebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]) + " " + this.myExpression.getExpression(), AllIcons.General.Filter, SimpleTextAttributes.REGULAR_ATTRIBUTES, FILTER_HYPERLINK);
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            if ((arrayLength = (array = (ArrayReference)value).length()) > 0) {
                builder.initChildrenArrayRenderer(this, arrayLength);
                CachedEvaluator cachedEvaluator = new CachedEvaluator(this){

                    @Override
                    protected String getClassName() {
                        return ((ArrayType)array.type()).componentTypeName();
                    }

                    @Override
                    protected PsiElement overrideContext(PsiElement context) {
                        return ContextUtil.getContextElement((StackFrameContext)evaluationContext);
                    }
                };
                cachedEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(this.myExpression));
                try {
                    int added = 0;
                    if (arrayLength - 1 >= this.START_INDEX) {
                        ErrorsValueGroup errorsGroup = null;
                        ArrayValuesCache arrayValuesCache = new ArrayValuesCache(array);
                        for (int idx = this.START_INDEX; idx < arrayLength; ++idx) {
                            ArrayElementDescriptorImpl descriptor = (ArrayElementDescriptorImpl)descriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), array, idx);
                            Value val = arrayValuesCache.getValue(idx);
                            descriptor.setValue(val);
                            try {
                                if (!DebuggerUtilsEx.evaluateBoolean(cachedEvaluator.getEvaluator(evaluationContext.getProject()), (EvaluationContextImpl)evaluationContext.createEvaluationContext(val))) continue;
                                DebuggerTreeNodeImpl arrayItemNode = nodeManager.createNode(descriptor, evaluationContext);
                                builder.addChildren(Collections.singletonList(arrayItemNode), false);
                                ++added;
                                continue;
                            }
                            catch (EvaluateException e) {
                                if (errorsGroup == null) {
                                    errorsGroup = new ErrorsValueGroup();
                                    builder.addChildren(XValueChildrenList.bottomGroup((XValueGroup)errorsGroup), false);
                                }
                                JavaValue childValue = JavaValue.create(null, descriptor, (EvaluationContextImpl)evaluationContext, nodeManager, false);
                                errorsGroup.addErrorValue(e.getMessage(), childValue);
                            }
                        }
                    }
                    builder.addChildren(Collections.emptyList(), true);
                }
                catch (ObjectCollectedException e) {
                    builder.setErrorMessage(JavaDebuggerBundle.message((String)"evaluation.error.array.collected", (Object[])new Object[0]));
                }
            }
        }
    }

    private static final class ArrayValuesCache {
        private final ArrayReference myArray;
        private List<Value> myCachedValues = Collections.emptyList();
        private int myCachedStartIndex;

        private ArrayValuesCache(ArrayReference array) {
            this.myArray = array;
        }

        Value getValue(int index) {
            if (index < this.myCachedStartIndex || index >= this.myCachedStartIndex + this.myCachedValues.size()) {
                this.myCachedStartIndex = index;
                this.myCachedValues = this.myArray.getValues(index, Math.min(100, this.myArray.length() - index));
            }
            return this.myCachedValues.get(index - this.myCachedStartIndex);
        }
    }
}

