/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprAttributeRegexp;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprComparison;
import com.intellij.rml.dfa.impl.rml.ast.RelExprIf;
import com.intellij.rml.dfa.impl.rml.ast.RelExprOrder;
import com.intellij.rml.dfa.impl.rml.ast.RelExprPredefinedPredicate;
import com.intellij.rml.dfa.impl.rml.ast.RelExprQuantify;
import com.intellij.rml.dfa.impl.rml.ast.RelExprSingleAttribute;
import com.intellij.rml.dfa.impl.rml.ast.RelExprUnary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVar;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVarEquivalence;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlBooleanExpressionTranslator;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlRelationExpressionTranslatorKt;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlAtomicExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBinaryExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBoolToRelationExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlCondition;
import com.intellij.rml.dfa.rml.dsl.ast.RmlDisableSemiNaiveExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlIfExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlOrderExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlPredefinedPredicateExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlQuantifyExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlRelationExpression;
import com.intellij.rml.dfa.rml.dsl.ast.RmlUnaryExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlVariableComparisonExpr;
import com.intellij.rml.dfa.rml.dsl.ast.RmlVariableEquivalenceExpr;
import com.intellij.rml.dfa.rml.dsl.lang.AttributeVar;
import com.intellij.rml.dfa.rml.dsl.lang.ConstValue;
import com.intellij.rml.dfa.rml.dsl.lang.CurRMLIteration;
import com.intellij.rml.dfa.rml.dsl.lang.CustomFunction;
import com.intellij.rml.dfa.rml.dsl.lang.RegexpValue;
import com.intellij.rml.dfa.rml.dsl.lang.RelationArgument;
import com.intellij.rml.dfa.rml.dsl.lang.Underscore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlRelationExpressionTranslator;", "", "context", "Lcom/intellij/rml/dfa/impl/rml/ast/Context;", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "<init>", "(Lcom/intellij/rml/dfa/impl/rml/ast/Context;Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "boolExprTranslator", "Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlBooleanExpressionTranslator;", "translate", "Lcom/intellij/rml/dfa/impl/rml/ast/RelExpr;", "expr", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlRelationExpression;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nRmlRelationExpressionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RmlRelationExpressionTranslator.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/RmlRelationExpressionTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1586#2:282\n1661#2,3:283\n1586#2:286\n1661#2,3:287\n1586#2:292\n1661#2,3:293\n1915#2,2:296\n37#3,2:290\n37#3,2:298\n1#4:300\n*S KotlinDebug\n*F\n+ 1 RmlRelationExpressionTranslator.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/RmlRelationExpressionTranslator\n*L\n75#1:282\n75#1:283,3\n85#1:286\n85#1:287,3\n90#1:292\n90#1:293,3\n96#1:296,2\n86#1:290,2\n97#1:298,2\n*E\n"})
public final class RmlRelationExpressionTranslator {
    @NotNull
    private final Context context;
    @NotNull
    private final VariablesManager manager;
    @NotNull
    private final RmlBooleanExpressionTranslator boolExprTranslator;

    public RmlRelationExpressionTranslator(@NotNull Context context, @NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.context = context;
        this.manager = manager;
        this.boolExprTranslator = new RmlBooleanExpressionTranslator(this.context, this.manager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RelExpr translate(@NotNull RmlRelationExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        RmlRelationExpression rmlRelationExpression = expr;
        if (rmlRelationExpression instanceof RmlAtomicExpr) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object relationDomain;
            String relationName = ((RmlAtomicExpr)expr).getRelationName();
            Object[] objectArray = this.manager.getRelation(relationName);
            if (objectArray == null) {
                throw new RmlParseException("Relation " + relationName + " is not registered in input/output/temp block", null, 2, null);
            }
            Object[] domainTypes = objectArray;
            for (Pair pair : CollectionsKt.zip((Iterable)((RmlAtomicExpr)expr).getArguments(), (Object[])domainTypes)) {
                RelationArgument arg = (RelationArgument)pair.component1();
                relationDomain = (DomainType)pair.component2();
                if (!(arg instanceof AttributeVar)) continue;
                String varName = ((AttributeVar)arg).getName();
                this.manager.useDomain(varName);
                DomainType domain = this.manager.getDomain(varName);
                if (domain == null) {
                    this.manager.addDomain(varName, (DomainType)relationDomain);
                    continue;
                }
                if (Intrinsics.areEqual((Object)domain, (Object)relationDomain)) continue;
                throw new RmlParseException("Actual type of " + varName + " is " + domain.getName() + ", but expected " + ((DomainType)relationDomain).getName() + " in " + relationName, null, 2, null);
            }
            Iterable $this$map$iv = ((RmlAtomicExpr)expr).getArguments();
            boolean $i$f$map = false;
            relationDomain = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                int n;
                void it;
                RelationArgument relationArgument = (RelationArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void var15_65 = it;
                if (var15_65 instanceof AttributeVar) {
                    n = 0;
                } else if (var15_65 instanceof ConstValue) {
                    n = 1;
                } else if (var15_65 instanceof RegexpValue) {
                    n = 3;
                } else if (var15_65 instanceof Underscore) {
                    n = 2;
                } else {
                    if (var15_65 instanceof CustomFunction) {
                        throw new RmlParseException("Usage of custom function in relational expression is not allowed", null, 2, null);
                    }
                    if (var15_65 instanceof CurRMLIteration) {
                        throw new RmlParseException("Usage of custom function in relational expression is not allowed", null, 2, null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(n);
            }
            List flags = (List)destination$iv$iv;
            Iterable $this$map$iv2 = ((RmlAtomicExpr)expr).getArguments();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RelationArgument bl = (RelationArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.value());
            }
            List values = (List)destination$iv$iv2;
            Collection $this$toTypedArray$iv = values;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new RelExprVar(relationName, thisCollection$iv.toArray(new String[0]), CollectionsKt.toIntArray((Collection)flags), this.context);
        }
        if (rmlRelationExpression instanceof RmlPredefinedPredicateExpr) {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((RmlPredefinedPredicateExpr)expr).getArguments();
            boolean $i$f$map = false;
            Iterable values = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator thisCollection$iv = $this$mapTo$iv$iv.iterator();
            while (thisCollection$iv.hasNext()) {
                void it;
                Object item$iv$iv = thisCollection$iv.next();
                RelationArgument $i$f$mapTo2 = (RelationArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(it instanceof AttributeVar)) {
                    throw new RmlParseException("Constant relation " + expr + " have to take only variable arguments", null, 2, null);
                }
                collection.add(((AttributeVar)it).getName());
            }
            List arguments = (List)destination$iv$iv;
            Iterable $this$forEach$iv = arguments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.manager.useDomain(it);
            }
            Collection $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            return new RelExprPredefinedPredicate(((RmlPredefinedPredicateExpr)expr).getPredicate(), thisCollection$iv2.toArray(new String[0]), this.context);
        }
        if (rmlRelationExpression instanceof RmlBoolToRelationExpr) {
            return new RelExprPredefinedPredicate(((RmlBoolToRelationExpr)expr).getFlag().getName(), this.context);
        }
        if (rmlRelationExpression instanceof RmlBinaryExpr) {
            int opCode = switch (WhenMappings.$EnumSwitchMapping$0[((RmlBinaryExpr)expr).getBinOp().ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                default -> throw new NoWhenBranchMatchedException();
            };
            RelExpr left2 = this.translate(((RmlBinaryExpr)expr).getLeftExpr());
            RelExpr right2 = this.translate(((RmlBinaryExpr)expr).getRightExpr());
            return new RelExprBinary(opCode, left2, right2, this.context);
        }
        if (rmlRelationExpression instanceof RmlQuantifyExpr) {
            for (RmlQuantifyExpr.Quantifier quantifier : ((RmlQuantifyExpr)expr).getQuantifiers()) {
                if (this.manager.containsDomain(quantifier.getName())) {
                    throw new RmlParseException("Redefinition of variable " + quantifier.getName() + " in quantify expression", null, 2, null);
                }
                if (!this.manager.getTypeManager().containsDomainType(quantifier.getDomainTypeName())) {
                    throw new RmlParseException("Domain type " + quantifier.getDomainTypeName() + " doesn't exist", null, 2, null);
                }
                DomainType domainType = this.manager.getTypeManager().getDomainType(quantifier.getDomainTypeName());
                this.manager.addDomain(quantifier.getName(), domainType);
            }
            RelExpr body = this.translate(((RmlQuantifyExpr)expr).getExpression());
            int opCode = switch (WhenMappings.$EnumSwitchMapping$1[((RmlQuantifyExpr)expr).getQuantifierType().ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                default -> throw new NoWhenBranchMatchedException();
            };
            for (RmlQuantifyExpr.Quantifier quantifier : CollectionsKt.reversed((Iterable)((RmlQuantifyExpr)expr).getQuantifiers())) {
                if (!this.manager.wasDomainUsed(quantifier.getName())) {
                    throw new RmlParseException("Variable " + quantifier.getName() + " of quantify expression is not used in expression " + ((RmlQuantifyExpr)expr).getExpression(), null, 2, null);
                }
                this.manager.removeDomain(quantifier.getName());
                body = new RelExprQuantify(opCode, quantifier.getName(), this.manager.getTypeManager().getDomainType(quantifier.getDomainTypeName()), body, this.context);
            }
            return body;
        }
        if (rmlRelationExpression instanceof RmlVariableComparisonExpr) {
            RelationArgument left3 = ((RmlVariableComparisonExpr)expr).getLeft();
            RelationArgument right3 = ((RmlVariableComparisonExpr)expr).getRight();
            if (!(left3 instanceof AttributeVar)) {
                throw new RmlParseException("Left argument of equality comparison is expected to be attribute variable", null, 2, null);
            }
            RelExprComparison.BinOp binOp = RmlRelationExpressionTranslatorKt.convert(((RmlVariableComparisonExpr)expr).getEqOp());
            this.manager.useDomain(((AttributeVar)left3).getName());
            RelationArgument relationArgument = right3;
            if (relationArgument instanceof AttributeVar) {
                DomainType domainType;
                String opDomName;
                this.manager.useDomain(((AttributeVar)right3).getName());
                if (this.manager.getDomain(((AttributeVar)left3).getName()) == null || this.manager.getDomain(((AttributeVar)right3).getName()) == null) {
                    throw new RmlParseException("Unknown domain type in equality expression " + expr, null, 2, null);
                }
                Object bl = ((RmlVariableComparisonExpr)expr).getRelationalOp();
                AttributeVar attributeVar = bl instanceof AttributeVar ? (AttributeVar)bl : null;
                String string = opDomName = attributeVar != null ? attributeVar.getName() : null;
                if (opDomName != null) {
                    this.manager.useDomain(opDomName);
                }
                String string2 = ((AttributeVar)left3).getName();
                String string3 = ((AttributeVar)right3).getName();
                String string4 = opDomName;
                DomainType domainType2 = this.manager.getDomain(((AttributeVar)left3).getName());
                DomainType domainType3 = this.manager.getDomain(((AttributeVar)right3).getName());
                String string5 = opDomName;
                if (string5 != null) {
                    void it;
                    bl = string5;
                    DomainType domainType4 = domainType3;
                    DomainType domainType5 = domainType2;
                    String string6 = string4;
                    String string7 = string3;
                    String string8 = string2;
                    boolean bl3 = false;
                    DomainType domainType6 = this.manager.getDomain((String)it);
                    string2 = string8;
                    string3 = string7;
                    string4 = string6;
                    domainType2 = domainType5;
                    domainType3 = domainType4;
                    domainType = domainType6;
                } else {
                    domainType = null;
                }
                Context context = this.context;
                boolean bl4 = ((RmlVariableComparisonExpr)expr).getNegation();
                RelExprComparison.BinOp binOp2 = binOp;
                DomainType domainType7 = domainType;
                DomainType domainType8 = domainType3;
                DomainType domainType9 = domainType2;
                String string9 = string4;
                String string10 = string3;
                String string11 = string2;
                return new RelExprComparison(string11, string10, string9, domainType9, domainType8, domainType7, binOp2, bl4, context);
            }
            if (relationArgument instanceof ConstValue) {
                return new RelExprSingleAttribute(((AttributeVar)left3).getName(), ((ConstValue)right3).getValue(), binOp, ((RmlVariableComparisonExpr)expr).getNegation(), this.context);
            }
            if (relationArgument instanceof RegexpValue) {
                if (binOp != RelExprComparison.BinOp.EQ) {
                    throw new RmlParseException("Only \"equals\" is supported in regexp comparison operator", null, 2, null);
                }
                return new RelExprAttributeRegexp(((AttributeVar)left3).getName(), ((RegexpValue)right3).getValue(), !((RmlVariableComparisonExpr)expr).getNegation(), this.context);
            }
            if (relationArgument instanceof CustomFunction) {
                Function1<IRelation, Integer> function2 = RmlRelationExpressionTranslatorKt.translateCustomFunction(((CustomFunction)right3).getFunction());
                return new RelExprSingleAttribute(((AttributeVar)left3).getName(), ((CustomFunction)right3).getRelName(), function2, binOp, ((RmlVariableComparisonExpr)expr).getNegation(), this.context);
            }
            if (relationArgument instanceof CurRMLIteration) {
                return new RelExprSingleAttribute(((AttributeVar)left3).getName(), "$curIteration", null, binOp, ((RmlVariableComparisonExpr)expr).getNegation(), this.context);
            }
            if (relationArgument instanceof Underscore) {
                throw new RmlParseException("Usage of any() expression in equality comparison is not allowed", null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        if (rmlRelationExpression instanceof RmlVariableEquivalenceExpr) {
            RelationArgument left4 = ((RmlVariableEquivalenceExpr)expr).getLeft();
            if (!(left4 instanceof AttributeVar)) {
                throw new RmlParseException("Left argument of equality comparison is expected to be attribute variable", null, 2, null);
            }
            this.manager.useDomain(((AttributeVar)left4).getName());
            RelExpr right4 = this.translate(((RmlVariableEquivalenceExpr)expr).getRight());
            return new RelExprVarEquivalence(((AttributeVar)left4).getName(), right4, this.context);
        }
        if (rmlRelationExpression instanceof RmlUnaryExpr) {
            RelExpr body = this.translate(((RmlUnaryExpr)expr).getSubexpr());
            if (WhenMappings.$EnumSwitchMapping$2[((RmlUnaryExpr)expr).getUnaryOp().ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            return new RelExprUnary(body, 0, this.context);
        }
        if (rmlRelationExpression instanceof RmlIfExpr) {
            RelExpr trueBranch = this.translate(((RmlIfExpr)expr).getTrueBranch());
            RelExpr falseBranch = this.translate(((RmlIfExpr)expr).getFalseBranch());
            RmlCondition cond = ((RmlIfExpr)expr).getCondition();
            RmlCondition rmlCondition = cond;
            if (rmlCondition instanceof RmlCondition.RelationCondition) {
                RelExpr condition = this.translate(((RmlCondition.RelationCondition)cond).getExpr());
                return new RelExprIf(condition, trueBranch, falseBranch, this.context);
            }
            if (rmlCondition instanceof RmlCondition.BooleanCondition) {
                Expr condition = this.boolExprTranslator.translate(((RmlCondition.BooleanCondition)cond).getExpr());
                return new RelExprIf(condition, trueBranch, falseBranch, this.context);
            }
            throw new NoWhenBranchMatchedException();
        }
        if (rmlRelationExpression instanceof RmlOrderExpr) {
            RelationArgument attr = ((RmlOrderExpr)expr).getAttr();
            if (attr instanceof AttributeVar) {
                String varName = ((AttributeVar)attr).getName();
                this.manager.useDomain(varName);
                for (String relation : ((RmlOrderExpr)expr).getStartingFromRelation()) {
                    if (this.manager.getRelation(relation) != null) continue;
                    throw new RmlParseException("Relation " + relation + " is not registered in input/output/temp block", null, 2, null);
                }
                return new RelExprOrder(this.translate(((RmlOrderExpr)expr).getExpression()), varName, ((RmlOrderExpr)expr).getStartingFromRelation(), ((RmlOrderExpr)expr).getMax(), this.context);
            }
            throw new RmlParseException("Attribute variable is expected", null, 2, null);
        }
        if (rmlRelationExpression instanceof RmlDisableSemiNaiveExpr) {
            boolean oldDisableSemiNaive = this.context.isDisableSemiNaive();
            this.context.setDisableSemiNaive(true);
            RelExpr result = this.translate(((RmlDisableSemiNaiveExpr)expr).getExpr());
            this.context.setDisableSemiNaive(oldDisableSemiNaive);
            return result;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[RmlBinaryExpr.RelationBinOp.values().length];
            try {
                nArray[RmlBinaryExpr.RelationBinOp.OR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlBinaryExpr.RelationBinOp.AND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlBinaryExpr.RelationBinOp.IMPLICATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RmlQuantifyExpr.QuantifierType.values().length];
            try {
                nArray[RmlQuantifyExpr.QuantifierType.EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlQuantifyExpr.QuantifierType.FORALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RmlUnaryExpr.RelationUnaryOp.values().length];
            try {
                nArray[RmlUnaryExpr.RelationUnaryOp.NOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

