/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.summaries;

import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProvider;
import com.intellij.rml.dfa.impl.providers.RMLInstancesProviderBase;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import com.intellij.rml.dfa.impl.summaries.AttributesFilter;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.visitors.Visitor;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor;", "Lcom/intellij/rml/dfa/impl/visitors/Visitor;", "globalProvider", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;", "intermediateProvider", "inputProviders", "", "Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProviderBase;", "summaryRelations", "", "<init>", "(Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;Lcom/intellij/rml/dfa/impl/providers/RMLInstancesProvider;Ljava/util/List;Ljava/util/List;)V", "name", "getName", "()Ljava/lang/String;", "outputRelations", "", "Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "getOutputRelations", "()[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "[Lcom/intellij/rml/dfa/impl/relations/RelationSignature;", "collectAttributes", "", "input", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "collectRelations", "provider", "Lcom/intellij/rml/dfa/impl/providers/RMLMutableInstancesProvider;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nMigrateFromSummariesVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateFromSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1586#2:82\n1661#2,3:83\n*S KotlinDebug\n*F\n+ 1 MigrateFromSummariesVisitor.kt\ncom/intellij/rml/dfa/impl/summaries/MigrateFromSummariesVisitor\n*L\n24#1:82\n24#1:83,3\n*E\n"})
public final class MigrateFromSummariesVisitor
implements Visitor {
    @Nullable
    private final RMLInstancesProvider globalProvider;
    @Nullable
    private final RMLInstancesProvider intermediateProvider;
    @NotNull
    private final List<RMLInstancesProviderBase> inputProviders;
    @NotNull
    private final List<String> summaryRelations;
    @NotNull
    private final String name;
    @NotNull
    private final RelationSignature[] outputRelations;

    public MigrateFromSummariesVisitor(@Nullable RMLInstancesProvider globalProvider, @Nullable RMLInstancesProvider intermediateProvider, @NotNull List<? extends RMLInstancesProviderBase> inputProviders, @NotNull List<String> summaryRelations) {
        Intrinsics.checkNotNullParameter(inputProviders, (String)"inputProviders");
        Intrinsics.checkNotNullParameter(summaryRelations, (String)"summaryRelations");
        this.globalProvider = globalProvider;
        this.intermediateProvider = intermediateProvider;
        this.inputProviders = inputProviders;
        this.summaryRelations = summaryRelations;
        this.name = "Summary merger";
        this.outputRelations = new RelationSignature[0];
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RelationSignature[] getOutputRelations() {
        return this.outputRelations;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectAttributes(@NotNull List<DfaTuple> input, @NotNull MutableSymbolTable symbolTable, @NotNull Cancellation cancellation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        SymbolTableWithDependencies cfr_ignored_0 = (SymbolTableWithDependencies)symbolTable;
        Iterable iterable = this.inputProviders;
        MutableSymbolTable mutableSymbolTable = symbolTable;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RMLInstancesProviderBase rMLInstancesProviderBase = (RMLInstancesProviderBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbolTable());
        }
        mutableSymbolTable.addAttributesFrom((List)destination$iv$iv);
        if (this.globalProvider != null) {
            SymbolTableWithDependencies symbolTableWithDependencies = (SymbolTableWithDependencies)symbolTable;
            SymbolTable symbolTable2 = this.globalProvider.getSymbolTable();
            Intrinsics.checkNotNull((Object)symbolTable2, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies");
            symbolTableWithDependencies.addDependentAttributes((SymbolTableWithDependencies)symbolTable2);
        }
        if (this.intermediateProvider != null) {
            SymbolTableWithDependencies symbolTableWithDependencies = (SymbolTableWithDependencies)symbolTable;
            SymbolTable symbolTable3 = this.intermediateProvider.getSymbolTable();
            Intrinsics.checkNotNull((Object)symbolTable3, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies");
            symbolTableWithDependencies.addDependentAttributes((SymbolTableWithDependencies)symbolTable3);
        }
    }

    @Override
    public void collectRelations(@NotNull List<DfaTuple> input, @NotNull RMLMutableInstancesProvider provider, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        MutableSymbolTable mutableSymbolTable = provider.getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)mutableSymbolTable, (String)"<get-symbolTable>(...)");
        MutableSymbolTable destTable = mutableSymbolTable;
        MutableRelationsRepository mutableRelationsRepository = provider.getRelationsRepository();
        Intrinsics.checkNotNullExpressionValue((Object)mutableRelationsRepository, (String)"<get-relationsRepository>(...)");
        MutableRelationsRepository relationsRepository = mutableRelationsRepository;
        RMLInstancesProvider rMLInstancesProvider = this.globalProvider;
        IRelationsManager globalManager = rMLInstancesProvider != null ? rMLInstancesProvider.cloneRelationsManager() : null;
        AttributesFilter attributesFilter = AttributesFilter.Companion.collect(CollectionsKt.plus((Collection)this.inputProviders, (Object)provider), provider);
        if (destTable instanceof SymbolTableWithDependencies) {
            for (RMLInstancesProviderBase inputProvider : this.inputProviders) {
                ((SymbolTableWithDependencies)destTable).buildMapRelation(inputProvider, null, provider, attributesFilter.subtract(inputProvider, provider), cancellation);
            }
            if (this.globalProvider != null) {
                ((SymbolTableWithDependencies)destTable).buildMapRelation(this.globalProvider, globalManager, provider, null, cancellation);
            }
        }
        if (this.globalProvider != null) {
            for (String relationName : this.globalProvider.getRelationsRepository().getAvailableRelations()) {
                MigrateFromSummariesVisitor.collectRelations$processRelation(provider, relationsRepository, destTable, cancellation, CollectionsKt.listOf((Object)this.globalProvider), globalManager, relationName);
            }
        }
        for (String relationName : this.summaryRelations) {
            MigrateFromSummariesVisitor.collectRelations$processRelation(provider, relationsRepository, destTable, cancellation, this.inputProviders, null, relationName);
        }
        if (destTable instanceof SymbolTableWithDependencies) {
            ((SymbolTableWithDependencies)destTable).cleanup();
        }
    }

    private static final void collectRelations$processRelation(RMLMutableInstancesProvider $provider, MutableRelationsRepository relationsRepository, MutableSymbolTable destTable, Cancellation $cancellation, List<? extends RMLInstancesProviderBase> dependentProviders, IRelationsManager sourceManager, String relationName) {
        IRelation relation = null;
        HypoteticRelationsRepository hypotheticRepository = $provider.getFactory().getHypotheticRepository();
        if (hypotheticRepository.containsRelation(relationName)) {
            relation = $provider.getRelationsManager().makeEmptyRelation(hypotheticRepository.getDomainTypes(relationName));
        }
        for (RMLInstancesProviderBase rMLInstancesProviderBase : dependentProviders) {
            RelationsRepository parentRepository = rMLInstancesProviderBase.getRelationsRepository();
            if (!parentRepository.containsRelation(relationName)) continue;
            IRelation parentRelation = parentRepository.getRelation(relationName).migrate(sourceManager, relationsRepository.getRelationsManager(), rMLInstancesProviderBase.getSymbolTable(), destTable, true, $cancellation);
            IRelation iRelation = relation;
            if (iRelation == null || (iRelation = iRelation.unite(parentRelation, $cancellation)) == null) {
                iRelation = parentRelation;
            }
            relation = iRelation;
        }
        if (relation != null) {
            relationsRepository.addRelation(relationName, relation);
        }
    }
}

