/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.test;

import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.DfaLocalSession;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.DfaLocalSessionImpl;
import com.intellij.rml.dfa.impl.DummyAnalysisRunner;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.rml.DomainPoolProfiler;
import com.intellij.rml.dfa.impl.rml.DomainPoolProfilerImpl;
import com.intellij.rml.dfa.impl.scripts.RMLScriptDSLCompiler;
import com.intellij.rml.dfa.impl.translator.RmlToIrTranslator;
import com.intellij.rml.dfa.impl.ui.ConsoleUI;
import com.intellij.rml.dfa.impl.ui.DummyThreadCallback;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.ui.console.StringConsole;
import com.intellij.rml.dfa.ir.IrLocationOwner;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.rml.dsl.DfaAnalysisSpecification;
import com.intellij.rml.dfa.test.DfaTestUtils;
import com.intellij.rml.dfa.translator.RmlToIrTranslatorExtension;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J<\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/rml/dfa/impl/test/DfaTestUtilsImpl;", "Lcom/intellij/rml/dfa/test/DfaTestUtils;", "<init>", "()V", "compileAllRmlScripts", "", "description", "Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "bindRmlConsoleWatcher", "Lkotlin/Function0;", "", "session", "Lcom/intellij/rml/dfa/DfaLocalSession;", "translateToIR", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/ir/IrProject;", "", "Lcom/intellij/rml/dfa/ir/IrLocationOwner;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "tuples", "", "Lcom/intellij/rml/dfa/attributes/DfaTuple;", "extensions", "Lcom/intellij/rml/dfa/translator/RmlToIrTranslatorExtension;", "intellij.rml.dfa.impl"})
public final class DfaTestUtilsImpl
implements DfaTestUtils {
    public void compileAllRmlScripts(@NotNull RMLAnalysisDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Collection allScripts = CollectionsKt.flatten((Iterable)description.getAnalyses().values());
        DomainTypeManager typeManager = new DomainTypeManager(description.getTypesDescriptor(), new RMLOptions(null, 1, null));
        RMLScriptDSLCompiler compiler = new RMLScriptDSLCompiler();
        DomainPoolProfiler profiler = new DomainPoolProfilerImpl();
        for (DfaAnalysisSpecification script : allScripts) {
            compiler.compile("", AnalysisPass.Pass1, script.buildRmlProgram(), typeManager, new DummyThreadCallback(), profiler);
        }
    }

    @NotNull
    public Function0<String> bindRmlConsoleWatcher(@NotNull DfaLocalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        StringConsole stringConsole = new StringConsole();
        ((DfaLocalSessionImpl)session).setRunner(new DummyAnalysisRunner(stringConsole){
            final /* synthetic */ StringConsole $stringConsole;
            {
                this.$stringConsole = $stringConsole;
            }

            public UIInstancesProvider getUiInstancesProvider() {
                return new UIInstancesProvider(this.$stringConsole, new ConsoleUI());
            }
        });
        return (Function0)new Function0<String>(stringConsole){
            final /* synthetic */ StringConsole $stringConsole;
            {
                this.$stringConsole = $stringConsole;
                super(0);
            }

            public final String invoke() {
                String string = this.$stringConsole.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContent(...)");
                return string;
            }
        };
    }

    @NotNull
    public Pair<IrProject, Map<IrLocationOwner, Attribute>> translateToIR(@NotNull List<DfaTuple> tuples, @NotNull List<? extends RmlToIrTranslatorExtension> extensions) {
        Intrinsics.checkNotNullParameter(tuples, (String)"tuples");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        return new RmlToIrTranslator(extensions).translateProject(tuples);
    }
}

