/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildTime;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorKt;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.EnumWhenTrackerImpl;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.ImportTrackerImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.InlineConstTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.ImportTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.FilesToRecompile;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.IdeaPlatformKt;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService;
import org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportServiceKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 R2\u00020\u0001:\u0001RB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010#\u001a\u00020$H\u0016J4\u0010%\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010#\u001a\u00020$H\u0002JD\u0010%\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002Jh\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u00100\u001a\u0002012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0016\u00104\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u000206052\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0018\u00109\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u000eH\u0002Jn\u0010:\u001a\u0004\u0018\u0001032\u0006\u0010\r\u001a\u00020\u000e2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030'2\u0016\u00104\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u000206052\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010*\u001a\u00020+H\u0002J2\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0I052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010K\u001a\u00020LH\u0002J \u0010M\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u001f\u001a\u00020)H\u0002JJ\u0010P\u001a\u00020\f2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0I052\u0006\u0010\u001b\u001a\u00020\u00112\u0016\u00104\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u000206052\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "<init>", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "getPresentableName", "", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "buildStarted", "", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "logSettings", "ensureKotlinContextInitialized", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "initializeKotlinContext", "buildFinished", "ensureKotlinContextDisposed", "chunkBuildStarted", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "markAdditionalFilesForInitialRound", "kotlinChunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "kotlinContext", "chunkBuildFinished", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "doBuild", "representativeTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "kotlinDirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "buildMetricReporter", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "registerFilesToCompile", "createCompileEnvironment", "kotlinModuleBuilderTarget", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "importTracker", "Lorg/jetbrains/kotlin/incremental/components/ImportTracker;", "computeKotlinPathsForJpsPlugin", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "updateLookupStorage", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "markDirtyComplementaryMultifileClasses", "generatedFiles", "Companion", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilder\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ProgressReporter.kt\norg/jetbrains/kotlin/compilerRunner/ProgressReporterKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,800:1\n29#2,3:801\n2792#3,3:804\n1915#3,2:807\n1915#3,2:809\n1807#3,3:811\n1807#3,3:814\n1915#3,2:817\n1915#3,2:819\n1915#3,2:821\n777#3:823\n873#3,2:824\n1586#3:826\n1661#3,3:827\n1807#3,3:830\n1915#3,2:833\n1915#3,2:840\n1915#3,2:843\n1068#3:845\n1525#3:846\n1557#3,3:847\n1560#3,3:857\n812#3,12:860\n777#3:872\n873#3,2:873\n1391#3:875\n1480#3,5:876\n777#3:881\n873#3,2:882\n1586#3:884\n1661#3,3:885\n1391#3:888\n1480#3,5:889\n1391#3:894\n1480#3,5:895\n672#3,11:900\n1586#3:911\n1661#3,3:912\n1586#3:915\n1661#3,3:916\n37#4,5:835\n1#5:842\n383#6,7:850\n*S KotlinDebug\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilder\n*L\n147#1:801,3\n200#1:804,3\n272#1:807,2\n290#1:809,2\n324#1:811,3\n403#1:814,3\n407#1:817,2\n412#1:819,2\n422#1:821,2\n426#1:823\n426#1:824,2\n485#1:826\n485#1:827,3\n503#1:830,3\n512#1:833,2\n577#1:840,2\n680#1:843,2\n697#1:845\n698#1:846\n698#1:847,3\n698#1:857,3\n724#1:860,12\n725#1:872\n725#1:873,2\n726#1:875\n726#1:876,5\n728#1:881\n728#1:882,2\n729#1:884\n729#1:885,3\n731#1:888\n731#1:889,5\n732#1:894\n732#1:895,5\n689#1:900,11\n71#1:911\n71#1:912,3\n73#1:915\n73#1:916,3\n531#1:835,5\n698#1:850,7\n*E\n"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NlsSafe
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    private static final boolean useDependencyGraph;
    private static final boolean isKotlinBuilderInDumbMode;
    private static final boolean enableLookupStorageFillingInDumbMode;
    @NotNull
    private static final List<String> classesToLoadByParentFromRegistry;
    @NotNull
    private static final List<String> classPrefixesToLoadByParentFromRegistry;

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        Object[] objectArray = new String[]{"kt", "kts"};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logSettings(context);
        JpsStatisticsReportService reportService = JpsStatisticsReportService.Companion.create$jps_plugin();
        context.putUserData((Key)JpsStatisticsReportServiceKt.getStatisticsReportServiceKey(), (Object)reportService);
        reportService.buildStarted(context);
    }

    private final void logSettings(CompileContext context) {
        LOG.debug("==========================================");
        LOG.info("is Kotlin incremental compilation enabled for JVM: " + IncrementalCompilation.isEnabledForJvm());
        LOG.info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info("Label in local history: " + historyLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final KotlinCompileContext ensureKotlinContextInitialized(CompileContext context) {
        KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
        if (kotlinCompileContext != null) {
            return kotlinCompileContext;
        }
        GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
        synchronized (globalContextKey) {
            boolean bl = false;
            KotlinCompileContext actualKotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
            if (actualKotlinCompileContext != null) {
                return actualKotlinCompileContext;
            }
            try {
                return this.initializeKotlinContext(context);
            }
            catch (Throwable t) {
                IdeaPlatformKt.jpsReportInternalBuilderError(context, new Error("Cannot initialize Kotlin context: " + t.getMessage(), t));
                throw t;
            }
        }
    }

    private final KotlinCompileContext initializeKotlinContext(CompileContext context) {
        KotlinCompileContext kotlinContext = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        kotlinContext = new KotlinCompileContext(context);
        context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), (Object)kotlinContext);
        TestingContext testingContext = TestingContextKt.getTestingContext(context);
        if (testingContext != null) {
            testingContext.setKotlinCompileContext(kotlinContext);
        }
        if (kotlinContext.getShouldCheckCacheVersions() && kotlinContext.hasKotlin()) {
            kotlinContext.checkCacheVersions();
        }
        kotlinContext.cleanupCaches();
        kotlinContext.reportUnsupportedTargets();
        long time = System.currentTimeMillis() - start$iv;
        LOG.info("Total Kotlin global compile context initialization time: " + time + " ms");
        return kotlinContext;
    }

    public void buildFinished(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureKotlinContextDisposed(context);
        JpsStatisticsReportService reportService = JpsStatisticsReportService.Companion.getFromContext$jps_plugin(context);
        reportService.buildFinish(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureKotlinContextDisposed(CompileContext context) {
        if (context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey()) != null) {
            GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
            synchronized (globalContextKey) {
                boolean bl = false;
                KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
                if (kotlinCompileContext != null) {
                    kotlinCompileContext.dispose();
                    context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), null);
                    this.statisticsLogger.reportTotal();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        block10: {
            boolean bl;
            TestingBuildLogger buildLogger;
            KotlinCompileContext kotlinContext;
            block9: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                super.chunkBuildStarted(context, chunk);
                if (JpsUtilKt.isDummy(chunk, context)) {
                    return;
                }
                kotlinContext = this.ensureKotlinContextInitialized(context);
                TestingContext testingContext = TestingContextKt.getTestingContext(context);
                TestingBuildLogger testingBuildLogger = buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
                if (testingBuildLogger != null) {
                    testingBuildLogger.chunkBuildStarted(context, chunk);
                }
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                    return;
                }
                Set set = chunk.getTargets();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTargets(...)");
                Set targets = set;
                Iterable $this$none$iv = targets;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                        boolean bl2 = false;
                        HasKotlinMarker hasKotlinMarker = kotlinContext.getHasKotlinMarker();
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(it), (Object)true)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            KotlinChunk kotlinChunk = kotlinContext.getChunk(chunk);
            if (kotlinChunk == null) {
                return;
            }
            KotlinChunk kotlinChunk2 = kotlinChunk;
            kotlinContext.checkChunkCacheVersion(kotlinChunk2);
            if (!isKotlinBuilderInDumbMode && !kotlinContext.getRebuildingAllKotlin() && kotlinChunk2.isEnabled()) {
                this.markAdditionalFilesForInitialRound(kotlinChunk2, chunk, kotlinContext);
            }
            TestingBuildLogger testingBuildLogger = buildLogger;
            if (testingBuildLogger == null) break block10;
            testingBuildLogger.afterChunkBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(KotlinChunk kotlinChunk, ModuleChunk chunk, KotlinCompileContext kotlinContext) {
        CompileContext context = kotlinContext.getJpsContext();
        KotlinDirtySourceFilesHolder dirtyFilesHolder2 = new KotlinDirtySourceFilesHolder(chunk, context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk){
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;
            {
                this.$context = $context;
                this.$chunk = $chunk;
                super($context);
            }

            public void processDirtyFiles(FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
            }
        }));
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, dirtyFilesHolder2, LOG);
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinContext.getTargetsBinding().get(chunk.representativeTarget());
        if (kotlinModuleBuildTarget == null) {
            return;
        }
        KotlinModuleBuildTarget<?> representativeTarget = kotlinModuleBuildTarget;
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> incrementalCaches = kotlinChunk.loadCaches(false);
        MessageCollectorAdapter messageCollector2 = new MessageCollectorAdapter(context, representativeTarget);
        JpsCompilerEnvironment jpsCompilerEnvironment = this.createCompileEnvironment(kotlinContext.getJpsContext(), representativeTarget, incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, ExpectActualTracker.DoNothing.INSTANCE, InlineConstTracker.DoNothing.INSTANCE, EnumWhenTracker.DoNothing.INSTANCE, ImportTracker.DoNothing.INSTANCE, chunk, messageCollector2);
        if (jpsCompilerEnvironment == null) {
            return;
        }
        JpsCompilerEnvironment environment = jpsCompilerEnvironment;
        HashSet<String> removedClasses = new HashSet<String>();
        for (KotlinModuleBuildTarget<?> target : kotlinChunk.getTargets()) {
            JpsIncrementalCache cache2;
            if (incrementalCaches.get(target) == null) continue;
            Set<File> dirtyFiles = dirtyFilesHolder2.getDirtyFiles(target.getJpsModuleBuildTarget()).keySet();
            Collection<File> removedFiles = dirtyFilesHolder2.getRemovedFiles(target.getJpsModuleBuildTarget());
            Set<String> existingClasses = new JpsKotlinCompilerRunner().classesFqNamesByFiles(environment, dirtyFiles);
            Collection<FqName> previousClasses = cache2.classesFqNamesBySources(SetsKt.plus(dirtyFiles, (Iterable)removedFiles));
            for (FqName jvmClassName : previousClasses) {
                String fqName2 = jvmClassName.asString();
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $this$forEach$iv = removedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            changesCollector.collectSignature(new FqName(it), true);
        }
        FilesToRecompile affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, incrementalCaches.values(), kotlinContext.getLookupStorageManager());
        fsOperations.markFilesForCurrentRound$jps_plugin(SetsKt.plus(affectedByRemovedClasses.getDirtyFiles(), (Iterable)affectedByRemovedClasses.getForceRecompileTogether()));
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        KotlinCompileContext kotlinContext = this.ensureKotlinContextInitialized(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            Collection outputRoots;
            HasKotlinMarker hasKotlinMarker = kotlinContext.getHasKotlinMarker();
            Intrinsics.checkNotNull((Object)target);
            if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(target), (Object)true)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)target.getOutputRoots(context), (String)"getOutputRoots(...)");
            if (outputRoots.size() <= 1) continue;
            Iterable $this$forEach$iv = outputRoots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                it.mkdirs();
            }
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ModuleLevelBuilder.ExitCode exitCode;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter(dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
        JpsStatisticsReportService reportService = JpsStatisticsReportService.Companion.getFromContext$jps_plugin(context);
        reportService.moduleBuildStarted(chunk);
        ModuleLevelBuilder.ExitCode result2 = exitCode = this.doBuild(context, chunk, dirtyFilesHolder2, outputConsumer);
        boolean bl = false;
        reportService.moduleBuildFinished(chunk, context, result2);
        return exitCode;
    }

    private final ModuleLevelBuilder.ExitCode doBuild(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        boolean bl;
        MessageCollectorAdapter messageCollector2;
        KotlinModuleBuildTarget<?> kotlinTarget;
        block11: {
            if (JpsUtilKt.isDummy(chunk, context)) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(chunk.representativeTarget());
            if (kotlinModuleBuildTarget == null) {
                return ModuleLevelBuilder.ExitCode.OK;
            }
            kotlinTarget = kotlinModuleBuildTarget;
            messageCollector2 = new MessageCollectorAdapter(context, kotlinTarget);
            Set set = chunk.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getModules(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpsModule it = (JpsModule)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(ModuleSettingsKt.getKotlinKind(it) == KotlinModuleKind.SOURCE_SET_HOLDER)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            if (chunk.getModules().size() > 1) {
                MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.cyclically.dependent.modules.are.not.supported.in.multiplatform.projects", new Object[0]), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder = new KotlinDirtySourceFilesHolder(chunk, context, dirtyFilesHolder2);
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, kotlinDirtyFilesHolder, LOG);
        try {
            JpsStatisticsReportService reportService = JpsStatisticsReportService.Companion.getFromContext$jps_plugin(context);
            reportService.reportDirtyFiles(kotlinDirtyFilesHolder);
            return (ModuleLevelBuilder.ExitCode)reportService.reportMetrics(chunk, JpsBuildTime.JPS_ITERATION, () -> KotlinBuilder.doBuild$lambda$1(this, chunk, kotlinTarget, context, kotlinDirtyFilesHolder, messageCollector2, outputConsumer, fsOperations));
        }
        catch (StopBuildException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw e;
        }
        catch (BuildDataCorruptedException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw e;
        }
        catch (Throwable e) {
            LOG.info("Caught exception: " + e);
            MessageCollectorUtil.reportException(messageCollector2, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CompileContext context, KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block38: {
            block37: {
                v0 = System.getProperty("kotlin.jps.enabled", "true");
                Intrinsics.checkNotNull((Object)v0);
                if (!Boolean.parseBoolean(v0)) {
                    MessageCollector.report$default(messageCollector, CompilerMessageSeverity.INFO, KotlinJpsBundle.message("info.text.kotlin.jps.plugin.is.disabled", new Object[0]), null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                kotlinContext = KotlinCompileContextKt.getKotlin(context);
                v1 = JpsUtilKt.toKotlinChunk(chunk, context);
                Intrinsics.checkNotNull((Object)v1);
                kotlinChunk = v1;
                if (!kotlinChunk.getHaveSameCompiler()) {
                    var10_10 = new Object[]{kotlinChunk.getPresentableModulesToCompilersList()};
                    MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.cyclically.dependent.modules.0.should.have.same.compiler", var10_10), null, 4, null);
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
                if (!kotlinChunk.isEnabled()) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                v2 = context.getProjectDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProjectDescriptor(...)");
                projectDescriptor = v2;
                v3 = chunk.getTargets();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getTargets(...)");
                targets = v3;
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                $this$any$iv = targets;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Object[] element$iv : $this$any$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-any-KotlinBuilder$doBuild$isChunkRebuilding$1 = false;
                        v5 = kotlinContext.getRebuildAfterCacheVersionChanged();
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)v5.get(it), (Object)true)) continue;
                        v4 = true;
                        break block37;
                    }
                    v4 = false;
                }
            }
            if (v4) lbl-1000:
            // 2 sources

            {
                v6 = true;
            } else {
                v6 = isChunkRebuilding = false;
            }
            if (!kotlinDirtyFilesHolder.getHasDirtyOrRemovedFiles()) {
                if (isChunkRebuilding) {
                    $this$forEach$iv = targets;
                    $i$f$forEach = false;
                    for (Object[] element$iv : $this$forEach$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-forEach-KotlinBuilder$doBuild$3 = false;
                        v7 = kotlinContext.getHasKotlinMarker();
                        Intrinsics.checkNotNull((Object)it);
                        v7.set(it, false);
                    }
                }
                $this$forEach$iv = targets;
                $i$f$forEach = false;
                for (Object[] element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$4 = false;
                    v8 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    Intrinsics.checkNotNull((Object)it);
                    v8.clean(it);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            if (!isChunkRebuilding && !representativeTarget.isIncrementalCompilationEnabled()) {
                $this$forEach$iv = targets;
                $i$f$forEach = false;
                for (Object[] element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$5 = false;
                    v9 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    Intrinsics.checkNotNull((Object)it);
                    v9.set(it, true);
                }
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            $this$filter$iv = (Object[])targets;
            $i$f$filter = false;
            element$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (ModuleBuildTarget)element$iv$iv;
                $i$a$-filter-KotlinBuilder$doBuild$targetsWithoutOutputDir$1 = false;
                if (!(it.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            if (((Collection)targetsWithoutOutputDir).isEmpty() == false) {
                $this$filter$iv = new Object[]{CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null)};
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, KotlinJpsBundle.message("error.text.output.directory.not.specified.for.0", $this$filter$iv), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            project = projectDescriptor.getProject();
            Intrinsics.checkNotNull((Object)project);
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(project, representativeTarget);
            exceptActualTracker = new ExpectActualTrackerImpl();
            incrementalCaches = KotlinChunk.loadCaches$default(kotlinChunk, false, 1, null);
            inlineConstTracker = new InlineConstTrackerImpl();
            enumWhenTracker = new EnumWhenTrackerImpl();
            importTracker = new ImportTrackerImpl();
            v10 = this.createCompileEnvironment(context, representativeTarget, incrementalCaches, lookupTracker, exceptActualTracker, inlineConstTracker, enumWhenTracker, importTracker, chunk, messageCollector);
            if (v10 == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            environment = v10;
            v11 = TestingContextKt.getTestingContext(context);
            if (v11 != null && (v11 = v11.getBuildLogger()) != null) {
                v11.compilingFiles((Collection<? extends File>)kotlinDirtyFilesHolder.getAllDirtyFiles(), (Collection<? extends File>)kotlinDirtyFilesHolder.getAllRemovedFilesFiles());
            }
            reportService = JpsStatisticsReportService.Companion.getFromContext$jps_plugin(context);
            reportService.reportCompilerArguments(chunk, kotlinChunk);
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(kotlinChunk, representativeTarget, kotlinChunk.getCompilerArguments(), context, kotlinDirtyFilesHolder, fsOperations, environment, incrementalCaches, reportService.getMetricReporter(chunk));
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            if (compilationErrors.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                var27_32 = messageCollector.getFilesWithErrors();
                var41_34 = context;
                $i$f$map = false;
                var29_37 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var34_51 = (String)item$iv$iv;
                    var42_56 = destination$iv$iv;
                    $i$a$-map-KotlinBuilder$doBuild$6 = false;
                    var42_56.add(new File((String)p0));
                }
                JavaBuilderUtil.registerFilesWithErrors((CompileContext)var41_34, (Collection)((List)destination$iv$iv));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)context, (Collection)kotlinDirtyFilesHolder.getAllDirtyFiles());
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            if (!KotlinBuilder.isKotlinBuilderInDumbMode) {
                this.markDirtyComplementaryMultifileClasses(generatedFiles, kotlinContext, incrementalCaches, fsOperations);
            }
            kotlinTargets = kotlinContext.getTargetsBinding();
            for (Map.Entry<ModuleBuildTarget, List<GeneratedFile>> destination$iv$iv : generatedFiles.entrySet()) {
                target = destination$iv$iv.getKey();
                outputItems = destination$iv$iv.getValue();
                if (kotlinTargets.get(target) == null) {
                    throw new IllegalStateException(("Could not find Kotlin target for JPS target " + target).toString());
                }
                kotlinTarget.registerOutputItems(outputConsumer, outputItems);
            }
            kotlinChunk.saveVersions();
            $this$any$iv = targets;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v12 = false;
            } else {
                target = $this$any$iv.iterator();
                while (target.hasNext()) {
                    element$iv = target.next();
                    it = (ModuleBuildTarget)element$iv;
                    $i$a$-any-KotlinBuilder$doBuild$7 = false;
                    v13 = kotlinContext.getHasKotlinMarker();
                    Intrinsics.checkNotNull((Object)it);
                    if (!(v13.get((ModuleBuildTarget)it) == null)) continue;
                    v12 = true;
                    break block38;
                }
                v12 = false;
            }
        }
        if (v12) {
            fsOperations.markChunk(false, true, kotlinDirtyFilesHolder.getAllDirtyFiles());
        }
        for (ModuleBuildTarget target : targets) {
            v14 = kotlinContext.getHasKotlinMarker();
            Intrinsics.checkNotNull((Object)target);
            v14.set(target, true);
            kotlinContext.getRebuildAfterCacheVersionChanged().clean(target);
        }
        $this$forEach$iv = kotlinChunk.getTargets();
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (KotlinModuleBuildTarget)element$iv;
            $i$a$-forEach-KotlinBuilder$doBuild$8 = false;
            it.doAfterBuild();
        }
        representativeTarget.updateChunkMappings(context, chunk, kotlinDirtyFilesHolder, generatedFiles, incrementalCaches, environment);
        if (!representativeTarget.isIncrementalCompilationEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $this$withProgressReporter$iv = environment;
        $i$f$withProgressReporter = false;
        try {
            progress = $this$withProgressReporter$iv.getProgressReporter();
            $i$a$-withProgressReporter-KotlinBuilder$doBuild$9 = false;
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            for (Map.Entry<ModuleBuildTarget, List<GeneratedFile>> var35_55 : generatedFiles.entrySet()) {
                target = var35_55.getKey();
                files = var35_55.getValue();
                Intrinsics.checkNotNull(kotlinContext.getTargetsBinding().get(target));
                v15 = incrementalCaches.get(kotlinModuleBuilderTarget);
                Intrinsics.checkNotNull(v15);
                kotlinModuleBuilderTarget.updateCaches(kotlinDirtyFilesHolder, (JpsIncrementalCache)v15, files, changesCollector, environment);
            }
            if (!KotlinBuilder.isKotlinBuilderInDumbMode || KotlinBuilder.enableLookupStorageFillingInDumbMode) {
                this.updateLookupStorage(lookupTracker, kotlinContext.getLookupStorageManager(), kotlinDirtyFilesHolder);
            }
            if (!KotlinBuilder.isKotlinBuilderInDumbMode && !isChunkRebuilding) {
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, kotlinDirtyFilesHolder.getAllDirtyFiles(), kotlinContext.getLookupStorageManager(), fsOperations, incrementalCaches.values());
            }
            var39_60 = Unit.INSTANCE;
        }
        finally {
            $this$withProgressReporter$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    private final OutputItemsCollector doCompileModuleChunk(KotlinChunk kotlinChunk, KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context, KotlinDirtySourceFilesHolder dirtyFilesHolder2, FSOperationsHelper fsOperations, JpsCompilerEnvironment environment, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, JpsBuilderMetricReporter buildMetricReporter) {
        Iterable $this$forEach$iv = kotlinChunk.getTargets();
        boolean bl = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl2 = false;
            it.nextRound(context);
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            JpsBuilderMetricReporter jpsBuilderMetricReporter = buildMetricReporter;
            if (jpsBuilderMetricReporter != null) {
                jpsBuilderMetricReporter.addTag(StatTag.INCREMENTAL);
            }
            for (KotlinModuleBuildTarget kotlinModuleBuildTarget : kotlinChunk.getTargets()) {
                JpsIncrementalCache cache2 = incrementalCaches.get(kotlinModuleBuildTarget);
                ModuleBuildTarget jpsTarget = kotlinModuleBuildTarget.getJpsModuleBuildTarget();
                KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles = dirtyFilesHolder2.getByTarget().get(jpsTarget);
                if (cache2 == null || targetDirtyFiles == null) continue;
                Collection<File> complementaryFiles = cache2.getComplementaryFilesRecursive(SetsKt.plus(targetDirtyFiles.getDirty().keySet(), (Iterable)targetDirtyFiles.getRemoved()));
                Object object = TestingContextKt.getTestingContext(context);
                if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                    object.markedAsComplementaryFiles((Collection<? extends File>)new ArrayList<File>(complementaryFiles));
                }
                fsOperations.markFilesForCurrentRound(jpsTarget, complementaryFiles);
                cache2.markDirty(SetsKt.plus(targetDirtyFiles.getDirty().keySet(), (Iterable)targetDirtyFiles.getRemoved()));
            }
        }
        this.registerFilesToCompile(dirtyFilesHolder2, context);
        boolean isDoneSomething = representativeTarget.compileModuleChunk(commonArguments, dirtyFilesHolder2, environment, buildMetricReporter);
        return isDoneSomething ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    private final void registerFilesToCompile(KotlinDirtySourceFilesHolder dirtyFilesHolder2, CompileContext context) {
        Set<File> allDirtyFiles = dirtyFilesHolder2.getAllDirtyFiles();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compiling files: " + allDirtyFiles);
        }
        JavaBuilderUtil.registerFilesToCompile((CompileContext)context, (Collection)allDirtyFiles);
    }

    private final JpsCompilerEnvironment createCompileEnvironment(CompileContext context, KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, LookupTracker lookupTracker, ExpectActualTracker exceptActualTracer, InlineConstTracker inlineConstTracker, EnumWhenTracker enumWhenTracker, ImportTracker importTracker, ModuleChunk chunk, MessageCollectorAdapter messageCollector2) {
        Services.Builder $this$createCompileEnvironment_u24lambda_u240 = new Services.Builder();
        boolean bl = false;
        kotlinModuleBuilderTarget.makeServices($this$createCompileEnvironment_u24lambda_u240, incrementalCaches, lookupTracker, exceptActualTracer, inlineConstTracker, enumWhenTracker, importTracker);
        Services compilerServices = $this$createCompileEnvironment_u24lambda_u240.build();
        KotlinPaths kotlinPaths = this.computeKotlinPathsForJpsPlugin(messageCollector2);
        if (kotlinPaths == null) {
            return null;
        }
        return new JpsCompilerEnvironment(kotlinPaths, compilerServices, Companion.getClassesToLoadByParent(), messageCollector2, new OutputItemsCollectorImpl(), new ProgressReporterImpl(context, chunk));
    }

    private final KotlinPaths computeKotlinPathsForJpsPlugin(MessageCollectorAdapter messageCollector2) {
        KotlinPaths kotlinPaths;
        File jpsKotlinHome;
        File file;
        String string = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = jpsKotlinHome = null;
        }
        if (StringsKt.equals((String)System.getProperty("kotlin.jps.tests"), (String)"true", (boolean)true) && jpsKotlinHome == null) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        if (jpsKotlinHome == null) {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Make sure that 'jps.kotlin.home' system property is set in JPS process", null, 4, null);
            kotlinPaths = null;
        } else if (jpsKotlinHome.exists()) {
            kotlinPaths = new KotlinPathsFromHomeDir(jpsKotlinHome);
        } else {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Cannot find kotlinc home at " + jpsKotlinHome, null, 4, null);
            kotlinPaths = null;
        }
        return kotlinPaths;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$sortedBy$iv;
        File it;
        Iterable target2;
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        if (chunk.getTargets().size() > 1) {
            for (Iterable target2 : chunk.getTargets()) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(target2);
                if (kotlinModuleBuildTarget != null && (kotlinModuleBuildTarget = kotlinModuleBuildTarget.getSourceFiles()) != null) {
                    Iterable $this$forEach$iv = (Iterable)((Object)kotlinModuleBuildTarget);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (File)element$iv;
                        boolean bl = false;
                        ((Map)sourceToTarget).put(it, target2);
                    }
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        target2 = outputItemCollector.getOutputs();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimpleOutputItem it = (SimpleOutputItem)a;
                boolean bl = false;
                Comparable comparable = it.getOutputFile();
                it = (SimpleOutputItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getOutputFile());
            }
        });
        boolean $i$f$groupBy = false;
        void var8_14 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            SimpleOutputItem p0 = (SimpleOutputItem)element$iv$iv;
            boolean bl = false;
            ModuleBuildTarget key$iv$iv = KotlinBuilder.getGeneratedFiles$target(p0, chunk, representativeTarget, sourceToTarget);
            Map map = destination$iv$iv;
            ModuleBuildTarget key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p0 = (SimpleOutputItem)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            list.add(OutputItemsCollectorKt.toGeneratedFile((SimpleOutputItem)((Object)it), MetadataVersion.INSTANCE));
        }
        return destination$iv$iv;
    }

    private final void updateLookupStorage(LookupTracker lookupTracker, JpsLookupStorageManager lookupStorageManager, KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass()));
        }
        lookupStorageManager.withLookupStorage(arg_0 -> KotlinBuilder.updateLookupStorage$lambda$0(dirtyFilesHolder2, lookupTracker, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void markDirtyComplementaryMultifileClasses(Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> generatedFiles, KotlinCompileContext kotlinContext, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, FSOperationsHelper fsOperations) {
        for (Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry : generatedFiles.entrySet()) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            IncrementalJvmCache cache2;
            KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget;
            JpsIncrementalCache jpsIncrementalCache;
            ModuleBuildTarget target = entry.getKey();
            List<? extends GeneratedFile> files2 = entry.getValue();
            if (kotlinContext.getTargetsBinding().get(target) == null || ((jpsIncrementalCache = incrementalCaches.get(kotlinModuleBuilderTarget)) instanceof IncrementalJvmCache ? (IncrementalJvmCache)((Object)jpsIncrementalCache) : null) == null) continue;
            cache2 = cache2;
            Iterable $this$filterIsInstance$iv = files2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof GeneratedJvmClass)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List generated = (List)destination$iv$iv;
            Iterable $this$filter$iv = generated;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv3;
                boolean bl = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List multifileClasses = (List)destination$iv$iv2;
            Iterable $this$flatMap$iv2 = multifileClasses;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv4 : $this$flatMapTo$iv$iv2) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv4;
                boolean bl = false;
                Collection collection = cache2.getAllPartsOfMultifileFacade(it.getOutputClass().getClassName());
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List expectedAllParts = (List)destination$iv$iv3;
            if (multifileClasses.isEmpty()) continue;
            Iterable $this$filter$iv2 = generated;
            boolean $i$f$filter2 = false;
            destination$iv$iv3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv5;
                boolean bl = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART)) continue;
                destination$iv$iv4.add(element$iv$iv5);
            }
            $this$filter$iv2 = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl = false;
                object.add(it.getOutputClass().getClassName().toString());
            }
            List actualParts = (List)destination$iv$iv4;
            if (actualParts.containsAll(expectedAllParts)) continue;
            $this$map$iv = expectedAllParts;
            object = fsOperations;
            boolean $i$f$flatMap2 = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv6 : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv6;
                boolean bl = false;
                Iterable list$iv$iv = cache2.sourcesByInternalName(it);
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = multifileClasses;
            Collection collection = (List)destination$iv$iv4;
            $i$f$flatMap2 = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv7 : $this$flatMapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv7;
                boolean bl = false;
                Iterable list$iv$iv = it.getSourceFiles();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv4;
            ((FSOperationsHelper)object).markFiles(CollectionsKt.plus((Collection)collection, (Iterable)list));
        }
    }

    private static final ModuleLevelBuilder.ExitCode doBuild$lambda$1(KotlinBuilder this$0, ModuleChunk $chunk, KotlinModuleBuildTarget $kotlinTarget, CompileContext $context, KotlinDirtySourceFilesHolder $kotlinDirtyFilesHolder, MessageCollectorAdapter $messageCollector, ModuleLevelBuilder.OutputConsumer $outputConsumer, FSOperationsHelper $fsOperations) {
        ModuleLevelBuilder.ExitCode actualExitCode;
        block0: {
            ModuleLevelBuilder.ExitCode proposedExitCode = this$0.doBuild($chunk, $kotlinTarget, $context, $kotlinDirtyFilesHolder, $messageCollector, $outputConsumer, $fsOperations);
            actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && $fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext($context);
            if (object == null || (object = ((TestingContext)object).getBuildLogger()) == null) break block0;
            object.buildFinished(actualExitCode);
        }
        return actualExitCode;
    }

    private static final ModuleBuildTarget getGeneratedFiles$target(SimpleOutputItem $this$getGeneratedFiles_u24target, ModuleChunk $chunk, ModuleBuildTarget representativeTarget, HashMap<File, ModuleBuildTarget> sourceToTarget) {
        File file;
        block9: {
            Object v4;
            block7: {
                block8: {
                    file = (File)CollectionsKt.firstOrNull((Iterable)$this$getGeneratedFiles_u24target.getSourceFiles());
                    if (file == null) break block8;
                    File it = file;
                    boolean bl = false;
                    ModuleBuildTarget moduleBuildTarget = sourceToTarget.get(it);
                    file = moduleBuildTarget;
                    if (moduleBuildTarget != null) break block9;
                }
                Set set = $chunk.getTargets();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTargets(...)");
                Iterable $this$singleOrNull$iv = set;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    boolean bl;
                    ModuleBuildTarget target = (ModuleBuildTarget)element$iv;
                    boolean bl2 = false;
                    if (target.getOutputDir() != null) {
                        File outputDir;
                        boolean bl3 = false;
                        bl = FilesKt.startsWith((File)$this$getGeneratedFiles_u24target.getOutputFile(), (File)outputDir);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    if (found$iv) {
                        v4 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            if ((file = (ModuleBuildTarget)v4) == null) {
                file = representativeTarget;
            }
        }
        return file;
    }

    private static final Unit updateLookupStorage$lambda$0(KotlinDirtySourceFilesHolder $dirtyFilesHolder, LookupTracker $lookupTracker, LookupStorage lookupStorage) {
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)$dirtyFilesHolder.getAllDirtyFiles()), (Sequence)CollectionsKt.asSequence((Iterable)$dirtyFilesHolder.getAllRemovedFilesFiles())));
        MultiMap<LookupSymbol, String> multiMap = ((LookupTrackerImpl)$lookupTracker).getLookups();
        Set set = ((LookupTrackerImpl)$lookupTracker).getPathInterner().getValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getValues(...)");
        lookupStorage.addAll(multiMap, set);
        return Unit.INSTANCE;
    }

    static {
        List list;
        Object object;
        List list2;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        char[] cArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        String string = System.getProperty("jps.use.dependency.graph", "false");
        Intrinsics.checkNotNull((Object)string);
        useDependencyGraph = Boolean.parseBoolean(string);
        String string2 = System.getProperty("kotlin.jps.dumb.mode", "false");
        Intrinsics.checkNotNull((Object)string2);
        isKotlinBuilderInDumbMode = Boolean.parseBoolean(string2);
        String string3 = System.getProperty("kotlin.jps.enable.lookups.in.dumb.mode", "false");
        Intrinsics.checkNotNull((Object)string3);
        enableLookupStorageFillingInDumbMode = Boolean.parseBoolean(string3);
        Object object2 = System.getProperty("kotlin.jps.classesToLoadByParent");
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
            $this$map$iv = (Iterable)object2;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = classesToLoadByParentFromRegistry = CollectionsKt.emptyList();
        }
        if ((object = System.getProperty("kotlin.jps.classPrefixesToLoadByParent")) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        classPrefixesToLoadByParentFromRegistry = list;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "<init>", "()V", "KOTLIN_BUILDER_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "JPS_KOTLIN_HOME_PROPERTY", "useDependencyGraph", "", "getUseDependencyGraph", "()Z", "isKotlinBuilderInDumbMode", "enableLookupStorageFillingInDumbMode", "getEnableLookupStorageFillingInDumbMode", "classesToLoadByParentFromRegistry", "", "classPrefixesToLoadByParentFromRegistry", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nKotlinBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,800:1\n1915#2,2:801\n1915#2,2:803\n*S KotlinDebug\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion\n*L\n91#1:801,2\n92#1:803,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean getUseDependencyGraph() {
            return useDependencyGraph;
        }

        public final boolean isKotlinBuilderInDumbMode() {
            return isKotlinBuilderInDumbMode;
        }

        public final boolean getEnableLookupStorageFillingInDumbMode() {
            return enableLookupStorageFillingInDumbMode;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return Companion::_get_classesToLoadByParent_$lambda$0;
        }

        private static final boolean _get_classesToLoadByParent_$lambda$0(String className) {
            String it;
            Object[] objectArray = new String[]{"org.apache.log4j.", "org.jetbrains.kotlin.incremental.components.", "org.jetbrains.kotlin.load.kotlin.incremental.components."};
            List prefixes = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)classPrefixesToLoadByParentFromRegistry);
            Object[] objectArray2 = new String[]{"org.jetbrains.kotlin.config.Services", "org.jetbrains.kotlin.progress.CompilationCanceledStatus", "org.jetbrains.kotlin.progress.CompilationCanceledException", "org.jetbrains.kotlin.modules.TargetId", "org.jetbrains.kotlin.cli.common.ExitCode"};
            List classes2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray2), (Iterable)classesToLoadByParentFromRegistry);
            Iterable $this$forEach$iv = prefixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)className);
                if (!StringsKt.startsWith$default((String)className, (String)it, (boolean)false, (int)2, null)) continue;
                return true;
            }
            $this$forEach$iv = classes2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)className, (Object)it)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

