/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.util.connection;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.execution.process.ProcessHandler;
import com.sun.jdi.VMDisconnectedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"isConnectionAlive", "", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)Z", "isVMDisconnectedException", "", "(Ljava/lang/Throwable;)Z", "isProxyInvocationException", "intellij.kotlin.jupyter.debug"})
public final class ConnectionCheckUtilsKt {
    public static final boolean isConnectionAlive(@NotNull DebugProcess $this$isConnectionAlive) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnectionAlive, (String)"<this>");
        if ($this$isConnectionAlive.isDetaching() || $this$isConnectionAlive.isDetached() || !$this$isConnectionAlive.isAttached()) {
            return false;
        }
        ProcessHandler handler = $this$isConnectionAlive.getProcessHandler();
        return handler != null && !handler.isProcessTerminated();
    }

    public static final boolean isVMDisconnectedException(@NotNull Throwable $this$isVMDisconnectedException) {
        Intrinsics.checkNotNullParameter((Object)$this$isVMDisconnectedException, (String)"<this>");
        if ($this$isVMDisconnectedException instanceof VMDisconnectedException) {
            return true;
        }
        Throwable throwable = $this$isVMDisconnectedException;
        Throwable cause = throwable instanceof InvocationTargetException ? ((InvocationTargetException)$this$isVMDisconnectedException).getTargetException() : (throwable instanceof UndeclaredThrowableException ? ((UndeclaredThrowableException)$this$isVMDisconnectedException).getUndeclaredThrowable() : $this$isVMDisconnectedException.getCause());
        return cause instanceof VMDisconnectedException;
    }

    public static final boolean isProxyInvocationException(@NotNull Throwable $this$isProxyInvocationException) {
        Intrinsics.checkNotNullParameter((Object)$this$isProxyInvocationException, (String)"<this>");
        Throwable throwable = $this$isProxyInvocationException;
        Throwable cause = throwable instanceof InvocationTargetException ? ((InvocationTargetException)$this$isProxyInvocationException).getTargetException() : (throwable instanceof UndeclaredThrowableException ? ((UndeclaredThrowableException)$this$isProxyInvocationException).getUndeclaredThrowable() : $this$isProxyInvocationException.getCause());
        return cause instanceof InvocationTargetException || cause instanceof IllegalStateException;
    }
}

