/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.util.connection;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionPath;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.debug.variables.KotlinNotebookSessionVariablesService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kotlin/jupyter/debug/util/connection/NotebookDebugProcessListener;", "Lcom/intellij/debugger/engine/DebugProcessListener;", "project", "Lcom/intellij/openapi/project/Project;", "sessionPath", "Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionPath;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "isSilent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionPath;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Z)V", "paused", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "resumed", "processDetached", "process", "Lcom/intellij/debugger/engine/DebugProcess;", "closedByUser", "processAttached", "Companion", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nNotebookDebugProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookDebugProcessListener.kt\ncom/intellij/kotlin/jupyter/debug/util/connection/NotebookDebugProcessListener\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,50:1\n13#2:51\n*S KotlinDebug\n*F\n+ 1 NotebookDebugProcessListener.kt\ncom/intellij/kotlin/jupyter/debug/util/connection/NotebookDebugProcessListener\n*L\n24#1:51\n*E\n"})
public final class NotebookDebugProcessListener
implements DebugProcessListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterDebugSessionPath sessionPath;
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;
    private final boolean isSilent;
    @NotNull
    private static final Logger LOG;

    public NotebookDebugProcessListener(@NotNull Project project, @NotNull JupyterDebugSessionPath sessionPath, @NotNull BackedNotebookVirtualFile virtualFile, boolean isSilent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionPath, (String)"sessionPath");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.sessionPath = sessionPath;
        this.virtualFile = virtualFile;
        this.isSilent = isSilent;
    }

    public /* synthetic */ NotebookDebugProcessListener(Project project, JupyterDebugSessionPath jupyterDebugSessionPath, BackedNotebookVirtualFile backedNotebookVirtualFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(project, jupyterDebugSessionPath, backedNotebookVirtualFile, bl);
    }

    public void paused(@NotNull SuspendContext suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        LOG.warn("PAUSED");
        if (!this.isSilent) {
            return;
        }
        KotlinNotebookSessionVariablesService.Companion.getForFile(this.project, this.virtualFile).requestVariablesUpdate();
    }

    public void resumed(@Nullable SuspendContext suspendContext) {
        LOG.warn("RESUMED");
    }

    public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        JupyterDebugSessionManager.Companion.getInstance(this.project).debugInSessionFinished(this.sessionPath);
        LOG.info("Process terminated, closedByUser: " + closedByUser);
    }

    public void processAttached(@NotNull DebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        LOG.info("Attached: " + process);
        if (process instanceof DebugProcessImpl) {
            KotlinNotebookDebugSessionManager.Companion.getForFile(this.project, this.virtualFile).prepareInternalRequests((DebugProcessImpl)process);
        }
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/debug/util/connection/NotebookDebugProcessListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

