/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ContinuationOption;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditorBase;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartIndentOptionsEditor
extends IndentOptionsEditor
implements SmartIndentOptionsEditorBase {
    private JCheckBox myCbSmartTabs;
    private final ContinuationOption myContinuationOption;
    private final ContinuationOption myDeclarationParameterIndentOption;
    private final ContinuationOption myGenericTypeParameterIndentOption;
    private final ContinuationOption myCallParameterIndentOption;
    private final ContinuationOption myChainedCallIndentOption;
    private final ContinuationOption myArrayElementIndentOption;
    private final List<ContinuationOption> myContinuationOptions = new ArrayList<ContinuationOption>();
    private JCheckBox myCbKeepIndentsOnEmptyLines;

    public SmartIndentOptionsEditor() {
        this(null);
    }

    public SmartIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
        super(provider);
        this.myContinuationOption = this.createContinuationOption(SmartIndentOptionsEditor.getContinuationIndentLabel(), options -> options.CONTINUATION_INDENT_SIZE, (options, value) -> {
            options.CONTINUATION_INDENT_SIZE = value;
        }, 8);
        this.myContinuationOption.setSupported(true);
        this.myDeclarationParameterIndentOption = this.createContinuationOption(ApplicationBundle.message((String)"editbox.indent.declaration.parameter", (Object[])new Object[0]), options -> options.DECLARATION_PARAMETER_INDENT, (options, value) -> {
            options.DECLARATION_PARAMETER_INDENT = value;
        }, -1);
        this.myGenericTypeParameterIndentOption = this.createContinuationOption(ApplicationBundle.message((String)"editbox.indent.generic.type", (Object[])new Object[0]), options -> options.GENERIC_TYPE_PARAMETER_INDENT, (options, value) -> {
            options.GENERIC_TYPE_PARAMETER_INDENT = value;
        }, -1);
        this.myCallParameterIndentOption = this.createContinuationOption(ApplicationBundle.message((String)"editbox.indent.call.parameter", (Object[])new Object[0]), options -> options.CALL_PARAMETER_INDENT, (options, value) -> {
            options.CALL_PARAMETER_INDENT = value;
        }, -1);
        this.myChainedCallIndentOption = this.createContinuationOption(ApplicationBundle.message((String)"editbox.indent.chained.call", (Object[])new Object[0]), options -> options.CHAINED_CALL_INDENT, (options, value) -> {
            options.CHAINED_CALL_INDENT = value;
        }, -1);
        this.myArrayElementIndentOption = this.createContinuationOption(ApplicationBundle.message((String)"editbox.indent.array.element", (Object[])new Object[0]), options -> options.ARRAY_ELEMENT_INDENT, (options, value) -> {
            options.ARRAY_ELEMENT_INDENT = value;
        }, -1);
    }

    private ContinuationOption createContinuationOption(@NlsContexts.Label @NotNull String labelText, Function<? super CommonCodeStyleSettings.IndentOptions, Integer> getter, BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> setter, int defaultValue) {
        if (labelText == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(0);
        }
        ContinuationOption option = new ContinuationOption(labelText, getter, setter, defaultValue);
        this.myContinuationOptions.add(option);
        return option;
    }

    @Override
    protected void addTabOptions() {
        super.addTabOptions();
        this.myCbSmartTabs = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.smart.tabs", (Object[])new Object[0]));
        this.add(this.myCbSmartTabs, true);
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        for (ContinuationOption option : this.myContinuationOptions) {
            option.addToEditor(this);
        }
        this.myContinuationOption.addListener((ValueEditor.Listener<Integer>)((ValueEditor.Listener)newValue -> this.updateDefaults((Integer)newValue)));
        this.myCbKeepIndentsOnEmptyLines = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.keep.indents.on.empty.lines", (Object[])new Object[0]));
        this.add(this.myCbKeepIndentsOnEmptyLines);
    }

    private void updateDefaults(@NotNull Integer value) {
        if (value == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(1);
        }
        for (ContinuationOption option : this.myContinuationOptions) {
            if (option == this.myContinuationOption) continue;
            option.setDefaultValueToDisplay(value);
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbSmartTabs, options.SMART_TABS);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            isModified |= continuationOption.isModified(options);
        }
        return isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbKeepIndentsOnEmptyLines, options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.apply(options);
        }
        options.SMART_TABS = SmartIndentOptionsEditor.isSmartTabValid(options.INDENT_SIZE, options.TAB_SIZE) && this.myCbSmartTabs.isSelected();
        options.KEEP_INDENTS_ON_EMPTY_LINES = this.myCbKeepIndentsOnEmptyLines.isSelected();
    }

    @Override
    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(2);
        }
        if (options == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(3);
        }
        super.reset(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.reset(options);
        }
        this.myCbSmartTabs.setSelected(options.SMART_TABS);
        this.myCbKeepIndentsOnEmptyLines.setSelected(options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean smartTabsChecked = enabled && this.isUseTabsSelected();
        boolean smartTabsValid = smartTabsChecked && SmartIndentOptionsEditor.isSmartTabValid(this.getUIIndent(), this.getUITabSize());
        this.myCbSmartTabs.setEnabled(smartTabsValid);
        this.myCbSmartTabs.setToolTipText(smartTabsChecked && !smartTabsValid ? ApplicationBundle.message((String)"tooltip.indent.must.be.multiple.of.tab.size.for.smart.tabs.to.operate", (Object[])new Object[0]) : null);
        this.myContinuationOption.setEnabled(enabled);
        this.myCbKeepIndentsOnEmptyLines.setEnabled(enabled);
    }

    private static boolean isSmartTabValid(int indent, int tabSize) {
        return indent / tabSize * tabSize == indent;
    }

    public SmartIndentOptionsEditor withDeclarationParameterIndent() {
        this.myDeclarationParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withGenericTypeParameterIndent() {
        this.myGenericTypeParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withCallParameterIndent() {
        this.myCallParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withChainedCallIndent() {
        this.myChainedCallIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withArrayElementIndent() {
        this.myArrayElementIndentOption.setSupported(true);
        return this;
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        super.showStandardOptions(optionNames);
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.IndentOption.SMART_TABS.toString().equals(optionName)) {
                this.myCbSmartTabs.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.IndentOption.CONTINUATION_INDENT_SIZE.toString().equals(optionName)) {
                this.myContinuationOption.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.IndentOption.KEEP_INDENTS_ON_EMPTY_LINES.toString().equals(optionName)) continue;
            this.myCbKeepIndentsOnEmptyLines.setVisible(true);
        }
    }

    @Override
    protected void setVisible(boolean visible) {
        super.setVisible(visible);
        this.myCbSmartTabs.setVisible(visible);
        this.myContinuationOption.setVisible(visible);
        this.myCbKeepIndentsOnEmptyLines.setVisible(visible);
    }

    @NlsContexts.Label
    public static String getContinuationIndentLabel() {
        return ApplicationBundle.message((String)"editbox.indent.continuation.indent", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/SmartIndentOptionsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContinuationOption";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDefaults";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

