/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.numeric;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.LangBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNumberConversionIntention
implements ModCommandAction,
DumbAware {
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message("intention.family.convert.number", new Object[0]);
        if (string == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext actionCtx) {
        PsiFile file;
        if (actionCtx == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(1);
        }
        if (!BaseIntentionAction.canModify((PsiElement)(file = actionCtx.file()))) {
            return null;
        }
        List<NumberConverter> converters = this.getConverters(file);
        if (converters.isEmpty()) {
            return null;
        }
        NumberConversionContext context = this.getContext(actionCtx);
        if (context == null) {
            return null;
        }
        Number number = context.myNumber;
        String text = context.myText;
        NumberConverter singleConverter = null;
        for (NumberConverter converter : converters) {
            String convertedText = converter.getConvertedText(text, number);
            if (convertedText == null) continue;
            if (singleConverter != null) {
                return Presentation.of((String)LangBundle.message("intention.name.convert.number.to", new Object[0]));
            }
            singleConverter = converter;
        }
        if (singleConverter == null) {
            return null;
        }
        String convertedText = singleConverter.getConvertedText(text, number);
        return Presentation.of((String)LangBundle.message("intention.name.convert.number.to.with.text", singleConverter, convertedText));
    }

    @Nullable
    private NumberConversionContext getContext(@NotNull ActionContext actionContext) {
        PsiElement element;
        NumberConversionContext context;
        if (actionContext == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(2);
        }
        NumberConversionContext numberConversionContext = context = (element = actionContext.findLeaf()) == null ? null : this.extract(element);
        if (context == null) {
            element = actionContext.findLeafOnTheLeft();
            context = element == null ? null : this.extract(element);
        }
        return context;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext actionContext) {
        List<NumberConverter> converters;
        if (actionContext == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(3);
        }
        if ((converters = this.getConverters(actionContext.file())).isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AbstractNumberConversionIntention.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        final NumberConversionContext context = this.getContext(actionContext);
        if (context == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AbstractNumberConversionIntention.$$$reportNull$$$0(5);
            }
            return modCommand;
        }
        Number number = context.myNumber;
        String text = context.myText;
        class Conversion
        implements ModCommandAction,
        DumbAware {
            final NumberConverter myConverter;
            final String myResult;

            Conversion(NumberConverter converter, String result) {
                this.myConverter = converter;
                this.myResult = result;
            }

            @NotNull
            public ModCommand perform(@NotNull ActionContext ctx) {
                PsiElement element;
                if (ctx == null) {
                    Conversion.$$$reportNull$$$0(0);
                }
                if ((element = context.getElement()) == null) {
                    ModCommand modCommand = ModCommand.nop();
                    if (modCommand == null) {
                        Conversion.$$$reportNull$$$0(1);
                    }
                    return modCommand;
                }
                ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, e -> AbstractNumberConversionIntention.this.replace((PsiElement)e, this.myResult));
                if (modCommand == null) {
                    Conversion.$$$reportNull$$$0(2);
                }
                return modCommand;
            }

            @Nullable
            public Presentation getPresentation(@NotNull ActionContext ctx) {
                if (ctx == null) {
                    Conversion.$$$reportNull$$$0(3);
                }
                if (context.getElement() == null) {
                    return null;
                }
                return Presentation.of((String)this.toString());
            }

            @NlsSafe
            public String toString() {
                return StringUtil.capitalize((String)this.myConverter.toString()) + " (" + this.myResult + ")";
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myConverter.toString();
                if (string == null) {
                    Conversion.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ctx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$1Conversion";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$1Conversion";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4 -> new IllegalStateException(string);
                };
            }
        }
        List<Conversion> list = this.getConverters(actionContext.file()).stream().map(converter -> new Conversion((NumberConverter)converter, converter.getConvertedText(text, number))).filter(conversion -> conversion.myResult != null).toList();
        ModCommand modCommand = ModCommand.chooseAction((String)LangBundle.message("intention.name.convert.number.to.title", new Object[0]), list);
        if (modCommand == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(6);
        }
        return modCommand;
    }

    @Contract(pure=true)
    @Nullable
    protected abstract NumberConversionContext extract(@NotNull PsiElement var1);

    @Contract(pure=true)
    @NotNull
    protected abstract List<NumberConverter> getConverters(@NotNull PsiFile var1);

    protected abstract void replace(PsiElement var1, String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionCtx";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    protected static class NumberConversionContext {
        @NotNull
        final SmartPsiElementPointer<PsiElement> myElement;
        @NotNull
        final Number myNumber;
        @NotNull
        final String myText;
        final boolean myNegated;

        public NumberConversionContext(@NotNull PsiElement element, @NotNull Number number, @NotNull String text, boolean negated) {
            if (element == null) {
                NumberConversionContext.$$$reportNull$$$0(0);
            }
            if (number == null) {
                NumberConversionContext.$$$reportNull$$$0(1);
            }
            if (text == null) {
                NumberConversionContext.$$$reportNull$$$0(2);
            }
            this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
            this.myNumber = number;
            this.myText = text;
            this.myNegated = negated;
        }

        @Nullable
        PsiElement getElement() {
            return this.myElement.getElement();
        }

        @NotNull
        public Project getProject() {
            Project project = this.myElement.getProject();
            if (project == null) {
                NumberConversionContext.$$$reportNull$$$0(3);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "number";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$NumberConversionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$NumberConversionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

