/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSnapshotProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class DataValidators {
    private static final Logger LOG = Logger.getInstance(DataValidators.class);
    public static final ExtensionPointName<DataValidators> EP_NAME = ExtensionPointName.create((String)"com.intellij.dataValidators");
    private static final Map<String, Validator<?>[]> ourValidators = new ConcurrentHashMap<String, Validator<?>[]>();

    protected abstract void collectValidators(@NotNull ValidatorRegistry var1);

    @NotNull
    public static <T> Validator<T[]> arrayValidator(@NotNull Validator<? super T> validator) {
        if (validator == null) {
            DataValidators.$$$reportNull$$$0(0);
        }
        Validator<T[]> validator2 = (data, dataId, source) -> {
            for (Object element : data) {
                if (element == null) {
                    Object notNull = ContainerUtil.find((Object[])data, (Condition)Conditions.notNull());
                    Class<?> aClass = DataValidators.unwrap(source).getClass();
                    LOG.error((Throwable)PluginException.createByClass((String)("Array with null provided by " + aClass.getName() + ".getData(\"" + dataId + "\"): " + data.getClass().getComponentType().getName() + "[" + ((Object[])data).length + "] {" + (notNull == null ? null : notNull.getClass().getName()) + (((Object[])data).length > 1 ? ", ..." : "") + "}"), null, aClass));
                    return false;
                }
                if (validator.checkValid(element, dataId, source)) continue;
                return false;
            }
            return true;
        };
        if (validator2 == null) {
            DataValidators.$$$reportNull$$$0(1);
        }
        return validator2;
    }

    @Nullable
    public static Object validOrNull(@NotNull Object data, @NotNull String dataId, @NotNull Object source) {
        if (data == null) {
            DataValidators.$$$reportNull$$$0(2);
        }
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(3);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(4);
        }
        return DataValidators.isDataValid(data, dataId, source) ? data : null;
    }

    private static boolean isDataValid(@NotNull Object data, @NotNull String dataId, @NotNull Object source) {
        Validator<?>[] validators;
        if (data == null) {
            DataValidators.$$$reportNull$$$0(5);
        }
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(6);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(7);
        }
        if (DataValidators.isPsiElementProvided(data) && EDT.isCurrentThreadEdt() && SlowOperations.isInSection((String)"  force assert  ")) {
            DataValidators.reportPsiElementOnEdt(dataId, source);
        }
        if ((validators = DataValidators.getValidators(dataId)) == null) {
            return true;
        }
        try {
            for (Validator<?> validator : validators) {
                if (validator.checkValid(data, dataId, source)) continue;
                return false;
            }
        }
        catch (ClassCastException ex) {
            DataValidators.reportObjectOfIncorrectType(dataId, source, ex);
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public static Validator<Object> uiOnlyDataKeyValidator() {
        Validator<Object> validator = (data, dataId, source) -> {
            Object provider = DataValidators.unwrap(source);
            if (provider instanceof UiDataProvider || provider instanceof DataSnapshotProvider) {
                return true;
            }
            if (!EDT.isCurrentThreadEdt() && (provider instanceof DataProvider || provider instanceof Function0)) {
                Class<?> aClass = provider.getClass();
                LOG.error((Throwable)PluginException.createByClass((String)("A data for UI-only DataKey(\"" + dataId + "\") is provided on BGT by " + aClass.getName() + ". Use a UI data provider to provide such data"), null, aClass));
            }
            return true;
        };
        if (validator == null) {
            DataValidators.$$$reportNull$$$0(8);
        }
        return validator;
    }

    private static boolean isPsiElementProvided(@Nullable Object data) {
        if (data instanceof PsiElement && !(data instanceof FakePsiElement)) {
            return true;
        }
        if (data instanceof Object[]) {
            Object[] array = (Object[])data;
            return DataValidators.isPsiElementProvided(ArrayUtil.getFirstElement((Object[])array));
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            return DataValidators.isPsiElementProvided(ContainerUtil.getFirstItem((Collection)collection));
        }
        return false;
    }

    private static void reportPsiElementOnEdt(@NotNull String dataId, @NotNull Object source) {
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(10);
        }
        Class<?> aClass = DataValidators.unwrap(source).getClass();
        LOG.error((Throwable)PluginException.createByClass((String)("PSI element for DataKey(\"" + dataId + "\") is provided on EDT by " + aClass.getName() + ". Use `DataSink.lazy` to provide such data"), null, aClass));
    }

    private static void reportObjectOfIncorrectType(@NotNull String dataId, @NotNull Object source, @NotNull ClassCastException ex) {
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(11);
        }
        if (source == null) {
            DataValidators.$$$reportNull$$$0(12);
        }
        if (ex == null) {
            DataValidators.$$$reportNull$$$0(13);
        }
        Class<?> aClass = DataValidators.unwrap(source).getClass();
        LOG.error((Throwable)PluginException.createByClass((String)("Object of incorrect type for DataKey(\"" + dataId + "\") is provided by " + aClass.getName() + "."), (Throwable)ex, aClass));
    }

    @NotNull
    private static Object unwrap(@NotNull Object source) {
        Object object;
        if (source == null) {
            DataValidators.$$$reportNull$$$0(14);
        }
        if (source instanceof SourceWrapper) {
            SourceWrapper o = (SourceWrapper)source;
            object = o.unwrapSource();
        } else {
            object = source;
        }
        if (object == null) {
            DataValidators.$$$reportNull$$$0(15);
        }
        return object;
    }

    static Validator<?> @Nullable [] getValidators(@NotNull String dataId) {
        Validator<?>[] result;
        if (dataId == null) {
            DataValidators.$$$reportNull$$$0(16);
        }
        if ((result = ourValidators.get(dataId)) != null || !ourValidators.isEmpty()) {
            return result;
        }
        List extensions = EP_NAME.getExtensionsIfPointIsRegistered();
        if (extensions.isEmpty()) {
            return null;
        }
        final Map map = FactoryMap.create(__ -> new ArrayList());
        ValidatorRegistry registry = new ValidatorRegistry(){

            @Override
            public <T> void register(@NotNull DataKey<T> key, @NotNull Validator<? super T> validator) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (validator == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((List)map.get(key.getName())).add(validator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "validator";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/impl/DataValidators$1";
                objectArray[2] = "register";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (DataValidators validators : extensions) {
            validators.collectValidators(registry);
        }
        Validator[] emptyArray = new Validator[]{};
        for (String s : map.keySet()) {
            ourValidators.put(s, ((List)map.get(s)).toArray(emptyArray));
        }
        return ourValidators.get(dataId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        Application app = ApplicationManager.getApplication();
        @NotNull ExtensionPoint dataRuleEP = app.getExtensionArea().getExtensionPointIfRegistered(EP_NAME.getName());
        if (dataRuleEP != null) {
            dataRuleEP.addChangeListener(() -> ourValidators.clear(), (Disposable)app);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataValidators";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataValidators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "uiOnlyDataKeyValidator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrayValidator";
                break;
            }
            case 1: 
            case 8: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validOrNull";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDataValid";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportPsiElementOnEdt";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportObjectOfIncorrectType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValidators";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 15 -> new IllegalStateException(string);
        };
    }

    public static interface Validator<T> {
        public boolean checkValid(@NotNull T var1, @NotNull String var2, @NotNull Object var3);
    }

    @ApiStatus.Internal
    public static interface SourceWrapper {
        @NotNull
        public Object unwrapSource();
    }

    @ApiStatus.NonExtendable
    protected static interface ValidatorRegistry {
        public <T> void register(@NotNull DataKey<T> var1, @NotNull Validator<? super T> var2);
    }
}

