/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/url/MultiPathBestMatcher;", "", "<init>", "()V", "bestResolveMatches", "Ljava/util/HashSet;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "Lkotlin/collections/HashSet;", "longestMatchLength", "", "addBestMatching", "all", "", "original", "Lcom/intellij/microservices/url/UrlPath;", "getResult", "", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/MultiPathBestMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1834#2,4:337\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/MultiPathBestMatcher\n*L\n314#1:337,4\n*E\n"})
public final class MultiPathBestMatcher {
    @NotNull
    private final HashSet<UrlTargetInfo> bestResolveMatches = new HashSet();
    private int longestMatchLength = 1;

    @NotNull
    public final MultiPathBestMatcher addBestMatching(@NotNull Iterable<? extends UrlTargetInfo> all, @Nullable UrlPath original) {
        Intrinsics.checkNotNullParameter(all, (String)"all");
        for (UrlTargetInfo urlTargetInfo : all) {
            int exactCount;
            UrlPath urlPath = original;
            if (urlPath != null) {
                v1 = urlPath.commonLength(urlTargetInfo.getPath());
            } else {
                Iterable $this$count$iv = urlTargetInfo.getPath().getSegments();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v1 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        UrlPath.PathSegment it = (UrlPath.PathSegment)element$iv;
                        boolean bl = false;
                        if (!(it instanceof UrlPath.PathSegment.Exact) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v1 = exactCount = count$iv;
                }
            }
            if (exactCount > this.longestMatchLength) {
                this.longestMatchLength = exactCount;
                this.bestResolveMatches.clear();
                this.bestResolveMatches.add(urlTargetInfo);
                continue;
            }
            if (exactCount != this.longestMatchLength) continue;
            this.bestResolveMatches.add(urlTargetInfo);
        }
        return this;
    }

    public static /* synthetic */ MultiPathBestMatcher addBestMatching$default(MultiPathBestMatcher multiPathBestMatcher, Iterable iterable, UrlPath urlPath, int n, Object object) {
        if ((n & 2) != 0) {
            urlPath = null;
        }
        return multiPathBestMatcher.addBestMatching(iterable, urlPath);
    }

    @NotNull
    public final Set<UrlTargetInfo> getResult() {
        return this.bestResolveMatches;
    }
}

