/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.HelperUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ9\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001a\b\u0004\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00190\u0018H\u0082\bJ4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00130\u001dJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/microservices/url/UrlResolverManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "all", "", "Lcom/intellij/microservices/url/UrlResolver;", "meaningfulResolvers", "getMeaningfulResolvers", "()Ljava/util/List;", "getAuthorityHints", "Lcom/intellij/microservices/url/Authority$Exact;", "schema", "", "supportedSchemes", "getSupportedSchemes", "allIterable", "", "T", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "call", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "resolve", "Lcom/intellij/microservices/url/UrlTargetInfo;", "action", "Lkotlin/Function2;", "getVariants", "Companion", "UrlTargetInfoDistinctKey", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlResolverManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlResolverManager.kt\ncom/intellij/microservices/url/UrlResolverManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n27#1,7:109\n27#1,7:116\n27#1,7:123\n1642#2,10:92\n1915#2:102\n1916#2:104\n1652#2:105\n777#2:106\n873#2,2:107\n1#3:103\n*S KotlinDebug\n*F\n+ 1 UrlResolverManager.kt\ncom/intellij/microservices/url/UrlResolverManager\n*L\n37#1:109,7\n42#1:116,7\n60#1:123,7\n11#1:92,10\n11#1:102\n11#1:104\n11#1:105\n14#1:106\n14#1:107,2\n11#1:103\n*E\n"})
public final class UrlResolverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UrlResolver> all;
    @ApiStatus.Internal
    @NotNull
    private final List<UrlResolver> meaningfulResolvers;

    /*
     * WARNING - void declaration
     */
    public UrlResolverManager(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = UrlResolverFactory.EP_NAME.getExtensionList();
        UrlResolverManager urlResolverManager = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UrlResolver it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlResolverFactory it = (UrlResolverFactory)element$iv$iv;
            boolean bl2 = false;
            if (it.forProject(project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        urlResolverManager.all = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.all;
        urlResolverManager = this;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UrlResolver it = (UrlResolver)element$iv$iv;
            boolean bl = false;
            if (!(it.getClass().getAnnotation(HelperUrlResolver.class) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        urlResolverManager.meaningfulResolvers = (List)destination$iv$iv;
    }

    @NotNull
    public final List<UrlResolver> getMeaningfulResolvers() {
        return this.meaningfulResolvers;
    }

    @NotNull
    public final List<Authority.Exact> getAuthorityHints(@Nullable String schema) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), arg_0 -> UrlResolverManager.getAuthorityHints$lambda$0(schema, arg_0))));
    }

    @NotNull
    public final List<String> getSupportedSchemes() {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), UrlResolverManager::_get_supportedSchemes_$lambda$0)));
    }

    private final <T> Iterable<T> allIterable(UrlResolveRequest request, Function1<? super UrlResolver, ? extends Sequence<? extends T>> call) {
        boolean $i$f$allIterable = false;
        List schemeHint = CollectionsKt.listOfNotNull((Object)request.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.all), (Function1)new Function1<UrlResolver, Sequence<? extends T>>(schemeHint, call){
            final /* synthetic */ List<String> $schemeHint;
            final /* synthetic */ Function1<UrlResolver, Sequence<T>> $call;
            {
                this.$schemeHint = $schemeHint;
                this.$call = $call;
            }

            public final Sequence<T> invoke(UrlResolver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), (Collection<String>)this.$schemeHint) ? (Sequence)this.$call.invoke((Object)it) : SequencesKt.emptySequence();
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request, @NotNull Function2<? super UrlResolver, ? super UrlResolveRequest, ? extends Iterable<? extends UrlTargetInfo>> action) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        UrlResolverManager urlResolverManager = this;
        UrlResolveRequest request$iv = request;
        boolean $i$f$allIterable = false;
        List schemeHint$iv = CollectionsKt.listOfNotNull((Object)request$iv.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(schemeHint$iv, action, request){
            final /* synthetic */ List $schemeHint;
            final /* synthetic */ Function2 $action$inlined;
            final /* synthetic */ UrlResolveRequest $request$inlined;
            {
                this.$schemeHint = $schemeHint;
                this.$action$inlined = function2;
                this.$request$inlined = urlResolveRequest;
            }

            public final Sequence<UrlTargetInfo> invoke(UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    UrlResolver it2 = it;
                    boolean bl = false;
                    sequence = CollectionsKt.asSequence((Iterable)((Iterable)this.$action$inlined.invoke((Object)it2, (Object)this.$request$inlined)));
                } else {
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UrlResolverManager urlResolverManager = this;
        UrlResolveRequest request$iv = request;
        boolean $i$f$allIterable = false;
        List schemeHint$iv = CollectionsKt.listOfNotNull((Object)request$iv.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(schemeHint$iv, request){
            final /* synthetic */ List $schemeHint;
            final /* synthetic */ UrlResolveRequest $request$inlined;
            {
                this.$schemeHint = $schemeHint;
                this.$request$inlined = urlResolveRequest;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Sequence<UrlTargetInfo> invoke(UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    sequence = SequencesKt.emptySequence();
                    return sequence;
                }
                UrlResolver urlResolver = it;
                boolean bl = false;
                Sequence seq = CollectionsKt.asSequence(urlResolver.resolve(this.$request$inlined));
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)UrlPath.Companion.getEMPTY(), (Object)this.$request$inlined.getPath())) {
                    Application $this$resolve_u24lambda_u241_u240_u240 = ApplicationManager.getApplication();
                    boolean bl3 = false;
                    boolean bl4 = $this$resolve_u24lambda_u241_u240_u240.isUnitTestMode() || $this$resolve_u24lambda_u241_u240_u240.isInternal();
                    if (bl4) {
                        sequence = SequencesKt.map((Sequence)seq, (Function1)((Function1)new Function1<UrlTargetInfo, UrlTargetInfo>(this.$request$inlined, urlResolver){
                            final /* synthetic */ UrlResolveRequest $request;
                            final /* synthetic */ UrlResolver $urlResolver;
                            {
                                this.$request = $request;
                                this.$urlResolver = $urlResolver;
                            }

                            public final UrlTargetInfo invoke(UrlTargetInfo it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                UrlTargetInfo urlTargetInfo = it;
                                UrlResolveRequest urlResolveRequest = this.$request;
                                UrlResolver urlResolver = this.$urlResolver;
                                UrlTargetInfo result = urlTargetInfo;
                                boolean bl = false;
                                if (result.getPath() == urlResolveRequest.getPath()) {
                                    boolean $i$f$logger = false;
                                    Logger logger = Logger.getInstance(UrlResolverManager.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    logger.error("urlResolver of class " + urlResolver.getClass() + " returned the UrlPath(" + result.getPath() + ") identical to the requested it is suspicious, because UrlResolvers are expected to return UrlPath built from sources, not the requested one");
                                }
                                return urlTargetInfo;
                            }
                        }));
                        return sequence;
                    }
                }
                sequence = seq;
                return sequence;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<UrlTargetInfo> getVariants(@NotNull UrlResolveRequest request) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UrlResolverManager urlResolverManager = this;
        UrlResolveRequest request$iv = request;
        boolean $i$f$allIterable = false;
        List schemeHint$iv = CollectionsKt.listOfNotNull((Object)request$iv.getSchemeHint());
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.all), (Function1)((Function1)new Function1<UrlResolver, Sequence<? extends UrlTargetInfo>>(schemeHint$iv){
            final /* synthetic */ List $schemeHint;
            {
                this.$schemeHint = $schemeHint;
            }

            public final Sequence<UrlTargetInfo> invoke(UrlResolver it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (UrlPathModelKt.compatibleSchemes((Collection<String>)it.getSupportedSchemes(), this.$schemeHint)) {
                    UrlResolver resolver = it;
                    boolean bl = false;
                    sequence = SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence(resolver.getVariants()), (Function1)getVariants.1.1.INSTANCE);
                } else {
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        })));
    }

    private static final Sequence getAuthorityHints$lambda$0(String $schema, UrlResolver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getAuthorityHints($schema));
    }

    private static final Sequence _get_supportedSchemes_$lambda$0(UrlResolver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getSupportedSchemes());
    }

    @JvmStatic
    @NotNull
    public static final UrlResolverManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/microservices/url/UrlResolverManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/microservices/url/UrlResolverManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlResolverManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ThreadingAssertions.assertReadAccess();
            return new UrlResolverManager(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u000b\u001a\u00020\fH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/url/UrlResolverManager$UrlTargetInfoDistinctKey;", "", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "<init>", "(Lcom/intellij/microservices/url/UrlTargetInfo;)V", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "equals", "", "other", "hashCode", "", "intellij.platform.lang"})
    private static final class UrlTargetInfoDistinctKey {
        @NotNull
        private final UrlTargetInfo targetInfo;

        public UrlTargetInfoDistinctKey(@NotNull UrlTargetInfo targetInfo) {
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            this.targetInfo = targetInfo;
        }

        @NotNull
        public final UrlTargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlResolverManager.UrlTargetInfoDistinctKey");
            UrlTargetInfoDistinctKey cfr_ignored_0 = (UrlTargetInfoDistinctKey)object2;
            if (!Intrinsics.areEqual(this.targetInfo.getMethods(), ((UrlTargetInfoDistinctKey)other).targetInfo.getMethods())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetInfo.getPath(), (Object)((UrlTargetInfoDistinctKey)other).targetInfo.getPath());
        }

        public int hashCode() {
            return Objects.hashCode(this.targetInfo.getPath()) + 31 * Objects.hashCode(this.targetInfo.getMethods());
        }
    }
}

