/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNamedElementWithCustomPresentation;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;

public abstract class AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance(AutomaticRenamer.class);
    private final LinkedHashMap<PsiNamedElement, String> myRenames = new LinkedHashMap();
    protected final List<PsiNamedElement> myElements = new ArrayList<PsiNamedElement>();

    protected AutomaticRenamer() {
    }

    public boolean hasAnythingToRename() {
        return ContainerUtil.exists(this.myRenames.values(), Objects::nonNull) && ContainerUtil.exists(this.myRenames.keySet(), obj -> !(obj instanceof SyntheticElement));
    }

    public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles) {
        this.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, null);
    }

    public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<? super UnresolvableCollisionUsageInfo> unresolvedUsages) {
        this.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, null);
    }

    public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<? super UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
        Iterator<PsiNamedElement> iterator = this.myElements.iterator();
        while (iterator.hasNext()) {
            PsiNamedElement variable = iterator.next();
            RenameUtil.assertNonCompileElement((PsiElement)variable);
            boolean success = this.findUsagesForElement(variable, result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            if (success) continue;
            iterator.remove();
        }
    }

    private boolean findUsagesForElement(PsiNamedElement element, List<? super UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<? super UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
        String newName = this.getNewName(element);
        if (newName != null) {
            Object[] usages;
            LinkedHashMap<PsiNamedElement, String> renames = new LinkedHashMap<PsiNamedElement, String>(this.myRenames);
            if (allRenames != null) {
                for (PsiElement psiElement : allRenames.keySet()) {
                    if (!(psiElement instanceof PsiNamedElement)) continue;
                    renames.put((PsiNamedElement)psiElement, allRenames.get(psiElement));
                }
            }
            for (UsageInfo usageInfo : usages = RenameUtil.findUsages((PsiElement)element, newName, searchInStringsAndComments, searchInNonJavaFiles, renames)) {
                if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
                if (unresolvedUsages != null) {
                    unresolvedUsages.add((UnresolvableCollisionUsageInfo)((UnresolvableCollisionUsageInfo)usageInfo));
                }
                return false;
            }
            ContainerUtil.addAll(result, (Object[])usages);
        }
        return true;
    }

    public List<PsiNamedElement> getElements() {
        return Collections.unmodifiableList(this.myElements);
    }

    public String getNewName(PsiNamedElement namedElement) {
        return this.myRenames.get(namedElement);
    }

    public Map<PsiNamedElement, String> getRenames() {
        return Collections.unmodifiableMap(this.myRenames);
    }

    public void setRename(PsiNamedElement element, String replacement) {
        LOG.assertTrue(this.myRenames.put(element, replacement) != null);
    }

    public void doNotRename(PsiNamedElement element) {
        LOG.assertTrue(this.myRenames.remove(element) != null);
    }

    protected static String getPresentationName(PsiNamedElement element) {
        String string;
        if (element instanceof PsiNamedElementWithCustomPresentation) {
            PsiNamedElementWithCustomPresentation custom = (PsiNamedElementWithCustomPresentation)element;
            string = custom.getPresentationName();
        } else {
            string = element.getName();
        }
        return string;
    }

    protected void suggestAllNames(String oldClassName, String newClassName) {
        NameSuggester suggester = new NameSuggester(oldClassName, newClassName);
        for (int varIndex = this.myElements.size() - 1; varIndex >= 0; --varIndex) {
            PsiNamedElement element = this.myElements.get(varIndex);
            String name = AutomaticRenamer.getPresentationName(element);
            if (!this.myRenames.containsKey(element) && name != null) {
                String newName = this.suggestNameForElement(element, suggester, newClassName, oldClassName);
                if (!newName.equals(name)) {
                    this.myRenames.put(element, newName);
                } else {
                    this.myRenames.put(element, null);
                }
            }
            if (this.myRenames.get(element) != null) continue;
            this.myElements.remove(varIndex);
        }
    }

    protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
        String name = AutomaticRenamer.getPresentationName(element);
        if (oldClassName.equals(name)) {
            return newClassName;
        }
        String canonicalName = this.nameToCanonicalName(name, element);
        String newCanonicalName = suggester.suggestName(canonicalName);
        if (newCanonicalName.isEmpty()) {
            LOG.error("oldClassName = " + oldClassName + ", newClassName = " + newClassName + ", name = " + name + ", canonicalName = " + canonicalName + ", newCanonicalName = " + newCanonicalName);
        }
        return this.canonicalNameToName(newCanonicalName, element);
    }

    @NonNls
    protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
        return canonicalName;
    }

    protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
        return name;
    }

    public boolean allowChangeSuggestedName() {
        return true;
    }

    public boolean isSelectedByDefault() {
        return false;
    }

    @NlsContexts.DialogTitle
    public abstract String getDialogTitle();

    @NlsContexts.Label
    public abstract String getDialogDescription();

    @NlsContexts.ColumnName
    public abstract String entityName();
}

