/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl.eel;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.eel.EelFileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b0\u00032\u0006\u0010\n\u001a\u00020\tH\u0016Jb\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b0\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b0\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/download/impl/eel/EelFileDownloaderImpl;", "Lcom/intellij/util/download/eel/EelFileDownloader;", "myFileDescriptions", "", "Lcom/intellij/util/download/DownloadableFileDescription;", "<init>", "(Ljava/util/List;)V", "download", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "targetDir", "createDownloadTask", "Ljava/util/concurrent/Callable;", "Ljava/lang/Void;", "progressManager", "Lcom/intellij/util/progress/ConcurrentTasksProgressManager;", "description", "existingFiles", "", "downloadedFiles", "totalSize", "Ljava/util/concurrent/atomic/AtomicLong;", "createIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.platform.ide.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEelFileDownloaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelFileDownloaderImpl.kt\ncom/intellij/util/download/impl/eel/EelFileDownloaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1915#2,2:187\n1915#2,2:189\n1#3:191\n*S KotlinDebug\n*F\n+ 1 EelFileDownloaderImpl.kt\ncom/intellij/util/download/impl/eel/EelFileDownloaderImpl\n*L\n48#1:187,2\n52#1:189,2\n*E\n"})
public final class EelFileDownloaderImpl
implements EelFileDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<? extends DownloadableFileDescription> myFileDescriptions;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LIB_SCHEMA = "lib://";

    public EelFileDownloaderImpl(@NotNull List<? extends DownloadableFileDescription> myFileDescriptions) {
        Intrinsics.checkNotNullParameter(myFileDescriptions, (String)"myFileDescriptions");
        this.myFileDescriptions = myFileDescriptions;
    }

    @NotNull
    public List<Pair<Path, DownloadableFileDescription>> download(@NotNull Path targetDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        List downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        try {
            Object it;
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(this.createIndicator(), this.myFileDescriptions.size());
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start = System.currentTimeMillis();
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"EelFileDownloaderImpl Pool", (int)maxParallelDownloads);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
            ExecutorService executor = executorService;
            List results = new ArrayList();
            AtomicLong totalSize = new AtomicLong();
            Iterable $this$forEach$iv = this.myFileDescriptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DownloadableFileDescription)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(existingFiles);
                Collection collection = existingFiles;
                Intrinsics.checkNotNull(downloadedFiles);
                Future<Void> future = executor.submit(this.createDownloadTask(progressManager, targetDir, (DownloadableFileDescription)it, collection, downloadedFiles, totalSize));
                Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
                results.add(future);
            }
            $this$forEach$iv = results;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Future)element$iv;
                boolean bl = false;
                EelFileDownloaderImpl.Companion.getCatching((Future)it);
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            Intrinsics.checkNotNull(downloadedFiles);
            Collection collection = Companion.moveToDir(downloadedFiles, targetDir);
            Intrinsics.checkNotNull(existingFiles);
            return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)existingFiles));
        }
        catch (ProcessCanceledException e) {
            Intrinsics.checkNotNull(downloadedFiles);
            EelFileDownloaderImpl.Companion.deleteFiles(downloadedFiles);
            throw e;
        }
        catch (IOException e) {
            Intrinsics.checkNotNull(downloadedFiles);
            EelFileDownloaderImpl.Companion.deleteFiles(downloadedFiles);
            throw e;
        }
    }

    private final Callable<Void> createDownloadTask(ConcurrentTasksProgressManager progressManager, Path targetDir, DownloadableFileDescription description, Collection<Pair<Path, DownloadableFileDescription>> existingFiles, Collection<Pair<Path, DownloadableFileDescription>> downloadedFiles, AtomicLong totalSize) {
        return () -> EelFileDownloaderImpl.createDownloadTask$lambda$0(progressManager, targetDir, description, existingFiles, totalSize, downloadedFiles);
    }

    private final ProgressIndicator createIndicator() {
        ProgressIndicator progressIndicator;
        ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator2 != null) {
            ProgressIndicator progressIndicator3;
            ProgressIndicator it = progressIndicator3 = progressIndicator2;
            boolean bl = false;
            it.setIndeterminate(false);
            progressIndicator = progressIndicator3;
        } else {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        Object[] objectArray = new Object[]{this.myFileDescriptions.size()};
        indicator.setText(IdeCoreBundle.message((String)"progress.downloading.0.files.text", (Object[])objectArray));
        return indicator;
    }

    private static final Void createDownloadTask$lambda$0(ConcurrentTasksProgressManager $progressManager, Path $targetDir, DownloadableFileDescription $description, Collection $existingFiles, AtomicLong $totalSize, Collection $downloadedFiles) {
        SubTaskProgressIndicator subTaskProgressIndicator = $progressManager.createSubTaskIndicator(1);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)subTaskProgressIndicator), (String)"createSubTaskIndicator(...)");
        SubTaskProgressIndicator indicator = subTaskProgressIndicator;
        indicator.checkCanceled();
        Path existing = $targetDir.resolve($description.getDefaultFileName());
        String string = $description.getDownloadUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDownloadUrl(...)");
        String url = string;
        if (StringsKt.startsWith$default((String)url, (String)LIB_SCHEMA, (boolean)false, (int)2, null)) {
            Path path = Path.of(StringsKt.removePrefix((String)url, (CharSequence)LIB_SCHEMA), new String[0]);
            Path file = PathManager.getLibDir().resolve(path);
            $existingFiles.add(TuplesKt.to((Object)file, (Object)$description));
        } else if (StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            Path path = Path.of(StringsKt.removePrefix((String)url, (CharSequence)"file://"), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                $existingFiles.add(TuplesKt.to((Object)path, (Object)$description));
            }
        } else {
            LOG.debug("Downloading `" + url + "` into `" + existing + "`");
            Path downloaded = null;
            try {
                Intrinsics.checkNotNull((Object)existing);
                downloaded = EelFileDownloaderImpl.Companion.downloadFile($description, existing, (ProgressIndicator)indicator);
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{$description.getDownloadUrl(), e.getMessage()};
                throw new IOException(IdeCoreBundle.message((String)"error.file.download.failed", (Object[])objectArray), e);
            }
            if (Intrinsics.areEqual((Object)downloaded, (Object)existing)) {
                v2 = $existingFiles.add(TuplesKt.to((Object)existing, (Object)$description));
            } else {
                $totalSize.addAndGet(Files.size(downloaded));
                v2 = $downloadedFiles.add(TuplesKt.to((Object)downloaded, (Object)$description));
            }
        }
        indicator.finished();
        return null;
    }

    static {
        Logger logger = Logger.getInstance(EelFileDownloaderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J:\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0010J\"\u0010\u0014\u001a\u00020\n2\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eH\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/download/impl/eel/EelFileDownloaderImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LIB_SCHEMA", "", "getCatching", "", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "moveToDir", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lcom/intellij/util/download/DownloadableFileDescription;", "downloadedFiles", "targetDir", "deleteFiles", "pairs", "downloadFile", "description", "existingFile", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.core.impl"})
    @SourceDebugExtension(value={"SMAP\nEelFileDownloaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelFileDownloaderImpl.kt\ncom/intellij/util/download/impl/eel/EelFileDownloaderImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1586#2:187\n1661#2,3:188\n1915#2,2:191\n*S KotlinDebug\n*F\n+ 1 EelFileDownloaderImpl.kt\ncom/intellij/util/download/impl/eel/EelFileDownloaderImpl$Companion\n*L\n149#1:187\n149#1:188,3\n161#1:191,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void getCatching(Future<Void> $this$getCatching) {
            try {
                $this$getCatching.get();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.io.IOException");
                    throw (IOException)throwable;
                }
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    throw (ProcessCanceledException)throwable;
                }
                LOG.error((Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<Path, DownloadableFileDescription>> moveToDir(@NotNull List<? extends Pair<? extends Path, ? extends DownloadableFileDescription>> downloadedFiles, @NotNull Path targetDir) throws IOException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(downloadedFiles, (String)"downloadedFiles");
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Iterable $this$map$iv = downloadedFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String fileName;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path fromPath = (Path)pair.component1();
                DownloadableFileDescription description = (DownloadableFileDescription)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)description.generateFileName(arg_0 -> Companion.moveToDir$lambda$0$1(arg_0 -> Companion.moveToDir$lambda$0$0(targetDir, arg_0), arg_0)), (String)"generateFileName(...)");
                Path toPath = targetDir.resolve(fileName);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(fromPath, toPath, copyOptionArray);
                collection.add(TuplesKt.to((Object)toPath, (Object)description));
            }
            return (List)destination$iv$iv;
        }

        private final void deleteFiles(List<? extends Pair<? extends Path, ? extends DownloadableFileDescription>> pairs) {
            Iterable $this$forEach$iv = pairs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                NioFiles.deleteRecursively((Path)((Path)it.getFirst()));
            }
        }

        private final Path downloadFile(DownloadableFileDescription description, Path existingFile, ProgressIndicator indicator) throws IOException {
            String string = description.getPresentableDownloadUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableDownloadUrl(...)");
            String presentableUrl = string;
            Object[] objectArray = new Object[]{presentableUrl};
            indicator.setText(IdeCoreBundle.message((String)"progress.connecting.to.download.file.text", (Object[])objectArray));
            Object object = HttpRequests.request((String)description.getDownloadUrl()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Path>(existingFile, indicator, description, presentableUrl){
                final /* synthetic */ Path $existingFile;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ DownloadableFileDescription $description;
                final /* synthetic */ String $presentableUrl;
                {
                    this.$existingFile = $existingFile;
                    this.$indicator = $indicator;
                    this.$description = $description;
                    this.$presentableUrl = $presentableUrl;
                }

                public Path process(HttpRequests.Request request) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    int size = request.getConnection().getContentLength();
                    if (Files.exists(this.$existingFile, new LinkOption[0]) && (long)size == Files.size(this.$existingFile)) {
                        return this.$existingFile;
                    }
                    Object[] objectArray = new Object[]{this.$description.getPresentableFileName(), this.$presentableUrl};
                    this.$indicator.setText(IdeCoreBundle.message((String)"progress.download.file.text", (Object[])objectArray));
                    Path path = request.saveToFile(Files.createTempFile("download.", ".tmp", new FileAttribute[0]), this.$indicator);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"saveToFile(...)");
                    return path;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
            return (Path)object;
        }

        private static final boolean moveToDir$lambda$0$0(Path $targetDir, String name) {
            return !Files.exists($targetDir.resolve(name), new LinkOption[0]);
        }

        private static final boolean moveToDir$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

