/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.backend.split;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.completion.backend.split.BackendCompletionService;
import com.intellij.platform.completion.backend.split.BackendCompletionSession;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemId;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequestId;
import com.intellij.platform.project.ProjectIdKt;
import com.jetbrains.rdserver.quickDoc.BackendCompletionDocumentationService;
import fleet.util.UID;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionDocumentationServiceImpl;", "Lcom/jetbrains/rdserver/quickDoc/BackendCompletionDocumentationService;", "<init>", "()V", "targets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionRequestId", "", "completionItemId", "intellij.platform.completion.backend.split"})
public final class BackendCompletionDocumentationServiceImpl
implements BackendCompletionDocumentationService {
    @NotNull
    public List<DocumentationTarget> targets(@NotNull Project project, @NotNull Editor editor, @NotNull String completionRequestId, @NotNull String completionItemId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionRequestId, (String)"completionRequestId");
        Intrinsics.checkNotNullParameter((Object)completionItemId, (String)"completionItemId");
        RpcCompletionRequestId requestId = new RpcCompletionRequestId(UID.Companion.fromString(completionRequestId), ProjectIdKt.projectId((Project)project));
        BackendCompletionSession backendCompletionSession = BackendCompletionService.Companion.getInstance(project).findSession(requestId);
        if (backendCompletionSession == null) {
            return CollectionsKt.emptyList();
        }
        BackendCompletionSession session = backendCompletionSession;
        RpcCompletionItemId lookupElementId = new RpcCompletionItemId(UID.Companion.fromString(completionItemId));
        return session.getDocumentationTargets(lookupElementId);
    }
}

