/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.lang.inject;

import com.intellij.jpa.ql.lang.inject.JpaSqlDialectDetector;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0015\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\b\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/ql/lang/inject/JpaSqlInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "<init>", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "annotations", "", "Lorg/jetbrains/annotations/Unmodifiable;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "intellij.javaee.jpa.ql"})
public final class JpaSqlInjector
implements MultiHostInjector {
    @NotNull
    private final List<Class<? extends PsiElement>> elementsToInjectIn;
    @NotNull
    private final List<String> annotations;

    public JpaSqlInjector() {
        Object[] objectArray = new Class[]{UInjectionHost.class, UPolyadicExpression.class};
        this.elementsToInjectIn = UastFacade.INSTANCE.getPossiblePsiSourceTypes((Class[])objectArray).toList();
        objectArray = new String[]{"javax.persistence.NamedNativeQuery", "jakarta.persistence.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQuery"};
        this.annotations = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return this.elementsToInjectIn;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)context);
        if (uElement == null) {
            return;
        }
        UElement uElement2 = uElement;
        UElement uElement3 = uElement2.getUastParent();
        UNamedExpression uNamedExpression = uElement3 instanceof UNamedExpression ? (UNamedExpression)uElement3 : null;
        if (uNamedExpression == null) {
            return;
        }
        UNamedExpression uNamedExpression2 = uNamedExpression;
        if (!Intrinsics.areEqual((Object)uNamedExpression2.getName(), (Object)"query")) {
            return;
        }
        UElement uElement4 = uNamedExpression2.getUastParent();
        UAnnotation uAnnotation = uElement4 instanceof UAnnotation ? (UAnnotation)uElement4 : null;
        if (uAnnotation == null) {
            return;
        }
        UAnnotation uAnnotation2 = uAnnotation;
        if (!CollectionsKt.contains((Iterable)this.annotations, (Object)uAnnotation2.getQualifiedName())) {
            return;
        }
        int textLength = ((PsiLanguageInjectionHost)context).getTextLength();
        if (textLength < 2) {
            return;
        }
        Language language = JpaSqlDialectDetector.Companion.detectSqlDialect(context);
        if (language == null && (language = Language.findLanguageByID((String)"SQL")) == null) {
            return;
        }
        Language sqlLanguage = language;
        registrar.startInjecting(sqlLanguage).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(1, textLength - 1)).doneInjecting();
    }
}

