/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaDebugAware;
import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtils {
    private static final Logger LOG = Logger.getInstance(DebuggerUtils.class);
    public static final Set<String> ourPrimitiveTypeNames = Set.of("byte", "short", "int", "long", "float", "double", "boolean", "char");
    public static final int MAX_DISPLAY_LABEL_LENGTH = 5120;

    public static HowToSwitchToSuspendAll howToSwitchToSuspendAll() {
        String howToSwitchStr = Registry.get((String)"debugger.how.to.switch.to.suspend.all").getSelectedOption();
        return HowToSwitchToSuspendAll.valueOf(howToSwitchStr);
    }

    public static boolean isAlwaysSuspendThreadBeforeSwitch() {
        return DebuggerUtils.howToSwitchToSuspendAll() != HowToSwitchToSuspendAll.DISABLE;
    }

    public static boolean isNewThreadSuspendStateTracking() {
        return Registry.is((String)"debugger.new.suspend.state.tracking");
    }

    @NonNls
    public static String getValueAsString(@NotNull EvaluationContext evaluationContext, @Nullable Value value) throws EvaluateException {
        if (evaluationContext == null) {
            DebuggerUtils.$$$reportNull$$$0(0);
        }
        return DebuggerUtils.getInstance().getValueAsStringImpl(evaluationContext, value);
    }

    @NonNls
    protected abstract String getValueAsStringImpl(@NotNull EvaluationContext var1, @Nullable Value var2) throws EvaluateException;

    @ApiStatus.Internal
    public abstract <R, T> R processCollectibleValue(@NotNull ThrowableComputable<? extends T, ? extends EvaluateException> var1, @NotNull Function<? super T, ? extends R> var2, @NotNull EvaluationContext var3) throws EvaluateException;

    public static void ensureNotInsideObjectConstructor(@NotNull ObjectReference reference, @NotNull EvaluationContext context) throws EvaluateException {
        Location location;
        if (reference == null) {
            DebuggerUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DebuggerUtils.$$$reportNull$$$0(2);
        }
        if ((location = DebuggerUtils.getInstance().getLocation(context.getSuspendContext())) != null && location.method().isConstructor() && reference.equals(context.computeThisObject())) {
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.object.is.being.initialized", new Object[0]));
        }
    }

    protected abstract Location getLocation(SuspendContext var1);

    public static String convertToPresentationString(String str) {
        if (str.length() > 5120) {
            str = DebuggerUtils.translateStringValue(str.substring(0, 5120));
            StringBuilder buf = new StringBuilder();
            buf.append(str);
            if (!str.endsWith("...")) {
                buf.append("...");
            }
            return buf.toString();
        }
        return DebuggerUtils.translateStringValue(str);
    }

    @Nullable
    public static Method findMethod(@NotNull ReferenceType refType, @NonNls String methodName, @Nullable @NonNls String methodSignature) {
        Method method;
        if (refType == null) {
            DebuggerUtils.$$$reportNull$$$0(3);
        }
        if (refType instanceof ArrayType) {
            method = DebuggerUtils.findMethod(DebuggerUtils.getObjectClassType(refType.virtualMachine()), methodName, methodSignature);
            if (method != null) {
                return method;
            }
            if ("clone".equals(methodName) && "()[Ljava/lang/Object;".equals(methodSignature) && (method = DebuggerUtils.findMethod(DebuggerUtils.getObjectClassType(refType.virtualMachine()), "clone", null)) != null) {
                return method;
            }
        }
        method = null;
        if (refType instanceof ClassType) {
            method = DebuggerUtils.concreteMethodByName((ClassType)refType, methodName, methodSignature);
        }
        if (method == null) {
            method = (Method)ContainerUtil.getFirstItem(methodSignature != null ? refType.methodsByName(methodName, methodSignature) : refType.methodsByName(methodName));
        }
        return method;
    }

    @Nullable
    private static Method concreteMethodByName(@NotNull ClassType type, @NotNull String name, @Nullable String signature) {
        ReferenceType t;
        if (type == null) {
            DebuggerUtils.$$$reportNull$$$0(4);
        }
        if (name == null) {
            DebuggerUtils.$$$reportNull$$$0(5);
        }
        Processor signatureChecker = signature != null ? m -> m.signature().equals(signature) : CommonProcessors.alwaysTrue();
        LinkedList<ReferenceType> types = new LinkedList<ReferenceType>();
        while (type != null) {
            for (Method candidate : type.methods()) {
                if (!candidate.name().equals(name) || !signatureChecker.process((Object)candidate)) continue;
                return !candidate.isAbstract() ? candidate : null;
            }
            types.add(type);
            type = type.superclass();
        }
        HashSet<ReferenceType> checkedInterfaces = new HashSet<ReferenceType>();
        while ((t = (ReferenceType)types.poll()) != null) {
            if (t instanceof ClassType) {
                types.addAll(0, ((ClassType)t).interfaces());
                continue;
            }
            if (!(t instanceof InterfaceType) || !checkedInterfaces.add(t)) continue;
            for (Method candidate : t.methods()) {
                if (!candidate.name().equals(name) || !signatureChecker.process((Object)candidate) || candidate.isAbstract()) continue;
                return candidate;
            }
            types.addAll(0, ((InterfaceType)t).superinterfaces());
        }
        return null;
    }

    @Nullable
    public static Field findField(@NotNull ReferenceType type, @NotNull String name) {
        ReferenceType t;
        if (type == null) {
            DebuggerUtils.$$$reportNull$$$0(6);
        }
        if (name == null) {
            DebuggerUtils.$$$reportNull$$$0(7);
        }
        LinkedList<ReferenceType> types = new LinkedList<ReferenceType>();
        while (type != null) {
            ClassType classType;
            for (Field candidate : type.fields()) {
                if (!candidate.name().equals(name)) continue;
                return candidate;
            }
            types.add(type);
            if (type instanceof ClassType) {
                ClassType classType2 = (ClassType)type;
                classType = classType2.superclass();
            } else {
                classType = null;
            }
            type = classType;
        }
        HashSet<ReferenceType> checkedInterfaces = new HashSet<ReferenceType>();
        while ((t = (ReferenceType)types.poll()) != null) {
            if (t instanceof ClassType) {
                types.addAll(0, ((ClassType)t).interfaces());
                continue;
            }
            if (!(t instanceof InterfaceType) || !checkedInterfaces.add(t)) continue;
            for (Field candidate : t.fields()) {
                if (!candidate.name().equals(name)) continue;
                return candidate;
            }
            types.addAll(0, ((InterfaceType)t).superinterfaces());
        }
        return null;
    }

    public static boolean isNumeric(Value value) {
        return value != null && (DebuggerUtils.isInteger(value) || value instanceof FloatValue || value instanceof DoubleValue);
    }

    public static boolean isInteger(Value value) {
        return value instanceof ByteValue || value instanceof ShortValue || value instanceof LongValue || value instanceof IntegerValue;
    }

    public static String translateStringValue(String str) {
        int length = str.length();
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)length, (String)str, (StringBuilder)buffer);
        return buffer.toString();
    }

    @Nullable
    protected static ArrayClass getArrayClass(@NotNull String className) {
        int pos;
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(8);
        }
        boolean searchBracket = false;
        int dims = 0;
        for (pos = className.lastIndexOf(93); pos >= 0; --pos) {
            char c = className.charAt(pos);
            if (searchBracket) {
                if (c == '[') {
                    ++dims;
                    searchBracket = false;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                break;
            }
            if (c == ']') {
                searchBracket = true;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (searchBracket) {
            return null;
        }
        if (dims == 0) {
            return null;
        }
        return new ArrayClass(className.substring(0, pos + 1), dims);
    }

    public static boolean instanceOf(@NotNull String subType, @NotNull String superType, @Nullable Project project) {
        if (subType == null) {
            DebuggerUtils.$$$reportNull$$$0(9);
        }
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(10);
        }
        if (project == null) {
            return subType.equals(superType);
        }
        ArrayClass nodeClass = DebuggerUtils.getArrayClass(subType);
        ArrayClass rendererClass = DebuggerUtils.getArrayClass(superType);
        if (nodeClass == null || rendererClass == null) {
            return false;
        }
        if (nodeClass.dims == rendererClass.dims) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass psiNodeClass = JavaPsiFacade.getInstance((Project)project).findClass(nodeClass.className, scope);
            PsiClass psiRendererClass = JavaPsiFacade.getInstance((Project)project).findClass(rendererClass.className, scope);
            return InheritanceUtil.isInheritorOrSelf((PsiClass)psiNodeClass, (PsiClass)psiRendererClass, (boolean)true);
        }
        if (nodeClass.dims > rendererClass.dims) {
            return rendererClass.className.equals("java.lang.Object");
        }
        return false;
    }

    public static boolean instanceOf(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(11);
        }
        if (subType == null || subType instanceof VoidType) {
            return false;
        }
        if (subType instanceof PrimitiveType) {
            return superType.equals(subType.name());
        }
        if ("java.lang.Object".equals(superType)) {
            return true;
        }
        if (subType instanceof ArrayType && ("java.lang.Cloneable".equals(superType) || "java.io.Serializable".equals(superType))) {
            return true;
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType) != null;
    }

    @Nullable
    public static Type getSuperType(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(12);
        }
        if (subType == null || subType instanceof PrimitiveType || subType instanceof VoidType) {
            return null;
        }
        if ("java.lang.Object".equals(superType)) {
            return DebuggerUtils.getObjectClassType(subType.virtualMachine());
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType);
    }

    protected static ReferenceType getObjectClassType(VirtualMachine virtualMachine) {
        return (ReferenceType)ContainerUtil.getFirstItem(virtualMachine.classesByName("java.lang.Object"));
    }

    private static boolean typeEquals(@NotNull Type type, @NotNull String typeName) {
        int genericPos;
        if (type == null) {
            DebuggerUtils.$$$reportNull$$$0(13);
        }
        if (typeName == null) {
            DebuggerUtils.$$$reportNull$$$0(14);
        }
        if ((genericPos = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, genericPos);
        }
        return type.name().replace('$', '.').equals(typeName.replace('$', '.'));
    }

    private static Type getSuperTypeInt(@NotNull Type subType, @NotNull String superType) {
        if (subType == null) {
            DebuggerUtils.$$$reportNull$$$0(15);
        }
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(16);
        }
        if (DebuggerUtils.typeEquals(subType, superType)) {
            return subType;
        }
        if (subType instanceof ClassType) {
            try {
                ClassType clsType = (ClassType)subType;
                Type result = DebuggerUtils.getSuperType(clsType.superclass(), superType);
                if (result != null) {
                    return result;
                }
                for (InterfaceType iface : clsType.interfaces()) {
                    result = DebuggerUtils.getSuperType(iface, superType);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }
        if (subType instanceof InterfaceType) {
            try {
                for (InterfaceType iface : ((InterfaceType)subType).superinterfaces()) {
                    Type result = DebuggerUtils.getSuperType(iface, superType);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
        } else if (subType instanceof ArrayType && superType.endsWith("[]")) {
            try {
                String superTypeItem = superType.substring(0, superType.length() - 2);
                Type subTypeItem = ((ArrayType)subType).componentType();
                return DebuggerUtils.instanceOf(subTypeItem, superTypeItem) ? subType : null;
            }
            catch (ClassNotLoadedException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    protected abstract PsiClass createArrayClass(Project var1, LanguageLevel var2);

    @Nullable
    public static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(17);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            DebuggerUtils.$$$reportNull$$$0(19);
        }
        return DebuggerUtils.findClass(className, project, scope, true);
    }

    @Nullable
    public static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope scope, boolean fallbackToAllScope) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(20);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            DebuggerUtils.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            GlobalSearchScope globalScope;
            if (DebuggerUtils.getArrayClass(className) != null) {
                return DebuggerUtils.getInstance().createArrayClass(project, LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel());
            }
            if (project.isDefault()) {
                return null;
            }
            className = StringUtil.notNullize((String)StringUtil.substringBefore((String)className, (String)"<"), (String)className);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className, null, (boolean)true, (GlobalSearchScope)scope);
            if (psiClass == null && fallbackToAllScope && (globalScope = DebuggerUtils.getInstance().getFallbackAllScope(scope, project)) != null) {
                psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className, null, (boolean)true, (GlobalSearchScope)globalScope);
            }
            return psiClass;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    protected abstract GlobalSearchScope getFallbackAllScope(@NotNull GlobalSearchScope var1, @NotNull Project var2);

    @Nullable
    public static PsiType getType(@NotNull String className, @NotNull Project project) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(23);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            if (DebuggerUtils.getArrayClass(className) != null) {
                return JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(className, null);
            }
            if (project.isDefault()) {
                return null;
            }
            PsiClass aClass = DebuggerUtils.findClass(className, project, GlobalSearchScope.allScope((Project)project));
            if (aClass != null) {
                return PsiTypesUtil.getClassType((PsiClass)aClass);
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return null;
    }

    public static void checkSyntax(PsiCodeFragment codeFragment) throws EvaluateException {
        PsiElement[] children = codeFragment.getChildren();
        if (children.length == 0) {
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.empty.code.fragment", new Object[0]));
        }
        for (PsiElement child : children) {
            if (!(child instanceof PsiErrorElement)) continue;
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.invalid.expression", child.getText()));
        }
    }

    public static boolean hasSideEffects(@Nullable PsiElement element) {
        return DebuggerUtils.hasSideEffectsOrReferencesMissingVars(element, null);
    }

    public static boolean hasSideEffectsOrReferencesMissingVars(@Nullable PsiElement element, final @Nullable Set<String> visibleLocalVariables) {
        if (element == null) {
            return false;
        }
        final Ref rv = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                rv.set((Object)Boolean.TRUE);
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiElement psiElement;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((psiElement = expression.resolve()) instanceof PsiLocalVariable) {
                    if (visibleLocalVariables != null && !visibleLocalVariables.contains(((PsiLocalVariable)psiElement).getName())) {
                        rv.set((Object)Boolean.TRUE);
                    }
                } else if (psiElement instanceof PsiMethod) {
                    rv.set((Object)Boolean.TRUE);
                }
                if (!((Boolean)rv.get()).booleanValue()) {
                    super.visitReferenceExpression(expression);
                }
            }

            public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
                IElementType op;
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (JavaTokenType.PLUSPLUS.equals(op = expression.getOperationTokenType()) || JavaTokenType.MINUSMINUS.equals(op)) {
                    rv.set((Object)Boolean.TRUE);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                rv.set((Object)Boolean.TRUE);
            }

            public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(4);
                }
                rv.set((Object)Boolean.TRUE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/DebuggerUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPostfixExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrefixExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)rv.get();
    }

    public abstract String findAvailableDebugAddress(boolean var1) throws ExecutionException;

    public static boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (typeComponent == null) {
            return false;
        }
        if (ContainerUtil.exists((Iterable)SyntheticTypeComponentProvider.EP_NAME.getExtensionList(), provider -> provider.isNotSynthetic(typeComponent))) {
            return false;
        }
        return ContainerUtil.exists((Iterable)SyntheticTypeComponentProvider.EP_NAME.getExtensionList(), provider -> provider.isSynthetic(typeComponent));
    }

    public static boolean isInsideSimpleGetter(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            DebuggerUtils.$$$reportNull$$$0(25);
        }
        return ContainerUtil.exists((Iterable)SimplePropertyGetterProvider.EP_NAME.getExtensionList(), provider -> provider.isInsideSimpleGetter(contextElement));
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName != null && ourPrimitiveTypeNames.contains(typeName);
    }

    @ApiStatus.Internal
    @Nullable
    public static String tryExtractExceptionMessage(@NotNull ObjectReference exception) {
        ReferenceType type;
        Field messageField;
        if (exception == null) {
            DebuggerUtils.$$$reportNull$$$0(26);
        }
        if ((messageField = DebuggerUtils.findField(type = exception.referenceType(), "detailMessage")) == null) {
            return null;
        }
        Value message = exception.getValue(messageField);
        if (message instanceof StringReference) {
            return ((StringReference)message).value();
        }
        return null;
    }

    public static DebuggerUtils getInstance() {
        return (DebuggerUtils)ApplicationManager.getApplication().getService(DebuggerUtils.class);
    }

    public abstract PsiExpression substituteThis(PsiExpression var1, PsiExpression var2, Value var3, StackFrameContext var4) throws EvaluateException;

    public abstract DebuggerContext getDebuggerContext(DataContext var1);

    public abstract Element writeTextWithImports(TextWithImports var1);

    public abstract TextWithImports readTextWithImports(Element var1);

    public abstract void writeTextWithImports(Element var1, @NonNls String var2, TextWithImports var3);

    public abstract TextWithImports readTextWithImports(Element var1, @NonNls String var2);

    public abstract TextWithImports createExpressionWithImports(@NonNls String var1);

    public abstract PsiElement getContextElement(StackFrameContext var1);

    public abstract PsiClass chooseClassDialog(String var1, Project var2);

    public static boolean isBreakpointAware(@NotNull PsiFile file) {
        LanguageFileType lft;
        FileType fileType;
        if (file == null) {
            DebuggerUtils.$$$reportNull$$$0(27);
        }
        if ((fileType = file.getFileType()) instanceof LanguageFileType && (lft = (LanguageFileType)fileType).isJVMDebuggingSupported()) {
            return true;
        }
        return ContainerUtil.exists((Iterable)JavaDebugAware.EP_NAME.getExtensionList(), provider -> provider.isBreakpointAware(file));
    }

    public static boolean isAndroidVM(@NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            DebuggerUtils.$$$reportNull$$$0(28);
        }
        return StringUtil.containsIgnoreCase((String)virtualMachine.name(), (String)"dalvik");
    }

    public static <T> void forEachSafe(ExtensionPointName<T> ep, Consumer<? super T> action) {
        DebuggerUtils.forEachSafe(ep.getIterable(), action);
    }

    public static <T> void forEachSafe(Iterable<? extends T> iterable, Consumer<? super T> action) {
        for (T o : iterable) {
            try {
                action.accept(o);
            }
            catch (Throwable e) {
                DebuggerUtils.getInstance().logErrorImpl(e);
            }
        }
    }

    protected abstract void logErrorImpl(@NotNull Throwable var1);

    @ApiStatus.Internal
    @NotNull
    public abstract VirtualMachineProxy getVmProxy();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DebuggerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureNotInsideObjectConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "concreteMethodByName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOf";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperTypeInt";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideSimpleGetter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "tryExtractExceptionMessage";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "isBreakpointAware";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidVM";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum HowToSwitchToSuspendAll {
        IMMEDIATE_PAUSE,
        PAUSE_WAITING_EVALUATION,
        METHOD_BREAKPOINT,
        DISABLE;

    }

    protected record ArrayClass(String className, int dims) {
    }
}

