/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.quic.QuicClientStreamTransportKt;
import com.intellij.platform.split.connection.network.quic.QuicStreamTransport;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.intellij.platform.split.connection.network.quic.QuicheConfig;
import com.intellij.platform.split.connection.network.quic.QuicheSockAddrKt;
import com.intellij.platform.split.connection.network.quic.SockAddrI;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.jetbrains.rd.platform.codeWithMe.util.ThreadUtil;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.ptr.PointerByReference;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0014\u0010\"\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport;", "Lcom/intellij/platform/split/connection/network/quic/QuicStreamTransport;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "localSocket", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "peer", "Ljava/net/InetSocketAddress;", "hostName", "", "idleTimeout", "Ljava/time/Duration;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;Ljava/net/InetSocketAddress;Ljava/lang/String;Ljava/time/Duration;)V", "name", "getName", "()Ljava/lang/String;", "connection", "Lcom/sun/jna/ptr/PointerByReference;", "myConnectionState", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "socketReceivedDatagrams", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Pair;", "", "receivedQueue", "Ljava/util/concurrent/BlockingDeque;", "getReceivedQueue", "()Ljava/util/concurrent/BlockingDeque;", "toSendQueue", "getToSendQueue", "wakeupQueue", "", "getWakeupQueue", "connected", "getConnected", "()Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "localSockAddress", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "peerSockAddr", "quicConnection", "quicThread", "", "addToSendQueue", "arr", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nQuicClientStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n67#2,4:310\n67#2,4:314\n67#2,4:318\n67#2,4:322\n67#2,4:326\n67#2,4:330\n67#2,4:334\n67#2,4:338\n67#2,4:342\n67#2,4:346\n67#2,4:350\n67#2,4:354\n67#2,4:358\n67#2,4:362\n67#2,4:366\n*S KotlinDebug\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n*L\n92#1:310,4\n128#1:314,4\n147#1:318,4\n162#1:322,4\n199#1:326,4\n222#1:330,4\n239#1:334,4\n251#1:338,4\n264#1:342,4\n269#1:346,4\n277#1:350,4\n280#1:354,4\n77#1:358,4\n83#1:362,4\n96#1:366,4\n*E\n"})
public final class QuicClientStreamTransport
extends QuicStreamTransport {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IDatagramSocketWrapper localSocket;
    @NotNull
    private final InetSocketAddress peer;
    @NotNull
    private final String hostName;
    @NotNull
    private final Duration idleTimeout;
    @NotNull
    private final String name;
    @NotNull
    private final PointerByReference connection;
    @NotNull
    private final ConnectionStateProperty myConnectionState;
    @NotNull
    private final LinkedBlockingQueue<Pair<InetSocketAddress, byte[]>> socketReceivedDatagrams;
    @NotNull
    private final BlockingDeque<byte[]> receivedQueue;
    @NotNull
    private final BlockingDeque<byte[]> toSendQueue;
    @NotNull
    private final BlockingDeque<Boolean> wakeupQueue;
    @NotNull
    private final SockAddrI localSockAddress;
    @NotNull
    private final SockAddrI peerSockAddr;

    public QuicClientStreamTransport(@NotNull Lifetime lifetime, @NotNull IDatagramSocketWrapper localSocket, @NotNull InetSocketAddress peer, @NotNull String hostName, @NotNull Duration idleTimeout) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)localSocket, (String)"localSocket");
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        this.lifetime = lifetime;
        this.localSocket = localSocket;
        this.peer = peer;
        this.hostName = hostName;
        this.idleTimeout = idleTimeout;
        this.name = "QUIC Client Transport (id: " + this.peer + ")";
        this.myConnectionState = new ConnectionStateProperty();
        this.socketReceivedDatagrams = new LinkedBlockingQueue();
        this.receivedQueue = new LinkedBlockingDeque();
        this.toSendQueue = new LinkedBlockingDeque();
        this.wakeupQueue = new LinkedBlockingDeque();
        InetSocketAddress inetSocketAddress = this.localSocket.getLocalAddress();
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        this.localSockAddress = QuicheSockAddrKt.getQuicheSockAddr(inetSocketAddress);
        this.peerSockAddr = QuicheSockAddrKt.getQuicheSockAddr(this.peer);
        SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)this.lifetime, (arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$0(this, arg_0, arg_1));
        this.localSocket.adviseOnSpecificAddressPackets(this.lifetime, this.peer, (Function1<? super byte[], Unit>)((Function1)arg_0 -> QuicClientStreamTransport._init_$lambda$1(this, arg_0)));
        this.localSocket.adviseOnRemainingPackets(this.lifetime, (Function2<? super InetSocketAddress, ? super byte[], Unit>)((Function2)(arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$2(this, arg_0, arg_1)));
        this.getWakeupQueue().add(true);
        this.connection = this.quicConnection();
        Logger $this$trace$iv = QuicClientStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Starting QUIC thread");
        }
        Thread quicThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("QUIC connect to " + this.peer), (int)10, () -> QuicClientStreamTransport._init_$lambda$4(this), (int)5, null);
        this.lifetime.onTermination(() -> QuicClientStreamTransport._init_$lambda$5(quicThread, this));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getReceivedQueue() {
        return this.receivedQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getToSendQueue() {
        return this.toSendQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<Boolean> getWakeupQueue() {
        return this.wakeupQueue;
    }

    @NotNull
    public ConnectionStateProperty getConnected() {
        return this.myConnectionState;
    }

    private final PointerByReference quicConnection() {
        QuicheConfig quicheConfig;
        byte[] quicConnectionId = Random.Default.nextBytes(16);
        QuicheConfig $this$quicConnection_u24lambda_u240 = quicheConfig = new QuicheConfig();
        boolean bl = false;
        $this$quicConnection_u24lambda_u240.setCommonSensibleOptions(this.idleTimeout);
        String[] stringArray = new String[]{"hq-27", "http/0.9"};
        $this$quicConnection_u24lambda_u240.setSupportedProtocols(stringArray);
        QuicheConfig config = quicheConfig;
        PointerByReference pointerByReference = Quiche.INSTANCE.getLibrary().quiche_connect(this.hostName, quicConnectionId, new NativeSize((long)quicConnectionId.length), this.localSockAddress.getQuicheSockAddr(), this.localSockAddress.getNativeSize(), this.peerSockAddr.getQuicheSockAddr(), this.peerSockAddr.getNativeSize(), config.getPointer());
        Intrinsics.checkNotNullExpressionValue((Object)pointerByReference, (String)"quiche_connect(...)");
        return pointerByReference;
    }

    /*
     * Exception decompiling
     */
    private final void quicThread() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 35[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void addToSendQueue(byte[] arr) {
        this.getToSendQueue().addFirst(arr);
        this.getWakeupQueue().add(true);
    }

    private static final Unit _init_$lambda$0(QuicClientStreamTransport this$0, Maybe previous, ConnectionState current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        QuicClientStreamTransportKt.access$getLogger$p().info(this$0.connectionStateChangedToString((ConnectionState)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(QuicClientStreamTransport this$0, byte[] datagramBytes) {
        Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)"datagramBytes");
        Logger $this$trace$iv = QuicClientStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this$0.getName() + " Received packet from " + IPrintableKt.printToString((Object)this$0.peer) + " of size " + datagramBytes.length);
        }
        this$0.socketReceivedDatagrams.add((Pair<InetSocketAddress, byte[]>)TuplesKt.to((Object)this$0.peer, (Object)datagramBytes));
        this$0.getWakeupQueue().add(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(QuicClientStreamTransport this$0, InetSocketAddress address, byte[] datagramBytes) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)"datagramBytes");
        Logger $this$trace$iv = QuicClientStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this$0.getName() + " Received remaining packets from " + IPrintableKt.printToString((Object)address) + " of size " + datagramBytes.length);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(QuicClientStreamTransport this$0) {
        this$0.quicThread();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Thread $quicThread, QuicClientStreamTransport this$0) {
        Logger $this$trace$iv = QuicClientStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this$0.getName() + " Lifetime has been terminated. Terminate QUIC thread");
        }
        ThreadUtil.INSTANCE.gracefullyJoinThread($quicThread);
        this$0.myConnectionState.setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
        return Unit.INSTANCE;
    }
}

