/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.quic.QuicheBinariesLocator;
import com.jetbrains.quiche.stubs.QuicheLibrary;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/split/connection/network/quic/Quiche;", "", "<init>", "()V", "disableQuicheSystemProperty", "", "isAvailable", "", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addLibrarySearchPath", "", "path", "Ljava/nio/file/Path;", "library", "Lcom/jetbrains/quiche/stubs/QuicheLibrary;", "getLibrary", "()Lcom/jetbrains/quiche/stubs/QuicheLibrary;", "intellij.platform.split.connection"})
public final class Quiche {
    @NotNull
    public static final Quiche INSTANCE;
    @NotNull
    public static final String disableQuicheSystemProperty = "codeWithMe.disable.quiche";
    private static final boolean isAvailable;
    @NotNull
    private static final Logger logger;

    private Quiche() {
    }

    public final boolean isAvailable() {
        return isAvailable;
    }

    private final void addLibrarySearchPath(Path path) {
        Path archSpecific = path.resolve(Platform.RESOURCE_PREFIX);
        logger.info("Adding " + archSpecific + " to JNA native library search path for 'quiche'");
        NativeLibrary.addSearchPath((String)"quiche", (String)((Object)archSpecific).toString());
    }

    @NotNull
    public final QuicheLibrary getLibrary() {
        if (!isAvailable) {
            throw new IllegalStateException("Quiche library is not available".toString());
        }
        QuicheLibrary quicheLibrary = QuicheLibrary.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)quicheLibrary, (String)"INSTANCE");
        return quicheLibrary;
    }

    static {
        boolean bl;
        INSTANCE = new Quiche();
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Quiche.logger = logger;
        if (Boolean.parseBoolean(System.getProperty(disableQuicheSystemProperty))) {
            Quiche.logger.info("codeWithMe.disable.quiche property is set to false, will not attempt to check Quiche availability.");
            bl = false;
        } else {
            boolean bl2;
            try {
                INSTANCE.addLibrarySearchPath(QuicheBinariesLocator.INSTANCE.getLibrarySearchRoot());
                QuicheLibrary.INSTANCE.quiche_version();
                bl2 = true;
            }
            catch (Throwable t) {
                Quiche.logger.info("Quiche library is not available. QUIC support will be disabled: " + t.getMessage(), t);
                bl2 = false;
            }
            bl = bl2;
        }
        isAvailable = bl;
    }
}

