/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.platform.split.connection.impl.config.ConnectionConfiguration;
import com.intellij.platform.split.connection.protocol.ServiceMessageProcessor;
import com.intellij.platform.split.connection.protocol.ServiceMessageProcessorKt;
import com.intellij.platform.split.connection.protocol.channel.frame.CurrentConfirmationFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.channel.frame.MessageFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.PingFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapper;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.jetbrains.rd.platform.codeWithMe.util.LifetimeUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020*2\u0006\u0010/\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020*2\u0006\u0010/\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u000e\u00106\u001a\u000204H\u0086@\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0012J\u0006\u00109\u001a\u00020*J\u0010\u0010:\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u001d\u0010;\u001a\u00020*2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020*0=H\u0002\u00a2\u0006\u0004\b>\u0010?J\u0010\u0010@\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010A\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0016\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010EJ\u0010\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0012H\u0002J\b\u0010J\u001a\u00020\u0012H\u0002J\b\u0010K\u001a\u00020\u0012H\u0002J\b\u0010L\u001a\u00020*H\u0002R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/platform/split/connection/protocol/ServiceMessageProcessor;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "id", "", "isServer", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Z)V", "name", "getName", "()Ljava/lang/String;", "ack", "Ljava/util/concurrent/atomic/AtomicInteger;", "confirmedFrameNumber", "unconfirmedFrames", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/intellij/platform/split/connection/protocol/channel/frame/MessageFrame;", "myUnconfirmedFramesBufferSize", "Ljava/util/concurrent/atomic/AtomicLong;", "logRemoteSide", "sendMessageFrameChannel", "Lkotlinx/coroutines/channels/Channel;", "myTransportInfo", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "transportInfo", "getTransportInfo", "()Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "transport", "Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;", "getTransport", "()Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;", "unconfirmedFramesBufferSize", "", "getUnconfirmedFramesBufferSize", "()J", "sendFramesMutex", "Lkotlinx/coroutines/sync/Mutex;", "myTransportToFinishSendingMessages", "attachTransport", "", "sendMessage", "bytes", "", "sendFrame", "frame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "sendPingFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/PingFrame;", "sendSystemFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;", "sendMessageFrame", "readNextSystemFrame", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processIncomingFrame", "reset", "sendMessageFrameToQueue", "handleSendResult", "result", "Lkotlinx/coroutines/channels/ChannelResult;", "handleSendResult-rs8usWo", "(Ljava/lang/Object;)V", "sendFrameToChannel", "confirmFrame", "acknowledgeFrame", "resendUnconfirmedFrames", "originalTransport", "(Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkRemoteFrameConfirmedNumber", "remoteFrameConfirmedNumber", "", "addUnconfirmedFrame", "pollUnconfirmedFrame", "peekUnconfirmedFrame", "resetTransport", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nServiceMessageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceMessageProcessor.kt\ncom/intellij/platform/split/connection/protocol/ServiceMessageProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n1#2:405\n67#3,4:406\n67#3,4:410\n67#3,4:414\n67#3,4:418\n67#3,4:422\n67#3,4:426\n67#3,4:430\n67#3,4:434\n60#3,5:438\n60#3,5:453\n82#3,3:459\n67#3,4:464\n67#3,4:468\n67#3,4:472\n116#4,8:443\n125#4:458\n126#4:463\n1924#5,2:451\n1926#5:462\n*S KotlinDebug\n*F\n+ 1 ServiceMessageProcessor.kt\ncom/intellij/platform/split/connection/protocol/ServiceMessageProcessor\n*L\n170#1:406,4\n189#1:410,4\n201#1:414,4\n215#1:418,4\n220#1:422,4\n258#1:426,4\n287#1:430,4\n309#1:434,4\n336#1:438,5\n341#1:453,5\n347#1:459,3\n365#1:464,4\n372#1:468,4\n382#1:472,4\n339#1:443,8\n339#1:458\n339#1:463\n340#1:451,2\n340#1:462\n*E\n"})
public final class ServiceMessageProcessor
implements NamedTransportEntity {
    @NotNull
    private final String name;
    @NotNull
    private final AtomicInteger ack;
    @NotNull
    private final AtomicInteger confirmedFrameNumber;
    @NotNull
    private final LinkedBlockingQueue<MessageFrame> unconfirmedFrames;
    @NotNull
    private final AtomicLong myUnconfirmedFramesBufferSize;
    @NotNull
    private final String logRemoteSide;
    @NotNull
    private final Channel<MessageFrame> sendMessageFrameChannel;
    @NotNull
    private final AtomicReference<TransportInfo> myTransportInfo;
    @NotNull
    private final Mutex sendFramesMutex;
    @NotNull
    private final AtomicReference<TransportInfo> myTransportToFinishSendingMessages;

    public ServiceMessageProcessor(@NotNull Lifetime lifetime, @NotNull String id, boolean isServer) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.name = "Service Message Processor (id: " + id + ")";
        this.ack = new AtomicInteger(1);
        this.confirmedFrameNumber = new AtomicInteger(0);
        this.unconfirmedFrames = new LinkedBlockingQueue();
        this.myUnconfirmedFramesBufferSize = new AtomicLong(0L);
        this.logRemoteSide = isServer ? "C" : "H";
        this.sendMessageFrameChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.myTransportInfo = new AtomicReference<Object>(null);
        this.sendFramesMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.myTransportToFinishSendingMessages = new AtomicReference<Object>(null);
        LifetimeUtilKt.launchAndJoinOnTerminationWithSoftCancellation-SYHnMyU$default((Lifetime)lifetime, (String)"ServiceMessageProcessor::Consumer", (long)((Duration)ConnectionConfiguration.INSTANCE.getTransportLifetimeTerminationDelay().getValue()).unbox-impl(), arg_0 -> ServiceMessageProcessor._init_$lambda$0(this, arg_0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            final /* synthetic */ ServiceMessageProcessor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)16, null);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final TransportInfo getTransportInfo() {
        TransportInfo transportInfo = this.myTransportInfo.get();
        if (transportInfo == null) {
            boolean bl = false;
            String string = this.getName() + " Transport Info is not defined";
            throw new IllegalStateException(string.toString());
        }
        return transportInfo;
    }

    private final TransportWrapper getTransport() {
        return this.getTransportInfo().getTransport();
    }

    public final long getUnconfirmedFramesBufferSize() {
        return this.myUnconfirmedFramesBufferSize.get();
    }

    public final void attachTransport(@NotNull TransportInfo transportInfo) {
        Intrinsics.checkNotNullParameter((Object)transportInfo, (String)"transportInfo");
        this.myTransportToFinishSendingMessages.set(transportInfo);
        this.myTransportInfo.set(transportInfo);
    }

    public final void sendMessage(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int confirmedFrameNumberToUse = this.confirmedFrameNumber.get();
        MessageFrame frame = new MessageFrame(0, confirmedFrameNumberToUse, bytes);
        this.sendFrame(frame);
    }

    public final void sendFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Frame frame2 = frame;
        if (frame2 instanceof SystemFrame) {
            this.sendSystemFrame((SystemFrame)frame);
        } else if (frame2 instanceof MessageFrame) {
            this.sendMessageFrame((MessageFrame)frame);
        } else if (frame2 instanceof PingFrame) {
            this.sendPingFrame((PingFrame)frame);
        } else {
            ServiceMessageProcessorKt.access$getLogger$p().error("Unexpected frame type. Expected to send <" + Reflection.getOrCreateKotlinClass(SystemFrame.class).getSimpleName() + " | " + Reflection.getOrCreateKotlinClass(MessageFrame.class).getSimpleName() + ">, but got: <" + frame + ">. Ignore this frame.");
        }
    }

    private final void sendPingFrame(PingFrame frame) {
        if (this.getTransportInfo().getTransport().isOpen()) {
            this.sendFrameToChannel(frame);
        }
    }

    private final void sendSystemFrame(SystemFrame frame) {
        if (this.getTransportInfo().getTransport().isOpen()) {
            Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this.getName() + " [ ] -> [" + this.logRemoteSide + "]. " + frame);
            }
            this.sendFrameToChannel(frame);
        }
    }

    private final void sendMessageFrame(MessageFrame frame) {
        this.sendMessageFrameToQueue(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object readNextSystemFrame(@NotNull Continuation<? super SystemFrame> $completion) {
        if (!($completion instanceof readNextSystemFrame.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ServiceMessageProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readNextSystemFrame((Continuation<? super SystemFrame>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var7_10 = $this$trace$iv;
                    $i$a$-trace-ServiceMessageProcessor$readNextSystemFrame$2 = false;
                    v0 = this.myTransportInfo.get();
                    var7_10.trace(this.getName() + " Going to read next frame from transport " + (v0 != null ? v0.getName() : null));
                }
                $continuation.label = 1;
                v1 = this.getTransportInfo().getTransport().receiveSingleSystemFrame((Continuation<? super SystemFrame>)$continuation);
                ** if (v1 != var10_4) goto lbl26
lbl25:
                // 1 sources

                return var10_4;
lbl26:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    var2_5 = v1;
                    return var2_5;
                }
                catch (Throwable t) {
                    if (!(t instanceof CancellationException)) {
                        ServiceMessageProcessorKt.access$getLogger$p().warn(t);
                    }
                    throw t;
                }
            }
            catch (Throwable var3_9) {
                throw var3_9;
            }
            {
                finally {
                    $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var7_10 = $this$trace$iv;
                        $i$a$-trace-ServiceMessageProcessor$readNextSystemFrame$3 = false;
                        var7_10.trace(this.getName() + " Service message reading ended");
                    }
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean processIncomingFrame(@NotNull MessageFrame frame) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " [" + this.logRemoteSide + "] -> [ ]. " + frame);
        }
        this.confirmFrame(frame);
        boolean isFrameValidForProcessing = this.acknowledgeFrame(frame);
        Logger $this$trace$iv2 = ServiceMessageProcessorKt.access$getLogger$p();
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace(this.getName() + " Message is acknowledge with result: " + isFrameValidForProcessing);
        }
        return isFrameValidForProcessing;
    }

    public final void reset() {
        ServiceMessageProcessorKt.access$getLogger$p().info(this.getName() + " Reset message processor");
        this.resetTransport();
    }

    private final void sendMessageFrameToQueue(MessageFrame frame) {
        Object sendResult = this.sendMessageFrameChannel.trySend-JP2dKIU((Object)frame);
        this.handleSendResult-rs8usWo(sendResult);
    }

    private final void handleSendResult-rs8usWo(Object result) {
        if (ChannelResult.isSuccess-impl((Object)result)) {
            return;
        }
        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)result);
        if (throwable != null) {
            throw throwable;
        }
    }

    private final void sendFrameToChannel(Frame frame) {
        Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " [ ] -> [" + this.logRemoteSide + "]. " + frame);
        }
        try {
            this.getTransport().send(frame);
        }
        catch (Throwable t) {
            Throwable throwable = t;
            if (throwable instanceof ClosedChannelException || throwable instanceof IOException) {
                ServiceMessageProcessorKt.access$getLogger$p().warn(this.getName() + " Exception on send message via the top level framed channel: " + t.getMessage(), t);
                ServiceMessageProcessorKt.access$getLogger$p().warn(this.getName() + " Wait for underlying stream transport termination.");
            }
            ServiceMessageProcessorKt.access$getLogger$p().error(this.getName() + " Unhandled exception on send message via top level framed channel: " + t.getMessage());
            throw t;
        }
    }

    private final void confirmFrame(MessageFrame frame) {
        Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Confirm stored frames in a queue after receiving a new incoming frame: " + frame);
        }
        this.checkRemoteFrameConfirmedNumber(frame.getConfirmedFrameNumber());
    }

    private final boolean acknowledgeFrame(MessageFrame frame) {
        if (this.confirmedFrameNumber.get() + 1 != frame.getAck()) {
            ServiceMessageProcessorKt.access$getLogger$p().warn(this.getName() + " [" + this.logRemoteSide + "] -> [ ]. Missing remote messages. Expected ack: <" + (this.confirmedFrameNumber.get() + 1) + ">, but got: <" + frame.getAck() + ">");
        }
        if (this.confirmedFrameNumber.get() < frame.getAck()) {
            Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this.getName() + " Update last confirmed remote frame number: <" + this.confirmedFrameNumber.get() + "> -> <" + frame.getAck() + ">");
            }
            this.confirmedFrameNumber.set(frame.getAck());
            return true;
        }
        ServiceMessageProcessorKt.access$getLogger$p().warn(this.getName() + " Local confirmed frame number if higher than received message. Local confirmed frame number: <" + this.confirmedFrameNumber.get() + ">, but received message with ack: <" + frame.getAck() + ">. Ignore the message.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object resendUnconfirmedFrames(@NotNull TransportInfo originalTransport, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof resendUnconfirmedFrames.1)) ** GOTO lbl-1000
        var29_3 = $completion;
        if ((var29_3.label & -2147483648) != 0) {
            var29_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ServiceMessageProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resendUnconfirmedFrames(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ServiceMessageProcessorKt.access$getLogger$p().info(this.getName() + " Process unconfirmed frames queue. Size: " + this.unconfirmedFrames.size());
                this.sendFrame(FrameFactory.INSTANCE.createCurrentConfirmationFrame(this.confirmedFrameNumber.get()));
                $continuation.L$0 = originalTransport;
                $continuation.label = 1;
                v0 = this.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
                if (v0 == var30_5) {
                    return var30_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                originalTransport = (TransportInfo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((counterpartReceivedFrame = (SystemFrame)v0) instanceof CurrentConfirmationFrame)) {
                    $i$a$-check-ServiceMessageProcessor$resendUnconfirmedFrames$2 = false;
                    $i$a$-check-ServiceMessageProcessor$resendUnconfirmedFrames$2 = "Expected frame: <CurrentConfirmationFrame>, but got: <" + counterpartReceivedFrame + ">";
                    throw new IllegalStateException($i$a$-check-ServiceMessageProcessor$resendUnconfirmedFrames$2.toString());
                }
                $this$debug_u24default$iv = ServiceMessageProcessorKt.access$getLogger$p();
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var27_12 = $this$debug_u24default$iv;
                    $i$a$-debug$default-ServiceMessageProcessor$resendUnconfirmedFrames$3 = false;
                    var27_12.debug(this.getName() + " Remote specified confirmation number in handshake: " + ((CurrentConfirmationFrame)counterpartReceivedFrame).getCounterpartFrameNumber(), t$iv);
                }
                this.checkRemoteFrameConfirmedNumber(((CurrentConfirmationFrame)counterpartReceivedFrame).getCounterpartFrameNumber());
                $this$withLock_u24default$iv = this.sendFramesMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = originalTransport;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)counterpartReceivedFrame);
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 2;
                v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v1 == var30_5) {
                    return var30_5;
                }
                ** GOTO lbl57
            }
            case 2: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                counterpartReceivedFrame = (SystemFrame)$continuation.L$1;
                originalTransport = (TransportInfo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl57:
                // 2 sources

                try {
                    $i$a$-withLock$default-ServiceMessageProcessor$resendUnconfirmedFrames$4 = false;
                    $this$forEachIndexed$iv = this.unconfirmedFrames;
                    $i$f$forEachIndexed = false;
                    index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        if ((var13_19 = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        var14_20 = (MessageFrame)item$iv;
                        index = var13_19;
                        $i$a$-forEachIndexed-ServiceMessageProcessor$resendUnconfirmedFrames$4$1 = false;
                        $this$debug_u24default$iv = ServiceMessageProcessorKt.access$getLogger$p();
                        t$iv = null;
                        $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            var20_28 = $this$debug_u24default$iv;
                            $i$a$-debug$default-ServiceMessageProcessor$resendUnconfirmedFrames$4$1$1 = false;
                            var20_28.debug(this.getName() + " Frame #" + (index + 1) + ". [ ] -> [" + this.logRemoteSide + "]: " + (MessageFrame)frame, t$iv);
                        }
                        if (!Intrinsics.areEqual((Object)this.myTransportInfo.get(), (Object)originalTransport) || !JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                            var26_34 = Unit.INSTANCE;
                            return var26_34;
                        }
                        $this$runAndLogException$iv = ServiceMessageProcessorKt.access$getLogger$p();
                        $i$f$runAndLogException = false;
                        var19_26 = $this$runAndLogException$iv;
                        try {
                            $this$runAndLogException_u24lambda_u240$iv = var19_26;
                            $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                            $i$a$-runAndLogException-ServiceMessageProcessor$resendUnconfirmedFrames$4$1$2 = false;
                            this.sendFrameToChannel((Frame)frame);
                            var21_29 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var22_32) {
                            var21_29 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var22_32));
                        }
                        LoggerKt.getOrLogException((Object)var21_29, (Logger)$this$runAndLogException$iv);
                    }
                    var24_35 = this.myTransportToFinishSendingMessages.compareAndExchange(originalTransport, null);
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void checkRemoteFrameConfirmedNumber(int remoteFrameConfirmedNumber) {
        while (!((Collection)this.unconfirmedFrames).isEmpty()) {
            Logger logger;
            boolean $i$f$trace;
            Logger $this$trace$iv;
            MessageFrame unconfirmedFrame = this.peekUnconfirmedFrame();
            if (unconfirmedFrame.getAck() == remoteFrameConfirmedNumber) {
                this.pollUnconfirmedFrame();
                break;
            }
            if (unconfirmedFrame.getAck() < remoteFrameConfirmedNumber) {
                $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace(this.getName() + " [" + this.logRemoteSide + "] -> [ ]. Received higher ack that exists in unconfirmed frames: <" + remoteFrameConfirmedNumber + ">. Client sent more messages. OK. Expected ack: <" + unconfirmedFrame.getAck() + ">, but got: <" + remoteFrameConfirmedNumber + ">");
                }
                this.pollUnconfirmedFrame();
                continue;
            }
            $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
            $i$f$trace = false;
            if (!$this$trace$iv.isTraceEnabled()) break;
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " [" + this.logRemoteSide + "] -> [ ]. Received outdated frame confirmation number: <" + remoteFrameConfirmedNumber + ">. Remote sent more messages. OK. Expected ack: <" + unconfirmedFrame.getAck() + ">, but got: <" + remoteFrameConfirmedNumber + ">");
            break;
        }
    }

    private final void addUnconfirmedFrame(MessageFrame frame) {
        Logger $this$trace$iv = ServiceMessageProcessorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " [ ] -> [Unconfirmed Frames]. " + frame);
        }
        this.unconfirmedFrames.offer(frame);
        this.myUnconfirmedFramesBufferSize.addAndGet(frame.getLength());
    }

    private final MessageFrame pollUnconfirmedFrame() {
        MessageFrame unconfirmedFrame = this.unconfirmedFrames.poll();
        this.myUnconfirmedFramesBufferSize.addAndGet(-((long)unconfirmedFrame.getLength()));
        Intrinsics.checkNotNull((Object)unconfirmedFrame);
        return unconfirmedFrame;
    }

    private final MessageFrame peekUnconfirmedFrame() {
        MessageFrame messageFrame = this.unconfirmedFrames.peek();
        Intrinsics.checkNotNullExpressionValue((Object)messageFrame, (String)"peek(...)");
        return messageFrame;
    }

    private final void resetTransport() {
        this.myTransportInfo.set(null);
        this.myTransportToFinishSendingMessages.set(null);
    }

    private static final Unit _init_$lambda$0(ServiceMessageProcessor this$0, Job it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this$0.sendMessageFrameChannel), null, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Channel access$getSendMessageFrameChannel$p(ServiceMessageProcessor $this) {
        return $this.sendMessageFrameChannel;
    }

    public static final /* synthetic */ AtomicInteger access$getAck$p(ServiceMessageProcessor $this) {
        return $this.ack;
    }

    public static final /* synthetic */ Mutex access$getSendFramesMutex$p(ServiceMessageProcessor $this) {
        return $this.sendFramesMutex;
    }

    public static final /* synthetic */ void access$addUnconfirmedFrame(ServiceMessageProcessor $this, MessageFrame frame) {
        $this.addUnconfirmedFrame(frame);
    }

    public static final /* synthetic */ AtomicReference access$getMyTransportInfo$p(ServiceMessageProcessor $this) {
        return $this.myTransportInfo;
    }

    public static final /* synthetic */ AtomicReference access$getMyTransportToFinishSendingMessages$p(ServiceMessageProcessor $this) {
        return $this.myTransportToFinishSendingMessages;
    }

    public static final /* synthetic */ void access$sendFrameToChannel(ServiceMessageProcessor $this, Frame frame) {
        $this.sendFrameToChannel(frame);
    }
}

