/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.platform.split.connection.protocol.channel.CompressingByteChannelKt;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J-\u0010%\u001a\u00020\u00182\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010*J\u001d\u0010%\u001a\u00020\u00182\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0'H\u0016\u00a2\u0006\u0002\u0010+J\u0012\u0010%\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010$H\u0016J\u001a\u0010-\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010.\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/CompressingByteChannel;", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/GatheringByteChannel;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "id", "", "underlying", "compressionLevel", "", "<init>", "(Ljava/lang/String;Ljava/nio/channels/ByteChannel;I)V", "inflateStream", "Ljava/util/zip/InflaterInputStream;", "deflater", "Ljava/util/zip/Deflater;", "deflateStream", "Ljava/util/zip/DeflaterOutputStream;", "readBuffer", "", "writeBuffer", "name", "getName", "()Ljava/lang/String;", "value", "", "rawBytesWritten", "getRawBytesWritten", "()J", "rawBytesRead", "getRawBytesRead", "close", "", "isOpen", "", "read", "dst", "Ljava/nio/ByteBuffer;", "write", "srcs", "", "offset", "length", "([Ljava/nio/ByteBuffer;II)J", "([Ljava/nio/ByteBuffer;)J", "src", "doWrite", "flush", "intellij.platform.split.connection"})
public final class CompressingByteChannel
implements ByteChannel,
GatheringByteChannel,
NamedTransportEntity {
    @NotNull
    private final String id;
    @NotNull
    private final ByteChannel underlying;
    @NotNull
    private final InflaterInputStream inflateStream;
    @NotNull
    private final Deflater deflater;
    @NotNull
    private final DeflaterOutputStream deflateStream;
    @NotNull
    private final byte[] readBuffer;
    @NotNull
    private final byte[] writeBuffer;
    @NotNull
    private final String name;
    private long rawBytesWritten;
    private long rawBytesRead;

    public CompressingByteChannel(@NotNull String id, @NotNull ByteChannel underlying, int compressionLevel) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        this.id = id;
        this.underlying = underlying;
        this.inflateStream = new InflaterInputStream(Channels.newInputStream(this.underlying), new Inflater(true), 65536);
        this.deflater = new Deflater(compressionLevel, true);
        this.deflateStream = new DeflaterOutputStream(Channels.newOutputStream(this.underlying), this.deflater, 65536, true);
        this.readBuffer = new byte[65536];
        this.writeBuffer = new byte[65536];
        this.name = "Compressing Channel (" + this.id + ")";
    }

    public /* synthetic */ CompressingByteChannel(String string, ByteChannel byteChannel, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(string, byteChannel, n);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final long getRawBytesWritten() {
        return this.rawBytesWritten;
    }

    public final long getRawBytesRead() {
        return this.rawBytesRead;
    }

    @Override
    public void close() {
        try {
            this.deflateStream.finish();
        }
        catch (IOException ex) {
            CompressingByteChannelKt.access$getLogger$p().debug(this.getName() + " failed on close with IO exception: " + ex.getMessage(), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                CompressingByteChannelKt.access$getLogger$p().debug(this.getName() + " failed on close the thread with error: " + ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
        this.deflater.end();
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public int read(@Nullable ByteBuffer dst) {
        try {
            if (dst == null) {
                return 0;
            }
            int maxRead = Math.min(dst.remaining(), this.readBuffer.length);
            int bytesRead = this.inflateStream.read(this.readBuffer, 0, maxRead);
            if (bytesRead >= 0) {
                dst.put(this.readBuffer, 0, bytesRead);
                this.rawBytesRead += (long)bytesRead;
            }
            return bytesRead;
        }
        catch (EOFException ex) {
            CompressingByteChannelKt.access$getLogger$p().debug(this.getName() + " Error on read: " + ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }

    @Override
    public long write(@NotNull ByteBuffer[] srcs, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
        long written = 0L;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            written += (long)this.doWrite(srcs[i], false);
            if (((Buffer)srcs[i]).hasRemaining()) break;
        }
        this.deflateStream.flush();
        return written;
    }

    @Override
    public long write(@NotNull ByteBuffer[] srcs) {
        Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        return this.doWrite(src, true);
    }

    private final int doWrite(ByteBuffer src, boolean flush) {
        if (src == null) {
            return 0;
        }
        int bytesToWrite = Math.min(src.remaining(), this.writeBuffer.length);
        src.get(this.writeBuffer, 0, bytesToWrite);
        this.deflateStream.write(this.writeBuffer, 0, bytesToWrite);
        this.rawBytesWritten += (long)bytesToWrite;
        if (flush) {
            this.deflateStream.flush();
        }
        return bytesToWrite;
    }
}

