/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.split.connection.impl.ConnectionFlowService;
import com.intellij.platform.split.connection.impl.config.ConnectionConfiguration;
import com.intellij.platform.split.connection.network.quic.QuicServerStreamTransport;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.intellij.platform.split.connection.protocol.channel.BufferedByteChannel;
import com.intellij.platform.split.connection.protocol.channel.CompressingByteChannel;
import com.intellij.platform.split.connection.protocol.channel.FramedByteChannel;
import com.intellij.platform.split.connection.protocol.channel.FramedByteChannelImpl;
import com.intellij.platform.split.connection.protocol.channel.InternalConnectionProxyChannel;
import com.intellij.platform.split.connection.protocol.channel.InternalConnectionProxyChannelImpl;
import com.intellij.platform.split.connection.protocol.channel.TelemetryByteChannel;
import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManager;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.transport.SocketStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.StatStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.platform.split.connection.protocol.transport.TlsStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapper;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapperImpl;
import com.intellij.platform.split.connection.protocol.transport.WebSocketStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.exception.TransportNotReadyException;
import com.intellij.platform.split.connection.protocol.transport.stats.TransportStatisticsData;
import com.intellij.platform.split.connection.protocol.transport.tls.TlsData;
import com.intellij.platform.split.connection.protocol.wire.TelemetryWireData;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.util.io.BlockingKt;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.ISourceCoroutineUtilKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.channels.ByteChannel;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 q2\u00020\u0001:\u0001qB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u00108\u001a\u000209H\u0096@\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020<H\u0096@\u00a2\u0006\u0002\u0010:J\b\u0010=\u001a\u000209H\u0016J\u0010\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@H\u0016J8\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020\u00032\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u000b0D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u0002090DH\u0016J$\u0010F\u001a\u0002092\u0006\u0010B\u001a\u00020\u00032\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u0002090DH\u0016J\n\u0010H\u001a\u0004\u0018\u00010IH\u0016J\b\u0010J\u001a\u00020\u000bH\u0016J\b\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020\u000bH\u0016J\b\u0010N\u001a\u00020OH\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020R0QH\u0016J\b\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020TH\u0016J\b\u0010V\u001a\u000209H\u0016J\u0010\u0010W\u001a\u0002092\u0006\u0010X\u001a\u00020\u000bH\u0017J\u0017\u0010Y\u001a\u0002092\u0006\u0010Z\u001a\u00020[H\u0017\u00a2\u0006\u0004\b\\\u0010]J\u0018\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020`2\u0006\u0010&\u001a\u00020'H\u0002J \u0010a\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020`2\u0006\u0010\n\u001a\u00020\u000bH\u0002J5\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010B\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u001f2\u0006\u0010c\u001a\u00020[H\u0002\u00a2\u0006\u0004\bd\u0010eJ \u0010f\u001a\u00020#2\u0006\u0010B\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020`H\u0002J\u0018\u0010g\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020#H\u0002J\b\u0010h\u001a\u000209H\u0002J\u000e\u0010i\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010:J\u0010\u0010j\u001a\u0002092\u0006\u0010B\u001a\u00020\u0003H\u0002J\b\u0010k\u001a\u000209H\u0002J)\u0010l\u001a\u0002092\u0006\u0010m\u001a\u00020\r2\b\u0010X\u001a\u0004\u0018\u0001052\u0006\u0010n\u001a\u00020[H\u0002\u00a2\u0006\u0004\bo\u0010pR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006r"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapperImpl;", "Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;", "outerLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "streamTransportLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "id", "", "tlsData", "Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;", "isServer", "", "underlyingTransport", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Ljava/lang/String;Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;ZLcom/intellij/platform/split/connection/protocol/transport/StreamTransport;)V", "name", "getName", "()Ljava/lang/String;", "myInnerTransportLifetimeDefinition", "transportLifetime", "getTransportLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "myUnderlyingTransport", "myTlsTransport", "Lcom/intellij/platform/split/connection/protocol/transport/TlsStreamTransport;", "myStatsTransport", "Lcom/intellij/platform/split/connection/protocol/transport/StatStreamTransport;", "myTelemetryChannel", "Lcom/intellij/platform/split/connection/protocol/channel/TelemetryByteChannel;", "myCompressingChannel", "Lcom/intellij/platform/split/connection/protocol/channel/CompressingByteChannel;", "myBufferedChannel", "Lcom/intellij/platform/split/connection/protocol/channel/BufferedByteChannel;", "myFramedByteChannel", "Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannel;", "myInternalConnectionProxyChannel", "Lcom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannel;", "telemetry", "Lcom/intellij/platform/split/connection/protocol/wire/TelemetryWireData;", "frameReceivedCounter", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/opentelemetry/api/metrics/LongCounter;", "frameSentCounter", "lenMeasurements", "Ljava/util/concurrent/atomic/AtomicInteger;", "sentFramesMeasurements", "isOpen", "()Z", "myConnectionState", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "connected", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/intellij/platform/split/connection/protocol/ConnectionState;", "getConnected", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "connect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "receiveSingleSystemFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;", "startProcessingCollectedEntries", "send", "frame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "onFrameReceived", "lifetime", "filter", "Lkotlin/Function1;", "handler", "onErrorReceived", "", "getRelayUri", "Ljava/net/URI;", "isHighPriorityTransport", "getTlsTrustManager", "Lcom/intellij/platform/split/connection/protocol/channel/certificate/RemoteTrustManager;", "isTlsTrusted", "getStats", "Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "getCounterPartCertificates", "", "Ljava/security/cert/X509Certificate;", "calculateTransmitCompressionRatio", "", "calculateReceiveCompressionRatio", "terminateTransport", "enableConnectionProxy", "state", "setTransportDelay", "delay", "Lkotlin/time/Duration;", "setTransportDelay-LRDsOJo", "(J)V", "initTelemetryByteChannel", "underlyingChannel", "Ljava/nio/channels/ByteChannel;", "initCompressionChannel", "initBufferedChannel", "mergingTimeSpan", "initBufferedChannel-Wn2Vu4Y", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Lcom/intellij/platform/split/connection/protocol/channel/CompressingByteChannel;J)Lcom/intellij/platform/split/connection/protocol/channel/BufferedByteChannel;", "initFramedByteChannel", "initConnectionConfigProxyChannel", "configureWrapperConnectionState", "connectImpl", "launchHealthCheck", "updateStatsSpeed", "checkTransportConnectedState", "transport", "timeout", "checkTransportConnectedState-SxA4cEA", "(Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;Lcom/intellij/platform/split/connection/protocol/ConnectionState;J)V", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTransportWrapperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportWrapperImpl.kt\ncom/intellij/platform/split/connection/protocol/transport/TransportWrapperImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ConnectionStateProperty.kt\ncom/intellij/platform/split/connection/protocol/ConnectionStateProperty\n*L\n1#1,553:1\n67#2,4:554\n67#2,4:558\n67#2,4:562\n67#2,4:566\n67#2,4:570\n67#2,4:574\n67#2,4:578\n60#2,5:582\n67#2,4:591\n60#2,5:595\n60#2,5:600\n60#2,5:605\n60#2,5:610\n67#2,4:615\n23#2:623\n51#3,4:587\n51#3,4:619\n*S KotlinDebug\n*F\n+ 1 TransportWrapperImpl.kt\ncom/intellij/platform/split/connection/protocol/transport/TransportWrapperImpl\n*L\n144#1:554,4\n153#1:558,4\n163#1:562,4\n170#1:566,4\n178#1:570,4\n187#1:574,4\n203#1:578,4\n215#1:582,5\n348#1:591,4\n465#1:595,5\n472#1:600,5\n475#1:605,5\n494#1:610,5\n502#1:615,4\n75#1:623\n219#1:587,4\n124#1:619,4\n*E\n"})
public final class TransportWrapperImpl
implements TransportWrapper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final TlsData tlsData;
    private final boolean isServer;
    @NotNull
    private final String name;
    @NotNull
    private final LifetimeDefinition myInnerTransportLifetimeDefinition;
    @NotNull
    private final StreamTransport myUnderlyingTransport;
    @NotNull
    private final TlsStreamTransport myTlsTransport;
    @NotNull
    private final StatStreamTransport myStatsTransport;
    @NotNull
    private final TelemetryByteChannel myTelemetryChannel;
    @NotNull
    private final CompressingByteChannel myCompressingChannel;
    @NotNull
    private final BufferedByteChannel<CompressingByteChannel> myBufferedChannel;
    @NotNull
    private final FramedByteChannel myFramedByteChannel;
    @NotNull
    private final InternalConnectionProxyChannel myInternalConnectionProxyChannel;
    @NotNull
    private final TelemetryWireData telemetry;
    @NotNull
    private final AtomicReference<LongCounter> frameReceivedCounter;
    @NotNull
    private final AtomicReference<LongCounter> frameSentCounter;
    @NotNull
    private AtomicInteger lenMeasurements;
    @NotNull
    private AtomicInteger sentFramesMeasurements;
    @NotNull
    private final ConnectionStateProperty myConnectionState;
    @NotNull
    private final IPropertyView<ConnectionState> connected;
    @NotNull
    private static final Logger logger;

    public TransportWrapperImpl(@NotNull Lifetime outerLifetime, @NotNull LifetimeDefinition streamTransportLifetimeDefinition, @NotNull String id, @NotNull TlsData tlsData, boolean isServer, @NotNull StreamTransport underlyingTransport) {
        TlsStreamTransport tlsStreamTransport;
        StatStreamTransport statsStreamTransport;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)outerLifetime, (String)"outerLifetime");
        Intrinsics.checkNotNullParameter((Object)streamTransportLifetimeDefinition, (String)"streamTransportLifetimeDefinition");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)tlsData, (String)"tlsData");
        Intrinsics.checkNotNullParameter((Object)underlyingTransport, (String)"underlyingTransport");
        this.id = id;
        this.tlsData = tlsData;
        this.isServer = isServer;
        this.name = "Transport Wrapper (id: " + this.id + ")";
        this.myInnerTransportLifetimeDefinition = outerLifetime.createNested();
        this.telemetry = new TelemetryWireData(TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT), this.id);
        this.frameReceivedCounter = new AtomicReference<Object>(null);
        this.frameSentCounter = new AtomicReference<Object>(null);
        this.lenMeasurements = new AtomicInteger(0);
        this.sentFramesMeasurements = new AtomicInteger(0);
        this.myConnectionState = new ConnectionStateProperty();
        this.connected = (IPropertyView)this.myConnectionState;
        Lifetime layerLifetime = streamTransportLifetimeDefinition.getLifetime();
        LifetimeExKt.onTerminationOrNow((Lifetime)this.getTransportLifetime(), () -> TransportWrapperImpl._init_$lambda$0(layerLifetime, streamTransportLifetimeDefinition));
        LifetimeExKt.onTerminationOrNow((Lifetime)this.getTransportLifetime(), () -> TransportWrapperImpl._init_$lambda$1(this));
        SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)layerLifetime, (arg_0, arg_1) -> TransportWrapperImpl._init_$lambda$2(this, arg_0, arg_1));
        this.myConnectionState.advise(layerLifetime, (Function1<? super ConnectionState, Unit>)((Function1)arg_0 -> TransportWrapperImpl._init_$lambda$3(this, arg_0)));
        TransportWrapperImpl.logger.info(this.getName() + " Attach channels for a transport: " + underlyingTransport.getName());
        this.myUnderlyingTransport = underlyingTransport;
        Logger $this$trace$iv = TransportWrapperImpl.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Define underlying layer - DONE");
        }
        this.myStatsTransport = statsStreamTransport = new StatStreamTransport(layerLifetime, this.id, underlyingTransport);
        Logger $this$trace$iv2 = TransportWrapperImpl.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap Stats layer - DONE");
        }
        this.myTlsTransport = tlsStreamTransport = new TlsStreamTransport(layerLifetime, this.id, statsStreamTransport, this.tlsData);
        Logger $this$trace$iv3 = TransportWrapperImpl.logger;
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap TLS layer - DONE");
        }
        this.myTelemetryChannel = this.initTelemetryByteChannel(tlsStreamTransport.getByteChannel(), this.telemetry);
        $this$trace$iv3 = TransportWrapperImpl.logger;
        $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap telemetry layer - DONE");
        }
        this.myCompressingChannel = this.initCompressionChannel(this.id, this.myTelemetryChannel, this.isServer);
        $this$trace$iv3 = TransportWrapperImpl.logger;
        $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap compression layer - DONE");
        }
        this.myBufferedChannel = this.initBufferedChannel-Wn2Vu4Y(layerLifetime, this.id, this.myCompressingChannel, DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MILLISECONDS));
        $this$trace$iv3 = TransportWrapperImpl.logger;
        $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap buffered layer - DONE");
        }
        this.myFramedByteChannel = this.initFramedByteChannel(layerLifetime, this.id, this.myBufferedChannel);
        this.myInternalConnectionProxyChannel = this.initConnectionConfigProxyChannel(this.id, this.myFramedByteChannel);
        $this$trace$iv3 = TransportWrapperImpl.logger;
        $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(this.getName() + " Wrap framed layer - DONE");
        }
        this.configureWrapperConnectionState();
        TransportWrapperImpl.logger.info(this.getName() + " Underlying transport is wrapped with all layers and ready");
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Lifetime getTransportLifetime() {
        return this.myInnerTransportLifetimeDefinition.getLifetime();
    }

    @Override
    public boolean isOpen() {
        return this.myUnderlyingTransport.getByteChannel().isOpen() && ConnectionState.Companion.isAlive(this.myConnectionState.getValue());
    }

    @Override
    @NotNull
    public IPropertyView<ConnectionState> getConnected() {
        return this.connected;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object connect(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof connect.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ TransportWrapperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connect((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$debug_u24default$iv = TransportWrapperImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var7_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TransportWrapperImpl$connect$2 = false;
                    var7_11.debug(this.getName() + " Start transport wrapper connection logic", t$iv);
                }
                $continuation.label = 1;
                v0 = this.connectImpl((Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_4) goto lbl26
lbl25:
                // 1 sources

                return var10_4;
lbl26:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable ex) {
                    t$iv = this.myConnectionState;
                    newValue$iv = new ConnectionState.FAULTED(ex);
                    $i$f$setIfNotTerminalAndRun = false;
                    if (this_$iv.setIfNotTerminal(newValue$iv)) {
                        $i$a$-setIfNotTerminalAndRun-TransportWrapperImpl$connect$3 = false;
                        TransportWrapperImpl.logger.info(this.getName() + " faulted during connection: " + ex);
                    }
                    throw ex;
                }
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object receiveSingleSystemFrame(@NotNull Continuation<? super SystemFrame> $completion) {
        return this.myInternalConnectionProxyChannel.receiveSingleSystemFrame($completion);
    }

    @Override
    public void startProcessingCollectedEntries() {
        this.myInternalConnectionProxyChannel.startProcessingCollectedEntries();
    }

    @Override
    public void send(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.myInternalConnectionProxyChannel.send(frame);
        this.sentFramesMeasurements.accumulateAndGet(frame.getLength(), Math::max);
    }

    @Override
    public void onFrameReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Frame, Boolean> filter2, @NotNull Function1<? super Frame, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        logger.info(this.getName() + " Advise on System frame received");
        this.myInternalConnectionProxyChannel.onFrameReceived(lifetime, filter2, handler);
    }

    @Override
    public void onErrorReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.myInternalConnectionProxyChannel.onErrorReceived(lifetime, handler);
    }

    @Override
    @Nullable
    public URI getRelayUri() {
        StreamTransport streamTransport = this.myUnderlyingTransport;
        WebSocketStreamTransport webSocketStreamTransport = streamTransport instanceof WebSocketStreamTransport ? (WebSocketStreamTransport)streamTransport : null;
        return webSocketStreamTransport != null ? webSocketStreamTransport.getUri() : null;
    }

    @Override
    public boolean isHighPriorityTransport() {
        return this.myUnderlyingTransport instanceof SocketStreamTransport || this.myUnderlyingTransport instanceof QuicServerStreamTransport;
    }

    @Override
    @NotNull
    public RemoteTrustManager getTlsTrustManager() {
        return this.tlsData.getTrustManager();
    }

    @Override
    public boolean isTlsTrusted() {
        Collection collection;
        return this.myTlsTransport.isTrusted() && !((collection = (Collection)this.tlsData.getCounterpartCertificates().get()) == null || collection.isEmpty());
    }

    @Override
    @NotNull
    public TransportStatisticsData getStats() {
        return this.myStatsTransport.getStats();
    }

    @Override
    @NotNull
    public List<X509Certificate> getCounterPartCertificates() {
        List<X509Certificate> counterpartCertificates = this.myTlsTransport.getTlsData().getCounterpartCertificates().get();
        if (counterpartCertificates == null) {
            boolean bl = false;
            String string = "Counterpart certificates are not defined. Make sure TLS handshake is succeeded.";
            throw new IllegalStateException(string.toString());
        }
        logger.info(this.getName() + " Got counterpart certificates size: <" + counterpartCertificates.size() + ">");
        return counterpartCertificates;
    }

    @Override
    public int calculateTransmitCompressionRatio() {
        return (int)(this.myStatsTransport.getStats().getTotalSend() * (long)100 / this.myCompressingChannel.getRawBytesWritten());
    }

    @Override
    public int calculateReceiveCompressionRatio() {
        return (int)(this.myStatsTransport.getStats().getTotalReceive() * (long)100 / this.myCompressingChannel.getRawBytesRead());
    }

    @Override
    public void terminateTransport() {
        logger.info(this.getName() + " Terminate transport. Underlying transport: " + this.myUnderlyingTransport.getName() + ", underlying channel: " + this.myUnderlyingTransport.getByteChannel());
        this.myConnectionState.setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.myInnerTransportLifetimeDefinition, (boolean)false, (int)1, null);
    }

    @Override
    @ApiStatus.Internal
    public void enableConnectionProxy(boolean state) {
        this.myInternalConnectionProxyChannel.enableConnectionProxy(state);
    }

    @Override
    @ApiStatus.Internal
    public void setTransportDelay-LRDsOJo(long delay) {
        this.myInternalConnectionProxyChannel.setDelay-BwNAW2A(Duration.box-impl((long)delay));
    }

    private final TelemetryByteChannel initTelemetryByteChannel(ByteChannel underlyingChannel, TelemetryWireData telemetry) {
        TelemetryByteChannel channel = new TelemetryByteChannel(underlyingChannel, telemetry);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Initialize Open Telemetry callbacks");
        }
        this.frameReceivedCounter.set(telemetry.getMeter().counterBuilder("rdct.TransportWrapperImpl.receivedFrames.project." + telemetry.getProjectId()).setUnit("1").build());
        this.frameSentCounter.set(telemetry.getMeter().counterBuilder("rdct.TransportWrapperImpl.sentFrames.project." + telemetry.getProjectId()).setUnit("1").build());
        ObservableLongGauge receivedFramesLenGauge = telemetry.getMeter().gaugeBuilder("rdct.TransportWrapperImpl.receivedFramesLenRate.project." + telemetry.getProjectId()).ofLongs().setUnit("framesLen").buildWithCallback(arg_0 -> TransportWrapperImpl.initTelemetryByteChannel$lambda$1(this, arg_0));
        ObservableLongGauge sentFramesLenGauge = telemetry.getMeter().gaugeBuilder("rdct.TransportWrapperImpl.sentFramesLenRate.project." + telemetry.getProjectId()).ofLongs().setUnit("framesLen").buildWithCallback(arg_0 -> TransportWrapperImpl.initTelemetryByteChannel$lambda$2(this, arg_0));
        ObservableLongGauge connectionStateGauge = telemetry.getMeter().gaugeBuilder("rdct.TransportWrapperImpl.connectionState.project." + telemetry.getProjectId()).ofLongs().setUnit("stateOrdinal").buildWithCallback(arg_0 -> TransportWrapperImpl.initTelemetryByteChannel$lambda$3(this, arg_0));
        this.getTransportLifetime().onTermination(() -> TransportWrapperImpl.initTelemetryByteChannel$lambda$4(receivedFramesLenGauge, sentFramesLenGauge, connectionStateGauge));
        return channel;
    }

    private final CompressingByteChannel initCompressionChannel(String id, ByteChannel underlyingChannel, boolean isServer) {
        return new CompressingByteChannel(id, underlyingChannel, isServer ? 4 : 1);
    }

    private final BufferedByteChannel<CompressingByteChannel> initBufferedChannel-Wn2Vu4Y(Lifetime lifetime, String id, CompressingByteChannel underlyingChannel, long mergingTimeSpan) {
        return new BufferedByteChannel<CompressingByteChannel>(lifetime, id, underlyingChannel, mergingTimeSpan, null);
    }

    private final FramedByteChannel initFramedByteChannel(Lifetime lifetime, String id, ByteChannel underlyingChannel) {
        FramedByteChannelImpl channel = new FramedByteChannelImpl(lifetime, id, underlyingChannel);
        FramedByteChannel.onFrameReceived$default(channel, lifetime, null, arg_0 -> TransportWrapperImpl.initFramedByteChannel$lambda$0(this, arg_0), 2, null);
        return channel;
    }

    private final InternalConnectionProxyChannel initConnectionConfigProxyChannel(String id, FramedByteChannel underlyingChannel) {
        return new InternalConnectionProxyChannelImpl(id, underlyingChannel);
    }

    private final void configureWrapperConnectionState() {
        this.myStatsTransport.getConnected().advise(this.getTransportLifetime(), arg_0 -> TransportWrapperImpl.configureWrapperConnectionState$lambda$0(this, arg_0));
        this.myTlsTransport.getConnected().advise(this.getTransportLifetime(), arg_0 -> TransportWrapperImpl.configureWrapperConnectionState$lambda$1(this, arg_0));
        this.myInternalConnectionProxyChannel.onErrorReceived(this.getTransportLifetime(), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> TransportWrapperImpl.configureWrapperConnectionState$lambda$2(this, arg_0)));
    }

    /*
     * Unable to fully structure code
     */
    private final Object connectImpl(Continuation<? super Unit> $completion) {
        if (!($completion instanceof connectImpl.1)) ** GOTO lbl-1000
        var12_2 = $completion;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransportWrapperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransportWrapperImpl.access$connectImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                transportReadyTimeoutMillis = ((Duration)ConnectionConfiguration.INSTANCE.getTransportReadyTimeout().getValue()).unbox-impl();
                $this$debug_u24default$iv = TransportWrapperImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var10_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TransportWrapperImpl$connectImpl$2 = false;
                    var10_11.debug(this.getName() + " Connecting underlying transport layer", t$iv);
                }
                $continuation.J$0 = transportReadyTimeoutMillis;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)transportReadyTimeoutMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ConnectionState>, Object>(this, null){
                    int label;
                    final /* synthetic */ TransportWrapperImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ISourceCoroutineUtilKt.nextValue((ISource)((ISource)TransportWrapperImpl.access$getMyUnderlyingTransport$p(this.this$0).getConnected()), connectImpl.nextTransportState.1::invokeSuspend$lambda$0, (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ConnectionState> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(ConnectionState it) {
                        return !Intrinsics.areEqual((Object)it, (Object)ConnectionState.NOT_CONNECTED.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                transportReadyTimeoutMillis = $continuation.J$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                nextTransportState = (ConnectionState)v0;
                this.checkTransportConnectedState-SxA4cEA(this.myUnderlyingTransport, nextTransportState, transportReadyTimeoutMillis);
                $this$debug_u24default$iv = TransportWrapperImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var10_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TransportWrapperImpl$connectImpl$3 = false;
                    var10_11.debug(this.getName() + " Underlying transport connected - DONE", t$iv);
                }
                $this$debug_u24default$iv = TransportWrapperImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var10_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TransportWrapperImpl$connectImpl$4 = false;
                    var10_11.debug(this.getName() + " Connecting TLS transport layer", t$iv);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)nextTransportState);
                $continuation.J$0 = transportReadyTimeoutMillis;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible((CoroutineContext)((CoroutineContext)ConnectionFlowService.Companion.getConnectionPool()), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, connectImpl$lambda$3(com.intellij.platform.split.connection.protocol.transport.TransportWrapperImpl ), ()Lkotlin/Unit;)((TransportWrapperImpl)this), (Continuation)$continuation);
                if (v1 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl61
            }
            case 2: {
                transportReadyTimeoutMillis = $continuation.J$0;
                nextTransportState = (ConnectionState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl61:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)nextTransportState);
                $continuation.J$0 = transportReadyTimeoutMillis;
                $continuation.label = 3;
                v2 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)transportReadyTimeoutMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ConnectionState>, Object>(this, null){
                    int label;
                    final /* synthetic */ TransportWrapperImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ISourceCoroutineUtilKt.nextValue((ISource)((ISource)TransportWrapperImpl.access$getMyTlsTransport$p(this.this$0).getConnected()), connectImpl.nextTlsState.1::invokeSuspend$lambda$0, (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ConnectionState> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(ConnectionState it) {
                        return !Intrinsics.areEqual((Object)it, (Object)ConnectionState.NOT_CONNECTED.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl73
            }
            case 3: {
                transportReadyTimeoutMillis = $continuation.J$0;
                nextTransportState = (ConnectionState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl73:
                // 2 sources

                nextTlsState = (ConnectionState)v2;
                this.checkTransportConnectedState-SxA4cEA(this.myTlsTransport, nextTlsState, transportReadyTimeoutMillis);
                if (!this.isTlsTrusted()) {
                    throw new TransportNotReadyException(this.getName() + " TLS transport (" + this.myTlsTransport.getName() + ") is not trusted", null, 2, null);
                }
                if (!Intrinsics.areEqual((Object)this.myConnectionState.getValue(), (Object)ConnectionState.CONNECTED.INSTANCE)) {
                    throw new TransportNotReadyException(this.getName() + " is not connected despite underlying TLS transport being connected: " + this.myConnectionState.getValue(), null, 2, null);
                }
                $this$debug_u24default$iv = TransportWrapperImpl.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var10_11 = $this$debug_u24default$iv;
                    $i$a$-debug$default-TransportWrapperImpl$connectImpl$6 = false;
                    var10_11.debug(this.getName() + " TLS transport connected - DONE", t$iv);
                }
                this.myStatsTransport.enableBytesTransferCheck-HG0u8IE(this.getTransportLifetime(), ((Duration)ConnectionConfiguration.INSTANCE.getConnectionIdleTimeout().getValue()).unbox-impl());
                $this$trace$iv = TransportWrapperImpl.logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var10_11 = $this$trace$iv;
                    $i$a$-trace-TransportWrapperImpl$connectImpl$7 = false;
                    var10_11.trace(this.getName() + " Start Receiving from an underlying channel");
                }
                this.myInternalConnectionProxyChannel.startReceivingFromByteChannel();
                this.launchHealthCheck(this.getTransportLifetime());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void launchHealthCheck(Lifetime lifetime) {
        long delayToUse = ((Duration)ConnectionConfiguration.INSTANCE.getPingsInterval().getValue()).unbox-impl();
        LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, (CoroutineContext)BlockingKt.getBlockingDispatcher().plus((CoroutineContext)new CoroutineName("Transport pings: " + this.getName())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delayToUse, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TransportWrapperImpl this$0;
            final /* synthetic */ long $delayToUse;
            {
                this.this$0 = $receiver;
                this.$delayToUse = $delayToUse;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            var3_4 = TransportWrapperImpl.access$getLogger$cp();
                            var4_5 = this.this$0;
                            $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                var7_8 = $this$trace$iv;
                                $i$a$-trace-TransportWrapperImpl$launchHealthCheck$1$1 = false;
                                var7_8.trace(var4_5.getName() + " Ping sent");
                            }
                            this.this$0.send(FrameFactory.INSTANCE.getPING_FRAME());
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)this.$delayToUse, (Continuation)((Continuation)this));
                            if (v0 != var8_3) continue;
                            return var8_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, delayToUse, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TransportWrapperImpl this$0;
            final /* synthetic */ long $delayToUse;
            {
                this.this$0 = $receiver;
                this.$delayToUse = $delayToUse;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            TransportWrapperImpl.access$updateStatsSpeed(this.this$0);
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)this.$delayToUse, (Continuation)((Continuation)this));
                            if (v0 != var3_3) continue;
                            return var3_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void updateStatsSpeed() {
        this.myStatsTransport.getStats().updateSpeeds();
    }

    private final void checkTransportConnectedState-SxA4cEA(StreamTransport transport, ConnectionState state, long timeout) {
        if (state == null) {
            throw new TransportNotReadyException("Transport (" + transport.getName() + ") is not connected after: " + Duration.toString-impl((long)timeout), null, 2, null);
        }
        if (!Intrinsics.areEqual((Object)state, (Object)ConnectionState.CONNECTED.INSTANCE)) {
            ConnectionState connectionState = state;
            ConnectionState.FAULTED fAULTED = connectionState instanceof ConnectionState.FAULTED ? (ConnectionState.FAULTED)connectionState : null;
            throw new TransportNotReadyException("Transport (" + transport.getName() + ") connection not succeeded. Expected to get transport connected, but got state: <" + state + ">. Error: " + (fAULTED != null ? fAULTED.getThrowable() : null), null, 2, null);
        }
    }

    private static final Unit lambda$0$0(LifetimeDefinition $streamTransportLifetimeDefinition, Throwable it) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)$streamTransportLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(Lifetime $layerLifetime, LifetimeDefinition $streamTransportLifetimeDefinition) {
        LifetimeCoroutineUtilKt.launch$default((Lifetime)$layerLifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DelayKt.delay-VtjQ1oo((long)((Duration)ConnectionConfiguration.INSTANCE.getTransportLifetimeTerminationDelay().getValue()).unbox-impl(), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null).invokeOnCompletion(arg_0 -> TransportWrapperImpl.lambda$0$0($streamTransportLifetimeDefinition, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$1(TransportWrapperImpl this$0) {
        void this_$iv;
        ConnectionStateProperty connectionStateProperty = this$0.myConnectionState;
        ConnectionState newValue$iv = ConnectionState.CLOSED.INSTANCE;
        boolean $i$f$setIfNotTerminalAndRun = false;
        if (this_$iv.setIfNotTerminal(newValue$iv)) {
            boolean bl = false;
            logger.warn(this$0.getName() + " Closed via external lifetime termination and transitioned to a terminal state while transport lifetime is being terminated");
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TransportWrapperImpl this$0, Maybe previous, ConnectionState current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        logger.info(this$0.getName() + " Connection state has been changed: <" + previous.getAsNullable() + "> -> <" + current + ">");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(TransportWrapperImpl this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ConnectionState.Companion.isAlive(state)) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this$0.myInnerTransportLifetimeDefinition, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void initTelemetryByteChannel$lambda$1(TransportWrapperImpl this$0, ObservableLongMeasurement it) {
        it.record((long)this$0.lenMeasurements.getAndSet(0));
    }

    private static final void initTelemetryByteChannel$lambda$2(TransportWrapperImpl this$0, ObservableLongMeasurement it) {
        it.record((long)this$0.sentFramesMeasurements.getAndSet(0));
    }

    private static final void initTelemetryByteChannel$lambda$3(TransportWrapperImpl this$0, ObservableLongMeasurement it) {
        it.record((long)((ConnectionState)this$0.getConnected().getValue()).getOrdinal());
    }

    private static final Unit initTelemetryByteChannel$lambda$4(ObservableLongGauge $receivedFramesLenGauge, ObservableLongGauge $sentFramesLenGauge, ObservableLongGauge $connectionStateGauge) {
        $receivedFramesLenGauge.close();
        $sentFramesLenGauge.close();
        $connectionStateGauge.close();
        return Unit.INSTANCE;
    }

    private static final Unit initFramedByteChannel$lambda$0(TransportWrapperImpl this$0, Frame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this$0.lenMeasurements.accumulateAndGet(frame.getLength(), Math::max);
            LongCounter longCounter = this$0.frameReceivedCounter.get();
            if (longCounter == null) break block0;
            longCounter.add(1L);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureWrapperConnectionState$lambda$0(TransportWrapperImpl this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ConnectionState.Companion.isAlive(state)) {
            logger.info(this$0.getName() + " Received state from Stats layer. Update to: <" + state + ">");
            this$0.myConnectionState.setIfNotTerminal(state);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureWrapperConnectionState$lambda$1(TransportWrapperImpl this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        logger.info(this$0.getName() + " Received state from TLS layer. Update to: <" + state + ">");
        this$0.myConnectionState.setIfNotTerminal(state);
        return Unit.INSTANCE;
    }

    private static final Unit configureWrapperConnectionState$lambda$2(TransportWrapperImpl this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        logger.info(this$0.getName() + " Received <FAULTED> state from Framed later. Error message: " + throwable.getMessage());
        this$0.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(throwable));
        return Unit.INSTANCE;
    }

    private static final Unit connectImpl$lambda$3(TransportWrapperImpl this$0) {
        this$0.myTlsTransport.connect();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$connectImpl(TransportWrapperImpl $this, Continuation $completion) {
        return $this.connectImpl((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ StreamTransport access$getMyUnderlyingTransport$p(TransportWrapperImpl $this) {
        return $this.myUnderlyingTransport;
    }

    public static final /* synthetic */ TlsStreamTransport access$getMyTlsTransport$p(TransportWrapperImpl $this) {
        return $this.myTlsTransport;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$updateStatsSpeed(TransportWrapperImpl $this) {
        $this.updateStatsSpeed();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TransportWrapperImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapperImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

