/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.impl.ConnectionFlowService;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.platform.split.connection.protocol.transport.WebSocketStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.WebSocketStreamTransportKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.util.NetworkUtils;
import com.jetbrains.rd.platform.util.NetworkUtilsKt;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.io.IOException;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import tlschannel.impl.ByteBufferSet;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/WebSocketStreamTransport;", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "id", "", "uri", "Ljava/net/URI;", "httpHeaders", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/net/URI;Ljava/util/Map;)V", "getUri", "()Ljava/net/URI;", "name", "getName", "()Ljava/lang/String;", "connected", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "getConnected", "()Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "inputQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "ws", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/http/WebSocket;", "getWs", "()Ljava/util/concurrent/CompletableFuture;", "myWebSocketChannel", "Ljava/nio/channels/ByteChannel;", "byteChannel", "getByteChannel", "()Ljava/nio/channels/ByteChannel;", "closeWebSocket", "", "onAbort", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nWebSocketStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/WebSocketStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,234:1\n67#2,4:235\n67#2,4:239\n*S KotlinDebug\n*F\n+ 1 WebSocketStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/WebSocketStreamTransport\n*L\n203#1:235,4\n207#1:239,4\n*E\n"})
public final class WebSocketStreamTransport
implements StreamTransport {
    @NotNull
    private final URI uri;
    @NotNull
    private final String name;
    @NotNull
    private final ConnectionStateProperty connected;
    @NotNull
    private final LinkedBlockingDeque<byte[]> inputQueue;
    @NotNull
    private final CompletableFuture<WebSocket> ws;
    @NotNull
    private final ByteChannel myWebSocketChannel;
    @NotNull
    private final ByteChannel byteChannel;

    /*
     * WARNING - void declaration
     */
    public WebSocketStreamTransport(@NotNull Lifetime lifetime, @NotNull String id, @NotNull URI uri, @NotNull Map<String, String> httpHeaders) {
        void $this$ws_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
        this.uri = uri;
        this.name = "Web Socket Transport (id: " + id + ")";
        this.connected = new ConnectionStateProperty();
        this.inputQueue = new LinkedBlockingDeque();
        WebSocketStreamTransport webSocketStreamTransport = this;
        WebSocketStreamTransport webSocketStreamTransport2 = this;
        boolean bl = false;
        WebSocket.Builder wsBuilder = NetworkUtils.INSTANCE.createWebSocketBuilderWithRequiredHeaders(httpHeaders);
        CompletableFuture<WebSocket> completableFuture = wsBuilder.buildAsync($this$ws_u24lambda_u240.uri, new WebSocket.Listener((WebSocketStreamTransport)$this$ws_u24lambda_u240, id){
            final /* synthetic */ WebSocketStreamTransport $this_run;
            final /* synthetic */ String $id;
            {
                this.$this_run = $this_run;
                this.$id = $id;
            }

            public void onOpen(WebSocket webSocket) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                WebSocketStreamTransportKt.access$getLogger$p().info(this.$this_run.getName() + " Connected at " + this.$this_run.getUri());
                this.$this_run.getConnected().set(ConnectionState.CONNECTED.INSTANCE);
                WebSocket.Listener.super.onOpen(webSocket);
            }

            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                String error = this.$this_run.getName() + " Received string message in " + this.getClass().getSimpleName() + ". String messages are not supported and will be ignored";
                if (ApplicationKt.getApplication().isEAP() || ApplicationKt.getApplication().isInternal() || ApplicationKt.getApplication().isUnitTestMode()) {
                    WebSocketStreamTransportKt.access$getLogger$p().error(error);
                } else {
                    WebSocketStreamTransportKt.access$getLogger$p().warn(error);
                }
                return WebSocket.Listener.super.onText(webSocket, data, last);
            }

            /*
             * WARNING - void declaration
             */
            public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
                void $this$trace$iv;
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                int remaining = data.remaining();
                Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                WebSocketStreamTransport webSocketStreamTransport = this.$this_run;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var9_8 = $this$trace$iv;
                    boolean bl = false;
                    var9_8.trace(webSocketStreamTransport.getName() + " Received message, size = " + remaining);
                }
                byte[] arr = new byte[remaining];
                data.get(arr);
                WebSocketStreamTransport.access$getInputQueue$p(this.$this_run).put(arr);
                return WebSocket.Listener.super.onBinary(webSocket, data, last);
            }

            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                WebSocketStreamTransportKt.access$getLogger$p().info(this.$this_run.getName() + " Disconnected, code: " + statusCode + ", reason: " + reason);
                this.$this_run.getConnected().set(ConnectionState.CLOSED.INSTANCE);
                return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
            }

            /*
             * WARNING - void declaration
             */
            public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
                void $this$trace$iv;
                Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                WebSocketStreamTransport webSocketStreamTransport = this.$this_run;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var7_6 = $this$trace$iv;
                    boolean bl = false;
                    var7_6.trace(webSocketStreamTransport.getName() + " Received PING. message: " + message);
                }
                CompletionStage<?> completionStage = WebSocket.Listener.super.onPing(webSocket, message);
                Intrinsics.checkNotNullExpressionValue(completionStage, (String)"onPing(...)");
                return completionStage;
            }

            /*
             * WARNING - void declaration
             */
            public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
                void $this$trace$iv;
                Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                WebSocketStreamTransport webSocketStreamTransport = this.$this_run;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var7_6 = $this$trace$iv;
                    boolean bl = false;
                    var7_6.trace(webSocketStreamTransport.getName() + " Received PONG. message: " + message);
                }
                CompletionStage<?> completionStage = WebSocket.Listener.super.onPong(webSocket, message);
                Intrinsics.checkNotNullExpressionValue(completionStage, (String)"onPong(...)");
                return completionStage;
            }

            public void onError(WebSocket webSocket, Throwable ex) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Throwable throwable = ex;
                WebSocketStreamTransportKt.access$getLogger$p().error(this.$this_run.getName() + " Error processing in WebSocket: " + (throwable != null ? throwable.getMessage() : null), ex);
                Throwable throwable2 = ex;
                this.$this_run.getConnected().set(new ConnectionState.FAULTED(new IOException("Error processing in WebSocket " + this.$id + ": " + (throwable2 != null ? throwable2.getMessage() : null), ex)));
                WebSocket.Listener.super.onError(webSocket, ex);
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"run(...)");
        webSocketStreamTransport2.ws = completableFuture;
        this.byteChannel = this.myWebSocketChannel = (ByteChannel)new ByteChannel(this){
            final /* synthetic */ WebSocketStreamTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isOpen() {
                return Intrinsics.areEqual((Object)this.this$0.getConnected().getValue(), (Object)ConnectionState.CONNECTED.INSTANCE);
            }

            public long write(ByteBuffer[] srcs, int offset, int length) {
                Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
                ByteBufferSet bufferSet = new ByteBufferSet(srcs, offset, length);
                if (bufferSet.hasRemaining()) {
                    boolean bl;
                    int total = (int)bufferSet.remaining();
                    ByteBuffer buf = ByteBuffer.allocate(total);
                    int copied = bufferSet.getRemaining(buf);
                    boolean bl2 = bl = copied == total;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    buf.rewind();
                    Intrinsics.checkNotNull((Object)buf);
                    this.send(buf);
                    return total;
                }
                return 0L;
            }

            public long write(ByteBuffer[] srcs) {
                Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
                return this.write(srcs, 0, srcs.length);
            }

            /*
             * WARNING - void declaration
             */
            public int write(ByteBuffer src) {
                void $this$trace$iv;
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                WebSocketStreamTransport webSocketStreamTransport = this.this$0;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var6_6 = $this$trace$iv;
                    boolean bl = false;
                    var6_6.trace(webSocketStreamTransport.getName() + " Sending message, size = " + src.remaining());
                }
                int length = src.remaining();
                this.send(src);
                return length;
            }

            public void close() {
                NetworkUtilsKt.closeNormal-BZiP2OM$default(this.this$0.getWs(), (CoroutineScope)ConnectionFlowService.Companion.getInstance().getCoroutineScope(), null, () -> myWebSocketChannel.1.close$lambda$1(this), (Function0)((Function0)new Function0<Unit>((Object)this.this$0){

                    public final void invoke() {
                        WebSocketStreamTransport.access$onAbort((WebSocketStreamTransport)this.receiver);
                    }
                }), (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            public int read(ByteBuffer dst) {
                Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                while (Intrinsics.areEqual((Object)this.this$0.getConnected().getValue(), (Object)ConnectionState.CONNECTED.INSTANCE)) {
                    byte[] buffer = (byte[])WebSocketStreamTransport.access$getInputQueue$p(this.this$0).poll(100L, TimeUnit.MILLISECONDS);
                    if (buffer == null) {
                        void $this$trace$iv;
                        Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                        WebSocketStreamTransport webSocketStreamTransport = this.this$0;
                        boolean $i$f$trace = false;
                        if (!$this$trace$iv.isTraceEnabled()) continue;
                        void var7_8 = $this$trace$iv;
                        boolean bl = false;
                        var7_8.trace(webSocketStreamTransport.getName() + " Waiting on read");
                        continue;
                    }
                    int available = dst.remaining();
                    if (available >= buffer.length) {
                        dst.put(buffer);
                        return buffer.length;
                    }
                    dst.put(ArraysKt.sliceArray((byte[])buffer, (IntRange)RangesKt.until((int)0, (int)available)));
                    WebSocketStreamTransport.access$getInputQueue$p(this.this$0).addFirst(ArraysKt.sliceArray((byte[])buffer, (IntRange)RangesKt.until((int)available, (int)buffer.length)));
                    return available;
                }
                WebSocketStreamTransportKt.access$getLogger$p().info(this.this$0.getName() + " Finished reading. connected state: " + this.this$0.getConnected().getValue());
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            private final void send(ByteBuffer buf) {
                try {
                    CompletableFuture<WebSocket> future = this.this$0.getWs().get().sendBinary(buf, true);
                    future.get();
                }
                catch (IOException t) {
                    void $this$trace$iv;
                    Logger logger = WebSocketStreamTransportKt.access$getLogger$p();
                    WebSocketStreamTransport webSocketStreamTransport = this.this$0;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        void var8_8 = $this$trace$iv;
                        boolean bl = false;
                        var8_8.trace(webSocketStreamTransport.getName() + " Throws IO exception on send: " + t.getMessage() + ". Ignore.");
                    }
                    this.this$0.getConnected().set(new ConnectionState.FAULTED(t));
                    throw t;
                }
                catch (Throwable t) {
                    this.this$0.getConnected().set(new ConnectionState.FAULTED(t));
                    throw t;
                }
            }

            private static final boolean close$lambda$1(myWebSocketChannel.1 this$0) {
                return !this$0.isOpen();
            }
        };
        WebSocketStreamTransportKt.access$getLogger$p().info(this.getName() + " Connecting to " + this.uri);
        SourceExKt.adviseWithPrev((ISource)((ISource)this.getConnected()), (Lifetime)lifetime, (arg_0, arg_1) -> WebSocketStreamTransport._init_$lambda$0(this, arg_0, arg_1));
        this.getConnected().advise(lifetime, (Function1<? super ConnectionState, Unit>)((Function1)arg_0 -> WebSocketStreamTransport._init_$lambda$1(this, arg_0)));
        this.ws.handleAsync((arg_0, arg_1) -> WebSocketStreamTransport._init_$lambda$3((arg_0, arg_1) -> WebSocketStreamTransport._init_$lambda$2(this, arg_0, arg_1), arg_0, arg_1));
        lifetime.onTermination(() -> WebSocketStreamTransport._init_$lambda$4(this));
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ConnectionStateProperty getConnected() {
        return this.connected;
    }

    @NotNull
    public final CompletableFuture<WebSocket> getWs() {
        return this.ws;
    }

    @Override
    @NotNull
    public ByteChannel getByteChannel() {
        return this.byteChannel;
    }

    private final void closeWebSocket() {
        WebSocketStreamTransportKt.access$getLogger$p().info(this.getName() + " Closing web socket");
        NetworkUtilsKt.closeNormal-BZiP2OM$default(this.ws, (CoroutineScope)ConnectionFlowService.Companion.getInstance().getCoroutineScope(), null, () -> WebSocketStreamTransport.closeWebSocket$lambda$0(this), (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                WebSocketStreamTransport.access$onAbort((WebSocketStreamTransport)this.receiver);
            }
        }), (int)2, null);
    }

    private final void onAbort() {
        WebSocketStreamTransportKt.access$getLogger$p().info(this.getName() + " Web Socket is aborted. Set connection state CLOSED if not terminal. Current state: <" + this.getConnected().getValue() + ">");
        this.getConnected().set(ConnectionState.CLOSED.INSTANCE);
    }

    private static final Unit _init_$lambda$0(WebSocketStreamTransport this$0, Maybe previous, ConnectionState current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        WebSocketStreamTransportKt.access$getLogger$p().info(this$0.connectionStateChangedToString((ConnectionState)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(WebSocketStreamTransport this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ConnectionState.Companion.isAlive(state)) {
            this$0.closeWebSocket();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(WebSocketStreamTransport this$0, WebSocket socket, Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (exception != null) {
            Logger $this$trace$iv = WebSocketStreamTransportKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this$0.getName() + " Got exception on transport web socket: " + exception.getMessage());
            }
            this$0.getConnected().set(new ConnectionState.FAULTED(new IllegalStateException("Unable to connect to " + this$0.uri + ": " + exception.getMessage(), exception)));
        } else {
            Logger $this$trace$iv = WebSocketStreamTransportKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this$0.getName() + " Created for " + this$0.uri);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit _init_$lambda$4(WebSocketStreamTransport this$0) {
        this$0.closeWebSocket();
        return Unit.INSTANCE;
    }

    private static final boolean closeWebSocket$lambda$0(WebSocketStreamTransport this$0) {
        return !ConnectionState.Companion.isAlive(this$0.getConnected().getValue());
    }

    public static final /* synthetic */ void access$onAbort(WebSocketStreamTransport $this) {
        $this.onAbort();
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getInputQueue$p(WebSocketStreamTransport $this) {
        return $this.inputQueue;
    }
}

