/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConsoleViewContentType {
    private static final Logger LOG = Logger.getInstance(ConsoleViewContentType.class);
    private final String myName;
    private final TextAttributes myTextAttributes;
    private final TextAttributesKey myTextAttributesKey;
    private static final Map<Key<?>, ConsoleViewContentType> ourRegisteredTypes = new HashMap();
    public static final ColorKey CONSOLE_BACKGROUND_KEY = ColorKey.createColorKey((String)"CONSOLE_BACKGROUND_KEY");
    public static final TextAttributesKey LOG_DEBUG_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"LOG_DEBUG_OUTPUT");
    public static final TextAttributesKey LOG_VERBOSE_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"LOG_VERBOSE_OUTPUT");
    public static final TextAttributesKey LOG_INFO_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"LOG_INFO_OUTPUT");
    public static final TextAttributesKey LOG_WARNING_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"LOG_WARNING_OUTPUT");
    public static final TextAttributesKey LOG_ERROR_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"LOG_ERROR_OUTPUT");
    public static final TextAttributesKey LOG_EXPIRED_ENTRY = TextAttributesKey.createTextAttributesKey((String)"LOG_EXPIRED_ENTRY");
    public static final TextAttributesKey NORMAL_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"CONSOLE_NORMAL_OUTPUT");
    public static final TextAttributesKey ERROR_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"CONSOLE_ERROR_OUTPUT");
    public static final TextAttributesKey USER_INPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"CONSOLE_USER_INPUT");
    public static final TextAttributesKey SYSTEM_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey((String)"CONSOLE_SYSTEM_OUTPUT");
    public static final ConsoleViewContentType LOG_DEBUG_OUTPUT = new ConsoleViewContentType("LOG_DEBUG_OUTPUT", LOG_DEBUG_OUTPUT_KEY);
    public static final ConsoleViewContentType LOG_VERBOSE_OUTPUT = new ConsoleViewContentType("LOG_VERBOSE_OUTPUT", LOG_VERBOSE_OUTPUT_KEY);
    public static final ConsoleViewContentType LOG_INFO_OUTPUT = new ConsoleViewContentType("LOG_INFO_OUTPUT", LOG_INFO_OUTPUT_KEY);
    public static final ConsoleViewContentType LOG_WARNING_OUTPUT = new ConsoleViewContentType("LOG_WARNING_OUTPUT", LOG_WARNING_OUTPUT_KEY);
    public static final ConsoleViewContentType LOG_ERROR_OUTPUT = new ConsoleViewContentType("LOG_ERROR_OUTPUT", LOG_ERROR_OUTPUT_KEY);
    public static final ConsoleViewContentType NORMAL_OUTPUT = new ConsoleViewContentType("NORMAL_OUTPUT", NORMAL_OUTPUT_KEY);
    public static final ConsoleViewContentType ERROR_OUTPUT = new ConsoleViewContentType("ERROR_OUTPUT", ERROR_OUTPUT_KEY);
    public static final ConsoleViewContentType SYSTEM_OUTPUT = new ConsoleViewContentType("SYSTEM_OUTPUT", SYSTEM_OUTPUT_KEY);
    public static final ConsoleViewContentType USER_INPUT = new ConsoleViewContentType("USER_INPUT", USER_INPUT_KEY);
    public static final ConsoleViewContentType[] OUTPUT_TYPES = new ConsoleViewContentType[]{NORMAL_OUTPUT, ERROR_OUTPUT, USER_INPUT, SYSTEM_OUTPUT};

    public ConsoleViewContentType(@NonNls String name, TextAttributes textAttributes) {
        this.myName = name;
        this.myTextAttributes = textAttributes;
        this.myTextAttributesKey = null;
    }

    public ConsoleViewContentType(@NonNls String name, TextAttributesKey textAttributesKey) {
        this.myName = name;
        this.myTextAttributes = null;
        this.myTextAttributesKey = textAttributesKey;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.myName;
    }

    public TextAttributes getAttributes() {
        if (this.myTextAttributesKey != null) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myTextAttributesKey);
        }
        return this.myTextAttributes;
    }

    @Nullable
    public TextAttributesKey getAttributesKey() {
        return this.myTextAttributesKey;
    }

    @NotNull
    public static ConsoleViewContentType registerNewConsoleViewType(@NotNull Key<?> key, @NotNull TextAttributesKey attributesKey) {
        if (key == null) {
            ConsoleViewContentType.$$$reportNull$$$0(0);
        }
        if (attributesKey == null) {
            ConsoleViewContentType.$$$reportNull$$$0(1);
        }
        ConsoleViewContentType type = new ConsoleViewContentType(key.toString(), attributesKey);
        ConsoleViewContentType.registerNewConsoleViewType(key, type);
        ConsoleViewContentType consoleViewContentType = type;
        if (consoleViewContentType == null) {
            ConsoleViewContentType.$$$reportNull$$$0(2);
        }
        return consoleViewContentType;
    }

    public static synchronized void registerNewConsoleViewType(@NotNull Key<?> processOutputType, @NotNull ConsoleViewContentType attributes) {
        if (processOutputType == null) {
            ConsoleViewContentType.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            ConsoleViewContentType.$$$reportNull$$$0(4);
        }
        ourRegisteredTypes.put(processOutputType, attributes);
    }

    @NotNull
    public static synchronized ConsoleViewContentType getConsoleViewType(@NotNull Key<?> processOutputType) {
        ConsoleViewContentType type;
        if (processOutputType == null) {
            ConsoleViewContentType.$$$reportNull$$$0(5);
        }
        if ((type = ourRegisteredTypes.get(processOutputType)) != null) {
            ConsoleViewContentType consoleViewContentType = type;
            if (consoleViewContentType == null) {
                ConsoleViewContentType.$$$reportNull$$$0(6);
            }
            return consoleViewContentType;
        }
        LOG.warn("Unregistered " + processOutputType.getClass().getName() + ": " + String.valueOf(processOutputType));
        ConsoleViewContentType consoleViewContentType = SYSTEM_OUTPUT;
        if (consoleViewContentType == null) {
            ConsoleViewContentType.$$$reportNull$$$0(7);
        }
        return consoleViewContentType;
    }

    @NotNull
    public static synchronized @Unmodifiable Collection<ConsoleViewContentType> getRegisteredTypes() {
        Collection<ConsoleViewContentType> collection = ourRegisteredTypes.values();
        if (collection == null) {
            ConsoleViewContentType.$$$reportNull$$$0(8);
        }
        return collection;
    }

    static {
        ourRegisteredTypes.put(ProcessOutputTypes.SYSTEM, SYSTEM_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDOUT, NORMAL_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDERR, ERROR_OUTPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/ConsoleViewContentType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/ConsoleViewContentType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerNewConsoleViewType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleViewType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerNewConsoleViewType";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleViewType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

