/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SyntheticPsiFileSupport {
    private static final Key<Boolean> KEY = Key.create((String)"OutsidersPsiFileSupport");
    private static final Key<String> VFS_URL_KEY = Key.create((String)"OutsidersPsiFileSupport.FilePath");

    public static void markFile(@NotNull VirtualFile file) {
        if (file == null) {
            SyntheticPsiFileSupport.$$$reportNull$$$0(0);
        }
        SyntheticPsiFileSupport.markFileWithUrl(file, null);
    }

    public static void markFile(@NotNull VirtualFile file, @Nullable String originalPath) {
        if (file == null) {
            SyntheticPsiFileSupport.$$$reportNull$$$0(1);
        }
        String vfsUrl = originalPath != null ? VirtualFileManager.constructUrl((String)"file", (String)originalPath) : null;
        SyntheticPsiFileSupport.markFileWithUrl(file, vfsUrl);
    }

    public static void markFileWithUrl(@NotNull VirtualFile file, @Nullable String originalVfsUrl) {
        if (file == null) {
            SyntheticPsiFileSupport.$$$reportNull$$$0(2);
        }
        file.putUserData(KEY, (Object)Boolean.TRUE);
        if (originalVfsUrl != null) {
            file.putUserData(VFS_URL_KEY, (Object)FileUtil.toSystemIndependentName((String)originalVfsUrl));
        }
    }

    public static boolean isOutsiderFile(@Nullable PsiFile file) {
        return file != null && SyntheticPsiFileSupport.isOutsiderFile(file.getVirtualFile());
    }

    public static boolean isOutsiderFile(@Nullable VirtualFile file) {
        return file != null && file.getUserData(KEY) == Boolean.TRUE;
    }

    @Nullable
    public static String getOriginalFileUrl(@NotNull VirtualFile file) {
        if (file == null) {
            SyntheticPsiFileSupport.$$$reportNull$$$0(3);
        }
        return (String)file.getUserData(VFS_URL_KEY);
    }

    @Nullable
    public static String getOriginalFilePath(@NotNull VirtualFile file) {
        String vfsUrl;
        if (file == null) {
            SyntheticPsiFileSupport.$$$reportNull$$$0(4);
        }
        return (vfsUrl = SyntheticPsiFileSupport.getOriginalFileUrl(file)) != null ? VirtualFileManager.extractPath((String)vfsUrl) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/codeInsight/daemon/SyntheticPsiFileSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markFileWithUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalFileUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static class IntentionFilter
    implements IntentionActionFilter {
        @Override
        public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile psiFile) {
            if (intentionAction == null) {
                IntentionFilter.$$$reportNull$$$0(0);
            }
            return !SyntheticPsiFileSupport.isOutsiderFile(psiFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/daemon/SyntheticPsiFileSupport$IntentionFilter", "accept"));
        }
    }

    @ApiStatus.Internal
    public static class HighlightFilter
    implements HighlightInfoFilter {
        @Override
        public boolean accept(@NotNull HighlightInfo info, @Nullable PsiFile psiFile) {
            if (info == null) {
                HighlightFilter.$$$reportNull$$$0(0);
            }
            if (!SyntheticPsiFileSupport.isOutsiderFile(psiFile)) {
                return true;
            }
            return info.getSeverity() != HighlightSeverity.ERROR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/SyntheticPsiFileSupport$HighlightFilter", "accept"));
        }
    }
}

