/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.InvalidPsi;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ManagedHighlighterRecycler {
    private final Long2ObjectMap<List<InvalidPsi>> incinerator;
    @NotNull
    final HighlightingSession myHighlightingSession;
    @NotNull
    private final HighlightInfoUpdaterImpl myHighlightInfoUpdater;

    private ManagedHighlighterRecycler(@NotNull HighlightingSession session) {
        if (session == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(0);
        }
        this.incinerator = new Long2ObjectOpenHashMap();
        this.myHighlightingSession = session;
        this.myHighlightInfoUpdater = (HighlightInfoUpdaterImpl)HighlightInfoUpdater.getInstance(session.getProject());
    }

    synchronized void recycleHighlighter(@NotNull PsiElement psiElement, @NotNull HighlightInfo info) {
        RangeHighlighterEx highlighter;
        if (psiElement == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(1);
        }
        if (info == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(2);
        }
        if (HighlightInfo.fromRangeHighlighter((RangeHighlighter)(highlighter = info.getHighlighter())) != info) {
            return;
        }
        assert (info.isFromHighlightVisitor() || info.isFromAnnotator() || info.isFromInspection() || info.isInjectionRelated()) : info;
        assert (info.getHighlighter() != null);
        assert (info.getGroup() == -6) : info;
        if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
            UpdateHighlightersUtil.LOG.debug("recycleHighlighter " + String.valueOf(highlighter) + HighlightInfoUpdaterImpl.currentProgressInfo());
        }
        long range = ((RangeMarkerImpl)highlighter).getScalarRange();
        ((List)this.incinerator.computeIfAbsent(range, __ -> new ArrayList())).add(new InvalidPsi(psiElement, info));
    }

    @Nullable
    synchronized InvalidPsi pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer, @Nullable String preferredDescription) {
        InvalidPsi psi;
        int i;
        long range = TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset);
        List list = (List)this.incinerator.get(range);
        if (list == null) {
            return null;
        }
        int previousFound = -1;
        for (i = list.size() - 1; i >= 0; --i) {
            psi = (InvalidPsi)list.get(i);
            RangeHighlighterEx highlighter = psi.info().getHighlighter();
            if (highlighter == null || !highlighter.isValid() || highlighter.getLayer() != layer || HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter) != psi.info()) continue;
            if (Comparing.strEqual((String)psi.info().getDescription(), (String)preferredDescription)) break;
            previousFound = i;
        }
        if (i == -1 && (i = previousFound) == -1) {
            return null;
        }
        psi = (InvalidPsi)list.remove(i);
        if (list.isEmpty()) {
            this.incinerator.remove(range);
        }
        if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
            UpdateHighlightersUtil.LOG.debug("pickupHighlighterFromGarbageBin pickedup:" + String.valueOf(psi.info().getHighlighter()) + HighlightInfoUpdaterImpl.currentProgressInfo());
        }
        return psi;
    }

    @NotNull
    synchronized @Unmodifiable Collection<InvalidPsi> forAllInGarbageBin() {
        List list = ContainerUtil.flatten((Iterable)this.incinerator.values());
        if (list == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static void runWithRecycler(@NotNull HighlightingSession session, @NotNull Consumer<? super ManagedHighlighterRecycler> consumer) {
        if (session == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            ManagedHighlighterRecycler.$$$reportNull$$$0(5);
        }
        ManagedHighlighterRecycler recycler = new ManagedHighlighterRecycler(session);
        consumer.accept(recycler);
        recycler.myHighlightInfoUpdater.incinerateAndRemoveFromDataAtomically(recycler);
    }

    public synchronized String toString() {
        return "ManagedHighlighterRecycler: " + this.incinerator.size() + " recycled RHs";
    }

    synchronized void incinerateAndClear() {
        for (InvalidPsi psi : this.forAllInGarbageBin()) {
            HighlightInfo info = psi.info();
            RangeHighlighterEx highlighter = info.getHighlighter();
            if (highlighter == null || HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter) != info) continue;
            UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(info, this.myHighlightingSession);
        }
        this.incinerator.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ManagedHighlighterRecycler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ManagedHighlighterRecycler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forAllInGarbageBin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recycleHighlighter";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithRecycler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

