/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ProblemImpl
implements Problem {
    private final VirtualFile virtualFile;
    private final boolean isSyntax;
    @NotNull
    private final TextRange myTextRange;
    @NotNull
    private final HighlightSeverity mySeverity;
    @NotNull
    private final HighlightInfoType myType;
    private final @NlsContexts.DetailedDescription String myDescription;
    private final TextAttributes myForcedTextAttributes;
    private final TextAttributesKey myForcedTextAttributesKey;

    public ProblemImpl(@NotNull VirtualFile virtualFile, @NotNull HighlightInfo info, boolean isSyntax) {
        if (virtualFile == null) {
            ProblemImpl.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ProblemImpl.$$$reportNull$$$0(1);
        }
        this.isSyntax = isSyntax;
        this.virtualFile = virtualFile;
        this.myTextRange = TextRange.create((Segment)info);
        this.mySeverity = info.getSeverity();
        this.myType = info.type;
        this.myDescription = info.getDescription();
        this.myForcedTextAttributes = info.forcedTextAttributes;
        this.myForcedTextAttributesKey = info.forcedTextAttributesKey;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.virtualFile;
        if (virtualFile == null) {
            ProblemImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public boolean isSyntaxOnly() {
        return this.isSyntax;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProblemImpl)) {
            return false;
        }
        ProblemImpl problem = (ProblemImpl)o;
        return this.isSyntax == problem.isSyntax && this.virtualFile.equals(problem.virtualFile) && this.myTextRange.equals((Object)problem.myTextRange) && this.mySeverity.equals((Object)problem.mySeverity) && this.myType.equals(problem.myType) && Objects.equals(this.myDescription, problem.myDescription) && Objects.equals(this.myForcedTextAttributes, problem.myForcedTextAttributes) && Objects.equals(this.myForcedTextAttributesKey, problem.myForcedTextAttributesKey);
    }

    public int hashCode() {
        int result = this.virtualFile.hashCode();
        result = 31 * result + this.myTextRange.hashCode();
        result = 31 * result + (this.isSyntax ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "Problem: " + String.valueOf(this.myTextRange) + ": " + this.myDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/problems/ProblemImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/problems/ProblemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

