/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public record DfaRelation(@NotNull DfaValue leftOperand, @NotNull DfaValue rightOperand, @NotNull RelationType relationType) implements DfaCondition
{
    @NotNull
    private final DfaValue leftOperand;
    @NotNull
    private final DfaValue rightOperand;
    @NotNull
    private final RelationType relationType;

    public DfaRelation(@NotNull DfaValue leftOperand, @NotNull DfaValue rightOperand, @NotNull RelationType relationType) {
        if (leftOperand == null) {
            DfaRelation.$$$reportNull$$$0(0);
        }
        if (rightOperand == null) {
            DfaRelation.$$$reportNull$$$0(1);
        }
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(2);
        }
    }

    @Override
    @NotNull
    public DfaRelation negate() {
        return new DfaRelation(this.leftOperand, this.rightOperand, this.relationType.getNegated());
    }

    @Override
    public DfaCondition correctForRelationResult(boolean result) {
        DfaValue newLeft = this.leftOperand;
        DfaValue newRight = this.rightOperand;
        if (newLeft instanceof DfaTypeValue) {
            DfaTypeValue leftTypeValue = (DfaTypeValue)newLeft;
            newLeft = newLeft.getFactory().fromDfType(leftTypeValue.getDfType().correctForRelationResult(this.relationType, result));
        }
        if (newRight instanceof DfaTypeValue) {
            DfaTypeValue rightTypeValue = (DfaTypeValue)newRight;
            newRight = newRight.getFactory().fromDfType(rightTypeValue.getDfType().correctForRelationResult(this.relationType, result));
        }
        return newLeft == this.leftOperand && newRight == this.rightOperand ? this : DfaCondition.createCondition(newLeft, this.relationType, newRight);
    }

    @Override
    public boolean isUnknown() {
        return this.leftOperand instanceof DfaTypeValue && this.rightOperand instanceof DfaTypeValue;
    }

    public static DfaRelation createRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaRelation.$$$reportNull$$$0(3);
        }
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(4);
        }
        if (dfaRight == null) {
            DfaRelation.$$$reportNull$$$0(5);
        }
        if ((dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaWrappedValue || dfaLeft instanceof DfaBinOpValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaWrappedValue || dfaRight instanceof DfaBinOpValue) && (!(dfaLeft instanceof DfaVariableValue) && !(dfaLeft instanceof DfaWrappedValue) && !(dfaLeft instanceof DfaBinOpValue) || dfaRight instanceof DfaBinOpValue && !(dfaLeft instanceof DfaBinOpValue))) {
            RelationType flipped = relationType.getFlipped();
            return flipped == null ? null : new DfaRelation(dfaRight, dfaLeft, flipped);
        }
        return new DfaRelation(dfaLeft, dfaRight, relationType);
    }

    public boolean isEquality() {
        return this.relationType == RelationType.EQ;
    }

    @Override
    @NonNls
    public String toString() {
        return String.valueOf(this.leftOperand) + " " + String.valueOf((Object)this.relationType) + " " + String.valueOf(this.rightOperand);
    }

    @NotNull
    public DfaValue leftOperand() {
        DfaValue dfaValue = this.leftOperand;
        if (dfaValue == null) {
            DfaRelation.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue rightOperand() {
        DfaValue dfaValue = this.rightOperand;
        if (dfaValue == null) {
            DfaRelation.$$$reportNull$$$0(7);
        }
        return dfaValue;
    }

    @NotNull
    public RelationType relationType() {
        RelationType relationType = this.relationType;
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(8);
        }
        return relationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaRelation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "leftOperand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "rightOperand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "relationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRelation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

