/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.CustomizableExcludeExtensions;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexFilterExcludingExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/find/ngrams/TrigramIndexFilter;", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "<init>", "()V", "acceptFileType", "Lcom/intellij/util/ThreeState;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "slowPathIfFileTypeHintUnsure", "", "file", "Lcom/intellij/util/indexing/IndexedFile;", "Companion", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nTrigramIndexFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrigramIndexFilter.kt\ncom/intellij/find/ngrams/TrigramIndexFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n13#2:67\n1#3:68\n*S KotlinDebug\n*F\n+ 1 TrigramIndexFilter.kt\ncom/intellij/find/ngrams/TrigramIndexFilter\n*L\n44#1:67\n*E\n"})
public final class TrigramIndexFilter
extends BaseFileTypeInputFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY = "ide.index.trigram.enable.exclude.extensions";
    private static final boolean ENABLE_EXTENSION_EXCLUDES = Registry.Companion.is(ENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY, false);
    @NotNull
    private static final CustomizableExcludeExtensions EXTENSION_EXCLUDES = new CustomizableExcludeExtensions((ExtensionPointName<IndexFilterExcludingExtension>)ExtensionPointName.Companion.create("com.intellij.trigramIndexFilterExcludeExtension"));

    public TrigramIndexFilter() {
        super(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TrigramIndexFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Filter exclude extensions is " + (String)(ENABLE_EXTENSION_EXCLUDES ? "enabled: " + EXTENSION_EXCLUDES : "disabled"));
    }

    @Override
    @NotNull
    public ThreeState acceptFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return !TrigramIndex.isEnabled() ? ThreeState.NO : (fileType.isBinary() ? ThreeState.NO : (fileType instanceof PlainTextFileType ? ThreeState.Companion.fromBoolean(!FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) : (ENABLE_EXTENSION_EXCLUDES && EXTENSION_EXCLUDES.hasExtensionForFileType(fileType) ? ThreeState.UNSURE : ThreeState.YES)));
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!ENABLE_EXTENSION_EXCLUDES) {
            boolean bl = false;
            String string = "ENABLE_EXTENSION_EXCLUDES must be true to reach this point";
            throw new IllegalStateException(string.toString());
        }
        return !EXTENSION_EXCLUDES.shouldExcludeFile(file);
    }

    @NotNull
    public static final String getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY() {
        return Companion.getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY();
    }

    @JvmStatic
    public static final boolean isExcludeExtensionsEnabled() {
        return Companion.isExcludeExtensionsEnabled();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\nH\u0007R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/find/ngrams/TrigramIndexFilter$Companion;", "", "<init>", "()V", "ENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY", "", "getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY$annotations", "getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY", "()Ljava/lang/String;", "ENABLE_EXTENSION_EXCLUDES", "", "EXTENSION_EXCLUDES", "Lcom/intellij/util/indexing/CustomizableExcludeExtensions;", "isExcludeExtensionsEnabled", "intellij.platform.indexing.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY() {
            return ENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY;
        }

        @JvmStatic
        public static /* synthetic */ void getENABLE_EXTENSION_EXCLUDES_REGISTRY_KEY$annotations() {
        }

        @JvmStatic
        public final boolean isExcludeExtensionsEnabled() {
            return ENABLE_EXTENSION_EXCLUDES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

