/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.blobstorage;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class RecordLayout {
    public static final byte RECORD_TYPE_MASK = -64;
    public static final byte RECORD_TYPE_ACTUAL = 0;
    public static final byte RECORD_TYPE_MOVED = 64;
    public static final byte RECORD_TYPE_PADDING = -128;
    public static final byte RECORD_TYPE_PARTIAL = -64;
    public static final int OFFSET_BUCKET = 8;
    public static final int OFFSET_BUCKET_BITS = 3;

    public static byte recordType(ByteBuffer source, int offset) {
        byte headerByte0 = source.get(offset);
        return RecordLayout.recordType(headerByte0);
    }

    public static byte recordType(byte headerByte0) {
        return (byte)(headerByte0 & 0xFFFFFFC0);
    }

    public static RecordLayout recordLayout(ByteBuffer source, int offset) {
        byte headerByte0 = source.get(offset);
        byte recordType = RecordLayout.recordType(headerByte0);
        return switch (recordType) {
            case 0 -> ActualRecords.recordLayoutForType(ActualRecords.recordSizeType(headerByte0));
            case 64 -> MovedRecord.INSTANCE;
            case -128 -> PaddingRecord.INSTANCE;
            case -64 -> throw new UnsupportedOperationException("RECORD_TYPE_PARTIAL is not supported yet");
            default -> throw new AssertionError((Object)("Bug: type " + recordType + " is unknown"));
        };
    }

    public abstract byte recordType();

    public abstract int headerSize();

    public abstract void putRecord(ByteBuffer var1, int var2, int var3, int var4, int var5, ByteBuffer var6);

    public void putLength(ByteBuffer buffer, int offset, int newLength) {
        throw new UnsupportedOperationException("Method not implemented for " + String.valueOf(this.getClass()));
    }

    public abstract int capacity(ByteBuffer var1, int var2);

    public abstract int length(ByteBuffer var1, int var2);

    public int redirectToId(ByteBuffer source, int offset) {
        return 0;
    }

    public int fullRecordSize(int capacity) {
        return this.headerSize() + capacity;
    }

    @VisibleForTesting
    public static final class ActualRecords {
        private static final byte RECORD_SIZE_TYPE_MASK = 32;
        private static final byte RECORD_SIZE_TYPE_LARGE = 32;
        private static final byte RECORD_SIZE_TYPE_SMALL = 0;

        public static byte recordSizeType(byte headerByte0) {
            return (byte)(headerByte0 & 0x20);
        }

        public static byte recordSizeTypeByCapacity(int capacity) {
            if (capacity <= 254) {
                return 0;
            }
            if (capacity <= 1048571) {
                return 32;
            }
            throw new IllegalArgumentException("capacity(=" + capacity + ") is too large for a storage");
        }

        public static RecordLayout recordLayoutForType(byte recordSizeType) {
            return switch (recordSizeType) {
                case 0 -> SmallRecord.INSTANCE;
                case 32 -> LargeRecord.INSTANCE;
                default -> throw new IllegalArgumentException("recordSizeType(=" + recordSizeType + ") is unknown");
            };
        }

        @ApiStatus.Internal
        @VisibleForTesting
        public static final class SmallRecord
        extends RecordLayout {
            public static final SmallRecord INSTANCE = new SmallRecord();
            public static final int HEADER_SIZE = 2;
            public static final byte CAPACITY_MASK = 31;
            public static final int MIN_CAPACITY = 6;
            public static final int MAX_CAPACITY = 254;

            @Override
            public void putRecord(ByteBuffer target, int offset, int capacity, int length, int redirectTo, ByteBuffer payload) {
                if (capacity < 6 || capacity > 254) {
                    throw new IllegalArgumentException("capacity(" + capacity + ") must be in [6..254]");
                }
                if (length < 0 || length > 254) {
                    throw new IllegalArgumentException("length(" + length + ") must be in [0, 254]");
                }
                int capacityOverFirstBucket = capacity - 6;
                if (capacityOverFirstBucket % 8 != 0) {
                    throw new IllegalArgumentException("capacity-MIN (=" + capacityOverFirstBucket + ") must be rounded up to 8");
                }
                int packedCapacity = capacityOverFirstBucket >> 3;
                byte headerByte0 = (byte)(0 | packedCapacity);
                byte headerByte1 = (byte)length;
                target.put(offset, headerByte0);
                target.put(offset + 1, headerByte1);
                target.put(offset + 2, payload, payload.position(), length);
            }

            @Override
            public void putLength(ByteBuffer target, int offset, int newLength) {
                if (newLength < 0 || newLength > 254) {
                    throw new IllegalArgumentException("length(" + newLength + ") must be in [0, 254]");
                }
                byte headerByte1 = (byte)newLength;
                target.put(offset + 1, headerByte1);
            }

            @Override
            public int capacity(ByteBuffer source, int offset) {
                byte headerByte0 = source.get(offset);
                return SmallRecord.capacity(headerByte0);
            }

            @Override
            public int length(ByteBuffer source, int offset) {
                byte headerByte1 = source.get(offset + 1);
                return Byte.toUnsignedInt(headerByte1);
            }

            public static int capacity(byte headerByte0) {
                byte recordSizeType = ActualRecords.recordSizeType(headerByte0);
                if (recordSizeType != 0) {
                    throw new IllegalArgumentException("headerByte0(" + headerByte0 + ") doesn't encode SMALL record!");
                }
                return ((headerByte0 & 0x1F) << 3) + 6;
            }

            public static int length(byte headerByte0, byte headerByte1) {
                return Byte.toUnsignedInt(headerByte1);
            }

            @Override
            public byte recordType() {
                return 0;
            }

            @Override
            public int headerSize() {
                return 2;
            }
        }

        @ApiStatus.Internal
        @VisibleForTesting
        public static final class LargeRecord
        extends RecordLayout {
            public static final LargeRecord INSTANCE = new LargeRecord();
            public static final int HEADER_SIZE = 5;
            private static final byte CAPACITY_MASK_0 = 31;
            private static final byte CAPACITY_BITS_0 = 5;
            private static final int CAPACITY_MASK_1 = 4095;
            private static final int CAPACITY_BITS_1 = 12;
            private static final int LENGTH_BITS = 20;
            private static final int LENGTH_MASK = 1048575;
            public static final int MIN_CAPACITY = 3;
            public static final int MAX_CAPACITY = 1048571;

            @Override
            public byte recordType() {
                return 0;
            }

            @Override
            public int headerSize() {
                return 5;
            }

            @Override
            public void putRecord(ByteBuffer target, int offset, int capacity, int length, int redirectTo, ByteBuffer payload) {
                int packedCapacity = LargeRecord.getPackedCapacity(capacity, length);
                int first5BitsOfCapacity = packedCapacity >> 12;
                byte headerByte0 = (byte)(0x20 | first5BitsOfCapacity);
                int headerBytes1_4 = Integer.rotateRight(packedCapacity & 0xFFF, 12) | length & 0xFFFFF;
                target.put(offset, headerByte0);
                target.putInt(offset + 1, headerBytes1_4);
                target.put(offset + 5, payload, payload.position(), length);
            }

            private static int getPackedCapacity(int capacity, int length) {
                if (capacity < 3 || capacity > 1048571) {
                    throw new IllegalArgumentException("capacity(" + capacity + ") must be in [3..1048571]");
                }
                if (length < 0 || length > 1048571) {
                    throw new IllegalArgumentException("length(" + length + ") must be in [0, 1048571]");
                }
                int capacityOverFirstBucket = capacity - 3;
                if (capacityOverFirstBucket % 8 != 0) {
                    throw new IllegalArgumentException("capacity-MIN (=" + capacityOverFirstBucket + ") must be rounded up to 8");
                }
                return capacityOverFirstBucket >> 3;
            }

            @Override
            public void putLength(ByteBuffer target, int offset, int length) {
                if (length < 0 || length > 1048571) {
                    throw new IllegalArgumentException("length(" + length + ") must be in [0, 1048571]");
                }
                int headerBytes1_4 = target.getInt(offset + 1);
                int headerBytes1_4_New = headerBytes1_4 & 0xFFF00000 | length & 0xFFFFF;
                target.putInt(offset + 1, headerBytes1_4_New);
            }

            @Override
            public int capacity(ByteBuffer source, int offset) {
                byte headerByte0 = source.get(offset);
                int headerBytes1_4 = source.getInt(offset + 1);
                return LargeRecord.capacity(headerByte0, headerBytes1_4);
            }

            @Override
            public int length(ByteBuffer source, int offset) {
                int headerBytes1_4 = source.getInt(offset + 1);
                return headerBytes1_4 & 0xFFFFF;
            }

            public static int capacity(byte headerByte0, int headerBytes1_4) {
                byte recordSizeType = ActualRecords.recordSizeType(headerByte0);
                if (recordSizeType != 32) {
                    throw new IllegalArgumentException("headerByte0(" + headerByte0 + ") doesn't encode LARGE record!");
                }
                int first5bits = headerByte0 & 0x1F;
                int next12bits = headerBytes1_4 >> 20 & 0xFFF;
                int allBits = first5bits << 12 | next12bits;
                return (allBits << 3) + 3;
            }
        }
    }

    @VisibleForTesting
    public static final class MovedRecord
    extends RecordLayout {
        public static final MovedRecord INSTANCE = new MovedRecord();
        public static final int HEADER_SIZE = 7;
        private static final byte CAPACITY_MASK_0 = 63;
        private static final byte CAPACITY_BITS_0 = 6;
        private static final int CAPACITY_MASK_1_2 = 65535;
        private static final int CAPACITY_BITS_1_2 = 16;
        private static final int REDIRECT_TO_OFFSET = 3;
        public static final int MIN_CAPACITY = 1;
        public static final int MAX_CAPACITY = 0x1FFFFF9;

        @Override
        public byte recordType() {
            return 64;
        }

        @Override
        public int headerSize() {
            return 7;
        }

        @Override
        public void putRecord(ByteBuffer target, int offset, int capacity, int length, int redirectToId, ByteBuffer payload) {
            if (capacity < 1 || capacity > 0x1FFFFF9) {
                throw new IllegalArgumentException("capacity(" + capacity + ") must be in [1..33554425]");
            }
            if (length != 0) {
                throw new IllegalArgumentException("length(" + length + ") must be in 0 for MOVED records");
            }
            int capacityOverFirstBucket = capacity - 1;
            if (capacityOverFirstBucket % 8 != 0) {
                throw new IllegalArgumentException("capacity-MIN (=" + capacityOverFirstBucket + ") must be rounded up to 8");
            }
            int packedCapacity = capacityOverFirstBucket >> 3;
            int highest6BitsOfCapacity = packedCapacity >> 16;
            byte headerByte0 = (byte)(0x40 | highest6BitsOfCapacity);
            short headerBytes1_2 = (short)(packedCapacity & 0xFFFF);
            target.put(offset, headerByte0);
            target.putShort(offset + 1, headerBytes1_2);
            target.putInt(offset + 3, redirectToId);
        }

        public void putRedirectTo(ByteBuffer target, int offset, int redirectToId) {
            target.putInt(offset + 3, redirectToId);
        }

        @Override
        public int capacity(ByteBuffer source, int offset) {
            byte headerByte0 = source.get(offset);
            short headerBytes1_2 = source.getShort(offset + 1);
            int packedCapacity = (headerByte0 & 0x3F) << 16 | headerBytes1_2 & 0xFFFF;
            int capacity = (packedCapacity << 3) + 1;
            assert (capacity <= 0x1FFFFF9) : "capacity(" + capacity + ") > MAX 33554425";
            return capacity;
        }

        @Override
        public int length(ByteBuffer source, int offset) {
            return 0;
        }

        @Override
        public int redirectToId(ByteBuffer source, int offset) {
            return source.getInt(offset + 3);
        }
    }

    @VisibleForTesting
    public static final class PaddingRecord
    extends RecordLayout {
        public static final PaddingRecord INSTANCE = new PaddingRecord();
        public static final int HEADER_SIZE = 3;
        private static final byte CAPACITY_MASK_0 = 63;
        private static final byte CAPACITY_BITS_0 = 6;
        private static final byte CAPACITY_BITS_1 = 8;
        private static final byte CAPACITY_BITS_2 = 8;
        private static final int CAPACITY_MASK_1 = 255;
        private static final int CAPACITY_MASK_2 = 255;
        public static final int MIN_CAPACITY = 5;
        public static final int MAX_CAPACITY = 0x1FFFFFD;

        @Override
        public byte recordType() {
            return -128;
        }

        @Override
        public int headerSize() {
            return 3;
        }

        @Override
        public void putRecord(ByteBuffer target, int offset, int capacity, int length, int redirectToId, ByteBuffer payload) {
            int packedCapacity = PaddingRecord.getPackedCapacity(capacity);
            byte headerByte0 = (byte)(0xFFFFFF80 | packedCapacity >> 8 >> 8 & 0x3F);
            byte headerByte1 = (byte)(packedCapacity >> 8 & 0xFF);
            byte headerByte2 = (byte)(packedCapacity & 0xFF);
            target.put(offset, headerByte0);
            target.put(offset + 1, headerByte1);
            target.put(offset + 2, headerByte2);
        }

        private static int getPackedCapacity(int capacity) {
            if (capacity < 5 || capacity > 0x1FFFFFD) {
                throw new IllegalArgumentException("PaddingRecord capacity(" + capacity + ") must be in [5..33554429]");
            }
            int capacityOverFirstBucket = capacity - 5;
            if (capacityOverFirstBucket % 8 != 0) {
                throw new IllegalArgumentException("capacity-MIN (=" + capacityOverFirstBucket + ") must be rounded up to 8");
            }
            return capacityOverFirstBucket >> 3;
        }

        @Override
        public int capacity(ByteBuffer source, int offset) {
            byte headerByte0 = source.get(offset);
            byte headerByte1 = source.get(offset + 1);
            byte headerByte2 = source.get(offset + 2);
            int packedCapacity = ((headerByte0 & 0x3F) << 8 | headerByte1 & 0xFF) << 8 | headerByte2 & 0xFF;
            return (packedCapacity << 3) + 5;
        }

        @Override
        public int length(ByteBuffer source, int offset) {
            return 0;
        }
    }
}

