/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatableIndexFactory;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.SingleEntryCompositeIndexer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.storage.MapReduceIndexBase;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    @ApiStatus.Internal
    public static final Logger LOG = Logger.getInstance(StubUpdatingIndex.class);
    private static final boolean DEBUG_PREBUILT_INDICES = SystemProperties.getBooleanProperty((String)"debug.prebuilt.indices", (boolean)false);
    public static final boolean USE_SNAPSHOT_MAPPINGS = false;
    private static final int VERSION = 45 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final FileBasedIndex.ProjectSpecificInputFilter INPUT_FILTER = new BaseFileTypeInputFilter(FileTypeSubstitutionStrategy.AFTER_SUBSTITUTION){

        private static void logIfStubTraceEnabled(@NotNull Supplier<String> logText) {
            FileBasedIndex fileBasedIndex;
            if (logText == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((fileBasedIndex = FileBasedIndex.getInstance()) instanceof FileBasedIndexEx) {
                FileBasedIndexEx fileBasedIndex2 = (FileBasedIndexEx)fileBasedIndex;
                if (FileBasedIndexEx.doTraceStubUpdates(INDEX_ID)) {
                    fileBasedIndex2.getLogger().info(logText.get());
                }
            }
        }

        @Nullable
        private static ParserDefinition getParserDefinition(@NotNull FileType fileType, @NotNull Supplier<String> logText) {
            Language l;
            if (fileType == null) {
                1.$$$reportNull$$$0(1);
            }
            if (logText == null) {
                1.$$$reportNull$$$0(2);
            }
            ParserDefinition parserDefinition = null;
            if (fileType instanceof LanguageFileType && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l = ((LanguageFileType)fileType).getLanguage())) == null) {
                1.logIfStubTraceEnabled(() -> "No parser definition for " + (String)logText.get());
            }
            return parserDefinition;
        }

        public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
            BinaryFileStubBuilder builder;
            if (file == null) {
                1.$$$reportNull$$$0(3);
            }
            if (file.getFileType() instanceof LanguageFileType) {
                ParserDefinition parserDefinition = 1.getParserDefinition(file.getFileType(), () -> ((IndexedFile)file).getFileName());
                if (parserDefinition == null) {
                    return false;
                }
                IFileElementType elementType = parserDefinition.getFileNodeType();
                LanguageStubDescriptor stubDescriptor = StubElementRegistryService.getInstance().getStubDescriptor(elementType.getLanguage());
                if (stubDescriptor != null && stubDescriptor.getStubDefinition().shouldBuildStubFor(file.getFile())) {
                    1.logIfStubTraceEnabled(() -> "Should build stub for " + ((VirtualFileWithId)file.getFile()).getId());
                    return true;
                }
                1.logIfStubTraceEnabled(() -> "Can't build stub. parserDefinition: " + String.valueOf(parserDefinition) + ", elementType: " + String.valueOf(elementType) + ", fileName:" + file.getFileName() + ", properties: " + String.valueOf(PushedFilePropertiesRetriever.getInstance().dumpSortedPushedProperties(file.getFile())));
            }
            return (builder = 1.getBinaryStubBuilder(file.getFileType())) != null && builder.acceptsFile(file.getFile());
        }

        @Nullable
        private static BinaryFileStubBuilder getBinaryStubBuilder(@NotNull FileType fileType) {
            if (fileType == null) {
                1.$$$reportNull$$$0(4);
            }
            return (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
        }

        @Override
        @NotNull
        public ThreeState acceptFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                1.$$$reportNull$$$0(5);
            }
            if (1.getParserDefinition(fileType, () -> ((FileType)fileType).toString()) == null) {
                BinaryFileStubBuilder builder = 1.getBinaryStubBuilder(fileType);
                if (builder == null) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return threeState;
                }
                VirtualFileFilter builderFileFilter = builder.getFileFilter();
                if (builderFileFilter == VirtualFileFilter.ALL) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return threeState;
                }
                if (builderFileFilter == VirtualFileFilter.NONE) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                1.$$$reportNull$$$0(9);
            }
            return threeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logText";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acceptFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "logIfStubTraceEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParserDefinition";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "slowPathIfFileTypeHintUnsure";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinaryStubBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptFileType";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    };
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private static final FileTypeExtension<PrebuiltStubsProvider> PREBUILT_STUBS_PROVIDER_EP = new FileTypeExtension("com.intellij.filetype.prebuiltStubsProvider");

    @ApiStatus.Internal
    public StubUpdatingIndex() {
        this(StubForwardIndexExternalizer.getIdeUsedExternalizer(), SerializationManagerEx.getInstanceEx());
    }

    @ApiStatus.Internal
    public StubUpdatingIndex(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        if (stubIndexesExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    public static boolean canHaveStub(@NotNull VirtualFile file) {
        if (file == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(file);
        IndexedFileImpl indexedFile = new IndexedFileImpl(file, project);
        return INPUT_FILTER.acceptInput((IndexedFile)indexedFile);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        return new SingleEntryCompositeIndexer<SerializedStubTree, StubBuilderType, String>(false){

            public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StubTreeBuilder.requiresContentToFindBuilder((FileType)file.getFileType());
            }

            @Nullable
            public StubBuilderType calculateSubIndexer(@NotNull IndexedFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                return StubTreeBuilder.getStubBuilderType((IndexedFile)file, (boolean)true);
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull StubBuilderType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(2);
                }
                StubUpdatingIndex.this.mySerializationManager.initSerializers();
                String string = type.getVersion();
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    2.$$$reportNull$$$0(4);
                }
                return enumeratorStringDescriptor;
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData) {
                StubBuilderType subIndexerType;
                if (inputData == null) {
                    2.$$$reportNull$$$0(5);
                }
                if ((subIndexerType = this.calculateSubIndexer((IndexedFile)inputData)) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stub builder not found for " + String.valueOf(inputData.getFile()) + ", " + String.valueOf(StubUpdatingIndex.calculateIndexingStamp(inputData)));
                    }
                    return null;
                }
                return this.computeValue(inputData, Objects.requireNonNull(subIndexerType));
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData, @NotNull StubBuilderType type) {
                SerializedStubTree serializedStubTree;
                Stub stub;
                if (inputData == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(7);
                }
                try {
                    SerializedStubTree prebuiltTree = StubUpdatingIndex.findPrebuiltSerializedStubTree(inputData);
                    if (prebuiltTree != null) {
                        prebuiltTree = prebuiltTree.reSerialize(StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                        if (DEBUG_PREBUILT_INDICES) {
                            StubUpdatingIndex.this.assertPrebuiltStubTreeMatchesActualTree(prebuiltTree, inputData, type);
                        }
                        return prebuiltTree;
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    LOG.error("Error while indexing: " + inputData.getFileName() + " using prebuilt stub index", (Throwable)e);
                }
                try {
                    stub = StubTreeBuilder.buildStubTree((FileContent)inputData, (StubBuilderType)type);
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrowUnchecked((Throwable)e);
                    }
                    throw new MapReduceIndexMappingException((Throwable)e, type.getClassToBlameInCaseOfException());
                }
                if (stub == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No stub present for " + String.valueOf(inputData.getFile()) + ", " + String.valueOf(StubUpdatingIndex.calculateIndexingStamp(inputData)));
                    }
                    return null;
                }
                try {
                    serializedStubTree = SerializedStubTree.serializeStub(stub, StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                    if (IndexDebugProperties.DEBUG) {
                        StubUpdatingIndex.assertDeserializedStubMatchesOriginalStub(serializedStubTree, stub);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stub is built for " + String.valueOf(inputData.getFile()) + ", " + String.valueOf(StubUpdatingIndex.calculateIndexingStamp(inputData)));
                    }
                }
                catch (Exception e) {
                    ObjectStubSerializer stubType;
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrowUnchecked((Throwable)e);
                    }
                    Class classToBlame = (stubType = stub.getStubSerializer()) != null ? stubType.getClass() : stub.getClass();
                    throw new MapReduceIndexMappingException((Throwable)e, classToBlame);
                }
                return serializedStubTree;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$2";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requiresContentForSubIndexerEvaluation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "computeValue";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        return new SerializedStubTreeDataExternalizer(this.mySerializationManager, this.myStubIndexesExternalizer);
    }

    private static void assertDeserializedStubMatchesOriginalStub(@NotNull SerializedStubTree stubTree, @NotNull Stub originalStub) {
        Stub deserializedStub;
        if (stubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        if (originalStub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        try {
            deserializedStub = stubTree.getStub();
        }
        catch (SerializerNotFoundException e) {
            throw new RuntimeException("Failed to deserialize stub tree", e);
        }
        if (!StubUpdatingIndex.areStubsSimilar(originalStub, deserializedStub)) {
            LOG.error("original and deserialized trees are not the same", new Attachment[]{new Attachment("originalStub.txt", DebugUtil.stubTreeToString((Stub)originalStub)), new Attachment("deserializedStub.txt", DebugUtil.stubTreeToString((Stub)deserializedStub))});
        }
    }

    private static boolean areStubsSimilar(@NotNull Stub stub, @NotNull Stub stub2) {
        IElementType elementType2;
        ObjectStubSerializer serializer2;
        ObjectStubSerializer serializer1;
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        if (!Objects.equals(serializer1 = stub.getStubSerializer(), serializer2 = stub2.getStubSerializer())) {
            return false;
        }
        IElementType elementType1 = stub instanceof StubElement ? ((StubElement)stub).getElementType() : null;
        IElementType iElementType = elementType2 = stub2 instanceof StubElement ? ((StubElement)stub2).getElementType() : null;
        if (!Objects.equals(elementType1, elementType2)) {
            return false;
        }
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        if (stubs.size() != stubs2.size()) {
            return false;
        }
        int len = stubs.size();
        for (int i = 0; i < len; ++i) {
            if (StubUpdatingIndex.areStubsSimilar((Stub)stubs.get(i), (Stub)stubs2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void assertPrebuiltStubTreeMatchesActualTree(@NotNull SerializedStubTree prebuiltStubTree, @NotNull FileContent fileContent, @NotNull StubBuilderType type) {
        if (prebuiltStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        if (type == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        try {
            Stub stub = StubTreeBuilder.buildStubTree((FileContent)fileContent, (StubBuilderType)type);
            if (stub == null) {
                return;
            }
            SerializedStubTree actualTree = SerializedStubTree.serializeStub(stub, this.mySerializationManager, this.myStubIndexesExternalizer);
            if (!IndexDataComparer.INSTANCE.areStubTreesTheSame(actualTree, prebuiltStubTree)) {
                throw new RuntimeExceptionWithAttachments("Prebuilt stub tree does not match actual stub tree", new Attachment[]{new Attachment("actual-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(actualTree)), new Attachment("prebuilt-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(prebuiltStubTree))});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.ProjectSpecificInputFilter projectSpecificInputFilter = INPUT_FILTER;
        if (projectSpecificInputFilter == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        return projectSpecificInputFilter;
    }

    public int getCacheSize() {
        return super.getCacheSize() * Runtime.getRuntime().availableProcessors();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> createIndexImplementation(final @NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, final @NotNull VfsAwareIndexStorageLayout<Integer, SerializedStubTree> layout) throws StorageException, IOException {
        if (extension == null) {
            StubUpdatingIndex.$$$reportNull$$$0(12);
        }
        if (layout == null) {
            StubUpdatingIndex.$$$reportNull$$$0(13);
        }
        ((StubIndexEx)StubIndex.getInstance()).initializeStubIndexes();
        this.checkNameStorage();
        this.mySerializationManager.initialize();
        MapReduceIndexBase<Integer, SerializedStubTree, ?> index = StubUpdatableIndexFactory.getInstance().createIndex(extension, new VfsAwareIndexStorageLayout<Integer, SerializedStubTree>(this){

            @Override
            public void clearIndexData() {
                layout.clearIndexData();
            }

            @NotNull
            public IndexStorage<Integer, SerializedStubTree> openIndexStorage() throws IOException {
                IndexStorage indexStorage = layout.openIndexStorage();
                if (indexStorage == null) {
                    3.$$$reportNull$$$0(0);
                }
                return indexStorage;
            }

            @Nullable
            public ForwardIndex openForwardIndex() throws IOException {
                return layout.openForwardIndex();
            }

            @NotNull
            public ForwardIndexAccessor<Integer, SerializedStubTree> getForwardIndexAccessor() {
                return new StubUpdatingForwardIndexAccessor((FileBasedIndexExtension<Integer, SerializedStubTree>)extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$3", "openIndexStorage"));
            }
        }, this.mySerializationManager);
        IndexStorage indexStorage = index.getStorage();
        if (indexStorage instanceof TransientChangesIndexStorage) {
            TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)indexStorage;
            memStorage.addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(this){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexEx)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexEx)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        MapReduceIndexBase<Integer, SerializedStubTree, ?> mapReduceIndexBase = index;
        if (mapReduceIndexBase == null) {
            StubUpdatingIndex.$$$reportNull$$$0(14);
        }
        return mapReduceIndexBase;
    }

    @Nullable
    private static SerializedStubTree findPrebuiltSerializedStubTree(@NotNull FileContent fileContent) {
        PrebuiltStubsProvider prebuiltStubsProvider;
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(15);
        }
        if ((prebuiltStubsProvider = (PrebuiltStubsProvider)PREBUILT_STUBS_PROVIDER_EP.forFileType(fileContent.getFileType())) == null) {
            return null;
        }
        return prebuiltStubsProvider.findStub(fileContent);
    }

    public int getVersion() {
        return VERSION;
    }

    public boolean enableWal() {
        return true;
    }

    @Override
    public void handleInitializationError(@NotNull Throwable e) {
        if (e == null) {
            StubUpdatingIndex.$$$reportNull$$$0(16);
        }
        ((StubIndexEx)StubIndex.getInstance()).initializationFailed(e);
    }

    @ApiStatus.Internal
    @NotNull
    public static IndexingStampInfo calculateIndexingStamp(@NotNull FileContent content) {
        VirtualFile file;
        boolean isBinary;
        if (content == null) {
            StubUpdatingIndex.$$$reportNull$$$0(17);
        }
        int contentLength = (isBinary = (file = content.getFile()).getFileType().isBinary()) ? -1 : content.getPsiFile().getTextLength();
        long byteLength = file.getLength();
        return new IndexingStampInfo(file.getTimeStamp(), byteLength, contentLength, isBinary);
    }

    private void checkNameStorage() throws StorageException {
        if (this.mySerializationManager.isNameStorageCorrupted()) {
            StorageException exception = new StorageException("NameStorage for stubs serialization has been corrupted");
            this.mySerializationManager.repairNameStorage((Exception)((Object)exception));
            throw exception;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltStubTree";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 3: 
            case 11: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertDeserializedStubMatchesOriginalStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areStubsSimilar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertPrebuiltStubTreeMatchesActualTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPrebuiltSerializedStubTree";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleInitializationError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexingStamp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 14 -> new IllegalStateException(string);
        };
    }
}

