/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.xml.AttributeIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/xml/AttributeIteratorImpl;", "Lcom/intellij/util/xml/AttributeIterator;", "reader", "Lorg/codehaus/stax2/XMLStreamReader2;", "<init>", "(Lorg/codehaus/stax2/XMLStreamReader2;)V", "index", "", "count", "reset", "", "next", "", "localName", "", "value", "valueAsInt", "namespacePrefix", "namespaceUri", "intellij.platform.indexing.impl"})
final class AttributeIteratorImpl
implements AttributeIterator {
    @NotNull
    private final XMLStreamReader2 reader;
    private int index;
    private int count;

    public AttributeIteratorImpl(@NotNull XMLStreamReader2 reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        this.index = -1;
    }

    public final void reset() {
        this.index = -1;
        this.count = this.reader.getAttributeCount();
    }

    @Override
    public boolean next() {
        int n = this.index;
        this.index = n + 1;
        return this.index < this.count;
    }

    @Override
    @NotNull
    public String localName() {
        String string = this.reader.getAttributeLocalName(this.index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeLocalName(...)");
        return string;
    }

    @Override
    @NotNull
    public String value() {
        String string = this.reader.getAttributeValue(this.index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
        return string;
    }

    @Override
    public int valueAsInt() {
        return this.reader.getElementAsInt();
    }

    @Override
    @Nullable
    public String namespacePrefix() {
        return this.reader.getAttributePrefix(this.index);
    }

    @Override
    @Nullable
    public String namespaceUri() {
        return this.reader.getAttributeNamespace(this.index);
    }
}

