/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.impl;

import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiTree;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.impl.HprofObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0005\u001a\u00020\u0002H\u0016J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/hprof/impl/HprofObjectTree;", "Lcom/intellij/profiler/ultimate/hprof/api/MuiTree;", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "root", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntSet;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;)V", "getDump", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "getRoot", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "getMap", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "get", "", "instance", "intellij.profiler.ultimate"})
final class HprofObjectTree
implements MuiTree<HprofObject> {
    @NotNull
    private final HprofDump dump;
    @NotNull
    private final HprofObject root;
    @NotNull
    private final Int2ObjectMap<IntSet> map;

    public HprofObjectTree(@NotNull HprofDump dump, @NotNull HprofObject root, @NotNull Int2ObjectMap<IntSet> map2) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.dump = dump;
        this.root = root;
        this.map = map2;
    }

    @NotNull
    public final HprofDump getDump() {
        return this.dump;
    }

    @NotNull
    public final HprofObject getRoot() {
        return this.root;
    }

    @NotNull
    public final Int2ObjectMap<IntSet> getMap() {
        return this.map;
    }

    @Override
    @NotNull
    public HprofObject root() {
        return this.root;
    }

    @Override
    @NotNull
    public List<HprofObject> get(@NotNull HprofObject instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        int objectIndex = this.dump.getIndex().getRemapId(instance.getId());
        IntSet children = (IntSet)this.map.get(objectIndex);
        if (children == null) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        children.forEach(arg_0 -> HprofObjectTree.get$lambda$0(result, this, arg_0));
        return result;
    }

    private static final void get$lambda$0(List $result, HprofObjectTree this$0, int i) {
        if (i < 0) {
            String msg = UltimateProfilerBundleKt.profilerMessage("hprof.stub.shortest.paths.truncated", new Object[0]);
            $result.add(HprofObject.Companion.createStub(0, msg));
            return;
        }
        HprofObject element = this$0.dump.getIndex().getObjectByIndex(i);
        if (element == null) {
            return;
        }
        $result.add(element);
    }
}

