/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ReadOnceFile
implements Closeable {
    private final DataInputStream myStream;
    private long remaining;

    public ReadOnceFile(Path path) throws IOException {
        this(path, 0x100000);
    }

    public ReadOnceFile(Path path, int bufferSize) throws IOException {
        this.myStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), bufferSize));
        this.remaining = Files.size(path);
    }

    public long getLong() throws IOException {
        long result = this.myStream.readLong();
        this.remaining -= 8L;
        return result;
    }

    public int getInt() throws IOException {
        int result = this.myStream.readInt();
        this.remaining -= 4L;
        return result;
    }

    public long remaining() {
        return this.remaining;
    }

    @Override
    public void close() throws IOException {
        this.myStream.close();
    }
}

