/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.view.mappers.KubernetesPodMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.KubernetesCachedValueBasedServiceViewContributorDescriptorBased;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptor;
import com.intellij.kubernetes.view.ui.KubernetesResourcesTablePanel;
import com.intellij.kubernetes.view.ui.KubernetesTable;
import com.intellij.kubernetes.view.ui.KubernetesTablePanelController;
import com.intellij.kubernetes.view.ui.actions.KubernetesCreateActionsUtilKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesPodsServiceViewContributor;", "Lcom/intellij/kubernetes/view/nodes/KubernetesCachedValueBasedServiceViewContributorDescriptorBased;", "Lio/kubernetes/client/openapi/models/V1Pod;", "Lio/kubernetes/client/openapi/models/V1PodList;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesPodServiceViewContributorDescriptor;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lkotlinx/coroutines/CoroutineScope;)V", "descriptorIcon", "Ljavax/swing/Icon;", "getDescriptorIcon", "()Ljavax/swing/Icon;", "createService", "resource", "createTablePanel", "Lcom/intellij/kubernetes/view/ui/KubernetesResourcesTablePanel;", "controller", "Lcom/intellij/kubernetes/view/ui/KubernetesTablePanelController;", "intellij.clouds.kubernetes"})
public final class KubernetesPodsServiceViewContributor
extends KubernetesCachedValueBasedServiceViewContributorDescriptorBased<V1Pod, V1PodList, KubernetesPodServiceViewContributorDescriptor> {
    public KubernetesPodsServiceViewContributor(@NotNull KubernetesApiModelInterface apiModel2, @NotNull CoroutineScope parentCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        super(apiModel2, parentCoroutineScope, (KubernetesResourceMapper)KubernetesPodMapper.INSTANCE);
    }

    @Override
    @NotNull
    public Icon getDescriptorIcon() {
        Icon icon = KubernetesIcons.Pod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Pod");
        return icon;
    }

    @Override
    @NotNull
    protected KubernetesPodServiceViewContributorDescriptor createService(@NotNull V1Pod resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return new KubernetesPodServiceViewContributorDescriptor(resource, this.getApiModel(), this.getCoroutineScope(), this.getMapper());
    }

    @NotNull
    public KubernetesResourcesTablePanel createTablePanel(@NotNull KubernetesTablePanelController<V1Pod> controller) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        String string = this.getMapper().getEntity().getResource();
        KubernetesTable kubernetesTable = controller.getTable();
        return new KubernetesResourcesTablePanel(this, string, kubernetesTable){

            protected ActionGroup createExtraActions() {
                return KubernetesCreateActionsUtilKt.createPodActions();
            }
        };
    }
}

