/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.browser;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.net.NetUtils;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.platform.codeWithMe.util.UnattendedHostUriUtil;
import com.jetbrains.rdserver.unattendedHost.UnattendedHostRemoteControlHandler;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import java.net.URI;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ,\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "UNATTENDED_HOST_URL_OPENER_LABEL", "", "openUrlOnControllerWithPortForward", "", "url", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "processForwarding", "uri", "Ljava/net/URI;", "portsToForward", "Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper$ForwardingOptions;", "forwardPortAndContinue", "", "portToForward", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "frontendPort", "ignorePortForwarding", "port", "ForwardingOptions", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostOpenUrlHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostOpenUrlHelper.kt\ncom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n60#2,5:200\n60#2,5:205\n60#2,5:210\n60#2,5:215\n60#2,5:221\n60#2,5:226\n60#2,5:231\n60#2,5:240\n60#2,5:245\n60#2,5:250\n60#2,5:255\n23#2:260\n1#3:220\n296#4,2:236\n296#4,2:238\n*S KotlinDebug\n*F\n+ 1 UnattendedHostOpenUrlHelper.kt\ncom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper\n*L\n42#1:200,5\n45#1:205,5\n64#1:210,5\n73#1:215,5\n83#1:221,5\n88#1:226,5\n112#1:231,5\n147#1:240,5\n193#1:245,5\n94#1:250,5\n100#1:255,5\n31#1:260\n120#1:236,2\n126#1:238,2\n*E\n"})
public final class UnattendedHostOpenUrlHelper {
    @NotNull
    public static final UnattendedHostOpenUrlHelper INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String UNATTENDED_HOST_URL_OPENER_LABEL = "unattendedHostUrlOpener";

    private UnattendedHostOpenUrlHelper() {
    }

    public final boolean openUrlOnControllerWithPortForward(@NotNull String url, @Nullable Project project, @Nullable WebBrowser browser) {
        Integer n;
        Integer n2;
        Integer n3;
        boolean $i$f$debug;
        Throwable t$iv;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Logger $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Trying to open URL " + url + " on controller client...", t$iv2);
        }
        if (!ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()).isOwner()) {
            $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
            t$iv2 = null;
            $i$f$debug2 = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Current application session is not an owner's session. Skip open URL call.", t$iv2);
            }
            return false;
        }
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            Ref.BooleanRef result = new Ref.BooleanRef();
            ApplicationKt.getApplication().invokeAndWait(() -> UnattendedHostOpenUrlHelper.openUrlOnControllerWithPortForward$lambda$2(result, url, project, browser), ModalityState.any());
            return result.element;
        }
        URI uri = URI.create(url);
        if (NetUtils.isLocalhost((String)uri.getHost())) {
            Intrinsics.checkNotNull((Object)uri);
            Integer effectivePort = UnattendedHostUriUtil.INSTANCE.getEffectivePort(uri);
            if (effectivePort == null) {
                UnattendedHostOpenUrlHelper.logger.info("Host wanted to open URL " + url + ", it points to localhost, but has no obvious port; not opening");
                return false;
            }
            Logger $this$debug_u24default$iv2 = UnattendedHostOpenUrlHelper.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("URL requested on client is localhost, will forward port " + effectivePort, t$iv);
            }
            n3 = effectivePort;
        } else {
            n3 = null;
        }
        Integer portInAuthority = n3;
        Intrinsics.checkNotNull((Object)uri);
        Integer portInQuery = UnattendedHostUriUtil.INSTANCE.getLocalHostPortInQuery(uri);
        if (portInQuery != null) {
            Logger $this$debug_u24default$iv3 = UnattendedHostOpenUrlHelper.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug("URL requested on client contains localhost with port " + portInQuery + " in query, will forward it", t$iv);
            }
        }
        Integer n4 = portInQuery;
        if (n4 != null) {
            int it = ((Number)n4).intValue();
            boolean bl = false;
            n2 = INSTANCE.ignorePortForwarding(it) ? null : portInQuery;
        } else {
            n2 = null;
        }
        Integer filteredPortInQuery = n2;
        Integer n5 = portInAuthority;
        if (n5 != null) {
            int it = ((Number)n5).intValue();
            boolean bl = false;
            n = INSTANCE.ignorePortForwarding(it) ? null : portInAuthority;
        } else {
            n = null;
        }
        Integer filteredPortInAuthority = n;
        return this.processForwarding(uri, new ForwardingOptions(filteredPortInQuery, filteredPortInAuthority), project, browser);
    }

    public static /* synthetic */ boolean openUrlOnControllerWithPortForward$default(UnattendedHostOpenUrlHelper unattendedHostOpenUrlHelper, String string, Project project, WebBrowser webBrowser, int n, Object object) {
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        return unattendedHostOpenUrlHelper.openUrlOnControllerWithPortForward(string, project, webBrowser);
    }

    private final boolean processForwarding(URI uri, ForwardingOptions portsToForward, Project project, WebBrowser browser) {
        Logger logger;
        Logger $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("URL requested for opening: " + uri, t$iv);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (portsToForward.getPortInAuthority() == null && portsToForward.getPortInQuery() == null) {
            $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Going to open url " + uri + " on client", t$iv);
            }
            UnattendedHostRemoteControlHandler unattendedHostRemoteControlHandler = UnattendedHostRemoteControlHandler.Companion.getInstance();
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            unattendedHostRemoteControlHandler.openUrlOnController(project, string, browser);
            return true;
        }
        if (portsToForward.getPortInAuthority() != null) {
            this.forwardPortAndContinue(portsToForward.getPortInAuthority(), (Function1<? super Integer, Unit>)((Function1)arg_0 -> UnattendedHostOpenUrlHelper.processForwarding$lambda$2(uri, portsToForward, project, browser, arg_0)));
        } else if (portsToForward.getPortInQuery() != null) {
            this.forwardPortAndContinue(portsToForward.getPortInQuery(), (Function1<? super Integer, Unit>)((Function1)arg_0 -> UnattendedHostOpenUrlHelper.processForwarding$lambda$3(uri, portsToForward, project, browser, arg_0)));
        }
        return true;
    }

    private final void forwardPortAndContinue(int portToForward, Function1<? super Integer, Unit> action) {
        ServerSocketPortState portState;
        ForwardedPort forwardedPort;
        Object v1;
        ForwardedPort directForwardedPort;
        Ref.BooleanRef shouldRemovePort;
        ClientAppSession session;
        Logger logger;
        block11: {
            Object v0;
            block10: {
                Logger $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Going to open forward port " + portToForward, t$iv);
                }
                session = UtilKt.getControllerSession((Application)ApplicationKt.getApplication());
                shouldRemovePort = new Ref.BooleanRef();
                Iterable $this$firstOrNull$iv = PerClientPortForwardingManager.Companion.getInstance(session).getPorts(portToForward);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ForwardedPort port = (ForwardedPort)element$iv;
                    boolean bl = false;
                    if (!PortConfigurationKt.isPerClientDirectForwardedPort((PortConfiguration)port.getConfiguration())) continue;
                    v0 = element$iv;
                    break block10;
                }
                v0 = null;
            }
            directForwardedPort = v0;
            Iterable $this$firstOrNull$iv = PerClientPortForwardingManager.Companion.getInstance(session).getPorts(portToForward);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ForwardedPort port = (ForwardedPort)element$iv;
                boolean bl = false;
                if (!PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)port.getConfiguration())) continue;
                v1 = element$iv;
                break block11;
            }
            v1 = null;
        }
        ForwardedPort reverseForwardedPort = v1;
        if (directForwardedPort == null && reverseForwardedPort == null) {
            ForwardedPort port = PerClientPortForwardingManager.forwardPort$default((PerClientPortForwardingManager)PerClientPortForwardingManager.Companion.getInstance(session), (int)portToForward, (PortType)PortType.TCP, (Set)SetsKt.setOf((Object)UNATTENDED_HOST_URL_OPENER_LABEL), null, null, (int)24, null);
            shouldRemovePort.element = true;
            v2 = port;
        } else {
            v2 = forwardedPort = directForwardedPort;
        }
        if (forwardedPort == null && reverseForwardedPort != null) {
            Logger $this$debug_u24default$iv = UnattendedHostOpenUrlHelper.logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Host port is reverse forwarded. Ignoring port replacing. Proceed with an open URL action.", t$iv);
            }
            action.invoke((Object)reverseForwardedPort.getTargetPortNumber());
            return;
        }
        if (forwardedPort == null) {
            UnattendedHostOpenUrlHelper.logger.warn("Port was not forwarded. Unable to complete browser URL action");
            return;
        }
        PortConfiguration portConfiguration = forwardedPort.getConfiguration();
        PortConfiguration.PerClientTcpForwarding perClientTcpForwarding = portConfiguration instanceof PortConfiguration.PerClientTcpForwarding ? (PortConfiguration.PerClientTcpForwarding)portConfiguration : null;
        Object object = portState = perClientTcpForwarding != null ? perClientTcpForwarding.getServerSocketPortState() : null;
        if (portState != null && portState instanceof ServerSocketPortState.Assigned) {
            action.invoke((Object)((ServerSocketPortState.Assigned)portState).getPort());
        } else {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable oneCallDisposable = disposable;
            forwardedPort.addPortListener(oneCallDisposable, new ForwardedPortListener(oneCallDisposable, shouldRemovePort, session, action){
                final /* synthetic */ Disposable $oneCallDisposable;
                final /* synthetic */ Ref.BooleanRef $shouldRemovePort;
                final /* synthetic */ ClientAppSession $session;
                final /* synthetic */ Function1<Integer, Unit> $action;
                {
                    this.$oneCallDisposable = $oneCallDisposable;
                    this.$shouldRemovePort = $shouldRemovePort;
                    this.$session = $session;
                    this.$action = $action;
                }

                public void stateChanged(ForwardedPort port, ServerSocketPortState newState) {
                    Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                    Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                    Disposer.dispose((Disposable)this.$oneCallDisposable);
                    if (newState instanceof ServerSocketPortState.FailedToAssign) {
                        UnattendedHostOpenUrlHelper.access$getLogger$p().warn("Failed to forward port, will not open url");
                        if (this.$shouldRemovePort.element) {
                            PerClientPortForwardingManager.Companion.getInstance(this.$session).removePort(port);
                        }
                    } else if (newState instanceof ServerSocketPortState.Assigned) {
                        this.$action.invoke((Object)((ServerSocketPortState.Assigned)newState).getPort());
                    }
                }
            });
        }
    }

    private final boolean ignorePortForwarding(int port) {
        Object[] objectArray = new Integer[]{BuiltInServerManager.Companion.getInstance().getPort()};
        Object[] ignoredPortsArray = objectArray;
        if (ArraysKt.contains((Object[])ignoredPortsArray, (Object)port)) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Port (" + port + ") is in the list of ports to be ignored for forwarding: " + ArraysKt.joinToString$default((Object[])ignoredPortsArray, null, null, null, (int)0, null, null, (int)63, null), t$iv);
            }
            return true;
        }
        return false;
    }

    private static final void openUrlOnControllerWithPortForward$lambda$2(Ref.BooleanRef $result, String $url, Project $project, WebBrowser $browser) {
        $result.element = INSTANCE.openUrlOnControllerWithPortForward($url, $project, $browser);
    }

    private static final Unit processForwarding$lambda$2(URI $uri, ForwardingOptions $portsToForward, Project $project, WebBrowser $browser, int it) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Port " + $portsToForward.getPortInAuthority() + " was forwarded to " + it, t$iv);
        }
        INSTANCE.processForwarding(UriUtilKt.withPort((URI)$uri, (int)it), new ForwardingOptions($portsToForward.getPortInQuery(), null), $project, $browser);
        return Unit.INSTANCE;
    }

    private static final Unit processForwarding$lambda$3(URI $uri, ForwardingOptions $portsToForward, Project $project, WebBrowser $browser, int it) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Port " + $portsToForward.getPortInQuery() + " was forwarded to " + it, t$iv);
        }
        URI urlWithUpdatedPort = UnattendedHostUriUtil.INSTANCE.replacePortInQuery($uri, $portsToForward.getPortInQuery().intValue(), it);
        INSTANCE.processForwarding(urlWithUpdatedPort, new ForwardingOptions(null, null), $project, $browser);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        UnattendedHostOpenUrlHelper $this$thisLogger$iv = INSTANCE = new UnattendedHostOpenUrlHelper();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UnattendedHostOpenUrlHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedHostOpenUrlHelper.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ&\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper$ForwardingOptions;", "", "portInQuery", "", "portInAuthority", "<init>", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "getPortInQuery", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPortInAuthority", "component1", "component2", "copy", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/rdserver/unattendedHost/browser/UnattendedHostOpenUrlHelper$ForwardingOptions;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.remoteController.backend"})
    public static final class ForwardingOptions {
        @Nullable
        private final Integer portInQuery;
        @Nullable
        private final Integer portInAuthority;

        public ForwardingOptions(@Nullable Integer portInQuery, @Nullable Integer portInAuthority) {
            this.portInQuery = portInQuery;
            this.portInAuthority = portInAuthority;
        }

        @Nullable
        public final Integer getPortInQuery() {
            return this.portInQuery;
        }

        @Nullable
        public final Integer getPortInAuthority() {
            return this.portInAuthority;
        }

        @Nullable
        public final Integer component1() {
            return this.portInQuery;
        }

        @Nullable
        public final Integer component2() {
            return this.portInAuthority;
        }

        @NotNull
        public final ForwardingOptions copy(@Nullable Integer portInQuery, @Nullable Integer portInAuthority) {
            return new ForwardingOptions(portInQuery, portInAuthority);
        }

        public static /* synthetic */ ForwardingOptions copy$default(ForwardingOptions forwardingOptions, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = forwardingOptions.portInQuery;
            }
            if ((n3 & 2) != 0) {
                n2 = forwardingOptions.portInAuthority;
            }
            return forwardingOptions.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ForwardingOptions(portInQuery=" + this.portInQuery + ", portInAuthority=" + this.portInAuthority + ")";
        }

        public int hashCode() {
            int result = this.portInQuery == null ? 0 : ((Object)this.portInQuery).hashCode();
            result = result * 31 + (this.portInAuthority == null ? 0 : ((Object)this.portInAuthority).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForwardingOptions)) {
                return false;
            }
            ForwardingOptions forwardingOptions = (ForwardingOptions)other;
            if (!Intrinsics.areEqual((Object)this.portInQuery, (Object)forwardingOptions.portInQuery)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.portInAuthority, (Object)forwardingOptions.portInAuthority);
        }
    }
}

