/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.portForwarding.ui.data;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.PortForwardingModel_GeneratedKt;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeControlWithValidationOnProperty;
import com.jetbrains.ide.model.uiautomation.BeGrid;
import com.jetbrains.ide.model.uiautomation.BeIcon;
import com.jetbrains.ide.model.uiautomation.BeLabel;
import com.jetbrains.ide.model.uiautomation.BeLink;
import com.jetbrains.ide.model.uiautomation.BeMargin;
import com.jetbrains.ide.model.uiautomation.BeRichText;
import com.jetbrains.ide.model.uiautomation.BeTextBox;
import com.jetbrains.ide.model.uiautomation.ValidationResult;
import com.jetbrains.ide.model.uiautomation.ValidationStates;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.ui.bedsl.BeDslButtonKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslEditableTextKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslLayouterKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslMiscKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslStyleKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslTextPresentationKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeValidationExtensionsKt;
import com.jetbrains.rd.ui.bedsl.dsl.HorizontalGridBuilder;
import com.jetbrains.rd.ui.bedsl.dsl.util.BeMarginsBuilder;
import com.jetbrains.rd.ui.bedsl.dsl.util.ValidationCheckResult;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.portForwarding.PortForwardingConfiguration;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortsFilter;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.PortForwardingBackendControlCenterColumns;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.PortForwardingStatus;
import com.jetbrains.rdserver.unattendedHost.portForwarding.ui.PortForwardingStatusProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 p2\u00020\u0001:\u0001pB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H&J\u0018\u0010;\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H&J\u000f\u0010<\u001a\u0004\u0018\u00010=H&\u00a2\u0006\u0002\u0010>J\u000f\u0010?\u001a\u0004\u0018\u00010=H&\u00a2\u0006\u0002\u0010>J\u0010\u0010@\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0006\u0010B\u001a\u00020AJ$\u0010C\u001a\b\u0012\u0004\u0012\u0002060D2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010FJ\u000e\u0010H\u001a\u00020A2\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010L\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010M\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J,\u0010N\u001a\u00020A2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0004J\u0017\u0010Q\u001a\u0004\u0018\u00010=2\u0006\u0010R\u001a\u00020\u0013H\u0004\u00a2\u0006\u0002\u0010SJ(\u0010T\u001a\u00020U2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u0013H\u0002J \u0010X\u001a\u00020U2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u0013H\u0002J\u0018\u0010Y\u001a\u00020U2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u0013H\u0002J\u001e\u0010Z\u001a\u00020:2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J \u0010\\\u001a\u0002082\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010]\u001a\u00020:2\u0006\u0010^\u001a\u00020:H\u0004J\u0010\u0010_\u001a\u00020`2\u0006\u0010R\u001a\u00020\u0013H\u0004J\u0014\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020`0bH\u0016J\u0014\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020`0bH\u0016J\u0010\u0010d\u001a\u00020\u001d2\u0006\u0010e\u001a\u00020=H\u0002J\u0010\u0010f\u001a\u00020\u001d2\u0006\u0010e\u001a\u00020=H\u0002J \u0010g\u001a\u00020A2\u0006\u0010h\u001a\u00020i2\u0006\u0010]\u001a\u00020:2\u0006\u0010j\u001a\u000208H\u0002J \u0010k\u001a\u00020A2\u0006\u0010]\u001a\u00020:2\u0006\u0010j\u001a\u0002082\u0006\u0010^\u001a\u00020:H\u0002J \u0010l\u001a\u00020A2\u0006\u0010m\u001a\u00020n2\u0006\u0010]\u001a\u00020:2\u0006\u0010o\u001a\u000208H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00140\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR!\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00140\u000b8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001c\u0010\u0018\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00140\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u001c\u0010\u001e\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00140\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001e\u0010 \u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00140\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001bR\u0012\u0010/\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010*R\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001bR\u0012\u00103\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006q"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/data/ForwardedPortUiData;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "forwardedPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "forwardedPortProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "getForwardedPortProperty", "()Lcom/jetbrains/rd/util/reactive/Property;", "statusProperty", "Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingStatusProperty;", "getStatusProperty", "()Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingStatusProperty;", "remotePortValueProperty", "", "Lorg/jetbrains/annotations/Nls;", "getRemotePortValueProperty$intellij_platform_remoteController_backend", "localPortValueProperty", "getLocalPortValueProperty$intellij_platform_remoteController_backend", "nameProperty", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getNameProperty", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "isReadOnlyProperty", "", "descriptionProperty", "getDescriptionProperty", "tooltipProperty", "getTooltipProperty", "myHasError", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "hasError", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "getHasError", "()Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "name", "getName", "()Ljava/lang/String;", "targetPortPrefix", "getTargetPortPrefix", "targetPortValueProperty", "getTargetPortValueProperty", "counterpartPortPrefix", "getCounterpartPortPrefix", "counterpartPortValueProperty", "getCounterpartPortValueProperty", "isReadOnly", "()Z", "getTargetPortControl", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "localPortUrl", "Lcom/jetbrains/ide/model/uiautomation/BeGrid;", "remotePortTextBox", "Lcom/jetbrains/ide/model/uiautomation/BeTextBox;", "getCounterpartPortControl", "getPortToForwardOrNull", "", "()Ljava/lang/Integer;", "getPreferedServerSocketPortNumberOrNull", "onReset", "", "reset", "asLineInTable", "", "columns", "", "Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingBackendControlCenterColumns;", "updateStateDependentData", "newState", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortState;", "updateTargetPortValueProperty", "updateNameProperty", "updateDescriptionProperty", "advisePortValueUpdate", "sourcePortProperty", "portToUpdateProperty", "getValidPortNumberOrNull", "portString", "(Ljava/lang/String;)Ljava/lang/Integer;", "createLocalUrlLink", "Lcom/jetbrains/ide/model/uiautomation/BeLink;", "localPortValue", "remotePortValue", "createDirectPortLocalUrlLink", "createReversePortLocalUrlLink", "createRemotePortTextBox", "portProperty", "createLocalPortWithUrl", "remotePortValueTextBox", "nameTextBox", "validatePortString", "Lcom/jetbrains/rd/ui/bedsl/dsl/util/ValidationCheckResult;", "getLocalPortTextBoxValidator", "Lkotlin/Function1;", "getRemotePortTextBoxValidator", "isBackendPortAlreadyForwarded", "port", "isFrontendPortAlreadyForwarded", "updatePortStatus", "status", "Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/PortForwardingStatus;", "localPortWithUrlGrid", "updateRowAsReadonly", "updateRowAsExposed", "portConfiguration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration$UrlExposure;", "localPortUrlGrid", "Companion", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nForwardedPortUiData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardedPortUiData.kt\ncom/jetbrains/rdserver/unattendedHost/portForwarding/ui/data/ForwardedPortUiData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,595:1\n1#2:596\n1586#3:597\n1661#3,3:598\n60#4,5:601\n60#4,5:606\n60#4,5:611\n60#4,5:616\n23#4:621\n*S KotlinDebug\n*F\n+ 1 ForwardedPortUiData.kt\ncom/jetbrains/rdserver/unattendedHost/portForwarding/ui/data/ForwardedPortUiData\n*L\n194#1:597\n194#1:598,3\n260#1:601,5\n263#1:606,5\n268#1:611,5\n274#1:616,5\n42#1:621\n*E\n"})
public abstract class ForwardedPortUiData {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Property<ForwardedPort> forwardedPortProperty;
    @NotNull
    private final PortForwardingStatusProperty statusProperty;
    @NotNull
    private final Property<String> remotePortValueProperty;
    @Nls
    @NotNull
    private final Property<String> localPortValueProperty;
    @NotNull
    private final IProperty<String> nameProperty;
    @NotNull
    private final IProperty<Boolean> isReadOnlyProperty;
    @NotNull
    private final IProperty<String> descriptionProperty;
    @NotNull
    private final Property<String> tooltipProperty;
    @NotNull
    private final IOptProperty<Boolean> myHasError;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Icon errorIcon;
    @NotNull
    private static final Icon forwardedIcon;

    public ForwardedPortUiData(@NotNull Lifetime lifetime, @Nullable ForwardedPort forwardedPort) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.forwardedPortProperty = new Property((Object)forwardedPort);
        this.statusProperty = new PortForwardingStatusProperty();
        this.remotePortValueProperty = new Property((Object)"");
        this.localPortValueProperty = new Property((Object)"");
        this.nameProperty = (IProperty)new Property((Object)"");
        this.isReadOnlyProperty = (IProperty)new Property((Object)false);
        this.descriptionProperty = (IProperty)new Property((Object)"");
        this.tooltipProperty = new Property((Object)"");
        this.myHasError = (IOptProperty)new OptProperty((Object)false);
        SourceExKt.adviseWithPrev((ISource)((ISource)this.forwardedPortProperty), (Lifetime)this.lifetime, (arg_0, arg_1) -> ForwardedPortUiData._init_$lambda$0(this, arg_0, arg_1));
    }

    public /* synthetic */ ForwardedPortUiData(Lifetime lifetime, ForwardedPort forwardedPort, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            forwardedPort = null;
        }
        this(lifetime, forwardedPort);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Property<ForwardedPort> getForwardedPortProperty() {
        return this.forwardedPortProperty;
    }

    @NotNull
    public final PortForwardingStatusProperty getStatusProperty() {
        return this.statusProperty;
    }

    @NotNull
    public final Property<String> getRemotePortValueProperty$intellij_platform_remoteController_backend() {
        return this.remotePortValueProperty;
    }

    @NotNull
    public final Property<String> getLocalPortValueProperty$intellij_platform_remoteController_backend() {
        return this.localPortValueProperty;
    }

    @NotNull
    public final IProperty<String> getNameProperty() {
        return this.nameProperty;
    }

    @NotNull
    public final IProperty<Boolean> isReadOnlyProperty() {
        return this.isReadOnlyProperty;
    }

    @NotNull
    public final IProperty<String> getDescriptionProperty() {
        return this.descriptionProperty;
    }

    @NotNull
    public final Property<String> getTooltipProperty() {
        return this.tooltipProperty;
    }

    @NotNull
    public final IOptPropertyView<Boolean> getHasError() {
        return (IOptPropertyView)this.myHasError;
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getTargetPortPrefix();

    @NotNull
    public abstract IProperty<String> getTargetPortValueProperty();

    @NotNull
    public abstract String getCounterpartPortPrefix();

    @NotNull
    public abstract IProperty<String> getCounterpartPortValueProperty();

    public abstract boolean isReadOnly();

    @NotNull
    public abstract BeControl getTargetPortControl(@NotNull BeGrid var1, @NotNull BeTextBox var2);

    @NotNull
    public abstract BeControl getCounterpartPortControl(@NotNull BeGrid var1, @NotNull BeTextBox var2);

    @Nullable
    public abstract Integer getPortToForwardOrNull();

    @Nullable
    public abstract Integer getPreferedServerSocketPortNumberOrNull();

    public abstract void onReset(@NotNull ForwardedPort var1);

    public final void reset() {
        ForwardedPort forwardedPort = (ForwardedPort)this.forwardedPortProperty.getValue();
        if (forwardedPort != null) {
            this.updateTargetPortValueProperty(forwardedPort);
            this.updateNameProperty(forwardedPort);
            this.updateDescriptionProperty(forwardedPort);
            this.onReset(forwardedPort);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BeControl> asLineInTable(@NotNull Lifetime lifetime, @Nullable Set<? extends PortForwardingBackendControlCenterColumns> columns) {
        List list;
        String string;
        BeIcon beIcon;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        BeIcon $this$asLineInTable_u24lambda_u240 = beIcon = BeDslMiscKt.icon((Lifetime)lifetime, (IPropertyView)((IPropertyView)this.statusProperty.getIcon()));
        boolean $i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22 = false;
        SourceExKt.flowInto((ISource)((ISource)this.tooltipProperty), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)$this$asLineInTable_u24lambda_u240.getTooltip()));
        BeIcon statusIcon = beIcon;
        BeTextBox nameTextBox = BeDslEditableTextKt.textBox$default(this.nameProperty, (Lifetime)lifetime, (boolean)false, null, null, (int)28, null);
        String string2 = this.getTargetPortPrefix().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String $i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22 = string2;
        if (((CharSequence)$i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22).length() > 0) {
            char p0 = $i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22.charAt(0);
            boolean $i$a$-replaceFirstCharWithChar-ForwardedPortUiData$asLineInTable$targetPortPrefixLabel$22 = false;
            p0 = Character.toTitleCase(p0);
            String $i$a$-replaceFirstCharWithChar-ForwardedPortUiData$asLineInTable$targetPortPrefixLabel$22 = $i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22;
            int n = 1;
            String string3 = $i$a$-replaceFirstCharWithChar-ForwardedPortUiData$asLineInTable$targetPortPrefixLabel$22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            $i$a$-replaceFirstCharWithChar-ForwardedPortUiData$asLineInTable$targetPortPrefixLabel$22 = string3;
            string = p0 + $i$a$-replaceFirstCharWithChar-ForwardedPortUiData$asLineInTable$targetPortPrefixLabel$22;
        } else {
            string = $i$a$-apply-ForwardedPortUiData$asLineInTable$statusIcon$22;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAY_ATTRIBUTES");
        BeControl targetPortPrefixLabel = BeDslStyleKt.withMargin((BeControl)((BeControl)BeDslTextPresentationKt.richText$default((RichTextModel)ProtocolConversionsKt.toRichText((String)string, (SimpleTextAttributes)simpleTextAttributes), null, (boolean)false, (int)6, null)), (BeMargin)BeMarginsBuilder.Companion.margin(20, 0, 20, 0));
        String string4 = this.getCounterpartPortPrefix().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAY_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAY_ATTRIBUTES");
        BeControl counterpartPortPrefixLabel = BeDslStyleKt.withMargin((BeControl)((BeControl)BeDslTextPresentationKt.richText$default((RichTextModel)ProtocolConversionsKt.toRichText((String)string4, (SimpleTextAttributes)simpleTextAttributes2), null, (boolean)false, (int)6, null)), (BeMargin)BeMarginsBuilder.Companion.margin(20, 0, 20, 0));
        SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAY_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"GRAY_ATTRIBUTES");
        BeRichText arrowLabel = BeDslTextPresentationKt.richText$default((RichTextModel)ProtocolConversionsKt.toRichText((String)"\u2192", (SimpleTextAttributes)simpleTextAttributes3), null, (boolean)false, (int)6, null);
        BeTextBox remotePortValueTextBox = this.createRemotePortTextBox(lifetime, (IProperty<String>)((IProperty)this.remotePortValueProperty));
        BeGrid localPortUrlGrid = this.createLocalPortWithUrl(lifetime, remotePortValueTextBox, nameTextBox);
        BeControl targetPortControl = this.getTargetPortControl(localPortUrlGrid, remotePortValueTextBox);
        BeControl counterpartPortControl = this.getCounterpartPortControl(localPortUrlGrid, remotePortValueTextBox);
        Set<? extends PortForwardingBackendControlCenterColumns> set = columns;
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PortForwardingBackendControlCenterColumns portForwardingBackendControlCenterColumns = (PortForwardingBackendControlCenterColumns)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1 -> (BeControl)statusIcon;
                    case 2 -> targetPortPrefixLabel;
                    case 3 -> targetPortControl;
                    case 4 -> (BeControl)arrowLabel;
                    case 5 -> counterpartPortPrefixLabel;
                    case 6 -> counterpartPortControl;
                    case 7 -> (BeControl)nameTextBox;
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List controls = list;
        return controls;
    }

    public final void updateStateDependentData(@NotNull ServerSocketPortState newState) {
        PortForwardingStatus portForwardingStatus;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        ServerSocketPortState serverSocketPortState = newState;
        if (serverSocketPortState instanceof ServerSocketPortState.Assigned) {
            this.getCounterpartPortValueProperty().set((Object)String.valueOf(((ServerSocketPortState.Assigned)newState).getPort()));
            portForwardingStatus = PortForwardingStatus.Success.INSTANCE;
        } else if (serverSocketPortState instanceof ServerSocketPortState.FailedToAssign) {
            portForwardingStatus = new PortForwardingStatus.Error(((ServerSocketPortState.FailedToAssign)newState).getReason());
        } else if (serverSocketPortState instanceof ServerSocketPortState.NotAssigned) {
            portForwardingStatus = PortForwardingStatus.Pending.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PortForwardingStatus status = portForwardingStatus;
        this.statusProperty.getStatus().set((Object)status);
    }

    private final void updateTargetPortValueProperty(ForwardedPort forwardedPort) {
        this.getTargetPortValueProperty().set((Object)String.valueOf(forwardedPort.getTargetPortNumber()));
    }

    private final void updateNameProperty(ForwardedPort forwardedPort) {
        String string = forwardedPort.getPresentation().getName();
        if (string == null) {
            string = "";
        }
        this.nameProperty.set((Object)string);
        this.nameProperty.advise(this.lifetime, arg_0 -> ForwardedPortUiData.updateNameProperty$lambda$0(forwardedPort, arg_0));
    }

    private final void updateDescriptionProperty(ForwardedPort forwardedPort) {
        String string = forwardedPort.getPresentation().getDescription();
        if (string == null) {
            string = "";
        }
        this.descriptionProperty.set((Object)string);
        this.descriptionProperty.advise(this.lifetime, arg_0 -> ForwardedPortUiData.updateDescriptionProperty$lambda$0(forwardedPort, arg_0));
    }

    protected final void advisePortValueUpdate(@NotNull Lifetime lifetime, @NotNull IProperty<String> sourcePortProperty, @NotNull IProperty<String> portToUpdateProperty) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sourcePortProperty, (String)"sourcePortProperty");
        Intrinsics.checkNotNullParameter(portToUpdateProperty, (String)"portToUpdateProperty");
        sourcePortProperty.advise(lifetime, arg_0 -> ForwardedPortUiData.advisePortValueUpdate$lambda$0(portToUpdateProperty, arg_0));
    }

    @Nullable
    protected final Integer getValidPortNumberOrNull(@NotNull String portString) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)portString, (String)"portString");
        Integer portNumber = StringsKt.toIntOrNull((String)portString);
        Logger $this$debug_u24default$iv = ForwardedPortUiData.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Get port number from property: " + portNumber, t$iv);
        }
        if (portNumber == null) {
            $this$debug_u24default$iv = ForwardedPortUiData.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unable to cast port number to integer: " + portString, t$iv);
            }
            return null;
        }
        boolean isPortValid = ForwardedPortUiData.Companion.isPortNumberValid(portNumber);
        Logger $this$debug_u24default$iv2 = ForwardedPortUiData.logger;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Is port <" + portString + "> valid: " + isPortValid, t$iv2);
        }
        if (!isPortValid) {
            return null;
        }
        $this$debug_u24default$iv2 = ForwardedPortUiData.logger;
        t$iv2 = null;
        $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Get port number from text box string: " + portNumber, t$iv2);
        }
        return portNumber;
    }

    private final BeLink createLocalUrlLink(Lifetime lifetime, ForwardedPort forwardedPort, String localPortValue, String remotePortValue) {
        return PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)forwardedPort.getConfiguration()) ? this.createReversePortLocalUrlLink(lifetime, localPortValue) : this.createDirectPortLocalUrlLink(lifetime, localPortValue, remotePortValue);
    }

    private final BeLink createDirectPortLocalUrlLink(Lifetime lifetime, String localPortValue, String remotePortValue) {
        return BeDslButtonKt.link$default((String)localPortValue, (Lifetime)lifetime, (String)("http://127.0.0.1:" + remotePortValue), null, null, (boolean)false, (boolean)false, (int)120, null);
    }

    private final BeLink createReversePortLocalUrlLink(Lifetime lifetime, String localPortValue) {
        return BeDslButtonKt.link$default((String)localPortValue, (Lifetime)lifetime, null, null, (boolean)false, () -> ForwardedPortUiData.createReversePortLocalUrlLink$lambda$0(localPortValue), (int)28, null);
    }

    private final BeTextBox createRemotePortTextBox(Lifetime lifetime, IProperty<String> portProperty) {
        Function1<String, ValidationCheckResult> validator = this.getRemotePortTextBoxValidator();
        BeTextBox textBox = (BeTextBox)BeValidationExtensionsKt.withValidationRule$default((BeControlWithValidationOnProperty)((BeControlWithValidationOnProperty)BeDslEditableTextKt.textBox$default(portProperty, (Lifetime)lifetime, (boolean)false, null, null, (int)28, null)), (Lifetime)lifetime, validator, null, (boolean)false, (int)12, null);
        textBox.getValidationResult().advise(lifetime, arg_0 -> ForwardedPortUiData.createRemotePortTextBox$lambda$0(this, arg_0));
        return textBox;
    }

    @NotNull
    protected final BeGrid createLocalPortWithUrl(@NotNull Lifetime lifetime, @NotNull BeTextBox remotePortValueTextBox, @NotNull BeTextBox nameTextBox) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)remotePortValueTextBox, (String)"remotePortValueTextBox");
        Intrinsics.checkNotNullParameter((Object)nameTextBox, (String)"nameTextBox");
        BeGrid portUrlGrid = BeDslLayouterKt.horizontalGrid$default(null, ForwardedPortUiData::createLocalPortWithUrl$lambda$0, (int)1, null);
        this.statusProperty.getStatus().advise(lifetime, arg_0 -> ForwardedPortUiData.createLocalPortWithUrl$lambda$1(this, remotePortValueTextBox, portUrlGrid, arg_0));
        this.forwardedPortProperty.advise(lifetime, arg_0 -> ForwardedPortUiData.createLocalPortWithUrl$lambda$2(this, remotePortValueTextBox, portUrlGrid, arg_0));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.isReadOnlyProperty), (Lifetime)lifetime, arg_0 -> ForwardedPortUiData.createLocalPortWithUrl$lambda$3(this, remotePortValueTextBox, portUrlGrid, nameTextBox, arg_0));
        return portUrlGrid;
    }

    @NotNull
    protected final ValidationCheckResult validatePortString(@NotNull String portString) {
        Intrinsics.checkNotNullParameter((Object)portString, (String)"portString");
        Integer portNumber = StringsKt.toIntOrNull((String)portString);
        if (portNumber == null) {
            return new ValidationCheckResult(SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.invalid.port", new Object[0]), null, ValidationStates.validationError, 2, null);
        }
        if (!ForwardedPortUiData.Companion.isPortNumberValid(portNumber)) {
            Object[] objectArray = new Object[]{portNumber, PortForwardingConfiguration.INSTANCE.getValidPortsRange().toString()};
            return new ValidationCheckResult(PlatformSplitBundle.INSTANCE.message("port.forwarding.error.port.out.of.valid.range.message", objectArray), null, ValidationStates.validationError, 2, null);
        }
        return new ValidationCheckResult(null, null, ValidationStates.validationPassed, 3, null);
    }

    @NotNull
    public Function1<String, ValidationCheckResult> getLocalPortTextBoxValidator() {
        return arg_0 -> ForwardedPortUiData.getLocalPortTextBoxValidator$lambda$0(this, arg_0);
    }

    @NotNull
    public Function1<String, ValidationCheckResult> getRemotePortTextBoxValidator() {
        return arg_0 -> ForwardedPortUiData.getRemotePortTextBoxValidator$lambda$0(this, arg_0);
    }

    private final boolean isBackendPortAlreadyForwarded(int port) {
        return !((Collection)ForwardedPortsFilter.INSTANCE.filterBackendForwardedPorts(PerClientPortForwardingManager.Companion.getInstance(UtilKt.getControllerSession((Application)ApplicationKt.getApplication())).getPorts(), port)).isEmpty();
    }

    private final boolean isFrontendPortAlreadyForwarded(int port) {
        return !((Collection)ForwardedPortsFilter.INSTANCE.filterFrontendForwardedPorts(PerClientPortForwardingManager.Companion.getInstance(UtilKt.getControllerSession((Application)ApplicationKt.getApplication())).getPorts(), port)).isEmpty();
    }

    private final void updatePortStatus(PortForwardingStatus status, BeTextBox remotePortValueTextBox, BeGrid localPortWithUrlGrid) {
        Icon icon = AllIcons.General.BalloonError;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
        Icon icon2 = icon;
        String tooltip = ForwardedPortUiData.Companion.getErrorTooltipMessage();
        ForwardedPort forwardedPort = (ForwardedPort)this.forwardedPortProperty.getValue();
        String localPortValue = (String)this.localPortValueProperty.getValue();
        String remotePortValue = (String)this.remotePortValueProperty.getValue();
        PortForwardingStatus portForwardingStatus = status;
        if (portForwardingStatus instanceof PortForwardingStatus.Success) {
            remotePortValueTextBox.getEnabled().set((Object)false);
            if (forwardedPort != null) {
                String string;
                BeLink localPortAddressLink = this.createLocalUrlLink(this.lifetime, forwardedPort, localPortValue, remotePortValue);
                BeDslLayouterKt.setElement$default((BeGrid)localPortWithUrlGrid, (BeControl)((BeControl)localPortAddressLink), null, (boolean)false, (int)6, null);
                Icon iconInsidePort = forwardedPort.getPresentation().getIcon();
                Icon icon3 = iconInsidePort;
                if (icon3 == null) {
                    icon3 = icon2 = forwardedIcon;
                }
                if ((string = forwardedPort.getPresentation().getTooltip()) == null) {
                    string = ForwardedPortUiData.Companion.getForwardedStateTooltipMessage();
                }
                tooltip = string;
            }
            v3 = Unit.INSTANCE;
        } else if (portForwardingStatus instanceof PortForwardingStatus.Pending) {
            icon2 = status.getDefaultIcon();
            tooltip = ((PortForwardingStatus.Pending)status).getMessage(forwardedPort);
            Function1<String, ValidationCheckResult> validator = this.getLocalPortTextBoxValidator();
            BeTextBox forwardingUrlTextBox = (BeTextBox)BeValidationExtensionsKt.withValidationRule$default((BeControlWithValidationOnProperty)((BeControlWithValidationOnProperty)BeDslEditableTextKt.textBox$default((IProperty)((IProperty)this.localPortValueProperty), (Lifetime)this.lifetime, (boolean)false, null, null, (int)28, null)), (Lifetime)this.lifetime, validator, null, (boolean)false, (int)12, null);
            forwardingUrlTextBox.getValidationResult().advise(this.lifetime, arg_0 -> ForwardedPortUiData.updatePortStatus$lambda$0(this, arg_0));
            v3 = BeDslLayouterKt.setElement$default((BeGrid)localPortWithUrlGrid, (BeControl)((BeControl)forwardingUrlTextBox), null, (boolean)false, (int)6, null);
        } else if (portForwardingStatus instanceof PortForwardingStatus.Error) {
            icon2 = errorIcon;
            tooltip = ForwardedPortUiData.Companion.getErrorTooltipMessage();
            BeLabel errorLabel = BeDslTextPresentationKt.label$default((String)ForwardedPortUiData.Companion.getErrorTooltipMessage(), null, (boolean)false, (int)6, null);
            v3 = BeDslLayouterKt.setElement$default((BeGrid)localPortWithUrlGrid, (BeControl)((BeControl)errorLabel), null, (boolean)false, (int)6, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.tooltipProperty.set((Object)tooltip);
        this.statusProperty.getIcon().set((Object)icon2);
    }

    private final void updateRowAsReadonly(BeTextBox remotePortValueTextBox, BeGrid localPortWithUrlGrid, BeTextBox nameTextBox) {
        this.tooltipProperty.set((Object)ForwardedPortUiData.Companion.getReadOnlyTooltipText());
        ForwardedPort forwardedPort = (ForwardedPort)this.forwardedPortProperty.getValue();
        if (forwardedPort != null) {
            BeLink localPortAddressLink = this.createLocalUrlLink(this.lifetime, forwardedPort, (String)this.localPortValueProperty.getValue(), (String)this.remotePortValueProperty.getValue());
            BeDslLayouterKt.setElement$default((BeGrid)localPortWithUrlGrid, (BeControl)((BeControl)localPortAddressLink), null, (boolean)false, (int)6, null);
        }
        remotePortValueTextBox.getEnabled().set((Object)false);
        localPortWithUrlGrid.getEnabled().set((Object)false);
        nameTextBox.getEnabled().set((Object)false);
    }

    private final void updateRowAsExposed(PortConfiguration.UrlExposure portConfiguration, BeTextBox remotePortValueTextBox, BeGrid localPortUrlGrid) {
        this.localPortValueProperty.set((Object)portConfiguration.getExposedUrl());
        BeLink link = BeDslButtonKt.link$default((String)((String)this.localPortValueProperty.getValue()), (Lifetime)this.lifetime, (String)portConfiguration.getExposedUrl(), null, null, (boolean)false, (boolean)false, (int)120, null);
        BeDslLayouterKt.setElement$default((BeGrid)localPortUrlGrid, (BeControl)((BeControl)link), null, (boolean)false, (int)6, null);
        remotePortValueTextBox.getEnabled().set((Object)false);
        localPortUrlGrid.getEnabled().set((Object)false);
    }

    private static final Unit _init_$lambda$0(ForwardedPortUiData this$0, Maybe previous, ForwardedPort current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (previous.getAsNullable() != null) {
            this$0.reset();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateNameProperty$lambda$0(ForwardedPort $forwardedPort, String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        $forwardedPort.getPresentation().setName(name);
        return Unit.INSTANCE;
    }

    private static final Unit updateDescriptionProperty$lambda$0(ForwardedPort $forwardedPort, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        $forwardedPort.getPresentation().setDescription(description);
        return Unit.INSTANCE;
    }

    private static final Unit advisePortValueUpdate$lambda$0(IProperty $portToUpdateProperty, String port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Integer portNumber = StringsKt.toIntOrNull((String)port);
        String portToUse = portNumber != null && ForwardedPortUiData.Companion.isPortNumberValid(portNumber) ? port : "";
        $portToUpdateProperty.set((Object)portToUse);
        return Unit.INSTANCE;
    }

    private static final Unit createReversePortLocalUrlLink$lambda$0(String $localPortValue) {
        PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol((ClientAppSession)UtilKt.getControllerSession((Application)ApplicationKt.getApplication())))).getOpenUrlInBrowser().fire((Object)("http://127.0.0.1:" + $localPortValue));
        return Unit.INSTANCE;
    }

    private static final Unit createRemotePortTextBox$lambda$0(ForwardedPortUiData this$0, ValidationResult validationResult) {
        Intrinsics.checkNotNullParameter((Object)validationResult, (String)"validationResult");
        this$0.myHasError.set((Object)(validationResult.getState() != ValidationStates.validationPassed ? 1 : 0));
        return Unit.INSTANCE;
    }

    private static final Unit createLocalPortWithUrl$lambda$0(HorizontalGridBuilder $this$horizontalGrid) {
        Intrinsics.checkNotNullParameter((Object)$this$horizontalGrid, (String)"$this$horizontalGrid");
        return Unit.INSTANCE;
    }

    private static final Unit createLocalPortWithUrl$lambda$1(ForwardedPortUiData this$0, BeTextBox $remotePortValueTextBox, BeGrid $portUrlGrid, PortForwardingStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this$0.reset();
        this$0.updatePortStatus(status, $remotePortValueTextBox, $portUrlGrid);
        return Unit.INSTANCE;
    }

    private static final Unit createLocalPortWithUrl$lambda$2(ForwardedPortUiData this$0, BeTextBox $remotePortValueTextBox, BeGrid $portUrlGrid, ForwardedPort port) {
        if (port != null && PortConfigurationKt.isExposedPort((PortConfiguration)port.getConfiguration())) {
            PortConfiguration portConfiguration = port.getConfiguration();
            Intrinsics.checkNotNull((Object)portConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration.UrlExposure");
            this$0.updateRowAsExposed((PortConfiguration.UrlExposure)portConfiguration, $remotePortValueTextBox, $portUrlGrid);
            return Unit.INSTANCE;
        }
        this$0.updatePortStatus((PortForwardingStatus)this$0.statusProperty.getStatus().getValue(), $remotePortValueTextBox, $portUrlGrid);
        return Unit.INSTANCE;
    }

    private static final Unit createLocalPortWithUrl$lambda$3(ForwardedPortUiData this$0, BeTextBox $remotePortValueTextBox, BeGrid $portUrlGrid, BeTextBox $nameTextBox, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateRowAsReadonly($remotePortValueTextBox, $portUrlGrid, $nameTextBox);
        return Unit.INSTANCE;
    }

    private static final ValidationCheckResult getLocalPortTextBoxValidator$lambda$0(ForwardedPortUiData this$0, String portString) {
        Intrinsics.checkNotNullParameter((Object)portString, (String)"portString");
        if (StringsKt.isBlank((CharSequence)portString)) {
            return new ValidationCheckResult(null, null, ValidationStates.validationPassed, 3, null);
        }
        ValidationCheckResult portBaseValidationResult = this$0.validatePortString(portString);
        if (portBaseValidationResult.getStates() != ValidationStates.validationPassed) {
            return portBaseValidationResult;
        }
        Integer portNumber = StringsKt.toIntOrNull((String)portString);
        if (portNumber == null) {
            ValidationStates validationStates = ValidationStates.validationError;
            String string = SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.invalid.port", new Object[0]);
            return new ValidationCheckResult(string, null, validationStates, 2, null);
        }
        if (this$0.isFrontendPortAlreadyForwarded(portNumber)) {
            ValidationStates validationStates = ValidationStates.validationError;
            String string = SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.local.port.already.forwarded", new Object[0]);
            return new ValidationCheckResult(string, null, validationStates, 2, null);
        }
        return new ValidationCheckResult(null, null, ValidationStates.validationPassed, 3, null);
    }

    private static final ValidationCheckResult getRemotePortTextBoxValidator$lambda$0(ForwardedPortUiData this$0, String portString) {
        Intrinsics.checkNotNullParameter((Object)portString, (String)"portString");
        ValidationCheckResult portBaseValidationResult = this$0.validatePortString(portString);
        if (portBaseValidationResult.getStates() != ValidationStates.validationPassed) {
            return portBaseValidationResult;
        }
        int portNumber = Integer.parseInt(portString);
        if (this$0.isBackendPortAlreadyForwarded(portNumber)) {
            ValidationStates validationStates = ValidationStates.validationError;
            String string = SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.remote.port.already.forwarded", new Object[0]);
            return new ValidationCheckResult(string, null, validationStates, 2, null);
        }
        return new ValidationCheckResult(null, null, ValidationStates.validationPassed, 3, null);
    }

    private static final Unit updatePortStatus$lambda$0(ForwardedPortUiData this$0, ValidationResult validationResult) {
        Intrinsics.checkNotNullParameter((Object)validationResult, (String)"validationResult");
        this$0.myHasError.set((Object)(validationResult.getState() != ValidationStates.validationPassed ? 1 : 0));
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ForwardedPortUiData.logger = logger;
        Icon icon = AllIcons.General.BalloonError;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
        errorIcon = icon;
        Icon icon2 = AllIcons.General.InspectionsOK;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InspectionsOK");
        forwardedIcon = icon2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0013\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/portForwarding/ui/data/ForwardedPortUiData$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "errorTooltipMessage", "", "getErrorTooltipMessage", "()Ljava/lang/String;", "errorIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "forwardedStateTooltipMessage", "getForwardedStateTooltipMessage", "forwardedIcon", "readOnlyTooltipText", "getReadOnlyTooltipText", "isPortNumberValid", "", "port", "", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final String getErrorTooltipMessage() {
            return SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.port.state.error", new Object[0]);
        }

        private final String getForwardedStateTooltipMessage() {
            return SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.port.state.forwarded", new Object[0]);
        }

        private final String getReadOnlyTooltipText() {
            return SplitBackendBundle.INSTANCE.message("backend.control.center.port.forwarding.tab.port.state.readonly", new Object[0]);
        }

        private final boolean isPortNumberValid(int port) {
            IntRange intRange = PortForwardingConfiguration.INSTANCE.getValidPortsRange();
            int n = intRange.getFirst();
            return port <= intRange.getLast() ? n <= port : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortForwardingBackendControlCenterColumns.values().length];
            try {
                nArray[PortForwardingBackendControlCenterColumns.STATUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.TARGET_PORT_PREFIX_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.TARGET_PORT_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.ARROW_TEXT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.COUNTERPART_PORT_PREFIX_TEXT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.COUNTERPART_PORT_VALUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortForwardingBackendControlCenterColumns.NAME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

