/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.maven.MavenJpsBundle;
import org.jetbrains.jps.maven.compiler.MavenFilteredJarModuleBuilder;
import org.jetbrains.jps.maven.compiler.MavenPatternFileFilter;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;

public final class MavenResourcesBuilder
extends TargetBuilder<MavenResourceRootDescriptor, MavenResourcesTarget> {
    private static final Logger LOG = Logger.getInstance(MavenResourcesBuilder.class);

    public MavenResourcesBuilder() {
        super(Arrays.asList(MavenResourcesTargetType.PRODUCTION, MavenResourcesTargetType.TEST));
    }

    public void build(final @NotNull MavenResourcesTarget target, @NotNull DirtyFilesHolder<MavenResourceRootDescriptor, MavenResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(3);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig == null) {
            context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.ERROR, MavenJpsBundle.message("maven.project.configuration.required", target.getModule().getName())));
            throw new StopBuildException();
        }
        MavenModuleResourceConfiguration config = target.getModuleResourcesConfiguration(dataPaths);
        if (config == null) {
            return;
        }
        List<MavenFilteredJarConfiguration> jarConfigurations = MavenFilteredJarModuleBuilder.getJarsConfig(context, target);
        final HashMap files = new HashMap();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<MavenResourceRootDescriptor, MavenResourcesTarget>(){

            public boolean apply(@NotNull MavenResourcesTarget t, @NotNull File file, @NotNull MavenResourceRootDescriptor rd) throws IOException {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rd == null) {
                    1.$$$reportNull$$$0(2);
                }
                assert (target == t);
                ArrayList<File> fileList = (ArrayList<File>)files.get((Object)rd);
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    files.put(rd, fileList);
                }
                fileList.add(file);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "t";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rd";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder$1";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MavenResourceRootDescriptor[] roots = files.keySet().toArray(new MavenResourceRootDescriptor[0]);
        Arrays.sort(roots, (r1, r2) -> {
            int res = r1.getIndexInPom() - r2.getIndexInPom();
            if (r1.isOverwrite()) {
                assert (r2.isOverwrite());
                return res;
            }
            if (r1.getConfiguration().isFiltered && !r2.getConfiguration().isFiltered) {
                return 1;
            }
            if (!r1.getConfiguration().isFiltered && r2.getConfiguration().isFiltered) {
                return -1;
            }
            if (!r1.getConfiguration().isFiltered) {
                res = -res;
            }
            return res;
        });
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfig, target.getModule().getProject(), config);
        context.processMessage((BuildMessage)new ProgressMessage(MavenJpsBundle.message("copying.resources", target.getModule().getName())));
        for (MavenResourceRootDescriptor rd : roots) {
            for (File file : (List)files.get((Object)rd)) {
                String relPath = FileUtil.getRelativePath((File)rd.getRootFile(), (File)file);
                if (relPath == null) continue;
                String outputDirectory = target.isTests() ? config.testOutputDirectory : config.outputDirectory;
                File outputDir = MavenResourcesTarget.getOutputDir(target.getModuleOutputDir(), rd.getConfiguration(), outputDirectory);
                if (outputDir == null) continue;
                File outputFile = new File(outputDir, relPath);
                String sourcePath = file.getPath();
                try {
                    fileProcessor.copyFile(file, outputFile, rd.getConfiguration(), context, FileFilters.EVERYTHING);
                    outputConsumer.registerOutputFile(outputFile, Collections.singleton(sourcePath));
                    this.copyToAdditionalJars(jarConfigurations, outputDir, relPath, context, outputConsumer);
                }
                catch (UnsupportedEncodingException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.INFO, MavenJpsBundle.message("resource.was.not.copied", e.getMessage()), sourcePath));
                }
                catch (IOException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.ERROR, MavenJpsBundle.message("failed.to.copy.0.to.1.2", sourcePath, outputFile.getAbsolutePath(), CompilerMessage.getTextFromThrowable((Throwable)e))));
                    LOG.info((Throwable)e);
                }
                if (!context.isCanceled()) continue;
                return;
            }
        }
        context.checkCanceled();
        context.processMessage((BuildMessage)new ProgressMessage(""));
    }

    private void copyToAdditionalJars(List<MavenFilteredJarConfiguration> configurations, File outputDir, String relPath, @NotNull CompileContext context, @NotNull BuildOutputConsumer consumer) throws IOException {
        if (context == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(5);
        }
        if (configurations.isEmpty()) {
            return;
        }
        List applicableConfigurations = ContainerUtil.filter(configurations, it -> FileUtil.filesEqual((File)outputDir, (File)new File(it.originalOutput)));
        for (MavenFilteredJarConfiguration config : applicableConfigurations) {
            MavenPatternFileFilter filter = new MavenPatternFileFilter(config.includes, config.excludes);
            if (!filter.accept(relPath)) continue;
            File from = new File(outputDir, relPath);
            File to = new File(new File(config.jarOutput), relPath);
            FSOperations.copy((File)from, (File)to);
        }
    }

    @NotNull
    public String getPresentableName() {
        String string = MavenJpsBundle.message("maven.resources.compiler", new Object[0]);
        if (string == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyToAdditionalJars";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

