/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.codeInsight.completion;

import com.intellij.codeInsight.completion.XmlCharFilter;
import com.intellij.codeInsight.editorActions.XmlAutoPopupHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.jsp.psi.BaseJspUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;

public final class JspCharFilter
extends CharFilter {
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        if (lookup == null) {
            JspCharFilter.$$$reportNull$$$0(0);
        }
        if (!XmlCharFilter.isInXmlContext((Lookup)lookup) || !BaseJspUtil.isInJspFile(lookup.getPsiFile())) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        switch (c) {
            case '-': {
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '/': 
            case '<': 
            case '[': {
                if (XmlCharFilter.isWithinTag((Lookup)lookup)) {
                    if (prefixLength > 0) {
                        return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                    }
                    XmlAutoPopupHandler.autoPopupXmlLookup((Project)lookup.getProject(), (Editor)lookup.getEditor());
                    return CharFilter.Result.HIDE_LOOKUP;
                }
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '\"': 
            case '\'': {
                int offset = lookup.getEditor().getCaretModel().getOffset();
                XmlAttributeValue attr = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)lookup.getPsiFile(), (int)offset, XmlAttributeValue.class, (boolean)false);
                if (attr != null) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
                return CharFilter.Result.HIDE_LOOKUP;
            }
            case '>': {
                if (prefixLength <= 0) break;
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/jsp/codeInsight/completion/JspCharFilter", "acceptChar"));
    }
}

