/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.jspJava;

import com.intellij.application.options.CodeStyle;
import com.intellij.jsp.javaee.web.options.JspCodeStyleSettings;
import com.intellij.jsp.jspJava.JspxImportListAttribute;
import com.intellij.jsp.jspJava.JspxStaticImportStatement;
import com.intellij.jsp.util.JspElementType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxImportListImpl
extends CompositePsiElement
implements JspxImportList {
    public JspxImportListImpl() {
        super(JspElementType.JSP_IMPORT_LIST_WRAPPER);
    }

    private JspxImportListAttribute[] computeAttributes(boolean checkIncludes) {
        ArrayList<JspxImportListAttribute> listAttributes = new ArrayList<JspxImportListAttribute>();
        for (XmlTag xmlTag : this.getAllImportDirectives(checkIncludes)) {
            for (XmlAttribute attribute : xmlTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                listAttributes.add(new JspxImportListAttribute(attribute, (PsiElement)this));
            }
        }
        return listAttributes.toArray(new JspxImportListAttribute[0]);
    }

    private List<XmlTag> getAllImportDirectives(boolean checkIncludes) {
        ArrayList<XmlTag> importStatements = new ArrayList<XmlTag>();
        block0: for (XmlTag directiveTag : this.getJspRoot().getDirectiveTags(JspDirectiveKind.PAGE, checkIncludes)) {
            for (XmlAttribute attribute : directiveTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                importStatements.add(directiveTag);
                continue block0;
            }
        }
        return importStatements;
    }

    private JspFile getJspRoot() {
        FileViewProvider viewProvider = this.getContainingFile().getViewProvider();
        return (JspFile)viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public PsiImportStatement @NotNull [] getImportStatements() {
        JspxImportListAttribute[] importAttributes = this.getImportAttributes();
        ArrayList importStatements = new ArrayList(importAttributes.length);
        for (JspxImportListAttribute importAttribute : importAttributes) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getImportStatements());
        }
        PsiImportStatement[] psiImportStatementArray = importStatements.isEmpty() ? PsiImportStatement.EMPTY_ARRAY : importStatements.toArray(PsiImportStatement.EMPTY_ARRAY);
        if (psiImportStatementArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(0);
        }
        return psiImportStatementArray;
    }

    private synchronized JspxImportListAttribute[] getImportAttributes() {
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            return this.computeAttributes(false);
        }
        return (JspxImportListAttribute[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            JspxImportListAttribute[] attributes = this.computeAttributes(true);
            return new CachedValueProvider.Result((Object)attributes, new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public PsiImportStaticStatement @NotNull [] getImportStaticStatements() {
        ArrayList importStatements = new ArrayList();
        for (JspxImportListAttribute importAttribute : this.getImportAttributes()) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getStaticImportStatements());
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStatements.toArray(PsiImportStaticStatement.EMPTY_ARRAY);
        if (psiImportStaticStatementArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(1);
        }
        return psiImportStaticStatementArray;
    }

    public PsiImportModuleStatement @NotNull [] getImportModuleStatements() {
        if (PsiImportModuleStatement.EMPTY_ARRAY == null) {
            JspxImportListImpl.$$$reportNull$$$0(2);
        }
        return PsiImportModuleStatement.EMPTY_ARRAY;
    }

    public PsiImportStatementBase @NotNull [] getAllImportStatements() {
        ArrayList importStatements = new ArrayList();
        for (JspxImportListAttribute attribute : this.getImportAttributes()) {
            ContainerUtil.addAll(importStatements, (Object[])attribute.getAllImportStatements());
        }
        PsiImportStatementBase[] psiImportStatementBaseArray = importStatements.toArray(PsiImportStatementBase.EMPTY_ARRAY);
        if (psiImportStatementBaseArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(3);
        }
        return psiImportStatementBaseArray;
    }

    public PsiImportStatement findSingleClassImportStatement(String qName) {
        return (PsiImportStatement)this.findImportStatement(qName);
    }

    @Nullable
    private PsiImportStatementBase findImportStatement(String text) {
        for (PsiImportStatementBase importStatement : this.getAllImportStatements()) {
            JspxImportStatement statement;
            JspxStaticImportStatement statement2;
            if (!(importStatement instanceof JspxStaticImportStatement ? text.equals((statement2 = (JspxStaticImportStatement)importStatement).getQualifiedName()) : importStatement instanceof JspxImportStatement && text.equals((statement = (JspxImportStatement)importStatement).getQualifiedName()))) continue;
            return importStatement;
        }
        return null;
    }

    public PsiImportStatement findOnDemandImportStatement(String packageName) {
        return (PsiImportStatement)this.findImportStatement(packageName + ".*");
    }

    @Nullable
    public PsiImportModuleStatement findImportModuleStatement(String moduleName) {
        return null;
    }

    public PsiImportStatementBase findSingleImportStatement(String name) {
        return this.findImportStatement(name);
    }

    public boolean isReplaceEquivalent(PsiImportList otherList) {
        PsiImportStatementBase[] importStatements2;
        PsiImportStatementBase[] importStatements1 = this.getAllImportStatements();
        if (importStatements1.length != (importStatements2 = otherList.getAllImportStatements()).length) {
            return false;
        }
        for (int i = 0; i < importStatements1.length; ++i) {
            PsiImportStaticStatement statement2;
            PsiImportStatementBase importStatement2 = importStatements2[i];
            PsiImportStatementBase psiImportStatementBase = importStatements1[i];
            if (!(psiImportStatementBase instanceof JspxImportStatement)) {
                return false;
            }
            JspxImportStatement jspxImportStatement = (JspxImportStatement)psiImportStatementBase;
            if (jspxImportStatement.isOnDemand() != importStatement2.isOnDemand()) {
                return false;
            }
            if (jspxImportStatement instanceof JspxStaticImportStatement) {
                if (!(importStatement2 instanceof PsiImportStaticStatement)) {
                    return false;
                }
                statement2 = (PsiImportStaticStatement)importStatement2;
                if (Comparing.strEqual((String)jspxImportStatement.getQualifiedName(), (String)statement2.getQualifiedName())) continue;
                return false;
            }
            if (!(importStatement2 instanceof PsiImportStatement)) {
                return false;
            }
            statement2 = (PsiImportStatement)importStatement2;
            if (Comparing.strEqual((String)jspxImportStatement.getQualifiedName(), (String)statement2.getQualifiedName())) continue;
            return false;
        }
        if (importStatements1.length > 1) {
            return ((JspCodeStyleSettings)CodeStyle.getSettings((PsiFile)this.getJspRoot()).getCustomSettings(JspCodeStyleSettings.class)).JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST ? this.getImportAttributes().length <= 1 : this.getImportAttributes().length >= importStatements1.length;
        }
        return true;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiImportStatementBase lastStatement;
        if (element == null) {
            JspxImportListImpl.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiImportStatement) && !(element instanceof PsiImportStaticStatement)) {
            throw new IncorrectOperationException("Cannot add anything but import statements into JSP import list: " + String.valueOf(element));
        }
        PsiImportStatementBase importStatement = (PsiImportStatementBase)element;
        PsiImportStatementBase[] statements = this.getAllImportStatements();
        PsiImportStatementBase psiImportStatementBase = lastStatement = statements.length > 0 ? statements[statements.length - 1] : null;
        if (((JspCodeStyleSettings)CodeStyle.getSettings((PsiFile)this.getJspRoot()).getCustomSettings(JspCodeStyleSettings.class)).JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST && lastStatement != null) {
            lastStatement.add(element);
        } else {
            Object object;
            XmlTag rootTag = this.getJspRoot().getRootTag();
            XmlTag lastImportDirective = this.findLastImportDirective();
            ASTNode anchor = lastImportDirective != null ? lastImportDirective.getNode() : XmlChildRole.START_TAG_END_FINDER.findChild(rootTag.getNode());
            ASTNode parent = anchor == null ? null : TreeUtil.findParent((ASTNode)anchor, (IElementType)XmlElementType.XML_TAG);
            XmlTag directive = this.getJspRoot().createDirective(parent != null ? (XmlTag)parent.getPsi() : null, JspDirectiveKind.PAGE);
            if (importStatement instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement statement = (PsiImportStaticStatement)importStatement;
                object = "static " + statement.getQualifiedName();
            } else {
                object = ((PsiImportStatement)importStatement).getQualifiedName();
            }
            String qualifiedName = object;
            @NonNls String text = qualifiedName + (importStatement.isOnDemand() ? ".*" : "");
            directive.setAttribute("import", text);
            if (anchor != null) {
                anchor.getTreeParent().getPsi().addAfter((PsiElement)directive, anchor.getPsi());
            } else {
                rootTag.add((PsiElement)directive);
            }
        }
        PsiImportStaticStatement[] importStatements = importStatement instanceof PsiImportStaticStatement ? this.getImportStaticStatements() : this.getImportStatements();
        return importStatements[importStatements.length - 1];
    }

    @Nullable
    private XmlTag findLastImportDirective() {
        List<XmlTag> importDirectives = this.getAllImportDirectives(false);
        return importDirectives.isEmpty() ? null : importDirectives.getLast();
    }

    public void delete() {
        for (PsiImportStatement importStatement : this.getImportStatements()) {
            importStatement.delete();
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) {
        if (newElement == null) {
            JspxImportListImpl.$$$reportNull$$$0(5);
        }
        if (!(newElement instanceof PsiImportList)) {
            throw new IncorrectOperationException("Can't replace import list with " + String.valueOf(newElement));
        }
        PsiImportList importList = (PsiImportList)newElement;
        PsiImportStatementBase[] jspxImportStatements = this.getAllImportStatements();
        PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
        ArrayList<PsiImportStatementBase> localImports = new ArrayList<PsiImportStatementBase>(jspxImportStatements.length);
        ArrayList<PsiImportStatementBase> includedImports = new ArrayList<PsiImportStatementBase>(jspxImportStatements.length);
        for (PsiImportStatementBase jspxImportStatement : jspxImportStatements) {
            if (jspxImportStatement.isForeignFileImport()) {
                includedImports.add(jspxImportStatement);
                continue;
            }
            localImports.add(jspxImportStatement);
        }
        block1: for (PsiImportStatementBase statement : importStatements) {
            PsiJavaCodeReferenceElement importReference = statement.getImportReference();
            if (importReference == null) continue;
            for (PsiImportStatementBase includedImport : includedImports) {
                PsiJavaCodeReferenceElement reference = includedImport.getImportReference();
                if (reference == null || !reference.getText().equals(importReference.getText())) continue;
                continue block1;
            }
            this.add((PsiElement)statement);
        }
        for (PsiImportStatementBase anImport : localImports) {
            anImport.delete();
        }
        return this;
    }

    public String toString() {
        return "JspxImportList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/jspJava/JspxImportListImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportModuleStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/jspJava/JspxImportListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

