/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.viewers;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUtil;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.diff.outputs.JupyterDiffOutputViewer;
import com.intellij.jupyter.diff.util.JupyterDiffModel;
import com.intellij.jupyter.diff.util.JupyterDiffViewerUtils;
import com.intellij.jupyter.diff.util.JupyterMyersDiffPostProcessor;
import com.intellij.jupyter.diff.util.JupyterSimpleDiffChangeUi;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\r\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/diff/viewers/JupyterDiffViewer;", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "<init>", "(Lcom/intellij/diff/DiffContext;Lcom/intellij/diff/requests/DiffRequest;)V", "myDiffOutputViewer", "Lcom/intellij/jupyter/diff/outputs/JupyterDiffOutputViewer;", "postProcessor", "Lcom/intellij/jupyter/diff/util/JupyterMyersDiffPostProcessor;", "computeDifferences", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getEditors", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "onAfterRediff", "", "getStatusTextMessage", "", "Lorg/jetbrains/annotations/Nls;", "createUi", "Lcom/intellij/diff/tools/simple/SimpleDiffChangeUi;", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nJupyterDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDiffViewer.kt\ncom/intellij/jupyter/diff/viewers/JupyterDiffViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1915#2,2:129\n1915#2,2:131\n1834#2,4:133\n1834#2,4:137\n*S KotlinDebug\n*F\n+ 1 JupyterDiffViewer.kt\ncom/intellij/jupyter/diff/viewers/JupyterDiffViewer\n*L\n90#1:129,2\n97#1:131,2\n114#1:133,4\n119#1:137,4\n*E\n"})
public final class JupyterDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final JupyterDiffOutputViewer myDiffOutputViewer;
    @NotNull
    private final JupyterMyersDiffPostProcessor postProcessor;

    public JupyterDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(context, request);
        this.myDiffOutputViewer = new JupyterDiffOutputViewer();
        this.postProcessor = new JupyterMyersDiffPostProcessor();
        this.setModel(new JupyterDiffModel(this));
        this.getFoldingModel().setEnabled(false);
        this.aligningViewModeSupported = false;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        boolean isContentsEqual;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        Document document = this.getContent1().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document1 = document;
        Document document2 = this.getContent2().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document22 = document2;
        CharSequence charSequence = document1.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text1 = charSequence;
        CharSequence charSequence2 = document22.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        CharSequence text2 = charSequence2;
        List lineFragmentsRaw = this.myTextDiffProvider.compare(text1, text2, indicator);
        List<LineFragment> lineFragments = this.postProcessor.adjustLineFragments(lineFragmentsRaw, document1, document22);
        if (Registry.Companion.is("jupyter.diff.viewer.output")) {
            ActionsKt.runReadAction(() -> JupyterDiffViewer.computeDifferences$lambda$0(this));
        }
        boolean bl = Registry.Companion.is("jupyter.diff.viewer.output") ? ((collection = (Collection)lineFragments) == null || collection.isEmpty()) && StringUtil.equals((CharSequence)text1, (CharSequence)text2) && this.myDiffOutputViewer.isOutputDiffChangesEmpty() : (isContentsEqual = ((collection = (Collection)lineFragments) == null || collection.isEmpty()) && StringUtil.equals((CharSequence)text1, (CharSequence)text2));
        if (lineFragments == null) {
            runnable = this.apply(null, isContentsEqual);
        } else {
            List changes = new ArrayList();
            for (LineFragment fragment : lineFragments) {
                changes.add(new SimpleDiffChange(changes.size(), fragment));
            }
            runnable = this.apply(changes, isContentsEqual);
        }
        Runnable runnable2 = runnable;
        Intrinsics.checkNotNull((Object)runnable2);
        Runnable runnable3 = runnable2;
        return () -> JupyterDiffViewer.computeDifferences$lambda$1(runnable3, isContentsEqual, this);
    }

    @NotNull
    public List<EditorEx> getEditors() {
        List list = super.getEditors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEditors(...)");
        List editors = list;
        Iterable $this$forEach$iv = editors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx editor = (EditorEx)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)editor);
            NotebookCellLinesProvider.Companion.install((Editor)editor);
        }
        return editors;
    }

    protected void onAfterRediff() {
        Iterable $this$forEach$iv = this.getEditors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx it = (EditorEx)element$iv;
            boolean bl = false;
            JupyterDiffViewerUtils.INSTANCE.paintEditor(it);
        }
        if (Registry.Companion.is("jupyter.diff.viewer.output")) {
            EditorEx editorEx = this.getEditor1();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor1(...)");
            Editor editor = (Editor)editorEx;
            EditorEx editorEx2 = this.getEditor2();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getEditor2(...)");
            this.myDiffOutputViewer.highlightChangedOutputs(editor, (Editor)editorEx2);
        }
        super.onAfterRediff();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getStatusTextMessage() {
        int n;
        if (this.myTextDiffProvider.isHighlightingDisabled()) {
            String string = DiffBundle.message((String)"diff.highlighting.disabled.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        List list = this.myModel.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllChanges(...)");
        List allChanges = list;
        if (Registry.Companion.is("jupyter.diff.viewer.output")) {
            int n2;
            void $this$count$iv;
            Iterable iterable = allChanges;
            int n3 = allChanges.size() + this.myDiffOutputViewer.getOutputChangesCount();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    SimpleDiffChange it = (SimpleDiffChange)element$iv;
                    boolean bl = false;
                    if (!it.isExcluded() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int n4 = n2;
            String string = DiffUtil.getStatusText((int)n3, (int)n4, (ThreeState)this.myModel.isContentsEqual());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatusText(...)");
            return string;
        }
        Iterable $this$count$iv = allChanges;
        int n5 = allChanges.size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SimpleDiffChange it = (SimpleDiffChange)element$iv;
                boolean bl = false;
                if (!it.isExcluded() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n6 = n;
        String string = DiffUtil.getStatusText((int)n5, (int)n6, (ThreeState)this.myModel.isContentsEqual());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatusText(...)");
        return string;
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return new JupyterSimpleDiffChangeUi(this, change);
    }

    private static final Unit computeDifferences$lambda$0(JupyterDiffViewer this$0) {
        JupyterDiffOutputViewer jupyterDiffOutputViewer = this$0.myDiffOutputViewer;
        Editor[] editorArray = new Editor[2];
        Intrinsics.checkNotNullExpressionValue((Object)this$0.getEditor1(), (String)"getEditor1(...)");
        Intrinsics.checkNotNullExpressionValue((Object)this$0.getEditor2(), (String)"getEditor2(...)");
        jupyterDiffOutputViewer.loadOutputComponents(editorArray);
        JupyterDiffOutputViewer jupyterDiffOutputViewer2 = this$0.myDiffOutputViewer;
        EditorEx editorEx = this$0.getEditor1();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor1(...)");
        Editor editor = (Editor)editorEx;
        EditorEx editorEx2 = this$0.getEditor2();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getEditor2(...)");
        jupyterDiffOutputViewer2.loadOutputKeysDifferences(editor, (Editor)editorEx2);
        return Unit.INSTANCE;
    }

    private static final void computeDifferences$lambda$1(Runnable $runnable, boolean $isContentsEqual, JupyterDiffViewer this$0) {
        $runnable.run();
        if ($isContentsEqual) {
            this$0.myPanel.resetNotifications();
            this$0.myPanel.addNotification((JComponent)DiffNotifications.createNotification$default((String)JupyterBundle.message((String)"jupyter.diff.viewer.contents.equal", (Object[])new Object[0]), null, (EditorNotificationPanel.Status)EditorNotificationPanel.Status.Info, (boolean)false, (int)10, null));
        }
    }
}

