/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import androidx.compose.compiler.plugins.kotlin.lower.IrInlineReferenceLocatorKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/ComposeInlineLambdaLocator;", "", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "inlineLambdaToParameter", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "inlineFunctionExpressions", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isInlineLambda", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isCrossinlineLambda", "isInlineFunctionExpression", "expression", "preservesComposableScope", "scan", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "kotlin-compose-compiler-plugin"})
public final class ComposeInlineLambdaLocator {
    @NotNull
    private final IrPluginContext context;
    @NotNull
    private final Map<IrFunctionSymbol, IrValueParameter> inlineLambdaToParameter;
    @NotNull
    private final Set<IrExpression> inlineFunctionExpressions;

    public ComposeInlineLambdaLocator(@NotNull IrPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.inlineLambdaToParameter = new LinkedHashMap();
        this.inlineFunctionExpressions = new LinkedHashSet();
    }

    public final boolean isInlineLambda(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return this.inlineLambdaToParameter.keySet().contains(irFunction.getSymbol());
    }

    public final boolean isCrossinlineLambda(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        IrValueParameter irValueParameter = this.inlineLambdaToParameter.get(irFunction.getSymbol());
        return irValueParameter != null ? irValueParameter.isCrossinline() : false;
    }

    public final boolean isInlineFunctionExpression(@NotNull IrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.inlineFunctionExpressions.contains(expression);
    }

    public final boolean preservesComposableScope(@NotNull IrFunction irFunction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        IrValueParameter irValueParameter = this.inlineLambdaToParameter.get(irFunction.getSymbol());
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl2 = false;
            bl = !it.isCrossinline() && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)it.getType()), (FqName)ComposeFqNames.INSTANCE.getDisallowComposableCalls());
        } else {
            bl = false;
        }
        return bl;
    }

    public final void scan(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptVoid((IrElement)element, (IrVisitorVoid)new IrVisitorVoid(this){
            final /* synthetic */ ComposeInlineLambdaLocator this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
            }

            public void visitValueParameter(IrValueParameter declaration) {
                block1: {
                    IrFunction parent;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)declaration), (IrVisitorVoid)this);
                    IrDeclarationParent irDeclarationParent = declaration.getParent();
                    IrFunction irFunction = parent = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
                    boolean bl = irFunction != null ? IrInlineReferenceLocatorKt.access$isInlineFunctionCall(irFunction, ComposeInlineLambdaLocator.access$getContext$p(this.this$0)) : false;
                    if (!bl || !IrInlineReferenceLocatorKt.access$isInlinedFunction(declaration)) break block1;
                    IrExpressionBody irExpressionBody = declaration.getDefaultValue();
                    if (irExpressionBody != null && (irExpressionBody = irExpressionBody.getExpression()) != null && (irExpressionBody = IrInlineReferenceLocatorKt.unwrapLambda((IrExpression)irExpressionBody)) != null) {
                        IrExpressionBody irExpressionBody2 = irExpressionBody;
                        ComposeInlineLambdaLocator composeInlineLambdaLocator = this.this$0;
                        IrExpressionBody it = irExpressionBody2;
                        boolean bl2 = false;
                        ComposeInlineLambdaLocator.access$getInlineLambdaToParameter$p(composeInlineLambdaLocator).put(it, declaration);
                    }
                }
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression), (IrVisitorVoid)this);
                IrFunction function = ((IrFunctionSymbol)expression.getSymbol()).getOwner();
                if (IrInlineReferenceLocatorKt.access$isInlineFunctionCall(function, ComposeInlineLambdaLocator.access$getContext$p(this.this$0))) {
                    for (IrValueParameter parameter : function.getParameters()) {
                        IrExpression irExpression;
                        if (!IrInlineReferenceLocatorKt.access$isInlinedFunction(parameter) || (irExpression = (IrExpression)expression.getArguments().get(parameter.getIndexInParameters())) == null) continue;
                        IrExpression irExpression2 = irExpression;
                        ComposeInlineLambdaLocator composeInlineLambdaLocator = this.this$0;
                        IrExpression it = irExpression2;
                        boolean bl = false;
                        ((Collection)ComposeInlineLambdaLocator.access$getInlineFunctionExpressions$p(composeInlineLambdaLocator)).add(it);
                        if ((irExpression2 = IrInlineReferenceLocatorKt.unwrapLambda(irExpression2)) == null) continue;
                        composeInlineLambdaLocator = irExpression2;
                        ComposeInlineLambdaLocator composeInlineLambdaLocator2 = this.this$0;
                        ComposeInlineLambdaLocator it2 = composeInlineLambdaLocator;
                        boolean bl2 = false;
                        ComposeInlineLambdaLocator.access$getInlineLambdaToParameter$p(composeInlineLambdaLocator2).put(it2, parameter);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ IrPluginContext access$getContext$p(ComposeInlineLambdaLocator $this) {
        return $this.context;
    }

    public static final /* synthetic */ Map access$getInlineLambdaToParameter$p(ComposeInlineLambdaLocator $this) {
        return $this.inlineLambdaToParameter;
    }

    public static final /* synthetic */ Set access$getInlineFunctionExpressions$p(ComposeInlineLambdaLocator $this) {
        return $this.inlineFunctionExpressions;
    }
}

