/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class CreateFieldWithPathParamFix
implements LocalQuickFix {
    private static final String FIELD_TEMPLATE = "private String {0};\n";
    private final String name;
    private final PsiClass context;

    public CreateFieldWithPathParamFix(String name, PsiClass context) {
        this.name = name;
        this.context = context;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("create.field.annotated.path.param", this.name);
        if (string == null) {
            CreateFieldWithPathParamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiField[] fields;
        PsiClass psiClass;
        if (project == null) {
            CreateFieldWithPathParamFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            CreateFieldWithPathParamFix.$$$reportNull$$$0(2);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class)) == null) {
            return;
        }
        String text = MessageFormat.format(FIELD_TEMPLATE, this.name);
        PsiField field = JavaPsiFacade.getElementFactory((Project)project).createFieldFromText(text, null);
        PsiElement element = this.context.addAfter((PsiElement)field, (PsiElement)((fields = this.context.getFields()).length == 0 ? this.context.getLBrace() : fields[fields.length - 1]));
        if (element instanceof PsiField) {
            RSUtils.annotateFieldWithPathParam(project, (PsiField)element, this.name);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            CreateFieldWithPathParamFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            CreateFieldWithPathParamFix.$$$reportNull$$$0(4);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, "", "@PathParam(\"" + this.name + "\")\n private String " + this.name + ";");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/fixes/CreateFieldWithPathParamFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/fixes/CreateFieldWithPathParamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

