/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.BaseXmlOutputter;
import com.intellij.configurationStore.JbXmlOutputterKt;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 82\u00020\u0001:\u00018BM\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 J(\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000bH\u0002J(\u0010#\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000bH\u0014J>\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000bH\u0002J.\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 H\u0002J&\u0010+\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010/\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u00100\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020 H\u0002J\u001e\u00101\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\u0018H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter;", "Lcom/intellij/configurationStore/BaseXmlOutputter;", "lineSeparator", "", "elementFilter", "Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;", "macroMap", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "macroFilter", "Lcom/intellij/openapi/application/PathMacroFilter;", "isForbidSensitiveData", "", "storageFilePathForDebugPurposes", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;Lcom/intellij/application/options/ReplacePathToMacroMap;Lcom/intellij/openapi/application/PathMacroFilter;ZLjava/lang/String;)V", "format", "Lorg/jdom/output/Format;", "Lorg/jetbrains/annotations/NotNull;", "writeLineSeparator", "", "out", "Ljava/io/Writer;", "output", "element", "Lorg/jdom/Element;", "printCDATA", "cdata", "Lorg/jdom/CDATA;", "printString", "str", "printElement", "level", "", "printElementImpl", "substituteMacro", "writeContent", "printContentRange", "content", "", "Lorg/jdom/Content;", "start", "end", "printTextRange", "printAttributes", "attributes", "Lorg/jdom/Attribute;", "newline", "indent", "skipLeadingWhite", "skipTrailingWhite", "checkIsElementContainsSensitiveInformation", "shouldCheckElement", "logSensitiveInformationError", "name", "elementKind", "parentElement", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nJbXmlOutputter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbXmlOutputter.kt\ncom/intellij/configurationStore/JbXmlOutputter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,519:1\n1#2:520\n*E\n"})
public class JbXmlOutputter
extends BaseXmlOutputter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JDOMUtil.ElementOutputFilter elementFilter;
    @Nullable
    private final ReplacePathToMacroMap macroMap;
    @Nullable
    private final PathMacroFilter macroFilter;
    private final boolean isForbidSensitiveData;
    @Nullable
    private final String storageFilePathForDebugPurposes;
    @NotNull
    private final Format format;
    private static final Set<String> reportedSensitiveProblems = Collections.synchronizedSet(new HashSet());

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData, @Nullable String storageFilePathForDebugPurposes) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        super(lineSeparator);
        this.elementFilter = elementFilter;
        this.macroMap = macroMap;
        this.macroFilter = macroFilter;
        this.isForbidSensitiveData = isForbidSensitiveData;
        this.storageFilePathForDebugPurposes = storageFilePathForDebugPurposes;
        Format format = JDOMUtil.createFormat((String)lineSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)format, (String)"createFormat(...)");
        this.format = format;
    }

    public /* synthetic */ JbXmlOutputter(String string, JDOMUtil.ElementOutputFilter elementOutputFilter, ReplacePathToMacroMap replacePathToMacroMap, PathMacroFilter pathMacroFilter, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        if ((n & 2) != 0) {
            elementOutputFilter = null;
        }
        if ((n & 4) != 0) {
            replacePathToMacroMap = null;
        }
        if ((n & 8) != 0) {
            pathMacroFilter = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(string, elementOutputFilter, replacePathToMacroMap, pathMacroFilter, bl, string2);
    }

    private final void writeLineSeparator(Writer out) {
        if (this.format.getLineSeparator() != null) {
            out.write(this.format.getLineSeparator());
        }
    }

    public final void output(@NotNull Element element, @NotNull Writer out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.printElement(out, element, 0);
    }

    private final void printCDATA(Writer out, CDATA cdata) {
        String str = null;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string = cdata.getTextNormalize();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextNormalize(...)");
            str = string;
        } else {
            String string = cdata.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            str = string;
            if (this.format.getTextMode() == Format.TextMode.TRIM) {
                str = ((Object)StringsKt.trim((CharSequence)str)).toString();
            }
        }
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    private final void printString(Writer out, String str) {
        String normalizedString = str;
        if (this.format.getTextMode() == Format.TextMode.NORMALIZE) {
            String string = Text.normalizeString((String)normalizedString);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeString(...)");
            normalizedString = string;
        } else if (this.format.getTextMode() == Format.TextMode.TRIM) {
            normalizedString = ((Object)StringsKt.trim((CharSequence)normalizedString)).toString();
        }
        if (this.macroMap != null) {
            String string = this.macroMap.substitute(normalizedString, SystemInfoRt.isFileSystemCaseSensitive);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substitute(...)");
            normalizedString = string;
        }
        out.write(Companion.escapeElementEntities(normalizedString));
    }

    public final void printElement(@NotNull Writer out, @NotNull Element element, int level) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.printElementImpl(out, element, level, this.macroFilter != null);
    }

    private final void printElementImpl(Writer out, Element element, int level, boolean substituteMacro) {
        if (this.elementFilter != null && !this.elementFilter.accept(element, level)) {
            return;
        }
        boolean currentSubstituteMacro = substituteMacro && this.macroFilter != null && !this.macroFilter.skipPathMacros(element);
        out.write(60);
        JbXmlOutputterKt.access$printQualifiedName(out, element);
        if (element.hasAttributes()) {
            List list = element.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
            this.printAttributes(out, list, currentSubstituteMacro);
        }
        if (!this.writeContent(out, element, level, currentSubstituteMacro)) {
            return;
        }
        out.write("</");
        JbXmlOutputterKt.access$printQualifiedName(out, element);
        out.write(62);
    }

    protected boolean writeContent(@NotNull Writer out, @NotNull Element element, int level, boolean substituteMacro) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isForbidSensitiveData) {
            this.checkIsElementContainsSensitiveInformation(element);
        }
        List content = element.getContent();
        Intrinsics.checkNotNull((Object)content);
        int start2 = this.skipLeadingWhite(content, 0);
        int size = content.size();
        if (start2 >= size) {
            out.write(" />");
            return false;
        }
        out.write(62);
        if (JbXmlOutputterKt.access$nextNonText(content, start2) < size) {
            this.newline(out);
            this.printContentRange(out, content, start2, size, level + 1, substituteMacro);
            this.newline(out);
            this.indent(out, level);
        } else {
            this.printTextRange(out, content, start2, size);
        }
        return true;
    }

    private final void printContentRange(Writer out, List<? extends Content> content, int start2, int end, int level, boolean substituteMacro) {
        boolean firstNode = false;
        Content next = null;
        int first = 0;
        int index = 0;
        index = start2;
        while (index < end) {
            firstNode = index == start2;
            next = content.get(index);
            if (next instanceof Text || next instanceof EntityRef) {
                first = this.skipLeadingWhite(content, index);
                if (first >= (index = JbXmlOutputterKt.access$nextNonText(content, first))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content, first, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Element) {
                this.printElementImpl(out, (Element)next, level, substituteMacro);
            }
            ++index;
        }
    }

    private final void printTextRange(Writer out, List<? extends Content> content, int start2, int end) {
        int start3 = this.skipLeadingWhite(content, start2);
        if (start3 >= content.size()) {
            return;
        }
        int end2 = this.skipTrailingWhite(content, end);
        Object previous = null;
        for (int i = start3; i < end2; ++i) {
            Content node = content.get(i);
            Object next = null;
            Object object = node;
            if (object instanceof Text) {
                next = ((Text)node).getText();
            } else if (object instanceof EntityRef) {
                next = "&" + ((EntityRef)node).getValue() + ";";
            } else {
                throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
            }
            object = (CharSequence)next;
            if (object == null || object.length() == 0) continue;
            if (previous != null && (this.format.getTextMode() == Format.TextMode.NORMALIZE || this.format.getTextMode() == Format.TextMode.TRIM) && (JbXmlOutputterKt.access$endsWithWhite(previous) || JbXmlOutputterKt.access$startsWithWhite((String)next))) {
                out.write(32);
            }
            if ((object = node) instanceof CDATA) {
                this.printCDATA(out, (CDATA)node);
            } else if (object instanceof EntityRef) {
                JbXmlOutputterKt.access$printEntityRef(out, (EntityRef)node);
            } else {
                this.printString(out, (String)next);
            }
            previous = next;
        }
    }

    private final void printAttributes(Writer out, List<? extends Attribute> attributes, boolean substituteMacro) {
        for (Attribute attribute : attributes) {
            String value;
            out.write(32);
            JbXmlOutputterKt.access$printQualifiedName(out, attribute);
            out.write(61);
            out.write(34);
            String string = value = this.macroMap != null && substituteMacro && (this.macroFilter == null || !this.macroFilter.skipPathMacros(attribute)) ? this.macroMap.getAttributeValue(attribute, this.macroFilter, SystemInfoRt.isFileSystemCaseSensitive, false) : attribute.getValue();
            if (this.isForbidSensitiveData) {
                String string2 = attribute.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string2)) {
                    this.logSensitiveInformationError("@" + attribute.getName(), "Attribute", attribute.getParent());
                }
            }
            out.write(JDOMUtil.escapeText((String)value, (boolean)false, (boolean)true));
            out.write(34);
        }
    }

    private final void newline(Writer out) {
        if (this.format.getIndent() != null) {
            this.writeLineSeparator(out);
        }
    }

    private final void indent(Writer out, int level) {
        CharSequence charSequence = this.format.getIndent();
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            out.write(this.format.getIndent());
        }
    }

    private final int skipLeadingWhite(List<? extends Content> content, int start2) {
        int index = start2;
        if (index < 0) {
            index = 0;
        }
        int size = content.size();
        Format.TextMode textMode = this.format.getTextMode();
        if (textMode == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index < size) {
                if (!JbXmlOutputterKt.access$isAllWhitespace(content.get(index))) {
                    return index;
                }
                ++index;
            }
        }
        return index;
    }

    private final int skipTrailingWhite(List<? extends Content> content, int start2) {
        Format.TextMode textMode;
        int index = start2;
        int size = content.size();
        if (index > size) {
            index = size;
        }
        if ((textMode = this.format.getTextMode()) == Format.TextMode.TRIM_FULL_WHITE || textMode == Format.TextMode.NORMALIZE || textMode == Format.TextMode.TRIM) {
            while (index >= 0 && JbXmlOutputterKt.access$isAllWhitespace(content.get(index - 1))) {
                --index;
            }
        }
        return index;
    }

    private final void checkIsElementContainsSensitiveInformation(Element element) {
        String name = element.getName();
        if (!this.shouldCheckElement(element)) {
            return;
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        if (BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(string) && !element.isEmpty()) {
            this.logSensitiveInformationError(name, "Element", element.getParentElement());
        }
        if ((name = element.getAttributeValue("name")) != null && BaseXmlOutputter.Companion.doesNameSuggestSensitiveInformation(name) && element.getAttribute("value") != null) {
            this.logSensitiveInformationError("@name=" + name, "Element", element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCheckElement(Element element) {
        if (!Intrinsics.areEqual((Object)"property", (Object)element.getName())) return true;
        Element element2 = element.getParentElement();
        String it = element2 != null ? element2.getName() : null;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)"driver-properties")) return false;
        if (!Intrinsics.areEqual((Object)it, (Object)"driver")) return true;
        return false;
    }

    private final void logSensitiveInformationError(String name, String elementKind, Element parentElement) {
        String parentPath = null;
        if (parentElement == null) {
            parentPath = null;
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            for (Element parent = parentElement; parent != null; parent = parent.getParentElement()) {
                String componentName;
                Object parentId = parent.getName();
                if (Intrinsics.areEqual((Object)parentId, (Object)"component") && (componentName = parent.getAttributeValue("name")) != null) {
                    parentId = (String)parentId + "@" + componentName;
                }
                ids.add((String)parentId);
            }
            if (ids.isEmpty()) {
                parentPath = null;
            } else {
                CollectionsKt.reverse((List)ids);
                parentPath = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            }
        }
        String string = parentPath;
        String message = elementKind + " " + (String)(string == null ? "" : string + ".") + name + " probably contains sensitive information";
        if (this.storageFilePathForDebugPurposes != null) {
            String string2 = FileUtilRt.toSystemIndependentName((String)SystemProperties.getUserHome());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            message = message + " (file: " + StringsKt.replace$default((String)this.storageFilePathForDebugPurposes, (String)string2, (String)"~", (boolean)false, (int)4, null) + ")";
        }
        if (reportedSensitiveProblems.add(message)) {
            Logger.getInstance(JbXmlOutputter.class).error(message);
        }
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter, boolean isForbidSensitiveData) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, macroFilter, isForbidSensitiveData, null, 32, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap, @Nullable PathMacroFilter macroFilter) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, macroFilter, false, null, 48, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter, @Nullable ReplacePathToMacroMap macroMap) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, macroMap, null, false, null, 56, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator, @Nullable JDOMUtil.ElementOutputFilter elementFilter) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, elementFilter, null, null, false, null, 60, null);
    }

    @JvmOverloads
    public JbXmlOutputter(@NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this(lineSeparator, null, null, null, false, null, 62, null);
    }

    @JvmOverloads
    public JbXmlOutputter() {
        this(null, null, null, null, false, null, 63, null);
    }

    @JvmStatic
    @NotNull
    public static final String collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project) throws IOException {
        return Companion.collapseMacrosAndWrite(element, project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eR2\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/configurationStore/JbXmlOutputter$Companion;", "", "<init>", "()V", "collapseMacrosAndWrite", "", "element", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/components/ComponentManager;", "writer", "Ljava/io/Writer;", "createOutputter", "Lcom/intellij/configurationStore/JbXmlOutputter;", "", "escapeElementEntities", "str", "reportedSensitiveProblems", "", "kotlin.jvm.PlatformType", "", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project, @NotNull Writer writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.createOutputter(project).output(element, writer);
        }

        @NotNull
        public final JbXmlOutputter createOutputter(@NotNull ComponentManager project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PathMacroManager pathMacroManager = PathMacroManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
            PathMacroManager macroManager = pathMacroManager;
            return new JbXmlOutputter(null, null, macroManager.getReplacePathMap(), macroManager.getMacroFilter(), false, null, 51, null);
        }

        @JvmStatic
        @NotNull
        public final String collapseMacrosAndWrite(@NotNull Element element, @NotNull ComponentManager project) throws IOException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StringWriter writer = new StringWriter();
            this.collapseMacrosAndWrite(element, project, writer);
            String string = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String escapeElementEntities(@Nullable String str) {
            String string = str;
            Intrinsics.checkNotNull((Object)string);
            String string2 = JDOMUtil.escapeText((String)string, (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeText(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

